/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.operation;

import java.io.Serializable;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.operation.ConfigurationResult;
import oracle.ops.mgmt.operation.Operation;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.rawdevice.RawDeviceConfig;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;

public class AddConfigurationOperation
extends Operation
implements Serializable {
    static final long serialVersionUID = 5425551853606829172L;
    private ParallelServerConfig m_opsConfig;

    public AddConfigurationOperation(ParallelServerConfig opsConfig, Version v) {
        super(true, v);
        this.m_opsConfig = opsConfig;
    }

    public ParallelServerConfig getConfiguration() {
        return this.m_opsConfig;
    }

    @Override
    public OperationResult run() {
        Trace.out("in AddConfigurationOperation.run()");
        ConfigurationResult result = null;
        try {
            RawDeviceConfig rawdeviceConfig = RawDeviceConfig.init(this.m_myVersion);
            rawdeviceConfig.addConfiguration(this.m_opsConfig);
            result = new ConfigurationResult(0);
        }
        catch (RawDeviceException e) {
            result = new ConfigurationResult(1, e.getMessage());
        }
        return result;
    }
}

