/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.cluster.network.Subnet;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VirtualIPException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.mgmt.viprange.DottedDecimalBinaryConverter;

public class VIPAddress
implements Serializable,
Cloneable {
    static final long serialVersionUID = 8133985297720130591L;
    private static final String COMMA = ",";
    private String m_VIPName = null;
    private InetAddress m_IPAddress;
    private String m_netmask;
    private String[] m_interfaces;
    private boolean m_isTaken;
    private String m_viporname = null;
    private IPAddressUtil.IPAddrType m_ipAddrType;

    public VIPAddress(String ipAddress) throws VirtualIPException {
        this(null, ipAddress, null, false, null);
    }

    public VIPAddress(String ipAddress, String netmask) throws VirtualIPException {
        this(null, ipAddress, netmask, true, null);
    }

    public VIPAddress(String vipName, String viporname, String netmask, String[] interfaces) throws VirtualIPException {
        this(vipName, viporname, netmask, true, interfaces);
    }

    private VIPAddress(String vipName, String viporname, String netmask, boolean netmaskRequired, String[] interfaces) throws VirtualIPException {
        Trace.out("vipName is " + vipName);
        Trace.out("viporname is " + viporname);
        MessageBundle clusterMsgBundle = MessageBundle.getMessageBundle("Prkc");
        if (viporname == null || IPAddressUtil.isLocalhost(viporname)) {
            Object[] args = new Object[]{viporname};
            throw new VirtualIPException(clusterMsgBundle.getMessage("1023", true, args));
        }
        boolean isIPv4 = false;
        boolean isIPv6 = false;
        if (netmaskRequired) {
            isIPv4 = IPAddressUtil.isIPv4AddressString(netmask);
            if (!isIPv4) {
                isIPv6 = IPAddressUtil.isIPv6PrefixLength(netmask);
            }
            if (!isIPv4 && !isIPv6 || isIPv4 && !this.isValidIPv4Netmask(netmask)) {
                Object[] args = new Object[]{netmask};
                throw new VirtualIPException(clusterMsgBundle.getMessage("1024", true, args));
            }
            this.m_netmask = netmask.trim();
        }
        this.m_viporname = viporname;
        String name = vipName != null ? vipName : viporname;
        try {
            InetAddress[] addresses = InetAddress.getAllByName(name);
            for (int i = 0; i < addresses.length; ++i) {
                if (isIPv4) {
                    if (!(addresses[i] instanceof Inet4Address)) continue;
                    this.m_IPAddress = addresses[i];
                    this.m_ipAddrType = IPAddressUtil.IPAddrType.IPv4;
                } else if (isIPv6) {
                    if (!(addresses[i] instanceof Inet6Address)) continue;
                    this.m_IPAddress = addresses[i];
                    this.m_ipAddrType = IPAddressUtil.IPAddrType.IPv6;
                } else {
                    this.m_IPAddress = addresses[i];
                    this.m_ipAddrType = this.m_IPAddress instanceof Inet4Address ? IPAddressUtil.IPAddrType.IPv4 : IPAddressUtil.IPAddrType.IPv6;
                }
                break;
            }
        }
        catch (UnknownHostException uhe) {
            Trace.out("VIPAddress: \"" + name + "\" is either an invalid IP address or an unknown host name");
            Object[] args = new Object[]{name};
            throw new VirtualIPException(clusterMsgBundle.getMessage("1168", true, args));
        }
        if (netmaskRequired && this.m_IPAddress == null) {
            String ipAddressType = isIPv4 ? "IPv4" : "IPv6";
            Object[] args = new Object[]{name, ipAddressType, this.m_netmask};
            throw new VirtualIPException(clusterMsgBundle.getMessage("1173", true, args));
        }
        String vipn = this.m_IPAddress.getHostName();
        this.m_VIPName = vipn != null && !vipn.equals(this.getAddressAsString()) ? (vipn.indexOf(".") > 0 ? vipn.substring(0, vipn.indexOf(".")) : vipn) : null;
        Trace.out("VIP name is " + this.m_VIPName);
        this.m_isTaken = false;
        this.m_interfaces = interfaces;
    }

    public VIPAddress(String ipAddress, String netmask, String[] interfaces) throws VirtualIPException {
        this(null, ipAddress, netmask, interfaces);
    }

    public String getVIPName() {
        return this.m_VIPName;
    }

    public String getVIPHostName() {
        if (this.m_VIPName != null && this.m_VIPName.indexOf(".") > 0) {
            return this.m_VIPName.substring(0, this.m_VIPName.indexOf("."));
        }
        return this.m_VIPName;
    }

    public String getUsrVIP() {
        return this.m_viporname;
    }

    public boolean isTaken() {
        return this.m_isTaken;
    }

    public void markTaken() {
        this.m_isTaken = true;
    }

    public void unmarkTaken() {
        this.m_isTaken = false;
    }

    public InetAddress getIPAddress() {
        return this.m_IPAddress;
    }

    public String getAddressAsString() {
        return this.m_IPAddress.getHostAddress();
    }

    public String getVIPOrName() {
        return this.m_viporname;
    }

    public String getNetmask() {
        return this.m_netmask;
    }

    public IPAddressUtil.IPAddrType getIPAddrType() {
        return this.m_ipAddrType;
    }

    public String getSubnet() {
        String subnet = null;
        if (this.m_ipAddrType == IPAddressUtil.IPAddrType.IPv4) {
            String[] ipParts = this.getAddressAsString().split(Pattern.quote(String.valueOf(".")));
            String[] nmParts = this.getNetmask().split(Pattern.quote(String.valueOf(".")));
            StringBuilder subnetStrBuilder = new StringBuilder();
            for (int i = 0; i < ipParts.length; ++i) {
                if (i < nmParts.length) {
                    subnetStrBuilder.append(Integer.parseInt(ipParts[i]) & Integer.parseInt(nmParts[i]));
                } else {
                    subnetStrBuilder.append(Integer.parseInt(ipParts[i]) & 0);
                }
                if (i >= ipParts.length - 1) continue;
                subnetStrBuilder.append(String.valueOf("."));
            }
            subnet = subnetStrBuilder.toString();
        }
        if (this.m_ipAddrType == IPAddressUtil.IPAddrType.IPv6) {
            String ipv6AddressStr = this.getAddressAsString();
            try {
                int numOfBits = Integer.valueOf(this.getNetmask());
                try {
                    subnet = IPAddressUtil.keepLeftHandBits(ipv6AddressStr, numOfBits);
                }
                catch (IPAddressException ipae) {
                    Trace.out("Error while applying the IPv6 netmask (i.e, number of left hand bits to keep) (" + numOfBits + ") to the IPv6 address (" + ipv6AddressStr + "). Details: " + ipae.getMessage());
                }
            }
            catch (NumberFormatException nfe) {
                Trace.out("Invalid IPv6. Provided \"" + this.getNetmask() + "\" which is not " + "\"an integer between 0 and 128. Details: " + nfe.getMessage());
            }
        }
        Trace.out("subnet=" + subnet);
        return subnet;
    }

    public void setSubnet(Subnet subnet) {
        this.m_netmask = subnet.subnetMaskAsStr();
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public void setInterfaces(String[] interfaces) {
        this.m_interfaces = interfaces;
    }

    public boolean compareNetmasks(VIPAddress secondVipAddress) {
        if (this.m_netmask != null && secondVipAddress != null) {
            return this.getNetmask().equals(secondVipAddress.getNetmask());
        }
        return this.m_netmask == null && secondVipAddress == null;
    }

    public boolean compareIPAddresses(VIPAddress secondVIPAddress) {
        if (this.getAddressAsString() != null && secondVIPAddress != null) {
            return this.getAddressAsString().equals(secondVIPAddress.getAddressAsString());
        }
        return this.m_IPAddress == null && secondVIPAddress == null;
    }

    public boolean equals(VIPAddress address) {
        return this.compareNetmasks(address) && this.compareIPAddresses(address);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            VIPAddress vipAddr = new VIPAddress(this.m_VIPName, this.m_viporname, this.m_netmask, this.m_interfaces);
            vipAddr.m_isTaken = this.m_isTaken;
            return vipAddr;
        }
        catch (VirtualIPException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
    }

    private boolean isValidIPv4Netmask(String netmask) {
        if (netmask == null) {
            return false;
        }
        StringTokenizer tokens = new StringTokenizer(netmask = netmask.trim(), ".");
        if (tokens.countTokens() != 4) {
            return false;
        }
        DottedDecimalBinaryConverter binaryForm = new DottedDecimalBinaryConverter(netmask);
        try {
            binaryForm = new DottedDecimalBinaryConverter(netmask);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        catch (Exception noSuchElemException) {
            return false;
        }
        String binaryStr = binaryForm.getBinary().toString();
        int leftIndexOfZero = binaryStr.indexOf("0");
        int rightIndexOfOne = binaryStr.lastIndexOf("1");
        if (leftIndexOfZero == -1 || rightIndexOfOne == -1) {
            return false;
        }
        return leftIndexOfZero == rightIndexOfOne + 1;
    }

    public boolean resolvesToOneAddress() {
        Trace.out("Entering resolves to One Address");
        try {
            Map<IPAddressUtil.IPAddrType, List<InetAddress>> ipMap = IPAddressUtil.getAddrMapFromAddressOrName(this.m_viporname);
            if (!ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                Trace.out("Cannot resolve VIP name:" + this.m_viporname);
                return false;
            }
            if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).size() == 1) {
                Trace.out("VIP name " + this.m_viporname + " resolves to: " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0).getHostAddress());
                return true;
            }
            if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).size() == 1) {
                Trace.out("VIP name " + this.m_viporname + " resolves to: " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0).getHostAddress());
                return true;
            }
        }
        catch (IPAddressException ipae) {
            Trace.out("Cannot resolve VIP name " + this.m_viporname);
            return false;
        }
        Trace.out("VIP name resolves to multiple addresses");
        return false;
    }

    public boolean resolvesToIPv4() {
        Trace.out("Entering resolvesToIPv4");
        try {
            Map<IPAddressUtil.IPAddrType, List<InetAddress>> ipMap = IPAddressUtil.getAddrMapFromAddressOrName(this.m_viporname);
            if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                StringBuilder output = new StringBuilder();
                for (InetAddress addr : ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4)) {
                    output.append(addr.getHostAddress() + COMMA);
                }
                Trace.out("VIP name " + this.m_viporname + " resolves to: " + output);
                return true;
            }
            Trace.out("VIP name does not resolve to an IPv4 address");
            return false;
        }
        catch (IPAddressException ipae) {
            Trace.out("Cannot resolve VIP name " + this.m_viporname);
            return false;
        }
    }

    public boolean resolvesToSingleAddressOfType() {
        Trace.out("Entering isBoth");
        try {
            Map<IPAddressUtil.IPAddrType, List<InetAddress>> ipMap = IPAddressUtil.getAddrMapFromAddressOrName(this.m_viporname);
            if (!ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                Trace.out("Cannot resolve VIP name:" + this.m_viporname);
                return false;
            }
            if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6)) {
                if (ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).size() == 1) {
                    Trace.out("VIP name " + this.m_viporname + " resolves to: " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0).getHostAddress());
                    return true;
                }
            } else if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && !ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                if (ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).size() == 1) {
                    Trace.out("VIP name " + this.m_viporname + " resolves to: " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0).getHostAddress());
                    return true;
                }
            } else if (ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv6) && ipMap.containsKey((Object)IPAddressUtil.IPAddrType.IPv4)) {
                if (ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).size() > 1 || ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).size() > 1) {
                    Trace.out("VIP name resolves to multiple IPv4 or IPv6 addresses");
                    return false;
                }
                Trace.out("VIP name " + this.m_viporname + " resolves to: " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv4).get(0).getHostAddress() + " and " + ipMap.get((Object)IPAddressUtil.IPAddrType.IPv6).get(0).getHostAddress());
                return true;
            }
        }
        catch (IPAddressException ipae) {
            Trace.out("Cannot resolve VIP name " + this.m_viporname);
            return false;
        }
        Trace.out("VIP name resolves to multiple IPv4 or IPv6 addresses");
        return false;
    }
}

