/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.AgentException;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.trace.Trace;

public class OEMAgent
implements HALiterals {
    private String m_oracleHome;
    private String m_nodeName;
    private String m_resName;
    private MessageBundle s_rawMesgBdle = MessageBundle.getMessageBundle("Prka");
    private Version m_version = new Version();
    private NodeApps m_nodeApps;

    public OEMAgent(String node, String ohome) throws AgentException {
        this.m_oracleHome = ohome;
        this.m_nodeName = node;
        this.m_resName = "ora." + this.m_nodeName.toLowerCase() + ".oem";
        this.m_nodeApps = new NodeApps(this.m_nodeName, this.m_version);
        throw new RuntimeException("This class is disabled");
    }

    public OEMAgent(String node) throws AgentException {
        this(node, null);
    }

    public boolean exists() throws AgentException {
        Trace.out("Testing if Agent exists on " + this.m_nodeName + " for resource " + this.m_resName);
        boolean bExists = false;
        try {
            bExists = this.m_nodeApps.isExists(this.m_resName);
        }
        catch (NodeException ne) {
            throw new AgentException(ne.getMessage());
        }
        return bExists;
    }

    public boolean isRunning() throws AgentException {
        boolean bRunning = false;
        try {
            bRunning = this.m_nodeApps.isRunning(this.m_resName);
        }
        catch (NodeException ne) {
            throw new AgentException(ne.getMessage());
        }
        return bRunning;
    }

    public void start() throws AgentException {
        Trace.out("Starting " + this.m_resName + " on " + this.m_nodeName);
        try {
            this.m_nodeApps.start(this.m_resName);
        }
        catch (NodeException ne) {
            throw new AgentException(ne.getMessage());
        }
    }

    public void stop() throws AgentException {
        Trace.out("Stopping service for " + this.m_resName + " on " + this.m_nodeName);
        try {
            this.m_nodeApps.stop(this.m_resName, false);
        }
        catch (NodeException ne) {
            throw new AgentException(ne.getMessage());
        }
    }

    public void create() throws AgentException {
        boolean checkRoot = !Boolean.getBoolean("srvm.vip.no_root_check");
        Util hasUtl = null;
        String primaryGroup = null;
        String oUser = null;
        String oGroup = null;
        if (checkRoot) {
            try {
                hasUtl = new Util();
                if (!hasUtl.hasHAPrivilege()) {
                    throw new AgentException(this.s_rawMesgBdle.getMessage("2018", true));
                }
            }
            catch (UtilException e) {
                throw new AgentException(e.getMessage());
            }
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                try {
                    primaryGroup = hasUtl.getCurrentUserPrimaryGroup();
                }
                catch (UtilException e) {
                    throw new AgentException(e.getMessage());
                }
                try {
                    oUser = this.m_nodeApps.getUserName();
                    Trace.out("oracle user is " + oUser);
                    oGroup = this.m_nodeApps.getGroupName();
                    Trace.out("oracle OINSTALL group is " + oGroup);
                }
                catch (NodeException ne) {
                    throw new AgentException(ne.getMessage());
                }
            }
        }
        boolean update = this.exists();
        try {
            Trace.out("Creating profile for " + this.m_resName + " on " + this.m_nodeName);
            this.m_nodeApps.generateProfile(this.m_resName, this.m_oracleHome, "oem");
            this.m_nodeApps.register(this.m_resName, update);
        }
        catch (NodeException ne) {
            Trace.out("Failed to register the resource: " + this.m_resName);
            throw new AgentException(ne.getMessage());
        }
        if (checkRoot && new SystemFactory().CreateSystem().isUnixSystem()) {
            try {
                this.m_nodeApps.setPermOwner(this.m_resName, oUser);
                if (primaryGroup != null && !primaryGroup.equals(oGroup)) {
                    Trace.out("Adding OINSTALL group to OEM resource");
                    this.m_nodeApps.setPermGroup(this.m_resName, oGroup);
                }
            }
            catch (NodeException ne) {
                throw new AgentException(ne.getMessage());
            }
            Trace.out("Agent resource ownership changed successfully to user:" + oUser);
        }
    }

    public void remove() throws AgentException {
        Trace.out("unregistering service for " + this.m_resName + " on " + this.m_nodeName);
        try {
            this.m_nodeApps.unregister(this.m_resName);
        }
        catch (NodeException ne) {
            throw new AgentException(ne.getMessage());
        }
    }

    public void modifyHome(String newOHome) throws AgentException {
        Trace.out("Modifying Oracle home of the resource: " + this.m_resName);
        if (!this.exists()) {
            Trace.out("Resource: " + this.m_resName + " does not exist to modify");
            return;
        }
        Trace.out("Generating profile for OEM resource " + this.m_resName + " on node " + this.m_nodeName);
        try {
            this.m_nodeApps.generateProfile(this.m_resName, newOHome, "oem");
            this.m_nodeApps.register(this.m_resName, true);
            this.m_oracleHome = newOHome;
        }
        catch (NodeException ne) {
            Trace.out("Failed to register the resource: " + this.m_resName + " with new new CRS home: " + this.m_oracleHome);
            throw new AgentException(ne.getMessage());
        }
        Trace.out("OEM resource modified successfully");
    }

    public String getOracleHome() {
        Trace.out("Retrieving the Oracle home of OEM resource for node: " + this.m_nodeName);
        String oracleHome = this.m_oracleHome;
        if (oracleHome == null) {
            try {
                oracleHome = this.m_nodeApps.getOracleHome(this.m_resName);
            }
            catch (NodeException ne) {
                Trace.out("Failed to retrieve oracle home of resource: " + this.m_resName);
                Trace.out(ne);
            }
        }
        return oracleHome;
    }

    public String getResourceName() {
        return this.m_resName;
    }
}

