/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.nodeapps.VIP;
import oracle.ops.mgmt.nodeapps.config.NodeApps;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.trace.Trace;

public class Listener
implements Constants,
HALiterals {
    private String m_nodeName;
    private String m_oracleHome;
    private String m_listenerName;
    private MessageBundle m_mesgBdle = MessageBundle.getMessageBundle("Prka");
    private String m_resName;
    private static Version s_version = new Version();
    private NodeApps m_nodeApp;

    public Listener(String node) throws ListenerException {
        this(node, null);
    }

    public Listener(String node, String ohome) throws ListenerException {
        this(new String("listener_" + node).toUpperCase(), node, ohome);
    }

    public Listener(String lsnrName, String node, String ohome) throws ListenerException {
        this(lsnrName.toUpperCase(), node, ohome, true);
    }

    public Listener(String lsnrName, String node, String ohome, boolean preserveCase) throws ListenerException {
        if (node == null || node.trim().length() == 0) {
            throw new ListenerException(MessageBundle.getMessageBundle("Prkc").getMessage("1045", true));
        }
        this.m_oracleHome = ohome;
        this.m_nodeName = node;
        this.m_listenerName = preserveCase ? lsnrName : lsnrName.toUpperCase();
        this.m_resName = "ora." + this.m_nodeName.toLowerCase() + "." + this.m_listenerName + ".lsnr";
        this.m_nodeApp = new NodeApps(this.m_nodeName, s_version);
        Trace.out("Creating listener with node name as " + this.m_nodeName + " and resource name as " + this.m_resName + " and listener name as " + this.m_listenerName);
    }

    public boolean exists() throws ListenerException {
        try {
            return this.m_nodeApp.isExists(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public boolean isRunning() throws ListenerException {
        Trace.out("Trying to find the status of " + this.m_resName + " on node " + this.m_nodeName);
        boolean bStatus = false;
        try {
            bStatus = this.m_nodeApp.isRunning(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
        Trace.out("online status of " + this.m_resName + " on " + this.m_nodeName + " is " + bStatus);
        return bStatus;
    }

    public void start() throws ListenerException {
        Trace.out("Running new start .. ");
        try {
            this.m_nodeApp.start(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public void stop() throws ListenerException {
        try {
            this.m_nodeApp.stop(this.m_resName, false);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public void stopForce() throws ListenerException {
        try {
            this.m_nodeApp.stop(this.m_resName, true);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public void create() throws ListenerException {
        try {
            VIP.assertNodeName(this.m_nodeName);
            VIP.assertCRSHome(this.m_nodeName, this.m_oracleHome);
            boolean update = this.exists();
            Trace.out("Listener.create:update=" + update);
            this.m_nodeApp.generateProfile(this.m_resName, this.m_oracleHome, "lsnr");
            this.m_nodeApp.register(this.m_resName, update);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public void remove() throws ListenerException {
        try {
            this.m_nodeApp.unregister(this.m_resName);
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public void modifyHome(String newOHome) throws ListenerException {
        try {
            VIP.assertNodeName(this.m_nodeName);
            VIP.assertCRSHome(this.m_nodeName, newOHome);
            Trace.out("Creating profile");
            this.m_nodeApp.generateProfile(this.m_resName, newOHome, "lsnr");
            this.m_nodeApp.register(this.m_resName, true);
            this.m_oracleHome = newOHome;
        }
        catch (NodeException ne) {
            throw new ListenerException(ne.getMessage());
        }
    }

    public String getOracleHome() throws ListenerException {
        if (this.m_oracleHome == null) {
            try {
                this.m_oracleHome = this.m_nodeApp.getOracleHome(this.m_resName);
            }
            catch (NodeException e) {
                throw new ListenerException(e.getMessage());
            }
        }
        return this.m_oracleHome;
    }

    public String getResourceName() {
        return this.m_resName;
    }

    public static String[] getListenerNames(String nodeName) throws ListenerException {
        try {
            VIP.assertNodeName(nodeName);
        }
        catch (NodeException ex) {
            throw new ListenerException(ex.getMessage());
        }
        try {
            HAStatusOperation statusOp = new HAStatusOperation(s_version);
            LocalCommand localCommand = new LocalCommand(statusOp);
            localCommand.execute();
            HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() == 0) {
                Vector vResourceStats = HAResourceStatus.parseHAStatusOutput(result.getOutput());
                ArrayList<String> list = new ArrayList<String>(vResourceStats.size());
                Pattern pattern = Pattern.compile("ora." + nodeName + "\\..*\\." + "lsnr");
                for (int i = 0; i < vResourceStats.size(); ++i) {
                    String resourceName = ((HAResourceStatus)vResourceStats.elementAt(i)).getResourceName();
                    if (!pattern.matcher(resourceName).matches()) continue;
                    String[] resCompNames = resourceName.replace('.', ':').split(":");
                    list.add(resCompNames[resCompNames.length - 2]);
                }
                String[] listenerNames = new String[list.size()];
                list.toArray(listenerNames);
                return listenerNames;
            }
            throw new ListenerException(result.getOutputSingle() + System.getProperty("line.separator") + result.getError());
        }
        catch (HAOperationException e) {
            throw new ListenerException(e.getMessage(), e);
        }
    }
}

