/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nodeapps;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import oracle.cluster.deployment.ractrans.FileHandler;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class IPAddressUtil {
    public static final String COLON = ":";
    public static final String DOT = ".";
    private static final String IPV4_LOCALHOST_IP = "127.0.0.1";
    private static final String IPV6_LOCALHOST_IP_FORM_1 = "0:0:0:0:0:0:0:1";
    private static final String IPV6_LOCALHOST_IP_FORM_2 = "::1";
    private static final String LOCALHOST = "localhost";
    public static final int PING_TIMEOUT_IN_MILLIS = 1000;
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static String IPv4_TO_IPv6_CONVERSION = ADDRESS_PREFIX.COMPATIBILITY_ADDRESS.toString();

    public static IPAddrType getIPAddrTypeMember(String value) {
        for (IPAddrType member : IPAddrType.values()) {
            if (!member.toString().equalsIgnoreCase(value)) continue;
            return member;
        }
        throw new EnumConstantNotPresentException(IPAddrType.class, value);
    }

    public static void setIPv4_TO_IPv6_CONVERSION(String value) {
        if ((value = value.trim()).equals(ADDRESS_PREFIX.COMPATIBILITY_ADDRESS.toString()) || value.equals(ADDRESS_PREFIX.IPv4MAPPED_ADDRESS.toString())) {
            IPv4_TO_IPv6_CONVERSION = value;
        }
    }

    public static Inet6Address toInet6Address(InetAddress inetAddress) throws IPAddressException {
        Inet6Address ipAddress = null;
        if (inetAddress instanceof Inet6Address) {
            ipAddress = (Inet6Address)inetAddress;
        } else {
            try {
                ipAddress = (Inet6Address)InetAddress.getByName(IPv4_TO_IPv6_CONVERSION + inetAddress.getHostAddress());
            }
            catch (UnknownHostException uhe) {
                Object[] args = new Object[]{inetAddress.getHostAddress()};
                throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
            }
        }
        return ipAddress;
    }

    public static Inet6Address toInet6Address(String ipAddressStr) throws IPAddressException {
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipAddressStr.trim());
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipAddressStr};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        return IPAddressUtil.toInet6Address(ipAddress);
    }

    public static boolean sameIPAddresses(String ipAddress1, String ipAddress2) throws IPAddressException {
        InetAddress inetAddress2;
        InetAddress inetAddress1;
        if (ipAddress1 == null) {
            Object[] args = new Object[]{"Passed null as \"ipAddress1\" argument"};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1171", true, args));
        }
        if (ipAddress2 == null) {
            Object[] args = new Object[]{"Passed null as \"ipAddress2\" argument"};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1171", true, args));
        }
        if ((ipAddress1 = ipAddress1.trim()).equalsIgnoreCase(ipAddress2 = ipAddress2.trim())) {
            return true;
        }
        try {
            inetAddress1 = InetAddress.getByName(ipAddress1.trim());
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipAddress1};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        try {
            inetAddress2 = InetAddress.getByName(ipAddress2.trim());
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipAddress2};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        return inetAddress1.equals(inetAddress2);
    }

    public static String getFullIPv6Notation(String ipv6AddressStr, boolean showLeadingZeros) throws IPAddressException {
        if (ipv6AddressStr == null || ipv6AddressStr.indexOf(COLON) == -1) {
            Object[] args = new Object[]{ipv6AddressStr};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1023", true, args));
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv6AddressStr.trim());
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipv6AddressStr};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        if (!(ipAddress instanceof Inet6Address)) {
            Object[] args = new Object[]{ipAddress.getHostAddress()};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1169", true, args));
        }
        Inet6Address ipv6Address = (Inet6Address)ipAddress;
        String ipv6NotationWithoutLeadingZeros = ipv6Address.getHostAddress();
        if (!showLeadingZeros) {
            return ipv6NotationWithoutLeadingZeros;
        }
        StringTokenizer tokenizer = new StringTokenizer(ipv6NotationWithoutLeadingZeros, COLON);
        StringBuilder ipv6NotationWithLeadingZeros = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            String twoBytePiece = tokenizer.nextToken().trim();
            int leadingZerosToAppend = 4 - twoBytePiece.length();
            for (int j = 0; j < leadingZerosToAppend; ++j) {
                ipv6NotationWithLeadingZeros.append('0');
            }
            ipv6NotationWithLeadingZeros.append(twoBytePiece);
            if (i == 7) continue;
            ipv6NotationWithLeadingZeros.append(COLON);
        }
        return ipv6NotationWithLeadingZeros.toString();
    }

    public static String getShorthandIPv6Notation(String ipv6AddressStr, boolean compressZeroFields) throws IPAddressException {
        if (ipv6AddressStr == null || ipv6AddressStr.indexOf(COLON) == -1) {
            Object[] args = new Object[]{ipv6AddressStr};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1023", true, args));
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipv6AddressStr.trim());
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipv6AddressStr};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        if (!(ipAddress instanceof Inet6Address)) {
            Object[] args = new Object[]{ipAddress.getHostAddress()};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1169", true, args));
        }
        Inet6Address ipv6Address = (Inet6Address)ipAddress;
        String ipv6NotationWithoutCompressedZeroFields = ipv6Address.getHostAddress();
        if (!compressZeroFields) {
            return ipv6NotationWithoutCompressedZeroFields;
        }
        StringTokenizer tokenizer = new StringTokenizer(ipv6NotationWithoutCompressedZeroFields, COLON);
        int maxChainOfZerosStartIndex = -1;
        int maxChainOfZerosLength = 0;
        int currChainOfZerosStartIndex = -1;
        int currChainOfZerosLength = 0;
        String[] ipv6AddressTokens = new String[8];
        for (int i = 0; i < 8; ++i) {
            String twoBytePiece;
            ipv6AddressTokens[i] = twoBytePiece = tokenizer.nextToken().trim();
            if (twoBytePiece.equals("0")) {
                if (currChainOfZerosStartIndex == -1) {
                    currChainOfZerosStartIndex = i;
                }
                if (i != 7 || ++currChainOfZerosLength <= maxChainOfZerosLength) continue;
                maxChainOfZerosLength = currChainOfZerosLength;
                maxChainOfZerosStartIndex = currChainOfZerosStartIndex;
                continue;
            }
            if (currChainOfZerosLength == 0) continue;
            if (currChainOfZerosLength > maxChainOfZerosLength) {
                maxChainOfZerosLength = currChainOfZerosLength;
                maxChainOfZerosStartIndex = currChainOfZerosStartIndex;
            }
            currChainOfZerosStartIndex = -1;
            currChainOfZerosLength = 0;
        }
        if (maxChainOfZerosLength == 0) {
            return ipv6NotationWithoutCompressedZeroFields;
        }
        StringBuilder ipv6NotationWithCompressedZeros = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            if (i < maxChainOfZerosStartIndex || i >= maxChainOfZerosStartIndex + maxChainOfZerosLength) {
                ipv6NotationWithCompressedZeros.append(ipv6AddressTokens[i]);
                if (i == 7) continue;
                ipv6NotationWithCompressedZeros.append(COLON);
                continue;
            }
            if (i != maxChainOfZerosStartIndex) continue;
            ipv6NotationWithCompressedZeros.append(COLON);
            if (i != 0) continue;
            ipv6NotationWithCompressedZeros.append(COLON);
        }
        return ipv6NotationWithCompressedZeros.toString();
    }

    public static Map<IPAddrType, List<InetAddress>> resolveHostname(String hostname) throws IPAddressException {
        InetAddress[] allAddresses;
        HashMap<IPAddrType, List<InetAddress>> ipAddressMap = new HashMap<IPAddrType, List<InetAddress>>(2);
        try {
            allAddresses = InetAddress.getAllByName(hostname);
        }
        catch (UnknownHostException uhe) {
            List<String> ipAddresses;
            Object[] args = new Object[]{hostname};
            String errorMessage = MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args);
            if (!IS_UNIX_SYSTEM) {
                throw new IPAddressException(errorMessage);
            }
            Map<IPAddrType, List<String>> resolutionMap = IPAddressUtil.dnsLookup(hostname);
            if (resolutionMap.isEmpty()) {
                throw new IPAddressException(errorMessage);
            }
            if (resolutionMap.containsKey((Object)IPAddrType.IPv4)) {
                ipAddresses = resolutionMap.get((Object)IPAddrType.IPv4);
                ArrayList<InetAddress> ipv4Addresses = new ArrayList<InetAddress>(ipAddresses.size());
                for (String ipAddress : ipAddresses) {
                    try {
                        ipv4Addresses.add(InetAddress.getByName(ipAddress));
                    }
                    catch (UnknownHostException nhe) {
                        throw new IPAddressException(uhe.getMessage(), uhe);
                    }
                }
                ipAddressMap.put(IPAddrType.IPv4, ipv4Addresses);
            }
            if (resolutionMap.containsKey((Object)IPAddrType.IPv6)) {
                ipAddresses = resolutionMap.get((Object)IPAddrType.IPv6);
                ArrayList<InetAddress> ipv6Addresses = new ArrayList<InetAddress>(ipAddresses.size());
                for (String ipAddress : ipAddresses) {
                    try {
                        ipv6Addresses.add(InetAddress.getByName(ipAddress));
                    }
                    catch (UnknownHostException nhe) {
                        throw new IPAddressException(uhe.getMessage(), uhe);
                    }
                }
                ipAddressMap.put(IPAddrType.IPv6, ipv6Addresses);
            }
            return ipAddressMap;
        }
        ArrayList<InetAddress> ipv4Addresses = new ArrayList<InetAddress>(allAddresses.length);
        ArrayList<InetAddress> ipv6Addresses = new ArrayList<InetAddress>(allAddresses.length);
        for (int i = 0; i < allAddresses.length; ++i) {
            if (allAddresses[i] instanceof Inet4Address) {
                ipv4Addresses.add(allAddresses[i]);
                continue;
            }
            if (!(allAddresses[i] instanceof Inet6Address)) continue;
            ipv6Addresses.add(allAddresses[i]);
        }
        if (ipv4Addresses.size() > 0) {
            ipAddressMap.put(IPAddrType.IPv4, ipv4Addresses);
        }
        if (ipv6Addresses.size() > 0) {
            ipAddressMap.put(IPAddrType.IPv6, ipv6Addresses);
        }
        return ipAddressMap;
    }

    public static String applyNetmaskOrPrefixLength(String ipAddressStr, String netmaskOrPrefixLength) throws IPAddressException {
        int prefixLength;
        boolean isIPv6;
        boolean isIPv4 = IPAddressUtil.isIPv4AddressString(ipAddressStr);
        boolean bl = isIPv6 = !isIPv4 && IPAddressUtil.isIPv6AddressString(ipAddressStr);
        if (!isIPv4 && !isIPv6) {
            Object[] args = new Object[]{"ipaddressutil_error-01"};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1171", true, args));
        }
        if (isIPv4) {
            if (!IPAddressUtil.isIPv4AddressString(netmaskOrPrefixLength)) {
                Object[] args = new Object[]{netmaskOrPrefixLength};
                throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1024", true, args));
            }
            try {
                InetAddress ipAddress = InetAddress.getByName(ipAddressStr);
                InetAddress mask = InetAddress.getByName(netmaskOrPrefixLength);
                InetAddress result = IPAddressUtil.applyMask(ipAddress, mask);
                return result.getHostAddress();
            }
            catch (UnknownHostException uhe) {
                Trace.out("Internal error. Caught an exception that was not thrown in the past b/c the code got modified");
                throw new IPAddressException(uhe.getMessage(), uhe);
            }
        }
        try {
            prefixLength = Integer.valueOf(netmaskOrPrefixLength);
            IPAddressUtil.assertIPv6PrefixLength(prefixLength);
        }
        catch (NumberFormatException nfe) {
            Object[] args = new Object[]{netmaskOrPrefixLength};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1172", true, args));
        }
        return IPAddressUtil.keepLeftHandBits(ipAddressStr, prefixLength);
    }

    public static InetAddress applyMask(InetAddress ipAddress, InetAddress mask) throws IPAddressException {
        byte[] maskBytes;
        byte[] ipAddressBytes = ipAddress.getAddress();
        if (ipAddressBytes.length != (maskBytes = mask.getAddress()).length) {
            Object[] args = new Object[]{"ipaddressutil_error-02"};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1171", true, args));
        }
        byte[] result = new byte[ipAddressBytes.length];
        for (int i = 0; i < ipAddressBytes.length; i = (int)((byte)(i + 1))) {
            result[i] = Integer.valueOf(Byte.valueOf(ipAddressBytes[i]).intValue() & Byte.valueOf(maskBytes[i]).intValue()).byteValue();
        }
        try {
            return InetAddress.getByAddress(ipAddress.getHostName(), result);
        }
        catch (UnknownHostException uhe) {
            throw new IPAddressException(uhe.getMessage(), uhe);
        }
    }

    public static List<String> getIPAddressesUsingDNSLookup(String hostname) throws IPAddressException {
        if (hostname == null || hostname.trim().length() == 0) {
            MessageBundle.getMessageBundle(PrCcMsgID.facility);
            throw new IPAddressException(MessageBundle.getMessage(PrCcMsgID.INVALID_PARAM_VALUE, true, "hostname", hostname));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (IS_UNIX_SYSTEM) {
            Map<IPAddrType, List<String>> dnsLookupMap = IPAddressUtil.dnsLookup(hostname);
            if (dnsLookupMap.containsKey((Object)IPAddrType.IPv4)) {
                result.addAll((Collection)dnsLookupMap.get((Object)IPAddrType.IPv4));
            }
            if (dnsLookupMap.containsKey((Object)IPAddrType.IPv6)) {
                result.addAll((Collection<String>)dnsLookupMap.get((Object)IPAddrType.IPv6));
            }
        } else {
            InetAddress hostInetAddress;
            try {
                hostInetAddress = InetAddress.getByName(hostname);
            }
            catch (UnknownHostException uhe) {
                Trace.out("UnknownHostException: " + uhe.getMessage());
                return result;
            }
            String fqdn = hostInetAddress.getCanonicalHostName();
            Trace.out("fqdn = " + fqdn);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            String dnsRecordType = hostInetAddress instanceof Inet6Address ? "AAAA" : "A";
            try {
                InitialDirContext dirContext = new InitialDirContext(env);
                Trace.out("Query DNS record for host: " + fqdn);
                Attributes attribs = dirContext.getAttributes(fqdn, new String[]{"A"});
                Trace.out("No of attributes = " + attribs.size());
                NamingEnumeration<? extends Attribute> attribEnumeration = attribs.getAll();
                String ipAddress = null;
                while (attribEnumeration.hasMoreElements()) {
                    Attribute attrib = attribEnumeration.next();
                    String attribID = attrib.getID();
                    Trace.out("Enumeration Attribute ID = " + attrib);
                    if (!attribID.equals(dnsRecordType)) continue;
                    NamingEnumeration<?> namingEnumeration = attrib.getAll();
                    ipAddress = namingEnumeration.next().toString();
                    Trace.out("IP address=" + ipAddress);
                    result.add(ipAddress);
                }
                return result;
            }
            catch (NamingException ne) {
                Trace.out("Host name \"" + hostname + "\" does not resolve to an IP address");
            }
        }
        return result;
    }

    public static Map<IPAddrType, List<String>> dnsLookup(String hostname) throws IPAddressException {
        String[] dnsURLs;
        List<String> resolvConfLines;
        if (!IS_UNIX_SYSTEM) {
            MessageBundle.getMessageBundle(PrCtMsgID.facility);
            throw new IPAddressException(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "UNIX-only"));
        }
        if (hostname == null || hostname.trim().length() == 0) {
            MessageBundle.getMessageBundle(PrCcMsgID.facility);
            throw new IPAddressException(MessageBundle.getMessage(PrCcMsgID.INVALID_PARAM_VALUE, true, "hostname", hostname));
        }
        try {
            resolvConfLines = FileHandler.readFile("/etc/resolv.conf", true, false);
        }
        catch (RACTransErrorException fileReadError) {
            throw new IPAddressException(fileReadError.getMessage());
        }
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<String> domains = new ArrayList<String>();
        if (resolvConfLines != null) {
            for (String line : resolvConfLines) {
                StringTokenizer tokenizer;
                if ((line = line.trim()).toLowerCase().startsWith("nameserver")) {
                    line = line.substring("nameserver".length());
                    tokenizer = new StringTokenizer(line);
                    while (tokenizer.hasMoreTokens()) {
                        hosts.add(tokenizer.nextToken());
                    }
                    continue;
                }
                if (!line.toLowerCase().startsWith("search")) continue;
                line = line.substring("search".length());
                tokenizer = new StringTokenizer(line);
                while (tokenizer.hasMoreTokens()) {
                    domains.add(tokenizer.nextToken());
                }
            }
        }
        if (hosts.isEmpty()) {
            MessageBundle.getMessageBundle(PrCnMsgID.facility);
            throw new IPAddressException(MessageBundle.getMessage(PrCnMsgID.NO_DNS_SERVER_HOST_FOUND, true, "/etc/resolv.conf"));
        }
        if (domains.isEmpty()) {
            int indexOfFirstDot;
            String localhost;
            try {
                localhost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                Trace.out("Unable to determine the local host to derive thedomain for it.");
                localhost = null;
            }
            String domain = null;
            if (localhost != null && (indexOfFirstDot = localhost.indexOf(DOT)) != -1) {
                domain = localhost.substring(indexOfFirstDot + 1);
            }
            dnsURLs = new String[hosts.size()];
            int i = 0;
            for (String host : hosts) {
                dnsURLs[i] = domain != null ? "dns://" + host + "/" + domain : "dns://" + host;
                ++i;
            }
        } else {
            int numOfDomains = domains.size();
            dnsURLs = new String[hosts.size() * numOfDomains];
            int i = 0;
            for (String host : hosts) {
                int j = 0;
                for (String domain : domains) {
                    dnsURLs[i * numOfDomains + j] = "dns://" + host + "/" + domain;
                    ++j;
                }
                ++i;
            }
        }
        HashMap<IPAddrType, List<String>> result = new HashMap<IPAddrType, List<String>>(2);
        for (String dnsURL : dnsURLs) {
            List<String> ipv4Addresses = IPAddressUtil.resolveDNS(hostname, IPAddrType.IPv4, dnsURL);
            if (ipv4Addresses == null) continue;
            result.put(IPAddrType.IPv4, ipv4Addresses);
            break;
        }
        for (String dnsURL : dnsURLs) {
            List<String> ipv6Addresses = IPAddressUtil.resolveDNS(hostname, IPAddrType.IPv6, dnsURL);
            if (ipv6Addresses == null) continue;
            result.put(IPAddrType.IPv6, ipv6Addresses);
            break;
        }
        return result;
    }

    public static String keepLeftHandBits(String ipv6AddressStr, int ipv6PrefixLength) throws IPAddressException {
        IPAddressUtil.assertIPv6PrefixLength(ipv6PrefixLength);
        String fullLengthIPv6Address = IPAddressUtil.getFullIPv6Notation(ipv6AddressStr, true);
        int numOfLeftHandedTwoBytePiecesToKeep = ipv6PrefixLength / 16;
        int numOfLeftHandBitsOfLastPieceToKeep = ipv6PrefixLength - numOfLeftHandedTwoBytePiecesToKeep * 16;
        StringTokenizer tokenizer = new StringTokenizer(fullLengthIPv6Address, COLON);
        StringBuilder resultingIPv6Address = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            String twoBytePiece = tokenizer.nextToken().trim();
            if (numOfLeftHandedTwoBytePiecesToKeep > 0) {
                resultingIPv6Address.append(twoBytePiece);
                --numOfLeftHandedTwoBytePiecesToKeep;
            } else if (numOfLeftHandBitsOfLastPieceToKeep > 0) {
                int numOfHexDigitsToKeep = numOfLeftHandBitsOfLastPieceToKeep / 4;
                int numOfBitsWithinLastHexDigitToKeep = numOfLeftHandBitsOfLastPieceToKeep - numOfHexDigitsToKeep * 4;
                for (int j = 0; j < 4; ++j) {
                    if (numOfHexDigitsToKeep > 0) {
                        resultingIPv6Address.append(twoBytePiece.charAt(j));
                        --numOfHexDigitsToKeep;
                        continue;
                    }
                    if (numOfBitsWithinLastHexDigitToKeep > 0) {
                        String tempBinaryValue = IPAddressUtil.hexToBin(twoBytePiece.charAt(j));
                        StringBuilder binaryValue = new StringBuilder(4);
                        for (int bitIndex = 0; bitIndex < 4; ++bitIndex) {
                            if (numOfBitsWithinLastHexDigitToKeep > 0) {
                                binaryValue.append(tempBinaryValue.charAt(bitIndex));
                                --numOfBitsWithinLastHexDigitToKeep;
                                continue;
                            }
                            binaryValue.append('0');
                        }
                        resultingIPv6Address.append(IPAddressUtil.binToHex(binaryValue.toString()));
                        continue;
                    }
                    resultingIPv6Address.append('0');
                }
                numOfLeftHandBitsOfLastPieceToKeep = 0;
            } else {
                resultingIPv6Address.append("0000");
            }
            if (i == 7) continue;
            resultingIPv6Address.append(COLON);
        }
        String expandedAddressStr = resultingIPv6Address.toString();
        try {
            Inet6Address ipAddress_shortForm = (Inet6Address)InetAddress.getByName(expandedAddressStr);
            return ipAddress_shortForm.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            Trace.out("Internal error. We should not get this exception. Details: " + uhe.getMessage());
            throw new IPAddressException(uhe.getMessage(), uhe);
        }
    }

    public static int getIPv4MaskPrefix(String netmask) {
        int prefix = 0;
        if (netmask != null && IPAddressUtil.getIPAddrTypeFromNetmask(netmask).equals((Object)IPAddrType.IPv4)) {
            for (String num : netmask.split(Pattern.quote(String.valueOf(DOT)))) {
                prefix += Integer.bitCount(Integer.parseInt(num));
            }
        }
        return prefix;
    }

    public static InetAddress getIPv4Mask(int prefix) throws IPAddressException {
        InetAddress subnetMask = null;
        try {
            int mask = -1 << 32 - prefix;
            byte[] bytes = new byte[]{(byte)(mask >>> 24), (byte)(mask >> 16 & 0xFF), (byte)(mask >> 8 & 0xFF), (byte)(mask & 0xFF)};
            subnetMask = InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new IPAddressException(uhe.getMessage(), uhe);
        }
        return subnetMask;
    }

    public static int getIPv6MaskPrefix(String netmask) throws IPAddressException {
        int prefixLength = 0;
        String strShortMask = IPAddressUtil.getShorthandIPv6Notation(netmask, true);
        for (String num : strShortMask.split(Pattern.quote(String.valueOf(COLON)))) {
            StringBuffer bufMask = new StringBuffer(num);
            int bufMaskLen = bufMask.length() - 1;
            while (bufMask.charAt(bufMaskLen) == '0') {
                bufMask.deleteCharAt(bufMaskLen);
                bufMaskLen = bufMask.length() - 1;
            }
            if (bufMask.charAt(bufMaskLen) != 'f') {
                prefixLength += Integer.bitCount(Character.digit(bufMask.charAt(bufMaskLen), 16));
                bufMask.deleteCharAt(bufMaskLen);
            }
            prefixLength += bufMask.length() * 4;
        }
        return prefixLength;
    }

    public static Inet6Address getIPv6Mask(int numOfBits) throws IPAddressException {
        IPAddressUtil.assertIPv6PrefixLength(numOfBits);
        if (numOfBits == 0) {
            try {
                return (Inet6Address)InetAddress.getByName("0:0:0:0:0:0:0:0");
            }
            catch (UnknownHostException uhe) {
                Trace.out("Internal Error: This exception should not never be encountered");
                return null;
            }
        }
        if (numOfBits == 128) {
            try {
                return (Inet6Address)InetAddress.getByName("ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
            }
            catch (UnknownHostException uhe) {
                Trace.out("Internal Error: This exception should not never be encountered");
                return null;
            }
        }
        StringBuilder ipv6Mask = new StringBuilder();
        int numOfLeftHandedTwoBytePiecesToKeep = numOfBits / 16;
        int numOfTwoBytePiecesAppended = 0;
        for (int i = 0; i < numOfLeftHandedTwoBytePiecesToKeep; ++i) {
            ipv6Mask.append("ffff");
            ipv6Mask.append(COLON);
            ++numOfTwoBytePiecesAppended;
        }
        int numOfLeftHandBitsOfLastPieceToKeep = numOfBits - numOfLeftHandedTwoBytePiecesToKeep * 16;
        if (numOfTwoBytePiecesAppended != 8) {
            StringBuilder twoBytePieceBinValue = new StringBuilder();
            for (int i = 0; i < 16; ++i) {
                if (numOfLeftHandBitsOfLastPieceToKeep > 0) {
                    twoBytePieceBinValue.append('1');
                    --numOfLeftHandBitsOfLastPieceToKeep;
                    continue;
                }
                twoBytePieceBinValue.append('0');
            }
            ipv6Mask.append(IPAddressUtil.binToHex(twoBytePieceBinValue.toString()));
            if (numOfTwoBytePiecesAppended != 7) {
                ipv6Mask.append(COLON);
            }
            ++numOfTwoBytePiecesAppended;
        }
        while (numOfTwoBytePiecesAppended < 8) {
            ipv6Mask.append("0");
            if (numOfTwoBytePiecesAppended != 7) {
                ipv6Mask.append(COLON);
            }
            ++numOfTwoBytePiecesAppended;
        }
        String ipv6MaskStr = ipv6Mask.toString();
        try {
            return (Inet6Address)InetAddress.getByName(ipv6MaskStr);
        }
        catch (UnknownHostException uhe) {
            Trace.out("Internal Error: This exception should not never be encountered. Details: While caclulating the IPv6 mask for 'numOfBits = " + numOfBits + "' encountered UnknownHostException for IP address string \"" + ipv6MaskStr + "\"");
            return null;
        }
    }

    private static void assertIPv6PrefixLength(int prefixLength) throws IPAddressException {
        if (prefixLength < 0 || prefixLength > 128) {
            Object[] args = new Object[]{prefixLength};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1170", true, args));
        }
    }

    public static String hexToBin(char hexDigit) {
        String binString = Integer.toBinaryString(Character.digit(hexDigit, 16));
        int leadingZeros = 4 - binString.length();
        if (leadingZeros != 0) {
            for (int i = 0; i < leadingZeros; ++i) {
                binString = "0" + binString;
            }
        }
        return binString;
    }

    public static String binToHex(String binary) {
        return Integer.toHexString(Integer.parseInt(binary, 2));
    }

    public static boolean isLocalhost(String ipAddress) {
        InetAddress[] addresses;
        if (ipAddress == null) {
            return false;
        }
        if ((ipAddress = ipAddress.trim()).length() == 0) {
            return false;
        }
        if (ipAddress.equalsIgnoreCase(LOCALHOST)) {
            return true;
        }
        try {
            addresses = InetAddress.getAllByName(LOCALHOST);
        }
        catch (UnknownHostException uhe) {
            Trace.out("Cannot determine whether localhost or not. Details: " + uhe.getMessage());
            return false;
        }
        catch (SecurityException se) {
            Trace.out("Cannot determine whether is localhost or not. Details: " + se.getMessage());
            return false;
        }
        if (ipAddress.equals(IPV4_LOCALHOST_IP) || ipAddress.equals(IPV6_LOCALHOST_IP_FORM_1) || ipAddress.equals(IPV6_LOCALHOST_IP_FORM_2)) {
            return true;
        }
        for (int i = 0; i < addresses.length; ++i) {
            if (!(addresses[i] instanceof Inet4Address ? ipAddress.equals(((Inet4Address)addresses[i]).getHostAddress()) : (addresses[i] instanceof Inet6Address ? ipAddress.equals(((Inet6Address)addresses[i]).getHostAddress()) : ipAddress.equals(addresses[i].getHostAddress())))) continue;
            return true;
        }
        return false;
    }

    public static Map<IPAddrType, List<InetAddress>> getAddrMapFromAddressOrName(String ipAddressOrName) throws IPAddressException {
        InetAddress[] inetAddresses;
        try {
            inetAddresses = InetAddress.getAllByName(ipAddressOrName);
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipAddressOrName};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        HashMap<IPAddrType, List<InetAddress>> addressMap = new HashMap<IPAddrType, List<InetAddress>>(2);
        int numOfAddresses = inetAddresses.length;
        ArrayList<InetAddress> ipv4List = new ArrayList<InetAddress>(numOfAddresses);
        ArrayList<InetAddress> ipv6List = new ArrayList<InetAddress>(numOfAddresses);
        for (int i = 0; i < inetAddresses.length; ++i) {
            if (inetAddresses[i] instanceof Inet4Address) {
                ipv4List.add(inetAddresses[i]);
                continue;
            }
            if (!(inetAddresses[i] instanceof Inet6Address)) continue;
            ipv6List.add(inetAddresses[i]);
        }
        if (!ipv4List.isEmpty()) {
            addressMap.put(IPAddrType.IPv4, ipv4List);
        }
        if (!ipv6List.isEmpty()) {
            addressMap.put(IPAddrType.IPv6, ipv6List);
        }
        return addressMap;
    }

    public static IPAddrType getAddrTypeFromAddressOrName(String ipAddressOrName) throws IPAddressException {
        InetAddress[] inetAddresses;
        try {
            inetAddresses = InetAddress.getAllByName(ipAddressOrName);
        }
        catch (UnknownHostException uhe) {
            Object[] args = new Object[]{ipAddressOrName};
            throw new IPAddressException(MessageBundle.getMessageBundle("Prkc").getMessage("1168", true, args));
        }
        boolean detectedIPpv4Address = false;
        boolean detectedIPpv6Address = false;
        for (int i = 0; i < inetAddresses.length; ++i) {
            if (inetAddresses[i] instanceof Inet4Address) {
                detectedIPpv4Address = true;
                continue;
            }
            if (!(inetAddresses[i] instanceof Inet6Address)) continue;
            detectedIPpv6Address = true;
        }
        if (detectedIPpv4Address && detectedIPpv6Address) {
            return IPAddrType.BOTH;
        }
        if (detectedIPpv4Address) {
            return IPAddrType.IPv4;
        }
        return IPAddrType.IPv6;
    }

    public static IPAddrType getIPAddrTypeFromIPAddress(String ipAddress) {
        if (ipAddress == null) {
            return null;
        }
        if (ipAddress.indexOf(COLON) != -1) {
            return IPAddrType.IPv6;
        }
        StringTokenizer dotTokenizer = new StringTokenizer(ipAddress, DOT);
        if (dotTokenizer.countTokens() == 4) {
            return IPAddrType.IPv4;
        }
        return null;
    }

    public static IPAddrType getIPAddrTypeFromNetmask(String netmask) {
        block4: {
            if (netmask == null) {
                return null;
            }
            try {
                int netmaskIPv6 = Integer.valueOf(netmask);
                if (netmaskIPv6 >= 0 && netmaskIPv6 <= 128) {
                    return IPAddrType.IPv6;
                }
            }
            catch (NumberFormatException nfe) {
                StringTokenizer dotTokenizer = new StringTokenizer(netmask, DOT);
                if (dotTokenizer.countTokens() != 4) break block4;
                return IPAddrType.IPv4;
            }
        }
        return null;
    }

    public static boolean isIPv4AddressString(String ipAddressStr) {
        if (ipAddressStr == null) {
            return false;
        }
        if (ipAddressStr.indexOf(DOT) == -1) {
            return false;
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipAddressStr.trim());
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        if (!(ipAddress instanceof Inet4Address)) {
            return false;
        }
        StringTokenizer dotTokenizer = new StringTokenizer(ipAddressStr, DOT);
        int numOfTokens = dotTokenizer.countTokens();
        if (numOfTokens != 4) {
            return false;
        }
        for (int i = 0; i < numOfTokens; ++i) {
            try {
                int tokenValue = Integer.valueOf(dotTokenizer.nextToken());
                if (tokenValue >= 0 && tokenValue <= 255) continue;
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    public static boolean isIPv6AddressString(String ipAddressStr) {
        if (ipAddressStr == null) {
            return false;
        }
        if (ipAddressStr.indexOf(COLON) == -1) {
            return false;
        }
        InetAddress ipAddress = null;
        try {
            ipAddress = InetAddress.getByName(ipAddressStr.trim());
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        return ipAddress instanceof Inet6Address;
    }

    public static boolean isIPv6PrefixLength(String prefixLengthStr) {
        int prefixLength;
        try {
            prefixLength = Integer.valueOf(prefixLengthStr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        try {
            IPAddressUtil.assertIPv6PrefixLength(prefixLength);
            return true;
        }
        catch (IPAddressException e) {
            return false;
        }
    }

    public static boolean isIPAddressString(String ipAddressStr) {
        if (ipAddressStr == null) {
            return false;
        }
        if ((ipAddressStr = ipAddressStr.trim()).length() == 0) {
            return false;
        }
        if (IPAddressUtil.isIPv4AddressString(ipAddressStr)) {
            return true;
        }
        return IPAddressUtil.isIPv6AddressString(ipAddressStr);
    }

    public static boolean isPingable(InetAddress address) throws IPAddressException {
        try {
            if (Utils.isDevelopmentEnv() && address.getHostAddress().equals("0.0.0.0")) {
                return false;
            }
            return address.isReachable(1000);
        }
        catch (IOException ioe) {
            Object[] args = new Object[]{address.getHostAddress()};
            String errorMessage = MessageBundle.getMessageBundle("Prkc").getMessage("1174", true, args);
            throw new IPAddressException(errorMessage);
        }
    }

    public static Map<Boolean, List<InetAddress>> getPingabilityMap(List<InetAddress> addressList) throws IPAddressException {
        int i;
        HashMap<Boolean, List<InetAddress>> pingabilityMap = new HashMap<Boolean, List<InetAddress>>(2);
        if (addressList == null) {
            return pingabilityMap;
        }
        int numOfAddresses = addressList.size();
        if (numOfAddresses == 0) {
            return pingabilityMap;
        }
        Thread[] pingThreads = new Thread[numOfAddresses];
        final PingableStatus[] status = new PingableStatus[numOfAddresses];
        Iterator<InetAddress> addressItr = addressList.iterator();
        for (i = 0; i < numOfAddresses; ++i) {
            final InetAddress currAddress = addressItr.next();
            final int threadIndex = i;
            pingThreads[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        status[threadIndex] = IPAddressUtil.isPingable(currAddress) ? PingableStatus.TRUE : PingableStatus.FALSE;
                    }
                    catch (IPAddressException ipae) {
                        status[threadIndex] = PingableStatus.UNABLE_TO_VERIFY;
                    }
                }
            };
            pingThreads[i].start();
        }
        try {
            for (i = 0; i < numOfAddresses; ++i) {
                pingThreads[i].join();
            }
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        ArrayList<InetAddress> pingableAddresses = new ArrayList<InetAddress>(numOfAddresses);
        ArrayList<InetAddress> nonPingableAddresses = new ArrayList<InetAddress>(numOfAddresses);
        StringBuilder errorReportBuilder = new StringBuilder();
        addressItr = addressList.iterator();
        for (int i3 = 0; i3 < numOfAddresses; ++i3) {
            InetAddress currAddress = addressItr.next();
            if (status[i3] == PingableStatus.TRUE) {
                pingableAddresses.add(currAddress);
                continue;
            }
            if (status[i3] == PingableStatus.FALSE) {
                nonPingableAddresses.add(currAddress);
                continue;
            }
            if (status[i3] != PingableStatus.UNABLE_TO_VERIFY) continue;
            errorReportBuilder.append(currAddress.getHostAddress());
            errorReportBuilder.append(", ");
        }
        if (errorReportBuilder.length() > 0) {
            String errorReport = errorReportBuilder.toString();
            errorReport = errorReport.substring(0, errorReport.lastIndexOf(", "));
            Object[] args = new Object[]{errorReport};
            String errorMessage = MessageBundle.getMessageBundle("Prkc").getMessage("1174", true, args);
            throw new IPAddressException(errorMessage);
        }
        if (!pingableAddresses.isEmpty()) {
            pingabilityMap.put(true, pingableAddresses);
        }
        if (!nonPingableAddresses.isEmpty()) {
            pingabilityMap.put(false, nonPingableAddresses);
        }
        return pingabilityMap;
    }

    @Deprecated
    public static boolean isValidHomeNode(String homeNode) {
        String validHostnameRegex;
        return null != homeNode && homeNode.length() < 63 && homeNode.matches(validHostnameRegex = "[a-zA-Z\\d-]+");
    }

    public static boolean isValidHostName(String hostName) {
        String validHostnameRegex = null;
        validHostnameRegex = Utils.isDevelopmentEnv() ? "[a-zA-Z\\d-_]+" : "[a-zA-Z\\d-]+";
        return null != hostName && !hostName.isEmpty() && hostName.length() < 63 && hostName.matches(validHostnameRegex);
    }

    public static boolean isValidHostNameOrIPAddress(String host) {
        String ipv4regex = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
        if (null != host) {
            if (host.matches(ipv4regex)) {
                Trace.out(host + " is a valid IPv4 address");
                return true;
            }
            Trace.out(host + " is not a valid IPv4 address");
            try {
                InetAddress ip = InetAddress.getByName(host);
                Trace.out(host + " is a valid hostname or IPv6 address");
                return true;
            }
            catch (UnknownHostException e) {
                Trace.out(host + " is not a valid hostname or IPv6 address");
            }
        }
        return false;
    }

    private static List<String> resolveDNS(String hostname, IPAddrType addressType, String dnsURL) {
        ArrayList<String> result = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        String record = addressType == IPAddrType.IPv4 ? "A" : "AAAA";
        String[] attribIDs = new String[]{record};
        try {
            InitialDirContext dirContext;
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", dnsURL);
            try {
                dirContext = new InitialDirContext(env);
            }
            catch (NumberFormatException ipv6NamesrverNotSupported) {
                return null;
            }
            Attributes attribs = dirContext.getAttributes(hostname, attribIDs);
            Attribute attrib = attribs.get(record);
            if (attrib != null) {
                result = new ArrayList<String>();
                NamingEnumeration<?> attribEnumeration = attrib.getAll();
                while (attribEnumeration.hasMoreElements()) {
                    result.add(attribEnumeration.next().toString());
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (null == result) {
            Trace.out("Host name \"" + hostname + "\" does not resolve to an " + addressType.toString() + " address usind DNS url \"" + dnsURL + "\"");
        }
        return result;
    }

    public static InetAddress getLocalIpFromNetworkAddress(String netAddress) throws IPAddressException {
        InetAddress matchingIpAddress = null;
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            block4: while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (!ni.isUp() || ni.isLoopback()) continue;
                List<InterfaceAddress> list = ni.getInterfaceAddresses();
                Iterator<InterfaceAddress> it = list.iterator();
                while (it.hasNext()) {
                    try {
                        InterfaceAddress ia = it.next();
                        String subnet = "";
                        String ip = ia.getAddress().getHostAddress();
                        if (IPAddressUtil.isIPv4AddressString(ip)) {
                            InetAddress subnetMask = IPAddressUtil.getIPv4Mask(ia.getNetworkPrefixLength());
                            if (subnetMask != null) {
                                subnet = subnetMask.getHostAddress();
                            }
                            Trace.out("Found local IPv4 " + ip + " with mask " + subnet);
                        } else if (IPAddressUtil.isIPv6AddressString(ip)) {
                            subnet = Short.toString(ia.getNetworkPrefixLength());
                            Trace.out("Found local IPv6 " + ip + " with prefix " + subnet);
                        }
                        String currentNetworkAddress = IPAddressUtil.applyNetmaskOrPrefixLength(ip, subnet);
                        Trace.out("Calculated " + currentNetworkAddress + " as the network address of " + ip + " / " + subnet);
                        if (!IPAddressUtil.sameIPAddresses(currentNetworkAddress, netAddress)) continue;
                        Trace.out("Successfully found IP " + ip + " part of network " + netAddress);
                        matchingIpAddress = InetAddress.getByName(ip);
                        continue block4;
                    }
                    catch (UnknownHostException | IPAddressException ex) {
                        Trace.out(ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    }
                }
            }
        }
        catch (SocketException se) {
            Trace.out("SocketException: " + se.getMessage());
            throw new IPAddressException(se.getMessage(), se);
        }
        if (matchingIpAddress == null) {
            Object[] args = new Object[]{netAddress};
            String msg = MessageBundle.getMessageBundle("Prkc").getMessage("1192", true, args);
            throw new IPAddressException(msg);
        }
        return matchingIpAddress;
    }

    public static enum ADDRESS_PREFIX {
        COMPATIBILITY_ADDRESS("::"),
        IPv4MAPPED_ADDRESS("::FFFF:");

        private String m_value;

        private ADDRESS_PREFIX(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    private static enum PingableStatus {
        TRUE,
        FALSE,
        UNABLE_TO_VERIFY;

    }

    public static enum IPAddrType {
        IPv4("IPV4"),
        IPv6("IPV6"),
        BOTH("BOTH");

        private String m_value;

        private IPAddrType(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }

        public static IPAddrType fromString(String value) {
            if (value != null) {
                if ((value = value.trim()).equalsIgnoreCase(IPv4.toString())) {
                    return IPv4;
                }
                if (value.equalsIgnoreCase(IPv6.toString())) {
                    return IPv6;
                }
                if (value.equalsIgnoreCase(BOTH.toString())) {
                    return BOTH;
                }
            }
            return null;
        }
    }
}

