/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nls;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.nls.MessageKey;

public class MessageBundle {
    private static Hashtable m_hBundles = new Hashtable();
    private static String m_sSeparator = "/";
    private static ThreadLocal<Locale> m_defLocale = new ThreadLocal();
    private static ThreadLocal<String> m_strLang = new ThreadLocal();
    private static ThreadLocal<String> m_strNlsLang = new ThreadLocal();
    private ResourceBundle m_resBundle;
    private MessageBundleList.FacilityList m_facility;
    private Locale m_locale = MessageBundle.getDefLocale();

    public MessageBundle(MessageBundleList.FacilityList facility) {
        this(facility, MessageBundle.getDefLocale());
    }

    public MessageBundle(MessageBundleList.FacilityList facility, Locale locale) {
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = facility;
    }

    public MessageBundle(MessageBundleList.FacilityList facility, String strLocale) {
        this.m_locale = this.toLocale(strLocale);
        this.m_facility = facility;
    }

    public MessageBundle(String facility) {
        this(facility, MessageBundle.getDefLocale());
    }

    public MessageBundle(String facility, Locale locale) {
        this(MessageBundleList.FacilityList.valueOf(facility), locale);
    }

    public MessageBundle(String facility, String strLocale) {
        this(MessageBundleList.FacilityList.valueOf(facility), strLocale);
    }

    public static MessageBundle getMessageBundle(MessageBundleList.FacilityList facility) {
        return MessageBundle.getMessageBundle(facility, MessageBundle.getDefLocale());
    }

    public static MessageBundle getMessageBundle(MessageKey key) {
        return MessageBundle.getMessageBundle(key.getFacility(), MessageBundle.getDefLocale());
    }

    public static MessageBundle getMessageBundle(MessageBundleList.FacilityList facility, Locale locale) {
        return MessageBundle.getMessageBundle(facility, locale.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBundle getMessageBundle(MessageBundleList.FacilityList facility, String strLocale) {
        StringBuffer bdlInfo = new StringBuffer(50);
        bdlInfo.append(facility.getFacility()).append(m_sSeparator).append(strLocale);
        MessageBundle bndl = null;
        Hashtable hashtable = m_hBundles;
        synchronized (hashtable) {
            bndl = (MessageBundle)m_hBundles.get(bdlInfo.toString());
            if (bndl == null) {
                bndl = new MessageBundle(facility, strLocale);
                m_hBundles.put(bdlInfo.toString(), bndl);
            }
        }
        return bndl;
    }

    public static MessageBundle getMessageBundle(String facility) {
        return MessageBundle.getMessageBundle(facility, MessageBundle.getDefLocale());
    }

    public static MessageBundle getMessageBundle(String facility, Locale locale) {
        return MessageBundle.getMessageBundle(facility, locale.toString());
    }

    public static MessageBundle getMessageBundle(String facility, String strLocale) {
        return MessageBundle.getMessageBundle(MessageBundleList.FacilityList.valueOf(facility), strLocale);
    }

    public String getMessage(MessageKey key, boolean errNum) {
        assert (this.getFacility().equals(key.getFacility())) : "Illegal key=" + key.getName() + " does not belong to facility=" + this.getFacility();
        String[] msg = (String[])this.getMyBundle().getObject(key.getName());
        if (!errNum) {
            return msg[0];
        }
        return this.getCode(key) + " : " + msg[0];
    }

    public static String getMessage(MessageKey key, boolean errNum, Object ... args) {
        return MessageFormat.format(MessageBundle.getMessageBundle(key.getFacility()).getMessage(key, errNum), args);
    }

    public String getMessageFields(String key, boolean errNum, int fld) {
        String[] msg = new String[3];
        try {
            msg = (String[])this.getMyBundle().getObject(key);
        }
        catch (MissingResourceException e) {
            msg[fld] = new String("<null>");
        }
        if (!errNum) {
            return msg[fld];
        }
        return this.getCode(key) + " : " + msg[fld];
    }

    public String getMessage(String key, boolean errNum) {
        return this.getMessageFields(key, errNum, 0);
    }

    public String getCause(String key, boolean errNum) {
        String msg = this.getMessageFields(key, errNum, 1);
        int index = msg.indexOf(58);
        if (index >= 0) {
            if (index + 1 == msg.length()) {
                return "";
            }
            return msg.substring(index + 1);
        }
        return msg;
    }

    public String getAction(String key, boolean errNum) {
        String msg = this.getMessageFields(key, errNum, 2);
        int index = msg.indexOf(58);
        if (index >= 0) {
            if (index + 1 == msg.length()) {
                return "";
            }
            return msg.substring(index + 1);
        }
        return msg;
    }

    public String getMessage(String key, boolean errNum, Object[] args) {
        return MessageFormat.format(this.getMessage(key, errNum), args);
    }

    private String getCode(MessageKey key) {
        return this.getFacility().toUpperCase() + "-" + key.getID();
    }

    private String getCode(String key) {
        return this.getFacility().toUpperCase() + "-" + key;
    }

    public void setPackage(String packageName) {
    }

    public String getPackageName() {
        return this.m_facility.getPackage();
    }

    private void loadBundle(boolean forceReload) {
        if (this.getLocale() != MessageBundle.getDefLocale()) {
            forceReload = true;
        }
        if (this.m_resBundle == null || forceReload) {
            String packageName = this.getPackageName();
            String resourceString = packageName + "." + this.getFacility() + "Msg";
            if (packageName.equals("oracle.gridhome.resources")) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this.m_resBundle = ResourceBundle.getBundle(resourceString, MessageBundle.getDefLocale(), cl);
            } else {
                this.m_resBundle = ResourceBundle.getBundle(resourceString, MessageBundle.getDefLocale());
            }
        }
    }

    private String getFacility() {
        return this.m_facility.getFacility();
    }

    public static void setDefLocale(Locale newLocale) {
        if (newLocale != null) {
            m_defLocale.set(newLocale);
        }
    }

    public static Locale getDefLocale() {
        Locale locale = m_defLocale.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public Locale toLocale(String strLocale) {
        Locale newLocale = MessageBundle.getDefLocale();
        if (strLocale != null) {
            StringTokenizer tk = new StringTokenizer(strLocale, "_");
            if (tk.countTokens() == 3) {
                String language = tk.nextToken();
                String country = tk.nextToken();
                String variant = tk.nextToken();
                newLocale = new Locale(language, country, variant);
            } else if (tk.countTokens() == 2) {
                if (!strLocale.startsWith("_")) {
                    String language = tk.nextToken();
                    String country = tk.nextToken();
                    newLocale = country.length() == 2 && country.toUpperCase().equals(country) ? new Locale(language, country) : new Locale(language);
                }
            } else if (tk.countTokens() == 1 && !strLocale.startsWith("_")) {
                String language = tk.nextToken();
                newLocale = new Locale(language);
            }
            try {
                newLocale.getISO3Language();
            }
            catch (MissingResourceException e) {
                newLocale = MessageBundle.getDefLocale();
            }
        }
        return newLocale;
    }

    private Locale getLocale() {
        return this.m_locale;
    }

    private synchronized ResourceBundle getMyBundle() {
        this.loadBundle(false);
        return this.m_resBundle;
    }

    public static void setStrLang(String env_LANG) {
        if (env_LANG == null) {
            env_LANG = "";
        }
        m_strLang.set(env_LANG);
    }

    public static void setStrNlsLang(String env_NLS_LANG) {
        if (env_NLS_LANG == null) {
            env_NLS_LANG = "";
        }
        m_strNlsLang.set(env_NLS_LANG);
    }

    public static String getStrLang() {
        return m_strLang.get();
    }

    public static String getStrNlsLang() {
        return m_strNlsLang.get();
    }
}

