/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.CopyListedFilesException;
import oracle.ops.mgmt.cluster.CreateListedDirsException;
import oracle.ops.mgmt.cluster.HostnameException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.RemoteCopyException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.service.ServiceData;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.UnixNative;
import oracle.ops.mgmt.nativesystem.sPlatform;
import oracle.ops.mgmt.nativesystem.sUnixCommands;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class UnixSystem
extends NativeSystem
implements sUnixCommands,
Constants {
    private static String m_remoteShellCmd = null;
    private static String m_remoteCopyCmd = null;
    private static final int ORACLE_GROUP = 1;
    private static final int ASMADMIN_GROUP = 2;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private static final String WILD_CARD_CHARACTER = "*";
    private static String s_permValue = null;

    protected UnixSystem() {
    }

    @Override
    String loadPathDescription() {
        return "LD_LIBRARY_PATH";
    }

    @Override
    String getOracleLibraryName(String libraryName) {
        return libraryName;
    }

    private boolean isLocalNode(String node) {
        String nodeName = null;
        int dotIdx = node.indexOf(".");
        nodeName = dotIdx != -1 ? node.substring(0, dotIdx) : node;
        try {
            String localhost = Utils.getLocalHost();
            if (Trace.isLevelEnabled(1)) {
                Trace.out("Comparing '" + nodeName + "' to localhost '" + localhost + "'");
            }
            return nodeName.equalsIgnoreCase(localhost);
        }
        catch (UnknownHostException uhe) {
            if (Trace.isLevelEnabled(5)) {
                Trace.out("UnknownHostException caught");
            }
            return false;
        }
    }

    @Override
    public String getIPAddrCommand() {
        return "/sbin/ifconfig -a";
    }

    @Override
    public String getHostName(String nodeName) throws HostnameException {
        if (nodeName.equals("localnode") || this.isLocalNode(nodeName)) {
            this.unixcmd = "/usr/bin/hostname";
        } else {
            try {
                this.unixcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " " + "/usr/bin/hostname";
            }
            catch (RemoteShellException re) {
                throw new HostnameException(re.getMessage());
            }
        }
        Trace.out(5, "unixcmd=" + this.unixcmd);
        RuntimeExec rt = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        rt.runCommand();
        String[] output = rt.getOutput();
        if (rt.getExitValue() != 0) {
            int i;
            String[] error = rt.getError();
            StringBuffer retStringBuffer = new StringBuffer();
            if (output != null) {
                for (i = 0; i < output.length; ++i) {
                    retStringBuffer.append(output[i] + " ");
                }
            }
            if (error != null) {
                for (i = 0; i < error.length; ++i) {
                    retStringBuffer.append(error[i] + " ");
                }
            }
            throw new HostnameException(retStringBuffer.toString());
        }
        if (output != null && output.length > 0) {
            return output[0];
        }
        Object[] args = new String[]{nodeName};
        throw new HostnameException("1056", args);
    }

    @Override
    public String getPrivateNodeName(String nodeName) throws HostnameException {
        int i;
        String pvtNodeNameCmd = this.getPrivateNodeNameCommand();
        if (pvtNodeNameCmd == null) {
            return null;
        }
        this.unixcmd = pvtNodeNameCmd + nodeName;
        Trace.out(5, "unixcmd=" + this.unixcmd);
        RuntimeExec rt = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        rt.runCommand();
        String[] output = rt.getOutput();
        if (rt.getExitValue() == 0 && output.length > 0) {
            return output[0];
        }
        String[] error = rt.getError();
        StringBuffer errBuf = new StringBuffer();
        for (i = 0; i < output.length; ++i) {
            errBuf.append(output[i] + " ");
        }
        for (i = 0; i < error.length; ++i) {
            errBuf.append(error[i] + " ");
        }
        Object[] args = new String[]{nodeName, errBuf.toString()};
        throw new HostnameException("1068", args);
    }

    @Override
    public String getEffectiveGroup() throws NativeException {
        NativeResult nativeResult = new NativeResult();
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        UnixNative.getEffectiveGroup(nativeResult);
        if (!nativeResult.getStatus()) {
            throw new NativeException(nativeResult.getOSString());
        }
        String eGroup = nativeResult.getStringResult();
        return eGroup;
    }

    @Override
    public NativeResult createRemoteExecDir(String node, String dir, String group) {
        String SEP = " ";
        String mask = "003";
        String umaskCmd = "umask 003";
        String mkdirCmd = "/usr/bin/mkdir -p " + dir;
        String chGrpCmd = "/bin/chgrp " + group + " " + dir;
        NativeResult nResult = new NativeResult();
        Trace.out(5, "createRemoteExecDir node = " + node + " | group = " + group + " | dir = " + dir);
        String makeRemDirCmd = "umask 003 && " + mkdirCmd + " && " + chGrpCmd;
        if (node.equals("localnode") || this.isLocalNode(node)) {
            this.unixcmd = makeRemDirCmd;
        } else {
            String remoteShellCmd = "";
            try {
                remoteShellCmd = this.getRemoteShellCmd(node) + " " + node + " -n ";
            }
            catch (RemoteShellException rse) {
                Trace.out(5, "createRemoteExecDir failed on node " + node);
                Trace.out(rse);
                return new NativeResult("0|" + rse.getMessage());
            }
            this.unixcmd = remoteShellCmd + " " + "\"" + "/usr/bin/sh" + " " + "-c" + " " + "'" + makeRemDirCmd + "'\"";
        }
        Trace.out(5, "unixcmd = " + this.unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        nResult.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdarray)) {
                retval = 1;
            }
            if (retval != 0) {
                nResult.setOSString(rtErr);
            }
        }
        boolean bstatus = retval == 0;
        nResult.setStatus(bstatus);
        return nResult;
    }

    @Override
    public String startDaemon(String nodeName, String oracleHome) {
        String runcmd = null;
        String exeLocation = oracleHome + File.separator + "bin" + File.separator + "gsd";
        Trace.out(5, "StartDaemon EXELOCATION IS " + exeLocation);
        if (nodeName.equals("localnode") || this.isLocalNode(nodeName)) {
            runcmd = exeLocation;
        } else {
            try {
                runcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " -n " + "/bin/sh" + " " + "-c" + " " + '\"' + "ORACLE_HOME=" + oracleHome + " " + "LD_LIBRARY_PATH" + '=' + oracleHome + "/lib" + exeLocation + '\"';
            }
            catch (RemoteShellException rse) {
                Trace.out(rse);
                return "0|" + rse.getMessage();
            }
        }
        Trace.out(5, "Inside startDaemon\n");
        String result = UnixSystem.rununixcmd(runcmd);
        return result;
    }

    @Override
    public String initializeClusterThread() {
        return null;
    }

    @Override
    public String initializeClusterWare() {
        return null;
    }

    private String createFileName(String nodeName, String fileName) {
        if (nodeName.equals("localnode") || this.isLocalNode(nodeName)) {
            return fileName;
        }
        if (isTectiaSsh) {
            return nodeName + ":" + fileName;
        }
        return nodeName + ":'" + fileName + "'";
    }

    @Override
    public boolean isACLSet(String filePath) throws NativeException {
        ArrayList<String> srcList = new ArrayList<String>();
        NativeResult nativeResult = new NativeResult();
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        String srcFile = null;
        String srcDir = null;
        int indexLastFileSeparator = filePath.lastIndexOf(File.separator);
        srcFile = filePath.substring(indexLastFileSeparator + 1);
        srcDir = filePath.substring(0, indexLastFileSeparator);
        Trace.out("Input src :" + srcFile);
        if (new File(filePath).exists()) {
            srcList.add(filePath);
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(srcDir, new String[0]), srcFile);){
                for (Path path : stream) {
                    Trace.out("Found file " + path.getFileName());
                    srcList.add(path.toAbsolutePath().toString());
                }
            }
            catch (IOException ie) {
                Object[] args = new Object[]{srcFile};
                throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
            }
            if (srcList.size() == 0) {
                Object[] args = new Object[]{srcFile};
                throw new NativeException(s_msgBundle.getMessage("1144", true, args));
            }
        }
        UnixNative.isAclSet(srcList.toArray(new String[srcList.size()]), nativeResult);
        if (nativeResult.getStatus()) {
            return nativeResult.getBooleanResult();
        }
        Trace.out("Failed to check on " + filePath + " : " + nativeResult.getOSString());
        throw new NativeException(new String[]{nativeResult.getOSString()});
    }

    @Override
    public boolean isPathACFS(String path) throws NativeException {
        NativeResult nativeResult = new NativeResult();
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        UnixNative.isACFS(path, nativeResult);
        if (nativeResult.getStatus()) {
            return nativeResult.getBooleanResult();
        }
        Trace.out("Failed to check on " + path + " : " + nativeResult.getOSString());
        throw new NativeException(new String[]{nativeResult.getOSString()});
    }

    @Override
    public boolean isACLSupported(String path) throws NativeException {
        NativeResult nativeResult = new NativeResult();
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        UnixNative.isAclSupported(path, nativeResult);
        if (nativeResult.getStatus()) {
            return nativeResult.getBooleanResult();
        }
        Trace.out("Failed to check on " + path + " : " + nativeResult.getOSString());
        throw new NativeException(new String[]{nativeResult.getOSString()});
    }

    private String remoteCopyFile(String node1, String file1, String node2, String file2, boolean noPreserve) {
        Trace.out(5, "Copying files " + node1 + file1 + " " + node2 + file2);
        String remoteNode = node1.equals("localnode") || this.isLocalNode(node1) ? node2 : node1;
        try {
            this.unixcmd = this.getRemoteCopyCmd(remoteNode) + (noPreserve ? " " : " -p ") + this.createFileName(node1, file1) + " " + this.createFileName(node2, file2);
        }
        catch (RemoteCopyException rce) {
            Trace.out(rce);
            return "0|" + rce.getMessage();
        }
        Trace.out(5, "UnixSystem: " + this.unixcmd);
        return UnixSystem.rununixcmd(remoteNode, this.unixcmd);
    }

    private String getCopyTarCmd(String srcFile, String srcDir, String destFile, String destDir) {
        String srcTAR = "/usr/bin/tar cfp - " + srcFile;
        String destTAR = "/usr/bin/tar xfp -";
        String newFile = "/usr/bin/mv -f " + srcFile + " " + destFile;
        boolean useSymLink = false;
        if (!srcFile.equals(destFile)) {
            File srcFileAtDest = new File(destDir + File.separator + srcFile);
            if (srcFileAtDest.exists()) {
                useSymLink = true;
            } else {
                destTAR = destTAR + " " + "&&" + " " + newFile;
            }
        }
        String cdToSrc = "cd " + srcDir;
        String cdToDest = "cd " + destDir;
        String srcCmd = null;
        String destCmd = null;
        if (!useSymLink) {
            srcCmd = "(" + cdToSrc + " " + "&&" + " " + srcTAR + " " + ")";
            destCmd = "(" + cdToDest + " " + "&&" + " " + destTAR + " " + ")";
        } else {
            String symLinkTAR = "/usr/bin/tar cfph - " + destFile;
            String lnCmd = "/usr/bin/ln -fs " + srcDir + File.separator + srcFile + " " + destFile;
            srcCmd = "(" + cdToDest + " " + "&&" + " " + lnCmd + " " + "&&" + " " + "(" + " " + symLinkTAR + " " + ")";
            destCmd = "( " + destTAR + " " + "))";
        }
        String tarCmd = srcCmd + " " + "|" + " " + destCmd;
        Trace.out("TAR command used = " + tarCmd);
        return tarCmd;
    }

    @Override
    public String copyFilesLocally(String fileNamesToCopy, String sourceDirPathname, String destDirPathname, boolean preserve) {
        boolean copyUsingTar;
        String options;
        String destFile;
        String destDir;
        block22: {
            if (sourceDirPathname == null || destDirPathname == null) {
                return "0|" + MessageBundle.getMessageBundle("Prkc").getMessage("1171", false, new String[]{"copy-unix-error-01"});
            }
            destDir = destDirPathname;
            destFile = fileNamesToCopy;
            options = " -f ";
            copyUsingTar = false;
            boolean canHandleACL = false;
            if (DeterminePlatform.getOSName().equals("AIX") || DeterminePlatform.getOSName().equals("HP-UX")) {
                canHandleACL = true;
            }
            if (preserve && !canHandleACL) {
                File dest = new File(destDirPathname);
                if (!dest.exists() || !dest.isDirectory()) {
                    destFile = dest.getName();
                    destDir = dest.getParent();
                }
                boolean isSameDir = false;
                try {
                    isSameDir = Files.isSameFile(Paths.get(destDir, new String[0]), Paths.get(sourceDirPathname, new String[0]));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (isSameDir) {
                    Trace.out("Copying a file within the same directory");
                    options = " -fp ";
                } else {
                    try {
                        if (this.isACLSet(sourceDirPathname + File.separator + fileNamesToCopy)) {
                            if (this.isACLSupported(destDir)) {
                                options = " -fp ";
                            } else {
                                Trace.out("src has ACL set and target doesn't support ACL");
                                copyUsingTar = true;
                            }
                            break block22;
                        }
                        options = " -fp ";
                    }
                    catch (NativeException ne) {
                        copyUsingTar = true;
                    }
                }
            } else if (preserve) {
                options = " -fp ";
            }
        }
        String unixcmd = !copyUsingTar ? "/usr/bin/cp" + options + sourceDirPathname + File.separator + fileNamesToCopy + " " + destDirPathname : this.getCopyTarCmd(fileNamesToCopy, sourceDirPathname, destFile, destDir);
        String[] cmdArray = new String[]{"/usr/bin/sh", "-c", unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retVal = runtime.runCommand();
        String[] cmdOutput = runtime.getOutput();
        String[] cmdError = runtime.getError();
        if (cmdError != null && cmdError.length != 0) {
            StringBuilder cmdErr = new StringBuilder();
            for (int i = 0; i < cmdError.length; ++i) {
                cmdErr.append(cmdError[i] + "\n");
            }
            Trace.out("Command error:\n" + cmdErr.toString());
            return "0|" + cmdErr.toString();
        }
        if (cmdOutput == null) {
            if (retVal == 0) {
                return "1|Successfully copied files";
            }
            return "0|Error copying files";
        }
        if (cmdOutput.length != 0) {
            StringBuilder cmdOut = new StringBuilder();
            for (int i = 0; i < cmdOutput.length; ++i) {
                cmdOut.append(cmdOutput[i] + "\n");
            }
            Trace.out("Command output:\n" + cmdOut.toString());
            return "0|" + cmdOut.toString();
        }
        if (retVal == 0) {
            return "1|" + cmdOutput.toString();
        }
        return "0|" + cmdOutput.toString();
    }

    @Override
    public String copyFile(String node1, String file1, String node2, String file2) {
        return this.copyFile(node1, file1, node2, file2, false);
    }

    @Override
    public String copyFile(String node1, String file1, String node2, String file2, boolean noPreserve) {
        String preserveFlag;
        file1 = Paths.get(file1, new String[0]).toAbsolutePath().toString();
        Trace.out(5, "Copy file " + node1 + ":" + file1 + " to " + node2 + ":" + file2);
        if (node1.equalsIgnoreCase(node2) && file1.equals(file2)) {
            try {
                if (this.pathExists(node1, file1, 0)) {
                    return "1|making self copy no-op";
                }
                return "0|" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{file1, node1});
            }
            catch (RemoteDirException e) {
                return "0|" + e.getMessage();
            }
        }
        String destDir = file2;
        String destFile = null;
        String srcFile = file1;
        String srcDir = null;
        boolean copyUsingTar = false;
        if ((node1.equals("localnode") || this.isLocalNode(node1)) && (node2.equals("localnode") || this.isLocalNode(node2))) {
            block23: {
                preserveFlag = " ";
                boolean canHandleACL = false;
                if (DeterminePlatform.getOSName().equals("AIX") || DeterminePlatform.getOSName().equals("HP-UX")) {
                    canHandleACL = true;
                }
                if (!noPreserve && !canHandleACL) {
                    File copyFile = new File(file1);
                    if (!copyFile.exists()) {
                        int indexLastFileSeparator = file1.lastIndexOf(File.separator);
                        srcFile = file1.substring(indexLastFileSeparator + 1);
                        srcDir = file1.substring(0, indexLastFileSeparator);
                    } else {
                        srcFile = copyFile.getName();
                        srcDir = copyFile.getParentFile().getAbsolutePath();
                    }
                    File dest = new File(destDir);
                    if (!dest.exists() || !dest.isDirectory()) {
                        destDir = dest.getParent();
                        destFile = dest.getName();
                    }
                    boolean isSameDir = false;
                    try {
                        isSameDir = Files.isSameFile(Paths.get(destDir, new String[0]), Paths.get(srcDir, new String[0]));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (isSameDir) {
                        Trace.out("Copying a file within the same directory");
                        preserveFlag = " -p ";
                    } else {
                        try {
                            if (this.isACLSet(file1)) {
                                if (this.isACLSupported(destDir)) {
                                    preserveFlag = " -p ";
                                } else {
                                    Trace.out("src has ACL set and target doesn't support ACL");
                                    copyUsingTar = true;
                                }
                                break block23;
                            }
                            preserveFlag = " -p ";
                        }
                        catch (NativeException ne) {
                            copyUsingTar = true;
                        }
                    }
                } else if (!noPreserve) {
                    preserveFlag = " -p ";
                }
            }
            if (copyUsingTar) {
                this.unixcmd = this.getCopyTarCmd(srcFile, srcDir, destFile == null ? srcFile : destFile, destDir);
                String[] cmdArray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
                Trace.out(5, "UnixSystem: " + this.unixcmd);
                return UnixSystem.rununixcmd(cmdArray, null, null);
            }
        } else {
            return this.remoteCopyFile(node1, file1, node2, file2, noPreserve);
        }
        this.unixcmd = "/usr/bin/cp" + preserveFlag + this.createFileName(node1, file1) + " " + this.createFileName(node2, file2);
        Trace.out(5, "UnixSystem: " + this.unixcmd);
        return UnixSystem.rununixcmd(this.unixcmd);
    }

    public int copyFilesByTar(String node, String fileList) throws RemoteShellException {
        Trace.out("Copying files By Tar " + node + fileList);
        this.unixcmd = "/usr/bin/cpio -oac  < " + fileList + " |" + " " + this.getRemoteShellCmd(node) + " " + node + " " + " \"" + "cd" + " " + "/" + ";" + "/usr/bin/cpio -idmuc" + "\"";
        Trace.out("UnixSystem: " + this.unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        return runtime.runCommand();
    }

    @Override
    public String moveFile(String node1, String file1, String file2) {
        if (file1.equals(file2)) {
            try {
                if (this.pathExists(node1, file1, 0)) {
                    return "1|making self move no-op";
                }
                return "0|" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{file1, node1});
            }
            catch (RemoteDirException e) {
                return "0|" + e.getMessage();
            }
        }
        if (node1.equals("localnode") || this.isLocalNode(node1)) {
            this.unixcmd = "/usr/bin/mv -f " + file1 + " " + file2;
        } else {
            try {
                this.unixcmd = this.getRemoteShellCmd(node1) + " " + node1 + " -n " + "/usr/bin/mv -f" + " " + file1 + " " + file2;
            }
            catch (RemoteShellException rse) {
                Trace.out(rse);
                return "0|" + rse.getMessage();
            }
        }
        return UnixSystem.rununixcmd(this.unixcmd);
    }

    @Override
    public String linkFile(String node1, String file1, String file2) {
        if (node1.equals("localnode") || this.isLocalNode(node1)) {
            this.unixcmd = "/usr/bin/ln -fs " + file1 + " " + file2;
        } else {
            try {
                this.unixcmd = this.getRemoteShellCmd(node1) + " " + node1 + " -n " + "/usr/bin/ln -fs" + " " + file1 + " " + file2;
            }
            catch (RemoteShellException rse) {
                Trace.out(rse);
                return "0|" + rse.getMessage();
            }
        }
        return UnixSystem.rununixcmd(this.unixcmd);
    }

    private String createCommand(String node, String command, String path) throws RemoteShellException {
        String commandString = node.equals("localnode") || this.isLocalNode(node) ? command + " " + path : this.getRemoteShellCmd(node) + " " + node + " -n " + command + " " + path;
        return commandString;
    }

    @Override
    public String removeFile(String node, String file) {
        try {
            String commandString = this.createCommand(node, "/usr/bin/rm -f", file);
            return UnixSystem.rununixcmd(node, commandString);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
    }

    @Override
    public String removeDir(String node, String dir) {
        return this.removeDir(node, dir, true);
    }

    @Override
    public String removeDir(String node, String dir, boolean dirPathRemove) {
        try {
            String commandString = dirPathRemove ? this.createCommand(node, "/usr/bin/rmdir -p", dir) : this.createCommand(node, "/usr/bin/rmdir ", dir);
            Trace.out("command:" + commandString);
            String retVal = UnixSystem.rununixcmd(node, commandString);
            return retVal;
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
    }

    @Override
    public String removeDirRecurse(String node, String dir) {
        try {
            if (DeterminePlatform.getOSName().equals("AIX") && !this.pathExists(node, dir, 1)) {
                return "1| :successful";
            }
            return UnixSystem.rununixcmd(this.createCommand(node, "/usr/bin/rm -rf", dir));
        }
        catch (RemoteDirException | RemoteShellException e) {
            Trace.out(e);
            return "0|" + e.getMessage();
        }
    }

    @Override
    public String createDir(String node, String dir) {
        try {
            String commandString = this.createCommand(node, "/usr/bin/mkdir -p", dir);
            return UnixSystem.rununixcmd(commandString);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
    }

    @Override
    public String createDirRecurse(String node, String dir) {
        Trace.out("Running unix command:Recurse");
        return this.createDir(node, dir);
    }

    @Override
    public String createDirWithMode(String node, String dir) {
        try {
            return this.createDirWithPermissions(node, dir, UnixSystem.getPermUsingUmask());
        }
        catch (NativeException e) {
            Trace.out(e);
            return "0|" + e.getMessage();
        }
    }

    @Override
    public String createDirWithPermissions(String node, String dir, String perm) {
        try {
            String mkdirCmd = "/usr/bin/mkdir -p -m " + perm;
            String commandString = this.createCommand(node, mkdirCmd, dir);
            return UnixSystem.rununixcmd(node, commandString);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
    }

    @Override
    public String createDirWithModeRecurse(String node, String dir) {
        return this.createDirWithMode(node, dir);
    }

    @Override
    public String changeModePermissions(String node, String paths, String permissions) {
        try {
            String changeModeCmd = "/usr/bin/chmod " + permissions + " " + paths;
            String commandString = node.equals("localnode") || this.isLocalNode(node) ? changeModeCmd : this.getRemoteShellCmd(node) + " " + node + " -n " + changeModeCmd;
            return UnixSystem.rununixcmd(node, commandString);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
    }

    @Override
    public boolean pathExists(String node, String path) throws RemoteDirException {
        Boolean status = false;
        try {
            if (this.isLocalNode(node)) {
                File f = new File(path);
                try {
                    status = f.exists();
                }
                catch (SecurityException se) {
                    Trace.out("Got security exception for path " + path);
                }
            } else {
                status = this.isCFSFile(node, path);
            }
        }
        catch (SharedDeviceException sde) {
            throw new RemoteDirException(sde.getMessage());
        }
        return status;
    }

    @Override
    public boolean pathExists(String node, String path, int pathType) throws RemoteDirException {
        String shellCmd = "";
        String flag = "";
        if (node.equals("localnode") || this.isLocalNode(node)) {
            File file = new File(path);
            boolean bExists = file.exists();
            switch (pathType) {
                case 0: {
                    return bExists;
                }
                case 1: {
                    return bExists && file.isDirectory();
                }
                case 4: {
                    return bExists && file.isDirectory() && file.canWrite();
                }
                case 2: {
                    return bExists && file.isFile();
                }
                case 3: {
                    shellCmd = "/usr/bin/sh";
                    break;
                }
                default: {
                    Object[] args = new String[]{String.valueOf(pathType), path};
                    throw new RemoteDirException(s_msgBundle.getMessage("1086", true, args));
                }
            }
        } else {
            try {
                shellCmd = this.getRemoteShellCmd(node) + " " + node + " -n " + (pathType == 0 ? KSH : "/usr/bin/sh");
            }
            catch (RemoteShellException rse) {
                Trace.out(rse);
                throw new RemoteDirException(rse.getMessage());
            }
            switch (pathType) {
                case 0: {
                    flag = " -a ";
                    break;
                }
                case 1: {
                    flag = " -d ";
                    break;
                }
                case 4: {
                    flag = " -d " + path + " -a -w ";
                    break;
                }
                case 2: {
                    flag = " -f ";
                    break;
                }
                case 3: {
                    flag = " -h ";
                    break;
                }
                default: {
                    Object[] args = new String[]{String.valueOf(pathType), path};
                    throw new RemoteDirException(s_msgBundle.getMessage("1086", true, args));
                }
            }
        }
        this.unixcmd = shellCmd + " -c " + '\"' + "if [ " + flag + path + " ] ; then echo exists; fi" + '\"';
        Trace.out("unixcmd=" + this.unixcmd);
        RuntimeExec rt = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        int retValue = rt.runCommand();
        Trace.out("pathExists..RuntimeExec returned " + retValue);
        String[] out = rt.getOutput();
        String[] err = rt.getError();
        String erroutString = Utils.getString(out, "");
        boolean secCmd = UnixSystem.isCmdScv(this.unixcmd);
        if (err.length > 0 && (retValue != 0 || retValue == 0 && !secCmd)) {
            erroutString = erroutString + Utils.getString(err, "");
        }
        if (retValue == 0) {
            Trace.out("erroutString is :" + erroutString);
            return "exists".equals(erroutString);
        }
        throw new RemoteDirException(erroutString);
    }

    @Override
    public String getNodeAccessiblityCommand(String node) throws RemoteShellException {
        String remoteShellCmd = this.getRemoteShellCmd(node);
        if (this.isLocalNode(node)) {
            return "/usr/bin/true";
        }
        return remoteShellCmd + " " + node + " -n " + "/usr/bin/true";
    }

    @Override
    public String isNodeAccessible(String node) throws RemoteShellException {
        Trace.out("Checking accessibility of node: " + node);
        this.unixcmd = this.getNodeAccessiblityCommand(node);
        Trace.out("isNodeAccessible:: Running Unix command: " + this.unixcmd);
        RuntimeExec runtime = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        int retVal = runtime.runCommand();
        String[] cmdOutput = runtime.getOutput();
        String[] cmdError = runtime.getError();
        if (retVal == 0 && (cmdOutput.length > 0 || cmdError.length > 0 && !UnixSystem.isCmdScv(this.unixcmd))) {
            retVal = 1;
        }
        StringBuffer retStringBuffer = new StringBuffer();
        if (retVal == 0) {
            retStringBuffer.append("1|");
        } else {
            retStringBuffer.append("0|");
        }
        for (int i = 0; i < cmdOutput.length; ++i) {
            retStringBuffer.append(cmdOutput[i]);
        }
        if (retVal != 0 && cmdError.length != 0) {
            String localhost = null;
            try {
                localhost = Utils.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                retStringBuffer.append(uhe.getMessage());
                return retStringBuffer.toString();
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cmdError.length; ++i) {
                sb.append(cmdError[i]);
            }
            retStringBuffer.append(MessageBundle.getMessageBundle("Prkn").getMessage("1038", true, new String[]{this.unixcmd, localhost, sb.toString()}));
        }
        return retStringBuffer.toString();
    }

    @Override
    public String getFreeSpace(String node, String path) throws RemoteShellException {
        String[] cmdOutput = null;
        String[] cmdError = null;
        Trace.out("Getting Free Space for : " + path + "on :" + node);
        String unixcmd = node.equals("localnode") || this.isLocalNode(node) ? "/usr/bin/df -k " + path : this.getRemoteShellCmd(node) + " " + node + " -n " + "/usr/bin/df -k" + " " + path;
        Trace.out("Running Unix command: " + unixcmd);
        RuntimeExec runtime = new RuntimeExec(UnixSystem.getCmdArr(unixcmd), null, null);
        int retVal = runtime.runCommand();
        cmdOutput = runtime.getOutput();
        cmdError = runtime.getError();
        if (retVal == 0 && (cmdError != null && cmdError.length != 0 && !UnixSystem.isCmdScv(unixcmd) || cmdOutput != null) && cmdOutput.length < 2) {
            retVal = 1;
        }
        StringBuffer retStringBuffer = new StringBuffer();
        if (retVal == 0) {
            StringBuffer outputBuffer = new StringBuffer();
            for (int i = 1; i < cmdOutput.length; ++i) {
                outputBuffer.append(cmdOutput[i]);
                outputBuffer.append(" ");
            }
            int col = DeterminePlatform.getOSName().equals("AIX") ? 3 : 4;
            retStringBuffer.append("1|");
            StringTokenizer st = new StringTokenizer(outputBuffer.toString());
            for (int i = 1; i < col; ++i) {
                st.nextToken();
            }
            retStringBuffer.append(st.nextToken());
        } else {
            retStringBuffer.append("0|");
        }
        if (retVal != 0 && cmdError != null) {
            for (int i = 0; i < cmdError.length; ++i) {
                retStringBuffer.append(cmdError[i]);
            }
        }
        return retStringBuffer.toString();
    }

    @Override
    public boolean removeListedFilesFromNode(String nodeName, String removeListFile) throws RemoteShellException, RemoveListedFilesException {
        String[] cmdOutput = null;
        String[] cmdError = null;
        Trace.out("Removing files listed in '" + removeListFile + "' from node: " + nodeName);
        this.unixcmd = "/usr/bin/sort -u " + removeListFile + " " + "|" + " " + this.getRemoteShellCmd(nodeName) + " " + nodeName + " " + " \"(xargs" + " " + "/usr/bin/rm -f" + " " + " )\" ";
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retVal = runtime.runCommand();
        cmdOutput = runtime.getOutput();
        cmdError = runtime.getError();
        if (retVal == 0 && (cmdError != null && cmdError.length != 0 && !UnixSystem.isCmdScv(cmdarray) || cmdOutput != null && cmdOutput.length != 0)) {
            retVal = 1;
        }
        if (retVal == 0) {
            return true;
        }
        Object[] msgArgs = new Object[]{removeListFile, nodeName};
        throw new RemoveListedFilesException("1037", msgArgs, cmdError);
    }

    @Override
    public boolean createListedDirsOnNode(String nodeName, String createListFile) throws RemoteShellException, CreateListedDirsException {
        return this.createDirsOnNode(nodeName, createListFile, null);
    }

    private boolean createDirsOnNode(String nodeName, String createListFile, String mode) throws RemoteShellException, CreateListedDirsException {
        String[] cmdOutput = null;
        String[] cmdError = null;
        String mkdirCmd = mode != null ? "/usr/bin/mkdir -p -m " + mode : "/usr/bin/mkdir -p";
        Trace.out("Creating directories listed in '" + createListFile + "' on node: " + nodeName + ", mode " + mode);
        this.unixcmd = "/usr/bin/sort -u " + createListFile + " " + "|" + " " + this.getRemoteShellCmd(nodeName) + " " + nodeName + " " + " \"(xargs" + " " + mkdirCmd + " " + " )\" ";
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retVal = runtime.runCommand();
        cmdOutput = runtime.getOutput();
        cmdError = runtime.getError();
        if (retVal == 0 && (cmdError != null && cmdError.length != 0 && !UnixSystem.isCmdScv(this.unixcmd) || cmdOutput != null && cmdOutput.length != 0)) {
            retVal = 1;
        }
        if (retVal == 0) {
            return true;
        }
        Object[] msgArgs = new Object[]{createListFile, nodeName};
        throw new CreateListedDirsException("1039", msgArgs, cmdError);
    }

    @Override
    public boolean copyListedFilesToNode(String nodeName, String copyListFile) throws RemoteShellException, CopyListedFilesException {
        String[] cmdOutput = null;
        String[] cmdError = null;
        Trace.out("Copying files listed in '" + copyListFile + "' to node: " + nodeName);
        this.unixcmd = " /usr/bin/cpio -oac < " + copyListFile + "|" + " " + this.getRemoteShellCmd(nodeName) + " " + nodeName + " " + "/usr/bin/cpio -idmuc" + " ";
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retVal = runtime.runCommand();
        cmdOutput = runtime.getOutput();
        cmdError = runtime.getError();
        if (retVal == 0) {
            if (DeterminePlatform.getOSName().equals("Linux")) {
                Trace.out("Using Tar");
                retVal = cmdOutput != null && cmdOutput.length != 0 || cmdError != null && cmdError.length != 0 && !UnixSystem.isCmdScv(cmdarray) ? 1 : 0;
            } else if (cmdOutput != null && cmdOutput.length != 0 || cmdError != null && cmdError.length != 2 && !UnixSystem.isCmdScv(cmdarray)) {
                retVal = 1;
            } else {
                for (int i = 0; i < 2; ++i) {
                    if (cmdError == null || cmdError[i] == null) continue;
                    StringTokenizer st = new StringTokenizer(cmdError[i]);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (!st.hasMoreTokens() || st.nextToken().equals("blocks")) continue;
                    retVal = 1;
                    break;
                }
            }
        }
        if (retVal == 0) {
            return true;
        }
        Object[] msgArgs = new Object[]{copyListFile, nodeName};
        throw new CopyListedFilesException("1038", msgArgs, cmdError);
    }

    @Override
    public String startService(String serviceName, String nodeName) {
        return "0|Starting Services has no meaning on Unix";
    }

    private void setAPINotSupportedError(String apiName, NativeResult result) {
        Object[] args = new String[]{apiName, DeterminePlatform.getOSName()};
        NativeException ne = new NativeException("1012", args);
        result.setStatus(false);
        result.setOSString(ne.getMessage());
        result.setException(ne);
    }

    @Override
    public boolean checkService(String serviceName, String nodeName, ServiceData data, NativeResult result) {
        this.setAPINotSupportedError("checkService", result);
        return false;
    }

    @Override
    public String stopService(String serviceName, String nodeName) {
        return "0|Stopping Services has no meaning on Unix";
    }

    @Override
    public String deleteService(String serviceName, String nodeName) {
        return "0|Deleting Services has no meaning on Unix";
    }

    @Override
    public String deleteService(boolean ignoreNotExist, String serviceName, String nodeName) {
        return "0|Deleting Services has no meaning on Unix";
    }

    @Override
    public String createService(String serviceName, String exeLocation, int mode, String nodeName) {
        return "0|Creating Services has no meaning on Unix";
    }

    @Override
    public String createService(String serviceName, String exeLocation, int access, int type, int mode, int errCtrl, String deps, String domainName, String userName, String password, String loadGrp, String nodeName) {
        return "0|Creating Services has no meaning on Unix";
    }

    @Override
    public String createServiceDep(String serviceName, String[] dependency, String nodeName) {
        return "0|Creating Service Dependency has no meaning on Unix";
    }

    @Override
    public String removeServiceDep(String serviceName, String[] dependency, String nodeName) throws NativeException {
        return "0|Removing Service Dependency has no meaning on Unix";
    }

    @Override
    public String queryServiceDep(String serviceName, String nodeName) throws NativeException {
        return "0|Querying Service Dependency has no meaning on Unix";
    }

    @Override
    public void regCreateKey(String nodeName, String key, String subkey, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
    }

    @Override
    public void regDeleteKey(String nodeName, String key, String subkey, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
    }

    @Override
    public void regSetValue(String nodeName, String key, String value, RegistryKeyData regData, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
    }

    @Override
    public void regDeleteValue(String nodeName, String key, String value, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
    }

    @Override
    public void regGetData(String nodeName, String key, String value, RegistryKeyData regReturnData, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
    }

    @Override
    public void regGetSubKey(String nodeName, String key, RegistryKeyData regKeyData, NativeResult result) {
        this.setAPINotSupportedError("regGetSubKey", result);
    }

    @Override
    public void getServices4ImagePath(String nodeName, String key, RegistryKeyData regKeyData, NativeResult result) {
        this.setAPINotSupportedError("getService4ImagePath", result);
    }

    @Override
    public boolean regKeyExists(String nodeName, String key, NativeResult result) {
        result.setStatus(true);
        result.setResultString(new String[]{"Registry Operations has no meaning on Unix"});
        return true;
    }

    @Override
    public String startListener(String nodeName, String listenerName, String oracleHome, String oracleHomeName) {
        String exeLocation = oracleHome + File.separator + "bin" + File.separator + "lsnrctl";
        try {
            this.unixcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " -n ";
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
        String runcmd = this.unixcmd + " " + " " + "/bin/sh" + " " + "-c" + " " + '\"' + "ORACLE_HOME=" + oracleHome + " " + exeLocation + " stop " + listenerName + " " + " > /dev/null < /dev/null 2>&1" + '\"' + " & ";
        Trace.out("EXELOCATION IS " + exeLocation);
        Trace.out("Inside startListener\n");
        String result = UnixSystem.rununixcmd(runcmd);
        runcmd = this.unixcmd + " " + " " + "/bin/sh" + " " + "-c" + " " + '\"' + "ORACLE_HOME=" + oracleHome + " " + exeLocation + " start " + listenerName + " > /dev/null < /dev/null 2>&1" + '\"' + " & ";
        result = UnixSystem.rununixcmd(runcmd);
        Trace.out("UnixSystem.startListener: The result obtained is" + result);
        return null;
    }

    @Override
    public NativeResult isSharedPath(String pathName, String[] nodeList, String localNode) throws SharedDeviceException, InvalidNodeListException {
        NativeResult nativeResult = new NativeResult();
        this.checkSharedFileSystemPath(pathName, nodeList, localNode, nativeResult);
        return nativeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> checkSharedFileSystemPath(String pathName, String[] nodeList, String localNode, NativeResult result) throws SharedDeviceException, InvalidNodeListException {
        if (null == result) {
            result = new NativeResult();
        }
        if (nodeList.length < 2) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < nodeList.length; ++i) {
                if (i > 0) {
                    sb.append("," + nodeList[i]);
                    continue;
                }
                sb.append(nodeList[i]);
            }
            Object[] args = new String[]{sb.toString(), String.valueOf(nodeList.length), String.valueOf(2)};
            Trace.out("UnixSystem.isShared: nodeList length is less than 2");
            throw new InvalidNodeListException("Prkc", "1063", args);
        }
        String[] localNodeList = new String[nodeList.length];
        for (int i = 0; i < nodeList.length; ++i) {
            localNodeList[i] = localNode.equalsIgnoreCase(nodeList[i]) ? "localnode" : nodeList[i];
        }
        File dirPath = new File(pathName);
        while (!dirPath.exists()) {
            if (dirPath.getParentFile() == null) continue;
            dirPath = dirPath.getParentFile();
        }
        if (!dirPath.isDirectory() && dirPath.getParentFile() != null) {
            dirPath = dirPath.getParentFile();
        }
        Trace.out("dirPath=" + dirPath.getPath());
        String tempFile = new File(this.getUniqueFilePath(dirPath.getPath(), "CFSFileName")).getName();
        Trace.out("pathName=" + pathName + " tempFile=" + tempFile);
        File newTempFile = new File(dirPath, tempFile);
        String dirPathName = newTempFile.getPath();
        Trace.out("dirPathName is " + dirPathName);
        for (int i = 0; i < localNodeList.length; ++i) {
            Trace.out("removing file " + dirPathName + "on  " + nodeList[i]);
            this.removeFile(localNodeList[i], dirPathName);
        }
        Trace.out("creating file " + dirPathName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(newTempFile);
            fos.write("This is CFS test file content".getBytes());
            fos.flush();
        }
        catch (FileNotFoundException e) {
            Trace.out("Failed to create the test CFS file at " + dirPathName);
            if (newTempFile.exists()) {
                newTempFile.delete();
            }
            Object[] args = new Object[]{pathName};
            throw new SharedDeviceException(s_msgBundle.getMessage("1025", true, args));
        }
        catch (IOException e) {
            Trace.out("Failed to write to the test CFS file " + dirPathName);
            if (newTempFile.exists()) {
                newTempFile.delete();
            }
            Object[] args = new Object[]{dirPathName};
            throw new SharedDeviceException(s_msgBundle.getMessage("1026", true, args));
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> nonSharedNodes = new ArrayList<String>();
        try {
            for (int i = 0; i < localNodeList.length; ++i) {
                if (localNodeList[i].compareTo("localnode") == 0 || this.testCFSFile(localNodeList[i], dirPathName)) continue;
                nonSharedNodes.add(nodeList[i]);
            }
        }
        finally {
            newTempFile.delete();
        }
        if (nonSharedNodes.size() > 0) {
            result.setStatus(false);
            result.setBooleanResult(false);
            result.setNodeName((String)nonSharedNodes.get(0));
            StringBuilder nodesThatShareNotPathWithLocalnode = new StringBuilder((String)nonSharedNodes.get(0));
            for (int i = 1; i < nonSharedNodes.size(); ++i) {
                nodesThatShareNotPathWithLocalnode.append(", ");
                nodesThatShareNotPathWithLocalnode.append((String)nonSharedNodes.get(i));
            }
            Object[] args = new Object[]{pathName, localNode, nodesThatShareNotPathWithLocalnode};
            result.setException(new NativeException("1033", args));
        } else {
            result.setStatus(true);
            result.setBooleanResult(true);
        }
        ArrayList<String> pathSharedNodeList = new ArrayList<String>();
        for (String node : nodeList) {
            if (nonSharedNodes.contains(node) || pathSharedNodeList.contains(node) || localNode.equalsIgnoreCase(node)) continue;
            pathSharedNodeList.add(node);
        }
        if (pathSharedNodeList.size() > 0) {
            pathSharedNodeList.add(localNode);
        }
        Trace.out("Path (" + pathName + ") is shared between nodes " + pathSharedNodeList);
        return pathSharedNodeList;
    }

    private boolean testCFSFile(String nodeName, String path) throws SharedDeviceException {
        boolean status = false;
        try {
            status = this.isCFSFile(nodeName, path);
        }
        catch (RemoteDirException rde) {
            Trace.out("Caught RemoteDirException: " + rde.getMessage());
            status = false;
        }
        return status;
    }

    private boolean isCFSFile(String nodeName, String path) throws SharedDeviceException, RemoteDirException {
        boolean status = true;
        File filePath = new File(path);
        try {
            this.unixcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " -n ";
        }
        catch (RemoteShellException rse) {
            Trace.out("Got exception " + rse + "in getRemoteShellCmd");
            throw new SharedDeviceException(rse.getMessage());
        }
        this.unixcmd = this.unixcmd + "/usr/bin/sh -c \"/usr/bin/ls " + filePath.getParentFile().getAbsolutePath() + " > /dev/null && " + "/usr/bin/cat" + " " + filePath.getAbsolutePath() + '\"';
        Trace.out("The unix command is " + this.unixcmd);
        RuntimeExec rt = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        rt.runCommand();
        String[] output = rt.getOutput();
        if (output.length <= 0) {
            String errString = Utils.getString(rt.getError(), "");
            Trace.out("Command output is empty");
            Trace.out("ERROR: " + errString + " from node " + nodeName);
            throw new RemoteDirException(errString);
        }
        status = "This is CFS test file content".equals(output[0]);
        return status;
    }

    @Override
    public void checkCFSPath(String nodeName, String pathName, String createFile, Constants.CFS_OP_TYPE opType, NativeResult result) throws RemoteShellException {
        boolean status = true;
        Trace.out("Operation on node: " + nodeName + " : " + (Object)((Object)opType));
        String unixcmd = "";
        if (opType != Constants.CFS_OP_TYPE.FILE_WRITE_LOCAL && opType != Constants.CFS_OP_TYPE.FILE_LIST_LOCAL && opType != Constants.CFS_OP_TYPE.FILE_DEL_LOCAL) {
            try {
                unixcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " -n ";
            }
            catch (RemoteShellException rse) {
                Trace.out(rse.getMessage());
                result.setStatus(false);
                result.setException(rse);
                return;
            }
        }
        switch (opType) {
            case FILE_WRITE: 
            case FILE_WRITE_LOCAL: {
                File filePath = new File(pathName + "/" + createFile + "." + nodeName);
                unixcmd = unixcmd + "/usr/bin/sh -c \"echo  This is CFS test file content >" + filePath.getAbsolutePath() + '\"';
                break;
            }
            case FILE_LIST_LOCAL: {
                File filePath = new File(pathName);
                String filePattern = filePath.getAbsolutePath() + "/" + createFile + WILD_CARD_CHARACTER;
                unixcmd = unixcmd + "/usr/bin/ls -1A " + filePattern;
                break;
            }
            case FILE_LIST: {
                File filePath = new File(pathName);
                String filePattern = filePath.getAbsolutePath() + "/" + createFile + "\\*";
                unixcmd = unixcmd + "/usr/bin/ls -1A " + filePattern;
                break;
            }
            case FILE_DEL: 
            case FILE_DEL_LOCAL: {
                File filePath = new File(pathName + "/" + createFile + "." + nodeName);
                unixcmd = unixcmd + "/usr/bin/rm -f " + filePath.getAbsolutePath();
                break;
            }
            default: {
                result.setStatus(false);
                return;
            }
        }
        Trace.out("File path to be checked: " + pathName);
        Trace.out("unixcmd = " + unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdarray)) {
                retval = 1;
            }
            if (retval != 0) {
                result.setOSString(rtErr);
            }
        }
        boolean cmdSuccess = retval == 0;
        result.setStatus(cmdSuccess);
        Object[] cmdOutput = runtime.getOutput();
        ArrayList<String> nodeNames = new ArrayList<String>();
        Trace.out("Result Str " + nodeName + " " + Arrays.toString(cmdOutput));
        if (cmdSuccess && (opType == Constants.CFS_OP_TYPE.FILE_LIST || opType == Constants.CFS_OP_TYPE.FILE_LIST_LOCAL)) {
            for (Object outLine : cmdOutput) {
                int index = ((String)outLine).lastIndexOf(".");
                if (index == -1 || !((String)outLine).toLowerCase().contains(createFile.toLowerCase())) continue;
                String node = ((String)outLine).substring(index + 1);
                Trace.out("Extracted nodeName :" + node);
                nodeNames.add(node);
            }
            result.setResultString(nodeNames.toArray(new String[nodeNames.size()]));
        } else {
            result.setResultString(runtime.getOutput());
        }
    }

    @Override
    public NativeResult validateRawDevice(String devName) throws NativeException {
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        UnixNative.validateRawDevice(devName, nativeResult);
        return nativeResult;
    }

    @Override
    public NativeResult validateDevice(String devName) throws NativeException {
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        UnixNative.validateDevice(devName, nativeResult);
        return nativeResult;
    }

    @Override
    public String getPfileName(String oh, String instName) {
        return oh + FILE_SEPARATOR + "dbs" + FILE_SEPARATOR + "init" + instName + ".ora";
    }

    private boolean checkSingleQuotes(String arg) {
        return arg != null && arg.indexOf("'") != -1;
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String node) {
        return this.runCmd(cmd, args, env, null, node);
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String[] stdin, String node, String srcLoc, String destLoc) {
        return this.runCmd(cmd, args, env, stdin, node);
    }

    @Override
    public String runCmd(String cmd, String[] args, String[] env, String[] stdin, String node) {
        int i;
        if (node.equals("localnode") || this.isLocalNode(node)) {
            Object[] cmdArr = UnixSystem.getCmdArr(cmd);
            if (args != null && args.length > 0) {
                int i2;
                Vector<String> cmdVec = new Vector<String>(cmdArr.length + args.length);
                for (i2 = 0; i2 < cmdArr.length; ++i2) {
                    cmdVec.addElement(cmdArr[i2]);
                }
                for (i2 = 0; i2 < args.length; ++i2) {
                    cmdVec.addElement(args[i2]);
                }
                Trace.out("cmdVec = " + cmdVec.toString());
                cmdArr = new String[cmdVec.size()];
                cmdVec.copyInto(cmdArr);
            }
            return NativeSystem.rununixcmd((String[])cmdArr, env, stdin);
        }
        try {
            this.unixcmd = this.getRemoteShellCmd(node) + " " + node + " ";
            if (stdin == null) {
                this.unixcmd = this.unixcmd + "-n ";
            }
        }
        catch (RemoteShellException rse) {
            Trace.out(rse);
            return "0|" + rse.getMessage();
        }
        boolean singleQuoteExists = this.checkSingleQuotes(cmd) || this.checkSingleQuotes(Utils.getString(env, " ")) || this.checkSingleQuotes(Utils.getString(args, " "));
        this.unixcmd = singleQuoteExists ? this.unixcmd + "/usr/bin/sh -c \"" : this.unixcmd + "/usr/bin/sh -c '";
        if (env != null) {
            for (i = 0; i < env.length; ++i) {
                this.unixcmd = this.unixcmd + env[i] + " ";
            }
        }
        this.unixcmd = this.unixcmd + cmd;
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                this.unixcmd = this.unixcmd + " " + args[i] + " ";
            }
        }
        this.unixcmd = singleQuoteExists ? this.unixcmd + '\"' : this.unixcmd + "'";
        if (stdin == null) {
            Trace.out("unixcmd=" + this.unixcmd);
            return NativeSystem.rununixcmd(this.unixcmd);
        }
        Trace.out("unixcmd=" + this.unixcmd + " stdin: " + stdin);
        return NativeSystem.rununixcmd(this.unixcmd, null, stdin);
    }

    @Override
    public String getRemoteShellCmd() throws RemoteShellException {
        if (m_remoteShellCmd == null) {
            throw new RemoteShellException(s_msgBundle.getMessage("1040", true));
        }
        return m_remoteShellCmd;
    }

    @Override
    public String getRemoteCopyCmd() throws RemoteCopyException {
        if (m_remoteCopyCmd == null) {
            throw new RemoteCopyException(s_msgBundle.getMessage("1041", true));
        }
        return m_remoteCopyCmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRemoteShellCmd() {
        Class<UnixSystem> clazz = UnixSystem.class;
        synchronized (UnixSystem.class) {
            m_remoteShellCmd = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRemoteCopyCmd() {
        Class<UnixSystem> clazz = UnixSystem.class;
        synchronized (UnixSystem.class) {
            m_remoteCopyCmd = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteShellCmd(String node) throws RemoteShellException {
        Class<UnixSystem> clazz = UnixSystem.class;
        synchronized (UnixSystem.class) {
            if (m_remoteShellCmd == null) {
                this.checkRemoteExecutionSetup(node);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return m_remoteShellCmd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRemoteCopyCmd(String node) throws RemoteCopyException {
        try {
            Class<UnixSystem> clazz = UnixSystem.class;
            synchronized (UnixSystem.class) {
                if (m_remoteCopyCmd == null) {
                    this.checkRemoteExecutionSetup(node);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (RemoteShellException rse) {
            throw new RemoteCopyException(rse.getMessage());
        }
        {
            return m_remoteCopyCmd;
        }
    }

    private boolean isSameCommandName(String str1, String str2) {
        String[] str = new String[]{str1, str2};
        String[] cmd = new String[2];
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null || str[i].equals("")) {
                return false;
            }
            String cmdLine = str[i].trim();
            StringTokenizer st = new StringTokenizer(cmdLine);
            if (st.countTokens() > 1) {
                return false;
            }
            int inx = cmdLine.lastIndexOf(47);
            cmd[i] = inx == -1 ? cmdLine : cmdLine.substring(inx + 1);
        }
        return cmd[0].equals(cmd[1]);
    }

    private void checkRemoteExecutionSetup(String node) throws RemoteShellException {
        boolean isRSHAllowed;
        boolean toCheckCopyCmd = true;
        String userRequestedShellCmd = System.getProperty("oracle.srvm.remoteshell");
        String userRequestedCopyCmd = System.getProperty("oracle.srvm.remotecp");
        boolean bl = isRSHAllowed = Boolean.getBoolean("SRVM_ALLOW_RSH") || "TRUE".equalsIgnoreCase(System.getenv("SRVM_ALLOW_RSH"));
        if (userRequestedShellCmd != null) {
            if (!isRSHAllowed && this.isSameCommandName(userRequestedShellCmd, "/usr/bin/rsh")) {
                Object[] args = new Object[]{userRequestedShellCmd};
                throw new RemoteShellException(s_msgBundle.getMessage("1042", true, args));
            }
            if (!new File(userRequestedShellCmd).exists()) {
                throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{userRequestedShellCmd, node}));
            }
            m_remoteShellCmd = userRequestedShellCmd;
            Trace.out("Client requested for a valid remote shell: " + m_remoteShellCmd);
        }
        if (userRequestedCopyCmd != null) {
            if (!isRSHAllowed && this.isSameCommandName(userRequestedCopyCmd, "/usr/bin/rcp")) {
                Object[] args = new Object[]{userRequestedCopyCmd};
                throw new RemoteShellException(s_msgBundle.getMessage("1043", true, args));
            }
            if (!new File(userRequestedCopyCmd).exists()) {
                throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{userRequestedCopyCmd, node}));
            }
            m_remoteCopyCmd = userRequestedCopyCmd;
            toCheckCopyCmd = false;
            Trace.out("Client requested for a valid remote copy command: " + m_remoteCopyCmd);
        }
        if (m_remoteShellCmd != null) {
            if (m_remoteCopyCmd != null) {
                if (this.isSameCommandName(m_remoteShellCmd, "/usr/bin/ssh")) {
                    m_remoteShellCmd = m_remoteShellCmd + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 ";
                }
                Trace.out("Using Remote Shell Command: '" + m_remoteShellCmd + "'");
                Trace.out("Using Remote Copy Command: '" + m_remoteCopyCmd + "'");
                return;
            }
            if (this.isSameCommandName(m_remoteShellCmd, "/usr/bin/ssh")) {
                m_remoteShellCmd = m_remoteShellCmd + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 ";
                m_remoteCopyCmd = "/usr/bin/scp";
            } else {
                m_remoteCopyCmd = "/usr/bin/rcp";
            }
        } else if (m_remoteCopyCmd != null) {
            if (this.isSameCommandName(m_remoteCopyCmd, "/usr/bin/scp")) {
                m_remoteShellCmd = "/usr/bin/ssh" + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 ";
            } else {
                m_remoteShellCmd = "/usr/bin/rsh";
                if (!new File("/usr/bin/rsh").exists()) {
                    throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{"/usr/bin/rsh", node}));
                }
            }
        } else {
            RuntimeExec runtime;
            Trace.out(" Client didn't specify for remote shell or remote copy ");
            String[] cmdError = null;
            int retVal = 0;
            boolean sshExists = new File("/usr/bin/ssh").exists();
            if (sshExists) {
                this.unixcmd = "/usr/bin/ssh" + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 " + node + " " + "/usr/bin/true";
                Trace.out("checkRemoteExecutionSetup:: Checking user equivalence using Secured Shell '/usr/bin/ssh'");
                Trace.out("checkRemoteExecutionSetup:: Running Unix command: " + this.unixcmd);
                runtime = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
                retVal = runtime.runCommand();
                if (retVal != 0) {
                    cmdError = runtime.getError();
                }
            }
            if (!sshExists || retVal != 0 || cmdError != null && cmdError.length != 0) {
                Trace.out("checkRemoteExecutionSetup:: Error checking user equivalence using Secured Shell '/usr/bin/ssh'");
                if (!isRSHAllowed) {
                    Object[] args = new Object[]{node, "/usr/bin/ssh"};
                    StringBuffer errMsgBuffer = new StringBuffer();
                    errMsgBuffer.append(s_msgBundle.getMessage("1191", true, args));
                    if (!sshExists) {
                        errMsgBuffer.append("\n" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{"/usr/bin/ssh", node}));
                    }
                    if (cmdError != null) {
                        errMsgBuffer.append("\n");
                        for (int i = 0; i < cmdError.length; ++i) {
                            errMsgBuffer.append((String)cmdError[i]);
                        }
                    }
                    throw new RemoteShellException(errMsgBuffer.toString());
                }
                boolean rshExists = new File("/usr/bin/rsh").exists();
                if (rshExists) {
                    this.unixcmd = "/usr/bin/rsh " + node + " " + "/usr/bin/true";
                    Trace.out("checkRemoteExecutionSetup:: Checking user equivalence using Remote Shell '/usr/bin/rsh'");
                    Trace.out("checkRemoteExecutionSetup:: Running Unix command: " + this.unixcmd);
                    runtime = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
                    retVal = runtime.runCommand();
                    cmdError = runtime.getError();
                }
                if (!sshExists && !rshExists || retVal != 0 || cmdError != null && cmdError.length != 0) {
                    Object[] args = new Object[]{node, "/usr/bin/ssh", "/usr/bin/rsh"};
                    StringBuffer errMsgBuffer = new StringBuffer();
                    errMsgBuffer.append(s_msgBundle.getMessage("1044", true, args));
                    if (!sshExists) {
                        errMsgBuffer.append("\n" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{"/usr/bin/ssh", node}));
                    }
                    if (!rshExists) {
                        errMsgBuffer.append("\n" + MessageBundle.getMessageBundle("Prkn").getMessage("1025", false, new String[]{"/usr/bin/rsh", node}));
                    }
                    if (cmdError != null) {
                        errMsgBuffer.append("\n");
                        for (int i = 0; i < cmdError.length; ++i) {
                            errMsgBuffer.append(cmdError[i]);
                        }
                    }
                    throw new RemoteShellException(errMsgBuffer.toString());
                }
                m_remoteShellCmd = "/usr/bin/rsh";
                m_remoteCopyCmd = "/usr/bin/rcp";
                if (!new File("/usr/bin/rcp").exists()) {
                    throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{"/usr/bin/rcp", node}));
                }
            } else {
                m_remoteShellCmd = "/usr/bin/ssh" + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 ";
                m_remoteCopyCmd = "/usr/bin/scp";
                if (!new File("/usr/bin/scp").exists()) {
                    throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{"/usr/bin/scp", node}));
                }
            }
        }
        if (toCheckCopyCmd && !new File(m_remoteCopyCmd).exists()) {
            throw new RemoteShellException(s_msgBundle.getMessage("1025", false, new String[]{m_remoteCopyCmd, node}));
        }
        Trace.out("Using Remote Shell Command: '" + m_remoteShellCmd + "'");
        Trace.out("Using Remote Copy Command: '" + m_remoteCopyCmd + "'");
    }

    @Override
    public String getExeName(String exe) {
        return exe;
    }

    @Override
    public String getScriptFileName(String scriptFile) {
        return scriptFile;
    }

    @Override
    public String getConfigLocation(Version version) {
        if (!Version.isPre10i(version)) {
            return System.getProperty("srvm.ocr.loc", "/var/opt/oracle" + FILE_SEPARATOR + "ocr.loc");
        }
        return System.getProperty("srvm.srvconfig.loc", "/var/opt/oracle" + FILE_SEPARATOR + "srvConfig.loc");
    }

    @Override
    public String getOLRConfigLocation(String node, Version version) {
        String olrLoc = null;
        String olrDevLoc = System.getProperty("srvm.olr.loc");
        if (olrDevLoc != null) {
            olrLoc = olrDevLoc;
            String hostName = null;
            try {
                hostName = this.getHostName(node);
            }
            catch (HostnameException hne) {
                Trace.out(hne.getMessage());
                hostName = null;
            }
            if (hostName != null) {
                olrLoc = olrLoc + "." + this.getNormHostName(hostName);
            }
        } else {
            olrLoc = "/var/opt/oracle" + FILE_SEPARATOR + "olr.loc";
        }
        return olrLoc;
    }

    @Override
    public Boolean getCSSConfigType(String node, Version version) throws NativeException {
        Boolean configType;
        String fileName = this.getConfigLocation(version);
        File configFile = new File(fileName);
        if (!node.equals("localnode") && !this.isLocalNode(node)) {
            String tmpFile = this.getUniqueFilePath(System.getProperty("java.io.tmpdir"), configFile.getName());
            try {
                if (this.pathExists(node, fileName, 2)) {
                    String result = this.remoteCopyFile(node, fileName, "localnode", tmpFile, false);
                    Trace.out("remote copy file result=" + result);
                }
            }
            catch (RemoteDirException e) {
                throw new NativeException(e.getMessage(), e);
            }
            configFile = new File(tmpFile);
        }
        Trace.out("configFile=" + configFile.getAbsolutePath());
        if (!configFile.exists()) {
            configType = null;
        } else {
            try {
                String propertyValue = Utils.getPropertyValue(configFile.getAbsolutePath(), "local_only", true);
                configType = propertyValue != null ? Boolean.valueOf(propertyValue.trim()) : Boolean.valueOf(false);
            }
            catch (FileNotFoundException fnfe) {
                throw new NativeException(fnfe.getMessage(), fnfe);
            }
            catch (IOException ie) {
                Object[] args = new Object[]{configFile.getAbsolutePath()};
                throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
            }
            finally {
                if (!node.equals("localnode") && !this.isLocalNode(node)) {
                    configFile.delete();
                }
            }
        }
        Trace.out("configType=" + configType);
        return configType;
    }

    @Override
    public HashMap getOCRLocations(Version version) throws NativeException {
        HashMap<String, String> diskMap = new HashMap<String, String>(2);
        String ocrLoc = null;
        String fileName = null;
        try {
            if (!Version.isPre112(version)) {
                String[] ocrLocs = OCR.getOCRLocations();
                for (int i = 0; i < ocrLocs.length; ++i) {
                    if (i == 0) {
                        diskMap.put(ocrLocs[0], "OCR_PRIMARY");
                        continue;
                    }
                    if (i == 1) {
                        diskMap.put(ocrLocs[1], "OCR_MIRROR");
                        continue;
                    }
                    diskMap.put(ocrLocs[i], "OCR_SECONDARY");
                }
            } else {
                fileName = this.getConfigLocation(version);
                String ocrConfigPropName = Version.isPre10i(version) ? "srvconfig_loc" : "ocrconfig_loc";
                String ocrMirrorPropName = "ocrmirrorconfig_loc";
                ocrLoc = Utils.getPropertyValue(fileName, ocrConfigPropName, true);
                diskMap.put(ocrLoc, new String("OCR_PRIMARY"));
                if (!Version.isPre10i(version) && (ocrLoc = Utils.getPropertyValue(fileName, ocrMirrorPropName, true)) != null) {
                    diskMap.put(ocrLoc, new String("OCR_MIRROR"));
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new NativeException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ie) {
            Object[] args = new Object[]{fileName};
            throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
        }
        catch (OCRException ocre) {
            throw new NativeException(s_msgBundle.getMessage("1149", true), ocre);
        }
        return diskMap;
    }

    @Override
    public int checkOCRStorageType(String path) throws NativeException {
        int retVal;
        try {
            retVal = OCR.checkOCRStorageType(path);
        }
        catch (OCRException ocre) {
            throw new NativeException(ocre.getMessage(), ocre);
        }
        return retVal;
    }

    @Override
    public boolean isCRSConfigured(Version version) throws NativeException {
        return this.isCRSConfigured("localnode", version);
    }

    @Override
    public boolean isCRSConfigured(String node, Version version) throws NativeException {
        File cnfgFile;
        String ocrConfigPropName;
        String ocrFile = this.getConfigLocation(version);
        String string = ocrConfigPropName = Version.isPre10i(version) ? "srvconfig_loc" : "ocrconfig_loc";
        if (!node.equals("localnode") && !this.isLocalNode(node)) {
            String tmpFile = this.getUniqueFilePath(System.getProperty("java.io.tmpdir"), new File(ocrFile).getName());
            try {
                if (!this.pathExists(node, ocrFile, 2)) {
                    return false;
                }
                String result = this.remoteCopyFile(node, ocrFile, "localnode", tmpFile, false);
                Trace.out("remote copy file result=" + result);
                ocrFile = tmpFile;
            }
            catch (RemoteDirException e) {
                Object[] args = new Object[]{node};
                throw new NativeException(s_msgBundle.getMessage("1139", true, args), e);
            }
        }
        if (!(cnfgFile = new File(ocrFile)).exists()) {
            return false;
        }
        Trace.out("configFile=" + cnfgFile.getAbsolutePath());
        try {
            String ocrCnfgLocPropertyValue = Utils.getPropertyValue(cnfgFile.getAbsolutePath(), ocrConfigPropName, true);
            Trace.out(ocrConfigPropName + "=" + ocrCnfgLocPropertyValue);
            String localOnlyPropVal = Utils.getPropertyValue(cnfgFile.getAbsolutePath(), "local_only", true);
            boolean localOnly = false;
            localOnly = localOnlyPropVal != null ? Boolean.parseBoolean(localOnlyPropVal.trim()) : false;
            boolean bl = !localOnly && ocrCnfgLocPropertyValue != null;
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            Object[] args = new Object[]{node};
            throw new NativeException(s_msgBundle.getMessage("1139", true, args), fnfe);
        }
        catch (IOException ie) {
            Object[] args = new Object[]{cnfgFile.getAbsolutePath()};
            throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
        }
        finally {
            if (!node.equals("localnode") && !this.isLocalNode(node)) {
                cnfgFile.delete();
            }
        }
    }

    @Override
    public boolean isHAConfigured(Version version) throws NativeException {
        return this.isHAConfigured("localnode", version);
    }

    @Override
    public boolean isHAConfigured(String node, Version version) throws NativeException {
        File cnfgFile;
        if (Version.isPre112(version)) {
            Object[] args = new String[]{version.toString(), "11.2.0.1.0"};
            throw new NativeException(s_msgBundle.getMessage("1141", true, args));
        }
        String olrFileName = this.getOLRConfigLocation(node, version);
        Trace.out("olrFileName = " + olrFileName);
        if (!node.equals("localnode") && !this.isLocalNode(node)) {
            String tmpFile = this.getUniqueFilePath(System.getProperty("java.io.tmpdir"), new File(olrFileName).getName());
            try {
                if (!this.pathExists(node, olrFileName, 2)) {
                    return false;
                }
                String result = this.remoteCopyFile(node, olrFileName, "localnode", tmpFile, false);
                Trace.out("remote copy file result=" + result);
                olrFileName = tmpFile;
            }
            catch (RemoteDirException e) {
                Object[] args = new Object[]{node};
                throw new NativeException(s_msgBundle.getMessage("1140", true, args), e);
            }
        }
        if (!(cnfgFile = new File(olrFileName)).exists()) {
            return false;
        }
        Trace.out("configFile=" + cnfgFile.getAbsolutePath());
        try {
            String olrCnfgLocPropertyValue = Utils.getPropertyValue(cnfgFile.getAbsolutePath(), "olrconfig_loc", true);
            Trace.out("olrconfig_loc=" + olrCnfgLocPropertyValue);
            boolean args = olrCnfgLocPropertyValue != null;
            return args;
        }
        catch (FileNotFoundException fnfe) {
            Object[] args = new Object[]{node};
            throw new NativeException(s_msgBundle.getMessage("1140", true, args), fnfe);
        }
        catch (IOException ie) {
            Object[] args = new Object[]{cnfgFile.getAbsolutePath()};
            throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
        }
        finally {
            if (!node.equals("localnode") && !this.isLocalNode(node)) {
                cnfgFile.delete();
            }
        }
    }

    @Override
    public String getCRSHome(String node, Version version) throws NativeException {
        File cnfgFile;
        boolean isRemoteNode = !node.equals("localnode") && !this.isLocalNode(node);
        String olrFileName = this.getOLRConfigLocation(node, version);
        Trace.out("olrFileName = " + olrFileName);
        if (isRemoteNode) {
            String tmpFile = this.getUniqueFilePath(System.getProperty("java.io.tmpdir"), new File(olrFileName).getName());
            try {
                if (!this.pathExists(node, olrFileName, 2)) {
                    Object[] args = new String[]{olrFileName};
                    String[] msgs = new String[]{s_msgBundle.getMessage("1144", true, args)};
                    throw new NativeException(msgs);
                }
                String result = this.remoteCopyFile(node, olrFileName, "localnode", tmpFile, false);
                Trace.out("remote copy file result=" + result);
                olrFileName = tmpFile;
            }
            catch (RemoteDirException e) {
                Object[] args = new Object[]{node};
                throw new NativeException(s_msgBundle.getMessage("1140", true, args), e);
            }
        }
        if (!(cnfgFile = new File(olrFileName).getAbsoluteFile()).exists()) {
            Object[] args = new String[]{olrFileName};
            String[] msgs = new String[]{s_msgBundle.getMessage("1144", true, args)};
            throw new NativeException(msgs);
        }
        Trace.out("configFile=" + cnfgFile.getPath());
        try {
            String crsHomePropertyValue = Utils.getPropertyValue(cnfgFile.getPath(), "crs_home", true);
            Trace.out("crs_home=" + crsHomePropertyValue);
            if (crsHomePropertyValue == null) {
                Object[] args = new Object[]{"crs_home", cnfgFile.getPath()};
                String[] msgs = new String[]{s_msgBundle.getMessage("1104", true, args)};
                throw new NativeException(msgs);
            }
            String args = crsHomePropertyValue;
            return args;
        }
        catch (FileNotFoundException fnfe) {
            Object[] args = new Object[]{node};
            throw new NativeException(s_msgBundle.getMessage("1140", true, args), fnfe);
        }
        catch (IOException ie) {
            Object[] args = new Object[]{cnfgFile.getPath()};
            throw new NativeException(s_msgBundle.getMessage("1026", true, args), ie);
        }
        finally {
            if (isRemoteNode) {
                cnfgFile.delete();
            }
        }
    }

    public String getGroup(String oracleHome, int which) throws NativeException {
        String[] cmd;
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        String libraryPath = this.m_library.getLibraryPath(FRAMEWORK_LIBRARY_NAME);
        Trace.out(5, "libraryPath=" + libraryPath);
        if (libraryPath.equals(oracleHome) || libraryPath.equals(oracleHome + FILE_SEPARATOR + "lib")) {
            NativeResult nativeResult = new NativeResult();
            switch (which) {
                case 1: {
                    UnixNative.getOracleGroup(nativeResult);
                    break;
                }
                case 2: {
                    UnixNative.getASMAdminGroup(nativeResult);
                    break;
                }
                default: {
                    nativeResult.setStatus(false);
                }
            }
            if (nativeResult.getStatus()) {
                return nativeResult.getStringResult();
            }
            throw new NativeException(nativeResult.getOSString());
        }
        String binPath = oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.getExeName("osdbagrp");
        File osdbagrp = new File(binPath);
        if (!osdbagrp.exists()) {
            throw new NativeException(new String[]{s_msgBundle.getMessage("1033", false, new String[]{osdbagrp.getName()})});
        }
        switch (which) {
            case 1: {
                cmd = new String[]{binPath};
                break;
            }
            case 2: {
                cmd = new String[]{binPath, "-a"};
                break;
            }
            default: {
                throw new NativeException(s_msgBundle.getMessage("1147", false));
            }
        }
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        if (runtimeExec.getExitValue() != 0) {
            throw new NativeException(runtimeExec.getError());
        }
        String[] output = runtimeExec.getOutput();
        if (output == null || output.length == 0) {
            Trace.out(5, "no group name returned by the binary");
            throw new NativeException(runtimeExec.getError());
        }
        return output[0];
    }

    @Override
    public String getOracleGroup(String oracleHome) throws NativeException {
        return this.getGroup(oracleHome, 1);
    }

    @Override
    public String getASMAdminGroup(String oracleHome) throws NativeException {
        return this.getGroup(oracleHome, 2);
    }

    private String getPrivateNodeNameCommand() {
        File file = new File("/opt/ORCLcluster/bin/clspvtname");
        String pvtNodeNameCmd = file.exists() ? "/opt/ORCLcluster/bin/clspvtname -n " : ((file = new File("/usr/cluster/bin/scha_cluster_get")).exists() ? "/usr/cluster/bin/scha_cluster_get -O PRIVATELINK_HOSTNAME_NODE " : null);
        Trace.out("pvtNodeNameCmd=" + pvtNodeNameCmd);
        return pvtNodeNameCmd;
    }

    @Override
    public boolean isRemoteExecServerNeeded() {
        return false;
    }

    @Override
    public void startRemoteExecServer(String srcLoc, String destLoc) throws NativeException {
    }

    @Override
    public void startRemoteExecServer(String node, String srcLoc, String destLoc) throws NativeException {
    }

    @Override
    public void startRemoteExecServer(String[] remoteExecServerFiles, String destLoc) throws NativeException {
    }

    @Override
    public void startRemoteExecServer(String node, String[] remoteExecServerFiles, String destLoc) throws NativeException {
    }

    @Override
    public String[] getRemoteExecServerFiles() {
        return null;
    }

    @Override
    public String[] getMSVCRTFullPath(String[] locArr) {
        return null;
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result) {
        this.runRemoteExecCmd(cmd, args, env, "localnode", result, false);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result, boolean chkException) {
        this.runRemoteExecCmd(cmd, args, env, "localnode", result, chkException);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, NativeResult result, boolean chkException, boolean toIgnore) {
        this.dorunRemoteExecCmd(cmd, args, env, "localnode", result, chkException, toIgnore);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, node, result, chkException);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result) {
        this.dorunRemoteExecCmd(cmd, args, env, node, result, false);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, NativeResult result, boolean chkException) {
        this.setAPINotSupportedError("runRemoteExecCmd with stdin", result);
    }

    @Override
    public void runRemoteExecCmd(String cmd, String[] args, String[] env, String[] stdin, String node, NativeResult result, boolean chkException) {
        this.setAPINotSupportedError("runRemoteExec with stdin", result);
    }

    private void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result, boolean chkException) {
        this.dorunRemoteExecCmd(cmd, args, env, node, result, chkException, false);
    }

    private void dorunRemoteExecCmd(String cmd, String[] args, String[] env, String node, NativeResult result, boolean chkException, boolean toIgnore) {
        boolean isLocalNode;
        String[] cmdArray = new String[3];
        boolean isShellSSH = false;
        boolean bl = isLocalNode = node.equals("localnode") || this.isLocalNode(node);
        if (isLocalNode) {
            this.unixcmd = "";
        } else {
            try {
                this.unixcmd = this.getRemoteShellCmd(node) + " " + node + " -n ";
            }
            catch (RemoteShellException rse) {
                Trace.out(rse.getMessage());
                result.setException(rse);
                result.setStatus(false);
                return;
            }
        }
        isShellSSH = UnixSystem.isCmdScv(this.unixcmd);
        StringBuffer sb = new StringBuffer(this.unixcmd);
        if (env != null && !isLocalNode) {
            int i;
            String envcmd = "\"/bin/sh -c '";
            for (i = 0; i < env.length; ++i) {
                envcmd = envcmd + env[i] + " ";
            }
            envcmd = envcmd + cmd;
            Trace.out("Incomplete envcmd without ending quotes and arguments: " + envcmd);
            if (args != null) {
                envcmd = envcmd + " ";
                for (i = 0; i < args.length; ++i) {
                    envcmd = envcmd + args[i] + " ";
                }
            }
            envcmd = envcmd + "'" + '\"';
            Trace.out("Complete envcmd with env and args: " + envcmd);
            sb.append(envcmd);
        } else {
            sb.append(cmd);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    sb.append(" " + args[i]);
                }
            }
        }
        this.unixcmd = sb.toString();
        Trace.out("Final unix SSH command: " + this.unixcmd);
        cmdArray[0] = "/usr/bin/sh";
        cmdArray[1] = "-c";
        cmdArray[2] = this.unixcmd;
        RuntimeExec runtime = isLocalNode ? new RuntimeExec(cmdArray, null, env) : new RuntimeExec(node, cmdArray, null, env);
        int retval = runtime.runCommand();
        Trace.out("retval = " + retval);
        String[] cmdOutput = runtime.getOutput();
        String[] rtErr = runtime.getError();
        if (!toIgnore && retval != 0 || (!chkException || chkException && runtime.hasException()) && !isShellSSH && rtErr.length > 0) {
            if (rtErr.length > 0) {
                result.setOSString(rtErr);
            }
            if (cmdOutput.length > 0) {
                result.setOutputString(cmdOutput);
            }
        } else {
            result.setStatus(true);
            int exitVal = runtime.getExitValue();
            Trace.out("exitValue = " + exitVal);
            if (0 != exitVal) {
                if (rtErr.length > 0) {
                    result.setResultString(rtErr);
                }
                result.setOSErrCode(exitVal);
                result.setBooleanResult(false);
                if (cmdOutput.length > 0) {
                    result.setOutputString(cmdOutput);
                }
                return;
            }
            result.setResultString(cmdOutput);
            result.setBooleanResult(true);
            return;
        }
        result.setStatus(false);
    }

    @Override
    public void transferDirToNode(String nodeName, String pathName, String excludeListFile, NativeResult result) {
        Trace.out("traferDirToNode operation on node: " + nodeName);
        String tarCmd = "";
        try {
            tarCmd = this.getTARCommand(nodeName, pathName, null, excludeListFile);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        String ret = this.createDir(nodeName, pathName);
        NativeResult dirCreateResult = new NativeResult(ret);
        if (!dirCreateResult.getStatus()) {
            Trace.out("Directory create failed on node : " + nodeName);
            result.setStatus(false);
            result.setOSString(dirCreateResult.getResultString());
            return;
        }
        String[] cmdArray = new String[]{"/usr/bin/sh", "-c", tarCmd};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        rtErr = this.eliminateTARErrors(rtErr);
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            result.setOSString(rtErr);
        }
    }

    private String getDirItems(String dirToTAR, String inclListFile) {
        if (inclListFile != null) {
            return "";
        }
        File dir = new File(dirToTAR);
        String[] items = dir.list();
        StringBuilder sb = new StringBuilder();
        for (String s : items) {
            sb.append("./").append(s).append(' ');
        }
        return sb.toString();
    }

    private String getTARCommand(String nodeName, String dirToTAR, String inclListFile, String exclListFile) throws RemoteShellException {
        String remoteShellCmd = this.getRemoteShellCmd(nodeName) + " " + nodeName;
        boolean isOption = "X".startsWith("-");
        boolean exclListSupported = !"X".equals("");
        boolean inclListSupported = !"-I".equals("");
        Trace.out("isOption = " + isOption);
        Trace.out("exclListFile = " + exclListFile);
        Trace.out("exclListSupported = " + exclListSupported);
        Trace.out("inclListSupported = " + inclListSupported);
        String itemsToInclude = this.getDirItems(dirToTAR, inclListFile);
        String srcTAR = inclListFile != null && !inclListSupported ? "/usr/bin/cat " + inclListFile + " " + "|" + " " + "/usr/bin/xargs" + " " : "";
        srcTAR = srcTAR + "/usr/bin/tar cf" + (exclListFile != null && !isOption ? "X" : "") + " " + "-" + " " + (exclListFile != null && isOption ? "X" : "") + " " + (exclListFile != null && exclListSupported ? exclListFile : "") + " " + (inclListFile != null ? "" : itemsToInclude) + " " + (inclListFile != null && inclListSupported ? "-I " + inclListFile : "");
        String destTAR = "/usr/bin/tar xfp -";
        String cdToPath = "cd " + dirToTAR;
        String srcCmd = "(" + cdToPath + " " + "&&" + " " + srcTAR + " " + ")" + " ";
        String destCmd = "\"(" + cdToPath + " " + "&&" + " " + destTAR + " " + ")\"";
        String tarCmd = srcCmd + " " + "|" + " " + remoteShellCmd + " " + destCmd;
        Trace.out("TAR command used = " + tarCmd);
        return tarCmd;
    }

    @Override
    public void transferListedDirsToNode(String nodeName, String oracleHome, String copyListFile, String excludeListFile, NativeResult result) {
        Trace.out("tranferListedDirsToNode operation on node: " + nodeName);
        String tarCmd = "";
        try {
            tarCmd = this.getTARCommand(nodeName, oracleHome, copyListFile, excludeListFile);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        String[] cmdArray = new String[]{"/usr/bin/sh", "-c", tarCmd};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        rtErr = this.eliminateTARErrors(rtErr);
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            result.setOSString(rtErr);
        }
    }

    private String[] eliminateTARErrors(String[] orgErrs) {
        Trace.out("Entered eliminateTARErrors...");
        if (orgErrs == null || orgErrs.length == 0) {
            Trace.out("Empty or NULL error list. No action to be taken.");
            return orgErrs;
        }
        Vector<String> vector = new Vector<String>(orgErrs.length);
        for (int i = 0; i < orgErrs.length; ++i) {
            if (-1 == orgErrs[i].indexOf("in the future")) {
                vector.add(orgErrs[i]);
                Trace.out("Added error: '" + orgErrs[i] + "'");
                continue;
            }
            Trace.out("Dropped error: '" + orgErrs[i] + "'");
        }
        String[] modErrs = vector.toArray(new String[vector.size()]);
        return modErrs;
    }

    @Override
    public void writeCommandsToFile(String scriptFileName, String[] scriptLines, NativeResult result) {
        String[] writeLines = new String[scriptLines.length + 1];
        writeLines[0] = "#!/bin/sh" + System.getProperty("line.separator");
        for (int i = 0; i < scriptLines.length; ++i) {
            writeLines[i + 1] = scriptLines[i];
        }
        super.writeCommandsToFile(scriptFileName, writeLines, result);
        String[] chModeCmd = new String[]{"/usr/bin/chmod", "777", scriptFileName};
        RuntimeExec runtime = new RuntimeExec(chModeCmd, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        if (retval != 0 || rtErr != null && rtErr.length > 0) {
            result.setOSString(rtErr);
            result.setOSErrCode(runtime.getExitValue());
            result.setStatus(false);
        } else {
            result.setStatus(true);
        }
    }

    @Override
    public void transferListedFilesToNode(String nodeName, String oracleHome, String copyListFile, NativeResult result) {
        Trace.out("transferListedFilesToNode operation on node: " + nodeName);
        String tarCmd = "";
        try {
            tarCmd = this.getTARCommand(nodeName, oracleHome, copyListFile, null);
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        String[] cmdArray = new String[]{"/usr/bin/sh", "-c", tarCmd};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        rtErr = this.eliminateTARErrors(rtErr);
        Trace.out("retval = " + retval);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdArray)) {
                retval = 1;
            }
            if (retval != 0) {
                result.setOSString(rtErr);
            }
        }
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
    }

    @Override
    public void transferFileToNode(String nodeName, String oracleHome, String sourceFile, NativeResult result) {
        Trace.out("transferFileToNode operation on node: " + nodeName);
        String remoteShellCmd = "";
        try {
            remoteShellCmd = this.getRemoteShellCmd(nodeName) + " " + nodeName;
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        Trace.out("oracleHome = " + oracleHome);
        Trace.out("file to transfer = " + sourceFile);
        boolean ohPathEndsWithSlash = oracleHome.endsWith(System.getProperty("file.separator"));
        String replaceString = ohPathEndsWithSlash ? "./" : ".";
        Trace.out("ohPathEndsWith file separator: " + ohPathEndsWithSlash);
        String relPathOfFileToXfer = sourceFile.replaceFirst(oracleHome, replaceString);
        Trace.out("Relative path of file to transfer = " + relPathOfFileToXfer);
        String srcTAR = "/usr/bin/tar cf - " + relPathOfFileToXfer;
        String destTAR = "/usr/bin/tar xfp -";
        String cdToPath = "cd " + oracleHome;
        String transferCmd = "(" + cdToPath + " " + "&&" + " " + srcTAR + " " + ")" + " " + "|" + " " + remoteShellCmd + " " + "\"(" + cdToPath + " " + "&&" + " " + destTAR + " " + ")\"";
        Trace.out("transferCommand = " + transferCmd);
        String[] cmdArray = new String[]{"/usr/bin/sh", "-c", transferCmd};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        rtErr = this.eliminateTARErrors(rtErr);
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdArray)) {
                retval = 1;
            }
            if (retval != 0) {
                result.setOSString(rtErr);
            }
        }
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
    }

    @Override
    public void createListedDirsOnNode(String nodeName, String createListFile, NativeResult result) {
        Trace.out("createListedDirsOnNode operation on node: " + nodeName);
        String remoteShellCmd = "";
        try {
            remoteShellCmd = this.getRemoteShellCmd(nodeName) + " " + nodeName;
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        this.unixcmd = "/usr/bin/cat " + createListFile + " " + "|" + " " + remoteShellCmd + " " + "/usr/bin/xargs" + " " + "/usr/bin/mkdir -p";
        Trace.out("unixcmd = " + this.unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdarray)) {
                retval = 1;
            }
            if (retval != 0) {
                result.setOSString(rtErr);
            }
        }
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
    }

    @Override
    public void removeListedDirsFromNode(String nodeName, String removeListFile, NativeResult result) {
        Trace.out("removeListedDirsFromNode operation on node: " + nodeName);
        String remoteShellCmd = "";
        try {
            remoteShellCmd = this.getRemoteShellCmd(nodeName) + " " + nodeName;
        }
        catch (RemoteShellException rse) {
            Trace.out(rse.getMessage());
            result.setStatus(false);
            result.setException(rse);
            return;
        }
        this.unixcmd = "/usr/bin/cat " + removeListFile + " " + "|" + " " + remoteShellCmd + " " + "/usr/bin/xargs" + " " + "/usr/bin/rm -rf";
        Trace.out("unixcmd = " + this.unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        result.setOSErrCode(runtime.getExitValue());
        if (rtErr.length > 0) {
            if (retval == 0 && !UnixSystem.isCmdScv(cmdarray)) {
                retval = 1;
            }
            if (retval != 0) {
                result.setOSString(rtErr);
            }
        }
        boolean bstatus = retval == 0;
        result.setStatus(bstatus);
    }

    @Override
    public void updateEnv(String srcLoc, NativeResult result) {
        this.setAPINotSupportedError("updateEnv", result);
    }

    @Override
    public void registerOCX(String ocxFname, String wkdir, boolean bregisterFlag, String srcLoc, NativeResult result) {
        this.setAPINotSupportedError("registerOCX", result);
    }

    @Override
    public void setACLs(String node, String path, boolean isAdmin, NativeResult result) {
        this.setAPINotSupportedError("setACLs", result);
    }

    @Override
    public void rebootNode(String srcLoc, NativeResult result) {
        this.setAPINotSupportedError("rebootNode", result);
    }

    @Override
    public void resolvePath(String path, String srcLoc, String destLoc, NativeResult result) {
        this.setAPINotSupportedError("resolvePath", result);
    }

    @Override
    public String getLocalCSSHome(String nodeName, Version version) throws NativeException {
        String cssHome;
        block11: {
            String[] msgs;
            Object[] args;
            String ocrLoc = null;
            cssHome = null;
            String fileName = this.getConfigLocation(version);
            File configFile = new File(fileName);
            if (!nodeName.equals("localnode") && !this.isLocalNode(nodeName)) {
                String tmpFile = this.getUniqueFilePath(System.getProperty("java.io.tmpdir"), configFile.getName());
                String result = this.remoteCopyFile(nodeName, fileName, "localnode", tmpFile, false);
                Trace.out("remote copy file result=" + result);
                fileName = tmpFile;
                configFile = new File(tmpFile);
            }
            Trace.out("configFile=" + configFile.getAbsolutePath());
            if (!configFile.exists()) {
                args = new String[]{fileName};
                msgs = new String[]{s_msgBundle.getMessage("1144", true, args)};
                throw new NativeException(msgs);
            }
            try {
                ocrLoc = Utils.getPropertyValue(fileName, "ocrconfig_loc", true);
                if (ocrLoc != null) {
                    int index = ocrLoc.indexOf(OCR_CDATA_PATH);
                    if (index == -1) {
                        Object[] args2 = new String[]{nodeName};
                        String[] msgs2 = new String[]{s_msgBundle.getMessage("1105", true, args2)};
                        throw new NativeException(msgs2);
                    }
                    cssHome = ocrLoc.substring(0, index);
                    break block11;
                }
                args = new Object[]{"ocrconfig_loc", configFile.getAbsolutePath()};
                msgs = new String[]{s_msgBundle.getMessage("1104", true, args)};
                throw new NativeException(msgs);
            }
            catch (FileNotFoundException fnfe) {
                throw new NativeException(fnfe.getMessage(), fnfe);
            }
            catch (IOException ie) {
                throw new NativeException(ie.getMessage(), ie);
            }
            finally {
                if (!nodeName.equals("localnode") && !this.isLocalNode(nodeName)) {
                    configFile.delete();
                }
            }
        }
        Trace.out("csshome = " + cssHome);
        return cssHome;
    }

    @Override
    public boolean checkCSSStatus(String nodeName, String oracleHome, Version version, NativeResult result) {
        Trace.out("checkCSSStatus operation on node: " + nodeName);
        String remoteShellCmd = "";
        String csscmd = oracleHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crsctl" + " " + "check" + " " + "cssd" + " " + "> /dev/null && echo true";
        if (nodeName.equals("localnode") || this.isLocalNode(nodeName)) {
            this.unixcmd = csscmd;
        } else {
            try {
                remoteShellCmd = this.getRemoteShellCmd(nodeName) + " " + nodeName;
            }
            catch (RemoteShellException rse) {
                Trace.out(rse.getMessage());
                result.setStatus(false);
                result.setException(rse);
                return false;
            }
            this.unixcmd = remoteShellCmd + " " + "\"" + "/usr/bin/sh" + " " + "-c" + " " + "'" + csscmd + "'\"";
        }
        Trace.out("unixcmd = " + this.unixcmd);
        String[] cmdarray = new String[]{"/usr/bin/sh", "-c", this.unixcmd};
        RuntimeExec runtime = new RuntimeExec(cmdarray, null, null);
        int retval = runtime.runCommand();
        String[] rtErr = runtime.getError();
        boolean bstatus = retval == 0;
        result.setOSErrCode(runtime.getExitValue());
        Trace.out("node = " + nodeName + ", Return Value = " + retval);
        Trace.out("node = " + nodeName + ", Exit Value = " + runtime.getExitValue());
        for (int i = 0; i < rtErr.length; ++i) {
            Trace.out("node = " + nodeName + ", rtErr[" + i + "] = " + rtErr[i]);
        }
        String[] output = runtime.getOutput();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < output.length; ++i) {
            buffer.append(output[i]);
            Trace.out("node = " + nodeName + ", output[" + i + "] = " + output[i]);
        }
        String outStr = buffer.toString();
        if (outStr.trim().length() == 0) {
            Trace.out("No output is obtained");
            bstatus = false;
        } else {
            String cmpStr = "true";
            int strRetval = outStr.toLowerCase().indexOf(cmpStr.toLowerCase());
            Trace.out("strRetval = " + strRetval);
            if (strRetval == -1) {
                bstatus = false;
            }
        }
        result.setStatus(bstatus);
        if (rtErr.length > 0 && (retval != 0 || retval == 0 && !UnixSystem.isCmdScv(cmdarray))) {
            result.setOSString(rtErr);
        }
        return bstatus;
    }

    @Override
    public void listDirectory(String nodeName, String dirPath, NativeResult result) {
        if (nodeName.equals("localnode") || this.isLocalNode(nodeName)) {
            this.unixcmd = "/usr/bin/ls -1A " + dirPath;
        } else {
            try {
                this.unixcmd = this.getRemoteShellCmd(nodeName) + " " + nodeName + " -n " + "/usr/bin/ls" + " -1A " + dirPath;
            }
            catch (RemoteShellException rse) {
                Trace.out(rse.getMessage());
                result.setException(rse);
                result.setStatus(false);
                return;
            }
        }
        Trace.out("unixcmd=" + this.unixcmd);
        RuntimeExec runtime = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
        int retVal = runtime.runCommand();
        String[] error = runtime.getError();
        if (retVal == 0 && (error.length == 0 || error.length != 0 && UnixSystem.isCmdScv(this.unixcmd))) {
            result.setStatus(true);
            result.setResultString(runtime.getOutput());
        } else {
            result.setStatus(false);
            result.setOSString(error);
        }
    }

    @Override
    public void getLibraryVersion(String libPath, NativeResult result) {
        this.setAPINotSupportedError("getLibraryVersion", result);
    }

    @Override
    public String getOFSUtilLocation() {
        return "/sbin/";
    }

    @Override
    public void isNodeAlive(String node, int timeout, NativeResult nativeResult) {
        if (Utils.isYodaInBMCEnvironment() || Utils.isBareMetalCloud()) {
            int i;
            String[] aliveErrorMessages = new String[]{"Permission denied", "port 22: Connection refused"};
            Trace.out("Found YODA in BMC OR Exadata on cloud");
            String[] envVars = new String[]{"LC_ALL=C", "LANG=C"};
            this.unixcmd = "/usr/bin/ssh" + NO_FALLBACK_TO_RSH + NO_PW_AUTHENTICATION + " " + " -o StrictHostKeyChecking=yes " + " -o NumberOfPasswordPrompts=0 " + node + " " + "/usr/bin/true";
            Trace.out("Running command [" + this.unixcmd + "]");
            RuntimeExec runtime = new RuntimeExec(node, UnixSystem.getCmdArr(this.unixcmd), null, envVars, true, timeout);
            int retVal = runtime.runCommand();
            String[] cmdOutput = runtime.getOutput();
            String[] cmdError = runtime.getError();
            nativeResult.setStatus(true);
            nativeResult.setNodeName(node);
            StringBuffer retStringBuffer = new StringBuffer();
            StringBuffer errorBuffer = new StringBuffer();
            for (i = 0; i < cmdOutput.length; ++i) {
                retStringBuffer.append(cmdOutput[i] + "\n");
            }
            nativeResult.setStringResult(retStringBuffer.toString());
            for (i = 0; i < cmdError.length; ++i) {
                errorBuffer.append(cmdError[i] + "\n");
            }
            boolean is255AndAlive = false;
            if (retVal == 255) {
                for (String msg : aliveErrorMessages) {
                    if (errorBuffer.indexOf(msg) == -1) continue;
                    is255AndAlive = true;
                    break;
                }
            }
            if (retVal == 0 || is255AndAlive) {
                Trace.out("return value for /bin/true is " + retVal);
                retStringBuffer.append("1|");
                nativeResult.setBooleanResult(true);
            } else if (retVal == 2) {
                nativeResult.setBooleanResult(false);
                for (int i2 = 0; i2 < cmdError.length; ++i2) {
                    retStringBuffer.append(cmdError[i2] + "\n");
                }
                if (runtime.hasException()) {
                    retStringBuffer.append(runtime.getException().getMessage());
                }
                nativeResult.setOSString(MessageBundle.getMessageBundle("Prkn").getMessage("1035", true, new String[]{node}));
            }
            return;
        }
        try {
            nativeResult.setNodeName(node);
            String nodeIP = InetAddress.getByName(node).getHostAddress();
            this.unixcmd = IPAddressUtil.isIPv6AddressString(nodeIP) ? "/usr/sbin/ping " + sPlatform.getPingCmdArgs(node, timeout) : "/usr/sbin/ping " + sPlatform.getPingCmdArgs(node, timeout);
            RuntimeExec runtime = new RuntimeExec(UnixSystem.getCmdArr(this.unixcmd), null, null);
            int retVal = runtime.runCommand();
            String[] cmdOut = runtime.getOutput();
            StringBuffer msgBuf = new StringBuffer();
            for (int i = 0; i < cmdOut.length; ++i) {
                msgBuf.append(cmdOut[i] + "\n");
            }
            nativeResult.setStatus(true);
            if (retVal == 0) {
                nativeResult.setBooleanResult(true);
                Trace.out("msgBuf=" + msgBuf);
                nativeResult.setStringResult(msgBuf.toString());
            } else {
                String[] cmdError = runtime.getError();
                for (int i = 0; i < cmdError.length; ++i) {
                    msgBuf.append(cmdError[i] + "\n");
                }
                nativeResult.setBooleanResult(false);
                Trace.out("msgBuf=" + msgBuf);
                nativeResult.setOSString(MessageBundle.getMessageBundle("Prkn").getMessage("1035", true, new String[]{node}));
            }
        }
        catch (UnknownHostException e) {
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(MessageBundle.getMessageBundle("Prkn").getMessage("1034", true, new String[]{node}));
            if (node.equals(e.getMessage())) {
                errMsg.append("\n" + MessageBundle.getMessageBundle("Prkn").getMessage("1043", false, new String[]{node}));
            } else {
                errMsg.append("\n" + e.getMessage());
            }
            Trace.out("UnknownHostException for node=" + node + " msg= " + errMsg.toString());
            NativeException ne = new NativeException(new String[]{errMsg.toString()});
            nativeResult.setException(ne);
            nativeResult.setStatus(false);
            nativeResult.setBooleanResult(false);
        }
    }

    private static String getPermUsingUmask() throws NativeException {
        if (s_permValue != null) {
            return s_permValue;
        }
        String[] cmdarray = new String[]{"/usr/bin/sh"};
        String[] inarray = new String[]{UMASK_S_FLAG};
        RuntimeExec runtime = new RuntimeExec(cmdarray, inarray, null);
        if (runtime.runCommand() != 0) {
            String[] rtErr = runtime.getError();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < rtErr.length; ++i) {
                sb.append(rtErr[i]).append(" ");
            }
            Trace.out("Umask failed: " + sb.toString());
            throw new NativeException("1145", new String[]{sb.toString()});
        }
        s_permValue = runtime.getOutput()[0];
        return s_permValue;
    }

    public void execCmdLocalPseduoTerm(String[] cmd, String username, String passwd, NativeResult result) throws NativeException {
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        UnixNative.execCmdLocalPseduoTerm(cmd, username, passwd, result);
    }

    @Override
    public String getCurrentUserName() throws NativeException {
        return System.getProperty("user.name");
    }

    public String getLSOFPath() {
        String lsofPath = "/usr/sbin/lsof";
        if (DeterminePlatform.getOSName().equals("SunOS") || DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("HP-UX")) {
            lsofPath = "/usr/local/bin/lsof";
        } else if (DeterminePlatform.getOSName().equals("AIX")) {
            lsofPath = "/usr/bin/lsof";
        }
        Trace.out((Object)"The lsof path is %s", lsofPath);
        return lsofPath;
    }

    public String getKillPath() {
        String killPath = "/bin/kill";
        if (DeterminePlatform.getOSName().equals("AIX") || DeterminePlatform.getOSName().equals("HP-UX")) {
            killPath = "/usr/bin/kill";
        }
        Trace.out((Object)"The kill path is %s", killPath);
        return killPath;
    }

    public String getOraInstLoc() {
        String oraInstFileLoc = "/etc/oraInst.loc";
        if (DeterminePlatform.getOSName().equals("SunOS") || DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("HP-UX")) {
            oraInstFileLoc = "/var/opt/oracle/oraInst.loc";
        }
        Trace.out((Object)"The oraInst.loc is %s", oraInstFileLoc);
        return oraInstFileLoc;
    }
}

