/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import oracle.cluster.remote.ExecRunTime;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.nativesystem.CreateWaitForThread;
import oracle.ops.mgmt.nativesystem.StreamReader;
import oracle.ops.mgmt.trace.Trace;

public class RuntimeExec {
    private static final Map<String, Semaphore> s_nodeSemaphoreMap = Collections.synchronizedMap(new HashMap());
    private String[] m_cmd;
    private String[] m_input;
    private String[] m_env;
    private boolean m_inherit;
    private String[] m_output;
    private String[] m_error;
    private int m_timeout = 0;
    private int m_exitValue = 0;
    private Exception m_exception = null;
    private final String m_nodeName;
    private final String LSEP = System.getProperty("line.separator");
    private static boolean debugEnabled = Trace.isLevelEnabled(5);

    public RuntimeExec(String[] cmd, String[] input, String[] env) {
        this(null, cmd, input, env, true);
    }

    public RuntimeExec(String[] cmd, String[] input, String[] env, boolean inherit) {
        this(null, cmd, input, env, inherit);
    }

    public RuntimeExec(String nodeName, String[] cmd, String[] input, String[] env) {
        this(nodeName, cmd, input, env, true);
    }

    public RuntimeExec(String nodeName, String[] cmd, String[] input, String[] env, boolean inherit) {
        this(nodeName, cmd, input, env, inherit, 0);
    }

    public RuntimeExec(String nodeName, String[] cmd, String[] input, String[] env, boolean inherit, int timeout) {
        this.m_cmd = cmd;
        this.m_input = input;
        this.m_env = env;
        this.m_inherit = inherit;
        this.m_nodeName = nodeName;
        this.m_timeout = timeout;
    }

    public ExecRunTime runCommandNoWait() throws IOException {
        Process proc = null;
        Runtime rt = Runtime.getRuntime();
        if (debugEnabled) {
            this.traceCmdEnv(this.m_cmd, this.m_env);
        }
        try {
            if (this.m_env != null) {
                if (this.m_env.length != 0 || this.m_env.length == 0 && !this.m_inherit) {
                    Trace.out("subprocess is not inheriting from the current process");
                    proc = rt.exec(this.m_cmd, this.m_env);
                } else {
                    proc = rt.exec(this.m_cmd);
                }
            } else {
                proc = rt.exec(this.m_cmd);
            }
        }
        catch (IOException e) {
            if (debugEnabled) {
                Trace.out("exec exception:" + e.getMessage());
                Trace.out(e);
            }
            throw new IOException(e);
        }
        return new ExecRunTime(proc);
    }

    public int runCommand() {
        StreamReader errorReader;
        StreamReader outputReader;
        Semaphore executionSemaphore;
        int ret;
        Process proc;
        block41: {
            block40: {
                proc = null;
                ret = 1;
                this.m_exception = null;
                if (this.m_cmd == null) {
                    if (debugEnabled) {
                        Trace.out("runCommand: null command passed");
                    }
                    return ret;
                }
                Runtime rt = Runtime.getRuntime();
                executionSemaphore = null;
                if (this.m_nodeName != null && (executionSemaphore = RuntimeExec.getSemaphore(this.m_nodeName)) != null) {
                    long startTime = System.currentTimeMillis();
                    try {
                        executionSemaphore.acquire();
                        long l = (System.currentTimeMillis() - startTime) / 1000L;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    proc = this.m_env != null ? rt.exec(this.m_cmd, this.m_env) : rt.exec(this.m_cmd);
                }
                catch (IOException e) {
                    this.m_exception = e;
                    this.setErrorMsg();
                    if (debugEnabled) {
                        Trace.out("exec exception:" + e.getMessage());
                        Trace.out(e);
                        this.traceCmdEnv(this.m_cmd, this.m_env);
                    }
                    if (executionSemaphore != null) {
                        executionSemaphore.release();
                    }
                    return 2;
                }
                if (this.m_input != null) {
                    block39: {
                        OutputStream os = proc.getOutputStream();
                        OutputStreamWriter osw = new OutputStreamWriter(os);
                        BufferedWriter bw = new BufferedWriter(osw);
                        try {
                            if (debugEnabled) {
                                Trace.out("runCommand: input length=" + this.m_input.length);
                            }
                            for (int line = 0; line < this.m_input.length; ++line) {
                                bw.write(this.m_input[line]);
                                bw.write(this.LSEP);
                                bw.flush();
                            }
                            os.close();
                            if (debugEnabled) {
                                Trace.out("runCommand: closed input for process");
                            }
                        }
                        catch (IOException ioe) {
                            this.m_exception = ioe;
                            if (!debugEnabled) break block39;
                            Trace.out(ioe);
                        }
                    }
                    if (debugEnabled) {
                        Trace.out("runCommand: submitted input");
                    }
                }
                outputReader = new StreamReader(proc.getInputStream(), "OUTPUT");
                errorReader = new StreamReader(proc.getErrorStream(), "ERROR");
                errorReader.start();
                outputReader.start();
                if (this.m_timeout != 0) {
                    ret = this.createWaitForThread(proc);
                } else {
                    try {
                        if (debugEnabled) {
                            Trace.out("runCommand: Waiting for the process");
                        }
                        ret = proc.waitFor();
                        if (debugEnabled) {
                            Trace.out("runCommand: process returns " + ret);
                        }
                    }
                    catch (InterruptedException e) {
                        this.m_exception = e;
                        if (!debugEnabled) break block40;
                        Trace.out("runCommand: interrupted awaiting process");
                    }
                }
            }
            try {
                errorReader.join();
                outputReader.join();
            }
            catch (InterruptedException ie) {
                this.m_exception = ie;
                if (!debugEnabled) break block41;
                Trace.out(ie);
            }
        }
        this.m_output = outputReader.getBuffer();
        if (debugEnabled) {
            Trace.out(1, "RunTimeExec: output>");
            if (this.m_output != null) {
                for (int j = 0; j < this.m_output.length; ++j) {
                    Trace.out(1, this.m_output[j]);
                }
            } else {
                Trace.out("RuntimeExec.runCommand: output is null");
            }
        }
        this.m_error = errorReader.getBuffer();
        if (debugEnabled) {
            Trace.out("RunTimeExec: error>");
            if (this.m_error != null) {
                for (int j = 0; j < this.m_error.length; ++j) {
                    Trace.out(this.m_error[j]);
                }
            } else {
                Trace.out("RuntimeExec.runCommand: error is null");
            }
        }
        try {
            this.m_exitValue = proc.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            if (debugEnabled) {
                Trace.out(ie);
            }
            this.m_exception = ie;
            this.m_exitValue = 2;
        }
        if (this.m_exitValue != 0 && debugEnabled) {
            this.traceCmdEnv(this.m_cmd, this.m_env);
        }
        proc.destroy();
        if (debugEnabled) {
            Trace.out("Returning from RunTimeExec.runCommand");
        }
        if (this.hasException()) {
            this.setErrorMsg();
            ret = 2;
        }
        if (executionSemaphore != null) {
            executionSemaphore.release();
        }
        return ret;
    }

    private int createWaitForThread(Process proc) {
        CreateWaitForThread waitThread = new CreateWaitForThread(proc);
        long startTime = System.currentTimeMillis();
        waitThread.start();
        try {
            Trace.out("waiting for " + this.m_timeout * 1000 + " ms");
            waitThread.join(this.m_timeout * 1000);
        }
        catch (InterruptedException e) {
            Trace.out("Interrupted before command could finsh");
            this.m_exception = e;
            return 2;
        }
        if (waitThread.getException() != null) {
            this.m_exception = waitThread.getException();
        }
        return waitThread.getReturnValue();
    }

    public String[] getOutput() {
        if (this.m_output != null) {
            return this.m_output;
        }
        return new String[0];
    }

    public String[] getError() {
        if (this.m_error != null) {
            return this.m_error;
        }
        return new String[0];
    }

    public String getErrorString() {
        StringBuffer buffer = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        if (this.m_error != null) {
            for (int i = 0; i < this.m_error.length; ++i) {
                buffer.append(this.m_error[i] + lineSep);
            }
        }
        return buffer.toString();
    }

    public int getExitValue() {
        return this.m_exitValue;
    }

    public boolean hasException() {
        return this.m_exception != null;
    }

    public Exception getException() {
        return this.m_exception;
    }

    private void setErrorMsg() {
        if (this.m_exception != null) {
            this.m_error = new String[]{this.m_exception.getMessage()};
        }
    }

    public static void resetNodeSemaphoreLookupMap() {
        if (!s_nodeSemaphoreMap.isEmpty()) {
            s_nodeSemaphoreMap.clear();
        }
    }

    public static void updateNodeSemaphoreLookupMap(String[] nodeNames) throws InvalidNodeListException {
        if (nodeNames == null) {
            throw new InvalidNodeListException("Prkc", "1062");
        }
        for (int i = 0; i < nodeNames.length; ++i) {
            String key = nodeNames[i].trim().toLowerCase();
            if (!s_nodeSemaphoreMap.containsKey(key)) {
                s_nodeSemaphoreMap.put(key, new Semaphore(1));
                continue;
            }
            Trace.out("There already exists a semahore for the remote connection to node \"" + nodeNames[i] + "\"");
        }
    }

    private static Semaphore getSemaphore(String nodeName) {
        nodeName = nodeName.trim().toLowerCase();
        return s_nodeSemaphoreMap.get(nodeName);
    }

    private void traceCmdEnv(String[] cmd, String[] env) {
        int i;
        Trace.out("Calling Runtime.exec() with the command ");
        for (i = 0; i < cmd.length; ++i) {
            Trace.out(cmd[i] + " ");
        }
        if (env != null && env.length != 0) {
            Trace.out("runCommand: env = ");
            for (i = 0; i < env.length; ++i) {
                if (env[i].contains("SUDO_PASSWD")) continue;
                Trace.out(" " + i + ":" + env[i]);
            }
        }
    }
}

