/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import oracle.cluster.common.DiskSpaceFlags;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.CopyListedFilesException;
import oracle.ops.mgmt.cluster.CreateListedDirsException;
import oracle.ops.mgmt.cluster.HostnameException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.RemoteCopyException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.service.ServiceData;
import oracle.ops.mgmt.daemon.OPSMDaemonResult;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.Library;
import oracle.ops.mgmt.nativesystem.Native;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NotAClusterException;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.UnixSystem;
import oracle.ops.mgmt.nativesystem.sUnixCommands;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public abstract class NativeSystem
implements Constants,
sUnixCommands {
    protected String unixcmd;
    protected Library m_library = Library.getInstance(this);
    private String m_srvmLibName;

    public abstract String getOracleGroup(String var1) throws NativeException;

    public abstract String getCurrentUserName() throws NativeException;

    public abstract String getASMAdminGroup(String var1) throws NativeException;

    public NativeResult getEnvironment(String environment) {
        NativeResult nativeResult = new NativeResult();
        this.getEnvironment(environment, nativeResult);
        return nativeResult;
    }

    public String getEnvironmentVariable(String variable) {
        NativeResult nativeResult = this.getEnvironment(variable);
        if (nativeResult.getStatus()) {
            return nativeResult.getStringResult();
        }
        return null;
    }

    public String getRDBMSVersion() throws NativeException {
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        Native.getRDBMSVersion(nativeResult);
        if (nativeResult.getStatus()) {
            return nativeResult.getStringResult();
        }
        throw new NativeException("1028");
    }

    public void getEnvironment(String environment, NativeResult nativeResult) {
        try {
            if (!this.isLibraryLoaded()) {
                this.loadSRVMNativeLibrary();
            }
        }
        catch (NativeException ne) {
            Trace.out(ne);
            nativeResult.setStatus(false);
            nativeResult.setOSString(ne.getMessage());
            nativeResult.setException(ne);
            return;
        }
        Native.getEnvironment(environment, nativeResult);
    }

    public abstract String getIPAddrCommand();

    public abstract NativeResult validateRawDevice(String var1) throws NativeException;

    public abstract NativeResult validateDevice(String var1) throws NativeException;

    NativeSystem() {
    }

    public boolean isUnixSystem() {
        return this instanceof UnixSystem;
    }

    abstract String loadPathDescription();

    abstract String getOracleLibraryName(String var1);

    String getNativeLibraryName(String libraryName) {
        return this.getNativeLibraryName(libraryName, true);
    }

    String getNativeLibraryName(String libraryName, boolean isOracleLib) {
        String retStr = isOracleLib ? System.mapLibraryName(this.getOracleLibraryName(libraryName)) : System.mapLibraryName(libraryName);
        if (DeterminePlatform.getOSName().equals("AIX")) {
            String base = retStr.substring(0, retStr.lastIndexOf(".a"));
            return base + ".so";
        }
        return retStr;
    }

    public boolean isLibraryLoaded() {
        try {
            return this.m_library.isLoaded(FRAMEWORK_LIBRARY_NAME);
        }
        catch (NativeException ne) {
            Trace.out(ne);
            return false;
        }
    }

    public boolean isOCRLibraryLoaded() throws NativeException {
        return this.m_library.isLoaded(FRAMEWORK_OCR_LIBRARY_NAME);
    }

    public boolean isSRVMHASLibraryLoaded() throws NativeException {
        return this.m_library.isLoaded(FRAMEWORK_OPSM_HA_LIBRARY_NAME);
    }

    public boolean isCredLibraryLoaded() {
        try {
            return this.m_library.isLoaded(FRAMEWORK_CRED_LIBRARY_NAME);
        }
        catch (NativeException ne) {
            Trace.out(ne);
            return false;
        }
    }

    public boolean isRemoteExecLibraryLoaded() throws NativeException {
        return this.m_library.isLoaded(WINDOWS_REMOTEEXEC_LIBRARY_NAME);
    }

    public final void loadSRVMNativeLibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_LIBRARY_NAME);
        }
    }

    public static final boolean isCmdScv(String cmd) {
        boolean rc = false;
        Trace.out("isCmdScv: cmd=[" + cmd + "]");
        if (cmd == null || cmd.length() == 0) {
            return rc;
        }
        String s_ssh = "/usr/bin/ssh".substring("/usr/bin/ssh".lastIndexOf(47) + 1);
        String s_scp = "/usr/bin/scp".substring("/usr/bin/scp".lastIndexOf(47) + 1);
        String[] parts = cmd.split("[ |]");
        for (int i = 0; i < parts.length; ++i) {
            String shellcmd;
            String shell;
            int sz;
            if (parts[i].length() == 0) continue;
            int pos = parts[i].indexOf(32);
            if (pos == -1) {
                pos = parts[i].length();
            }
            if ((pos = parts[i].indexOf(47, pos)) == -1) {
                pos = 0;
            }
            if ((sz = (shell = shellcmd.substring(pos = (pos = (shellcmd = parts[i].substring(pos)).lastIndexOf(47)) == -1 ? 0 : pos + 1)).length()) != s_ssh.length() || sz != s_scp.length()) continue;
            if (shell.equals(s_ssh) || shell.equals(s_scp)) {
                File f = new File(shellcmd);
                if (f.exists()) {
                    Trace.out("isCmdScv: " + shellcmd + " is present.");
                    if (f.isFile()) {
                        Trace.out("isCmdScv: " + shellcmd + " is a file.");
                        rc = true;
                        break;
                    }
                    Trace.out("isCmdScv: " + shellcmd + " is not a file.");
                } else {
                    Trace.out("isCmdScv: " + shellcmd + " does not exist.");
                }
            }
            shellcmd = null;
            shell = null;
        }
        parts = null;
        Trace.out("isCmdScv: returned " + rc);
        return rc;
    }

    public static final boolean isCmdScv(String[] cmds) {
        return NativeSystem.isCmdScv(Utils.getString(cmds, " "));
    }

    public final void loadSRVMHASNativeLibrary() throws NativeException, NotAClusterException {
        if (!this.m_library.isLoaded(FRAMEWORK_OPSM_HA_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_OPSM_HA_LIBRARY_NAME);
        }
    }

    public final void loadSRVMCREDNativeLibrary() throws NativeException, NotAClusterException {
        if (!this.m_library.isLoaded(FRAMEWORK_CRED_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_CRED_LIBRARY_NAME);
        }
    }

    public final void loadOCRNativeLibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_OCR_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_OCR_LIBRARY_NAME);
        }
    }

    public final void loadRDJNILibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_RD_JNI_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_RD_JNI_LIBRARY_NAME);
        }
    }

    public final void loadGNSJNILibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_GNS_JNI_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_GNS_JNI_LIBRARY_NAME);
        }
    }

    public final void loadCLSCEJNILibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_CLSCE_JNI_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_CLSCE_JNI_LIBRARY_NAME);
        }
    }

    public final void loadCLSNSJNILibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_CLSNS_JNI_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_CLSNS_JNI_LIBRARY_NAME);
        }
    }

    public final void loadCLSCREDJNILibrary() throws NativeException {
        if (!this.m_library.isLoaded(FRAMEWORK_CLSCRED_JNI_LIBRARY_NAME)) {
            this.m_library.load(FRAMEWORK_CLSCRED_JNI_LIBRARY_NAME);
        }
    }

    public final void loadRemoteExecLibrary() throws NativeException, NotAClusterException {
        if (!this.m_library.isLoaded(WINDOWS_REMOTEEXEC_LIBRARY_NAME)) {
            this.m_library.load(WINDOWS_REMOTEEXEC_LIBRARY_NAME);
        }
    }

    public abstract String getEffectiveGroup() throws NativeException;

    public OPSMDaemonResult initializeDaemon(String groupName, int portNumber) {
        Object retString = null;
        OPSMDaemonResult daemonResult = new OPSMDaemonResult();
        if (Trace.isNativeDebug()) {
            daemonResult.setNativeDebugFlag(true);
        }
        try {
            Native.initializeDaemon(groupName, portNumber, daemonResult);
            Trace.out("\ninitializeDaemon status = " + daemonResult.getStatus());
        }
        catch (UnsatisfiedLinkError e) {
            daemonResult.setStatus(false);
            daemonResult.setOPSMErrCode(new Integer("1003"));
            Trace.out("Unsatisfied Link Error caught.  Could not initialize the cluster");
        }
        return daemonResult;
    }

    public String getLiveDaemon() {
        String groupName = new String(System.getProperty("srvm.daemon.groupname", "opsm"));
        return Native.getLiveDaemon(groupName);
    }

    public OPSMDaemonResult checkCoordinator() {
        Trace.out("About to call native system checkCoordinator");
        OPSMDaemonResult daemonResult = new OPSMDaemonResult();
        Native.checkCoordinator(daemonResult);
        return daemonResult;
    }

    public NativeResult initSRVMCtx() {
        Object retString = null;
        NativeResult nativeResult = new NativeResult();
        try {
            Native.initSRVMCtx(nativeResult);
            Trace.out("\ninitializeDaemon status = " + nativeResult.getStatus());
        }
        catch (UnsatisfiedLinkError e) {
            nativeResult.setStatus(false);
            nativeResult.setOPSMErrCode(new Integer("1003"));
            Trace.out("Unsatisfied Link Error caught.  Could not initialize the cluster");
        }
        return nativeResult;
    }

    public OPSMDaemonResult getGSDPortNum(String groupName, String nodeName) {
        Object retString = null;
        OPSMDaemonResult daemonResult = new OPSMDaemonResult();
        if (Trace.isNativeDebug()) {
            Trace.out("Setting native debug to true");
            daemonResult.setNativeDebugFlag(true);
        }
        Trace.out("GSD groupName = " + groupName);
        try {
            Native.getGSDPortNum(groupName, nodeName, daemonResult);
            Trace.out("\n getGSDPortNum status = " + daemonResult.getStatus());
        }
        catch (UnsatisfiedLinkError e) {
            daemonResult.setStatus(false);
            daemonResult.setOPSMErrCode(new Integer("1003"));
            Trace.out("Unsatisfied Link Error caught.  Could not initialize the cluster");
        }
        return daemonResult;
    }

    public String getNodeName() {
        return Native.getNodeName();
    }

    public String getNormHostName(String hostName) {
        String nodename = hostName.toLowerCase();
        int indx = nodename.indexOf(46);
        if (indx > -1) {
            nodename = nodename.substring(0, indx);
        }
        return nodename;
    }

    public OPSMDaemonResult getCoordinatorName(String groupName) {
        Trace.out("About to call native function in getCoordinatorName");
        OPSMDaemonResult opsmDaemonResult = new OPSMDaemonResult();
        Native.getCoordinatorName(groupName, opsmDaemonResult);
        return opsmDaemonResult;
    }

    public OPSMDaemonResult pollCluster() {
        OPSMDaemonResult daemonResult = new OPSMDaemonResult();
        Native.updateBitMap(daemonResult);
        return daemonResult;
    }

    public String checkInstance(String dbName, String instanceName) {
        return Native.checkInstance(dbName, instanceName);
    }

    public String checkOPS(String groupName) {
        return Native.checkOPS(groupName);
    }

    public void postEvent(NativeResult result) {
        Native.postEvent(result);
    }

    public void waitForEvent(NativeResult result) {
        Native.waitForEvent(result);
    }

    public abstract String copyFile(String var1, String var2, String var3, String var4);

    public abstract String copyFilesLocally(String var1, String var2, String var3, boolean var4);

    public abstract String copyFile(String var1, String var2, String var3, String var4, boolean var5);

    public abstract String moveFile(String var1, String var2, String var3);

    public abstract String linkFile(String var1, String var2, String var3);

    public abstract String removeFile(String var1, String var2);

    public abstract String removeDir(String var1, String var2);

    public abstract String removeDir(String var1, String var2, boolean var3);

    public abstract String removeDirRecurse(String var1, String var2);

    public abstract String createDir(String var1, String var2);

    public abstract String createDirRecurse(String var1, String var2);

    public abstract String createDirWithMode(String var1, String var2);

    public abstract String createDirWithModeRecurse(String var1, String var2);

    public abstract String createDirWithPermissions(String var1, String var2, String var3);

    public abstract String changeModePermissions(String var1, String var2, String var3) throws RemoteShellException;

    public abstract boolean pathExists(String var1, String var2) throws RemoteDirException;

    public abstract boolean pathExists(String var1, String var2, int var3) throws RemoteDirException;

    public abstract String getFreeSpace(String var1, String var2) throws RemoteShellException;

    public abstract boolean removeListedFilesFromNode(String var1, String var2) throws RemoteShellException, RemoveListedFilesException;

    public abstract boolean createListedDirsOnNode(String var1, String var2) throws RemoteShellException, CreateListedDirsException;

    public abstract boolean copyListedFilesToNode(String var1, String var2) throws RemoteShellException, CopyListedFilesException;

    public abstract String isNodeAccessible(String var1) throws RemoteShellException;

    public abstract String getNodeAccessiblityCommand(String var1) throws RemoteShellException;

    public abstract void isNodeAlive(String var1, int var2, NativeResult var3);

    public abstract String getRemoteShellCmd() throws RemoteShellException;

    public abstract String getRemoteCopyCmd() throws RemoteCopyException;

    public abstract void resetRemoteShellCmd();

    public abstract void resetRemoteCopyCmd();

    public abstract String getHostName(String var1) throws HostnameException;

    public abstract String getPrivateNodeName(String var1) throws HostnameException;

    public abstract String startService(String var1, String var2);

    public abstract boolean checkService(String var1, String var2, ServiceData var3, NativeResult var4);

    public abstract String stopService(String var1, String var2);

    public abstract String deleteService(String var1, String var2);

    public abstract String deleteService(boolean var1, String var2, String var3);

    public abstract String createService(String var1, String var2, int var3, String var4);

    public abstract String createService(String var1, String var2, int var3, int var4, int var5, int var6, String var7, String var8, String var9, String var10, String var11, String var12);

    public abstract String createServiceDep(String var1, String[] var2, String var3);

    public abstract String removeServiceDep(String var1, String[] var2, String var3) throws NativeException;

    public abstract String queryServiceDep(String var1, String var2) throws NativeException;

    public abstract String startListener(String var1, String var2, String var3, String var4);

    public abstract void regCreateKey(String var1, String var2, String var3, NativeResult var4);

    public abstract void regDeleteKey(String var1, String var2, String var3, NativeResult var4);

    public abstract void regSetValue(String var1, String var2, String var3, RegistryKeyData var4, NativeResult var5);

    public abstract void regDeleteValue(String var1, String var2, String var3, NativeResult var4);

    public abstract void regGetData(String var1, String var2, String var3, RegistryKeyData var4, NativeResult var5);

    public abstract void regGetSubKey(String var1, String var2, RegistryKeyData var3, NativeResult var4);

    public abstract void getServices4ImagePath(String var1, String var2, RegistryKeyData var3, NativeResult var4);

    public abstract boolean regKeyExists(String var1, String var2, NativeResult var3);

    public abstract String initializeClusterThread();

    public abstract String initializeClusterWare();

    public abstract String getPfileName(String var1, String var2);

    public abstract String startDaemon(String var1, String var2);

    public abstract String getExeName(String var1);

    public abstract String getScriptFileName(String var1);

    public abstract NativeResult isSharedPath(String var1, String[] var2, String var3) throws SharedDeviceException, InvalidNodeListException;

    public abstract void checkCFSPath(String var1, String var2, String var3, Constants.CFS_OP_TYPE var4, NativeResult var5) throws RemoteShellException;

    public abstract String runCmd(String var1, String[] var2, String[] var3, String var4);

    public abstract String runCmd(String var1, String[] var2, String[] var3, String[] var4, String var5);

    public abstract String runCmd(String var1, String[] var2, String[] var3, String[] var4, String var5, String var6, String var7);

    public abstract String getConfigLocation(Version var1);

    public abstract String getOLRConfigLocation(String var1, Version var2);

    public abstract Boolean getCSSConfigType(String var1, Version var2) throws NativeException;

    public abstract HashMap getOCRLocations(Version var1) throws NativeException;

    public abstract int checkOCRStorageType(String var1) throws NativeException;

    public abstract boolean isCRSConfigured(Version var1) throws NativeException;

    public abstract boolean isCRSConfigured(String var1, Version var2) throws NativeException;

    public abstract boolean isHAConfigured(Version var1) throws NativeException;

    public abstract boolean isHAConfigured(String var1, Version var2) throws NativeException;

    public String getCRSHome(Version version) throws NativeException {
        if (Utils.isDevelopmentEnv()) {
            String chome = System.getenv("ORA_CRS_HOME");
            Trace.out("crshome in Dev environment is " + chome);
            if (chome != null && chome.length() > 0) {
                return chome;
            }
        }
        return this.getCRSHome("localnode", version);
    }

    public abstract String getCRSHome(String var1, Version var2) throws NativeException;

    public boolean isLocalOnly(String node, Version version) throws NativeException {
        Boolean configType = this.getCSSConfigType(node, version);
        return configType == null ? true : configType;
    }

    protected static String rununixcmd(String unixcmd) {
        return NativeSystem.rununixcmd(unixcmd, null, null);
    }

    protected static String rununixcmd(String nodeName, String unixcmd) {
        return NativeSystem.rununixcmd(nodeName, unixcmd, null, null);
    }

    protected static String rununixcmd(String unixcmd, String[] environ) {
        String[] cmdArr = NativeSystem.getCmdArr(unixcmd);
        return NativeSystem.rununixcmd(cmdArr, environ, null);
    }

    protected static String rununixcmd(String unixcmd, String[] environ, String[] stdin) {
        return NativeSystem.rununixcmd(null, unixcmd, environ, stdin);
    }

    protected static String rununixcmd(String nodeName, String unixcmd, String[] environ, String[] stdin) {
        String[] cmdArr = NativeSystem.getCmdArr(unixcmd);
        return NativeSystem.rununixcmd(nodeName, cmdArr, environ, stdin);
    }

    protected static String rununixcmd(String[] cmds, String[] environ, String[] stdin) {
        return NativeSystem.rununixcmd(null, cmds, environ, stdin);
    }

    protected static String rununixcmd(String nodeName, String[] cmds, String[] environ, String[] stdin) {
        int i;
        StringBuffer retStringBuffer = new StringBuffer();
        RuntimeExec rt = new RuntimeExec(nodeName, cmds, stdin, environ);
        int retValue = rt.runCommand();
        String[] out = rt.getOutput();
        String[] err = rt.getError();
        if (retValue == 0 && !NativeSystem.isCmdScv(cmds) && err != null && err.length != 0) {
            retValue = 1;
        }
        if (retValue == 0) {
            retStringBuffer.append("1|");
        } else {
            retStringBuffer.append("0|");
        }
        if (out != null) {
            for (i = 0; i < out.length; ++i) {
                retStringBuffer.append(out[i]);
            }
        }
        if (err != null) {
            for (i = 0; i < err.length; ++i) {
                retStringBuffer.append(err[i]);
            }
        }
        if (retValue == 0) {
            retStringBuffer.append(" :successful");
        } else {
            retStringBuffer.append(" :failed");
        }
        Trace.out("NativeSystem.rununixcmd: RetString " + retStringBuffer.toString());
        return retStringBuffer.toString();
    }

    public static final String[] getCmdArr(String cmdStr) {
        StringTokenizer st = new StringTokenizer(cmdStr);
        String[] cmdArr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArr[i] = st.nextToken();
            ++i;
        }
        return cmdArr;
    }

    public NativeResult createRemoteExecDir(String node, String dir, String group) {
        String retStr = this.createDir(node, dir);
        return new NativeResult(retStr);
    }

    public abstract boolean isRemoteExecServerNeeded();

    public abstract void startRemoteExecServer(String var1, String var2) throws NativeException;

    public abstract void startRemoteExecServer(String var1, String var2, String var3) throws NativeException;

    public abstract void startRemoteExecServer(String[] var1, String var2) throws NativeException;

    public abstract void startRemoteExecServer(String var1, String[] var2, String var3) throws NativeException;

    public abstract String[] getRemoteExecServerFiles();

    public abstract String[] getMSVCRTFullPath(String[] var1) throws NativeException;

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, String[] var4, String var5, NativeResult var6, boolean var7);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, String[] var4, NativeResult var5, boolean var6);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, String var4, NativeResult var5, boolean var6);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, NativeResult var4, boolean var5);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, NativeResult var4, boolean var5, boolean var6);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, String var4, NativeResult var5);

    public abstract void runRemoteExecCmd(String var1, String[] var2, String[] var3, NativeResult var4);

    public abstract void transferDirToNode(String var1, String var2, String var3, NativeResult var4);

    public abstract void transferListedDirsToNode(String var1, String var2, String var3, String var4, NativeResult var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCommandsToFile(String scriptFileName, String[] scriptLines, NativeResult result) {
        Trace.out("Writing commands into file: " + scriptFileName);
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(scriptFileName));
            for (int i = 0; i < scriptLines.length; ++i) {
                out.println(scriptLines[i]);
            }
            result.setStatus(true);
        }
    }

    public abstract void transferListedFilesToNode(String var1, String var2, String var3, NativeResult var4);

    public abstract void transferFileToNode(String var1, String var2, String var3, NativeResult var4);

    public abstract void createListedDirsOnNode(String var1, String var2, NativeResult var3);

    public abstract void removeListedDirsFromNode(String var1, String var2, NativeResult var3);

    public abstract void setACLs(String var1, String var2, boolean var3, NativeResult var4);

    public abstract void updateEnv(String var1, NativeResult var2);

    public abstract void registerOCX(String var1, String var2, boolean var3, String var4, NativeResult var5);

    public abstract void resolvePath(String var1, String var2, String var3, NativeResult var4);

    public abstract void rebootNode(String var1, NativeResult var2);

    public abstract String getLocalCSSHome(String var1, Version var2) throws NativeException;

    public abstract boolean checkCSSStatus(String var1, String var2, Version var3, NativeResult var4);

    public abstract void listDirectory(String var1, String var2, NativeResult var3);

    public abstract void getLibraryVersion(String var1, NativeResult var2);

    public abstract String getOFSUtilLocation();

    String getUniqueFilePath(String dirPath, String prefix) {
        String tempFile;
        try {
            File file = File.createTempFile(prefix + String.valueOf(System.currentTimeMillis()), null, new File(dirPath));
            tempFile = file.getAbsolutePath();
            file.delete();
        }
        catch (IOException e) {
            tempFile = dirPath + FILE_SEPARATOR + prefix + String.valueOf(System.currentTimeMillis());
        }
        return tempFile;
    }

    public abstract boolean isPathACFS(String var1) throws NativeException;

    public abstract boolean isACLSupported(String var1) throws NativeException;

    public abstract boolean isACLSet(String var1) throws NativeException;

    public boolean isPathOnASM(String path) {
        return path.indexOf("+") == 0;
    }

    public void getWinDomainName(String srcLoc, String destLoc, NativeResult result) {
        Object[] args = new String[]{"getWinDomainName", DeterminePlatform.getOSName()};
        NativeException ne = new NativeException("1012", args);
        result.setStatus(false);
        result.setOSString(ne.getMessage());
        result.setException(ne);
    }

    public List<String> checkSharedFileSystemPath(String pathName, String[] nodeList, String localNode, NativeResult result) throws SharedDeviceException, InvalidNodeListException {
        if (null == result) {
            result = new NativeResult();
        }
        ArrayList<String> pathSharedNodes = new ArrayList<String>();
        Object[] args = new String[]{"checkSharedFileSystemPath", DeterminePlatform.getOSName()};
        NativeException ne = new NativeException("1012", args);
        result.setStatus(false);
        result.setOSString(ne.getMessage());
        result.setException(ne);
        return pathSharedNodes;
    }

    public char[] readFromConsole(boolean echo, String prompt) throws NativeException {
        if (!this.isLibraryLoaded()) {
            this.loadSRVMNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        char[] userInput = Native.readFromConsole(echo, prompt, nativeResult);
        if (nativeResult.getStatus()) {
            return userInput;
        }
        throw new NativeException(nativeResult.getOSString());
    }

    public int getMgmtDBSpace(int numOfNodes, int seedDBSize, boolean flexCluster) throws NativeException {
        if (!this.isCredLibraryLoaded()) {
            this.loadSRVMCREDNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        int size = Native.getMgmtDBSpace(numOfNodes, seedDBSize, flexCluster, nativeResult);
        if (nativeResult.getStatus()) {
            return size;
        }
        throw new NativeException("1028");
    }

    public int getGIMRDiskSpace(int numOfHubNodes, int numOfLeafNodes, int seedDBSize, boolean isDSC, int noOfPDBs, EnumSet<DiskSpaceFlags> diskSpaceFlagEnumSet) throws NativeException {
        if (!this.isCredLibraryLoaded()) {
            this.loadSRVMCREDNativeLibrary();
        }
        NativeResult nativeResult = new NativeResult();
        int size = Native.getGIMRDiskSpace(numOfHubNodes, numOfLeafNodes, seedDBSize, isDSC, noOfPDBs, diskSpaceFlagEnumSet, nativeResult);
        if (nativeResult.getStatus()) {
            return size;
        }
        throw new NativeException(new String[]{nativeResult.getOSString()});
    }

    public boolean isRemExecServiceRunning(String node, NativeResult nativeResult) throws NativeException {
        nativeResult.setStatus(true);
        nativeResult.setOSString((String)null);
        nativeResult.setException(null);
        nativeResult.setBooleanResult(true);
        nativeResult.setOSErrCode(0);
        return true;
    }
}

