/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.nativesystem;

import java.util.StringTokenizer;
import oracle.ops.mgmt.trace.Trace;

public class NativeResult {
    protected boolean m_status = false;
    protected int m_OSErrCode = 0;
    protected int m_OPSMErrCode = 0;
    protected boolean m_nativeDebugFlag = false;
    protected String m_logFileName = null;
    protected String[] m_OSString = null;
    protected Exception m_exception = null;
    protected String m_nativeResultString = null;
    protected String[] m_resultString = null;
    protected String[] m_outputString = null;
    protected String m_skgxnErrorString = null;
    protected String m_nodeName = null;
    protected String m_nativeStringResult = null;
    protected byte[] m_byteResult = null;
    protected boolean m_nativeBooleanResult = false;

    public NativeResult() {
        this.m_nativeDebugFlag = Trace.isNativeDebug();
        this.m_logFileName = Trace.getTraceFile();
    }

    public NativeResult(String s) {
        int j = 0;
        this.m_nativeResultString = s;
        Trace.out("NativeResult: The String obtained is" + s);
        StringTokenizer st = new StringTokenizer(s, "|");
        if (st.countTokens() - 1 > 0) {
            this.m_resultString = new String[st.countTokens() - 1];
        }
        if (st.hasMoreTokens()) {
            String statusString = st.nextToken();
            Trace.out("The status string is: " + statusString);
            int stat = Integer.parseInt(statusString, 10);
            this.m_status = stat == 1;
        }
        while (st.hasMoreTokens()) {
            if (this.m_resultString == null) continue;
            this.m_resultString[j++] = new String(st.nextToken());
        }
        if (this.m_resultString != null) {
            Trace.out("The result string is: " + this.m_resultString[0] + " " + this.m_resultString.length);
        }
    }

    public boolean getStatus() {
        return this.m_status;
    }

    public int getOSErrCode() {
        return this.m_OSErrCode;
    }

    public int getOPSMErrCode() {
        return this.m_OPSMErrCode;
    }

    public boolean getNativeDebugFlag() {
        return this.m_nativeDebugFlag;
    }

    public boolean getNativeFileDebugFlag() {
        return this.m_nativeDebugFlag;
    }

    public String getLogFileName() {
        return this.m_logFileName;
    }

    public String getOSString() {
        if (this.m_OSString != null) {
            StringBuffer buffer = new StringBuffer();
            String lineSeparator = System.getProperty("line.separator");
            for (int i = 0; i < this.m_OSString.length; ++i) {
                if (i > 0) {
                    buffer.append(lineSeparator + this.m_OSString[i]);
                    continue;
                }
                buffer.append(this.m_OSString[i]);
            }
            return buffer.toString();
        }
        return null;
    }

    public String[] getOSStrings() {
        return this.m_OSString;
    }

    public String getSKGXNErrorString() {
        return this.m_skgxnErrorString;
    }

    public String getNodeName() {
        return this.m_nodeName;
    }

    public byte[] getByteResult() {
        return this.m_byteResult;
    }

    public void setStatus(boolean status) {
        this.m_status = status;
    }

    public void setOSErrCode(int OSErrCode) {
        this.m_OSErrCode = OSErrCode;
    }

    public void setOPSMErrCode(int OPSMErrCode) {
        this.m_OPSMErrCode = OPSMErrCode;
    }

    public void setNativeDebugFlag(boolean nativeDebugFlag) {
        this.m_nativeDebugFlag = nativeDebugFlag;
    }

    public void setOSString(String OSString) {
        if (OSString != null) {
            this.m_OSString = new String[1];
            this.m_OSString[0] = OSString;
        } else {
            this.m_OSString = null;
        }
    }

    public void setOSString(String[] OSString) {
        if (OSString != null) {
            this.m_OSString = new String[OSString.length];
            for (int i = 0; i < OSString.length; ++i) {
                this.m_OSString[i] = OSString[i];
            }
        }
    }

    public Exception getException() {
        return this.m_exception;
    }

    public void setException(Exception e) {
        this.m_exception = e;
    }

    public String[] getResultString() {
        return this.m_resultString;
    }

    public void setResultString(String[] resultString) {
        this.m_resultString = resultString;
    }

    public String[] getOutputString() {
        return this.m_outputString;
    }

    public void setOutputString(String[] outputString) {
        this.m_outputString = outputString;
    }

    public String getNativeResultString() {
        return this.m_nativeResultString;
    }

    private String chop(String str) {
        String retStr = str;
        char lastCh = str.charAt(str.length() - 1);
        while (lastCh == '\r' || lastCh == '\n') {
            retStr = retStr.substring(0, retStr.length() - 1);
            lastCh = retStr.charAt(retStr.length() - 1);
        }
        return retStr;
    }

    public void setSKGXNErrorString(String errString) {
        this.m_skgxnErrorString = errString;
    }

    public void setNodeName(String nodeName) {
        this.m_nodeName = nodeName;
    }

    public void setLogFileName(String logFileName) {
        this.m_nativeDebugFlag = true;
        this.m_logFileName = logFileName;
    }

    public void setBooleanResult(boolean result) {
        this.m_nativeBooleanResult = result;
    }

    public boolean getBooleanResult() {
        return this.m_nativeBooleanResult;
    }

    public void setStringResult(String result) {
        this.m_nativeStringResult = result;
    }

    public String getStringResult() {
        return this.m_nativeStringResult;
    }

    public void setByteResult(byte[] array) {
        this.m_byteResult = array;
    }
}

