/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.monitor;

import java.util.Hashtable;
import oracle.ops.mgmt.monitor.Monitor;
import oracle.ops.mgmt.monitor.MonitorList;
import oracle.ops.mgmt.trace.Trace;

public class MonitorFactory
implements MonitorList {
    private Monitor[] m_monitor;
    private Hashtable m_monitorTable = new Hashtable();

    public MonitorFactory() {
        this.m_monitor = new Monitor[m_monitorList.length];
        for (int i = 0; i < m_monitorList.length; ++i) {
            try {
                Class<?> mc = Class.forName(m_monitorList[i][1]);
                this.m_monitor[i] = (Monitor)mc.newInstance();
                this.m_monitorTable.put(m_monitorList[i][0], this.m_monitor[i]);
                continue;
            }
            catch (ClassNotFoundException ce) {
                Trace.out(ce);
                continue;
            }
            catch (InstantiationException ie) {
                Trace.out(ie);
                continue;
            }
            catch (IllegalAccessException iae) {
                Trace.out(iae);
            }
        }
    }

    public void startMonitor(String monitorName) {
        Monitor m = (Monitor)this.m_monitorTable.get(monitorName);
        m.start();
    }
}

