/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.monitor;

import oracle.ops.mgmt.monitor.MonitoringThread;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

public abstract class Monitor {
    private Thread m_monitoringThread;
    private int m_pollInterval = 0;
    protected NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();

    public Monitor(int pollInterval, String monitorName) {
        this(monitorName);
        this.m_pollInterval = pollInterval;
    }

    public Monitor(String monitorName) {
        Trace.out("instantiating m_nativeSystem" + this.m_nativeSystem);
        this.initialize(monitorName);
    }

    private void initialize(String monitorName) {
        this.m_monitoringThread = new Thread((Runnable)new MonitoringThread(this), monitorName);
    }

    public void start() {
        this.m_monitoringThread.start();
    }

    public void restart() {
    }

    public void stop() {
    }

    public abstract void response();

    public void waitInterval() {
        try {
            Thread.currentThread();
            Thread.sleep(this.m_pollInterval);
        }
        catch (Exception e) {
            Trace.out("Caught Interrupted Exception while sleeping");
        }
    }

    public abstract boolean check();
}

