/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config.downgrade;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HAService {
    public static final int NOT_USED = 0;
    public static final int PREFERRED = 1;
    public static final int AVAILABLE = 2;
    public static final int NONE = 10;
    public static final int BASIC = 20;
    public static final int PRE = 30;
    public static final String s_NONE = "none";
    public static final String s_BASIC = "basic";
    public static final String s_PRE = "preconnect";
    private Hashtable m_instanceHAStatus;
    private String m_serviceName;
    private int m_TAF = 0;

    public HAService(String serviceName, String[] instances) {
        this.m_serviceName = serviceName;
        this.m_instanceHAStatus = new Hashtable(instances.length);
        this.m_TAF = 10;
        if (instances.length != 0) {
            for (int i = 0; i < instances.length; ++i) {
                this.m_instanceHAStatus.put(instances[i], Integer.toString(0));
            }
        }
    }

    public String toString() {
        return this.m_serviceName;
    }

    public String getName() {
        return this.m_serviceName;
    }

    public void setInstanceStatus(String instanceName, int status) {
        if (instanceName != null) {
            this.m_instanceHAStatus.put(instanceName, Integer.toString(status));
        }
    }

    public int getInstanceStatus(String instanceName) {
        if (this.m_instanceHAStatus.containsKey(instanceName)) {
            return Integer.parseInt((String)this.m_instanceHAStatus.get(instanceName));
        }
        return 0;
    }

    public void setTAF(int tafPolicy) {
        this.m_TAF = tafPolicy;
    }

    public void setTAF(String tafString) {
        this.m_TAF = tafString.equalsIgnoreCase(s_BASIC) ? 20 : (tafString.equalsIgnoreCase(s_PRE) ? 30 : 10);
    }

    public int getTAF() {
        return this.m_TAF;
    }

    public String getTAFString() {
        if (this.m_TAF == 20) {
            return s_BASIC;
        }
        if (this.m_TAF == 30) {
            return s_PRE;
        }
        return s_NONE;
    }

    public String[] getInstances() {
        String[] instances = new String[this.m_instanceHAStatus.size()];
        int i = 0;
        Enumeration e = this.m_instanceHAStatus.keys();
        while (e.hasMoreElements()) {
            instances[i] = (String)e.nextElement();
            ++i;
        }
        return instances;
    }

    public String[] getInstances(int type) {
        Object[] instances = this.getInstances();
        Vector<Object> instancesOfType = new Vector<Object>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            if (this.getInstanceStatus(instances[i]) != type) continue;
            instancesOfType.addElement(instances[i]);
        }
        instances = new String[instancesOfType.size()];
        instancesOfType.copyInto(instances);
        return instances;
    }
}

