/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config.downgrade;

import oracle.ops.mgmt.database.config.downgrade.HAService;
import oracle.ops.mgmt.nodeapps.VIPAddress;

public class HADatabase {
    private String m_oldOracleHome;
    private String m_newOracleHome;
    private String m_dbName;
    private String m_dbDomain;
    private VIPAddress m_cluaAddr;
    private String m_spfile;
    private String m_userName;
    private String m_userPasswd;
    private String[] m_instances;
    private String[] m_nodes;
    private HAService[] m_haServices;

    public HADatabase(String dbName) {
        this(dbName, null);
    }

    public HADatabase(String dbName, String dbDomain) {
        this.m_dbName = dbName;
        this.m_dbDomain = dbDomain;
    }

    public String toString() {
        return this.getGDBName();
    }

    public String getOldOracleHome() {
        return this.m_oldOracleHome;
    }

    public void setOldOracleHome(String oracleHome) {
        this.m_oldOracleHome = oracleHome;
    }

    public String getNewOracleHome() {
        return this.m_newOracleHome;
    }

    public void setNewOracleHome(String oracleHome) {
        this.m_newOracleHome = oracleHome;
    }

    public String getDBName() {
        return this.m_dbName;
    }

    public String getDBDomain() {
        return this.m_dbDomain;
    }

    public String getGDBName() {
        String gdbName = this.m_dbName;
        if (this.m_dbDomain != null && this.m_dbDomain.length() != 0) {
            gdbName = gdbName + "." + this.m_dbDomain;
        }
        return gdbName;
    }

    public void setVIPAddress(VIPAddress cluaAddr) {
        this.m_cluaAddr = cluaAddr;
    }

    public VIPAddress getVIPAddress() {
        return this.m_cluaAddr;
    }

    public String getDBClua() {
        return this.m_cluaAddr.getAddressAsString();
    }

    public void setSPFile(String spfile) {
        this.m_spfile = spfile;
    }

    public String getSPFile() {
        return this.m_spfile;
    }

    public void setCredentials(String userName, String userPasswd) {
        this.m_userName = userName;
        this.m_userPasswd = userPasswd;
    }

    public void setInstances(String[] instances) {
        if (instances != null) {
            this.m_instances = new String[instances.length];
            for (int i = 0; i < instances.length; ++i) {
                this.m_instances[i] = instances[i];
            }
        } else {
            this.m_instances = new String[0];
        }
    }

    public void setNodes(String[] nodes) {
        if (nodes != null) {
            this.m_nodes = new String[nodes.length];
            for (int i = 0; i < nodes.length; ++i) {
                this.m_nodes[i] = nodes[i];
            }
        } else {
            this.m_nodes = new String[0];
        }
    }

    public String[] getInstances() {
        return this.m_instances;
    }

    public String[] getNodes() {
        return this.m_nodes;
    }

    public void setHAServices(HAService[] haServices) {
        if (haServices == null) {
            this.m_haServices = new HAService[0];
            return;
        }
        this.m_haServices = new HAService[haServices.length];
        for (int i = 0; i < haServices.length; ++i) {
            this.m_haServices[i] = haServices[i];
        }
    }

    public HAService[] getHAServices() {
        return this.m_haServices;
    }

    public String[] getServiceNames() {
        if (this.m_haServices == null) {
            return new String[0];
        }
        String[] services = new String[this.m_haServices.length];
        for (int i = 0; i < this.m_haServices.length; ++i) {
            services[i] = this.m_haServices[i].getName();
        }
        return services;
    }
}

