/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config.downgrade;

import java.util.Vector;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.Service;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.database.config.DatabaseConfigConverter;
import oracle.ops.mgmt.database.config.downgrade.DowngradeException;
import oracle.ops.mgmt.database.config.downgrade.HADatabase;
import oracle.ops.mgmt.database.config.downgrade.HAService;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.CmdLineParser;
import oracle.ops.util.MissingArgumentException;
import oracle.ops.util.ParamMissingArgumentException;
import oracle.ops.util.UnexpectedArgumentException;

public class DowngradeDBConfig {
    public static final String[] PARAMS = new String[]{"orahome"};
    public static final String[] OPTIONAL = new String[]{"dbname", "version"};
    private Vector m_haDatabases = null;
    private String m_dbName = null;
    private String m_dbDomain = null;
    private String m_newOracleHome = null;
    private String m_oldOracleHome = null;
    private Version m_version = null;
    private static MessageBundle s_msgBundle;
    private static MessageBundle a_msgBundle;

    public DowngradeDBConfig() {
        s_msgBundle = MessageBundle.getMessageBundle("Prkp");
        a_msgBundle = MessageBundle.getMessageBundle("Prkr");
    }

    public void processCmdArgs(String[] args) throws DowngradeException {
        Trace.out("Processing command line arguments passed");
        CmdLineParser cmdParser = new CmdLineParser("-", DatabaseConfigConverter.FLAGS, PARAMS, OPTIONAL);
        try {
            cmdParser.parse(args);
        }
        catch (MissingArgumentException mae) {
            throw new DowngradeException(mae.getMessage());
        }
        catch (ParamMissingArgumentException pmae) {
            throw new DowngradeException(pmae.getMessage());
        }
        catch (UnexpectedArgumentException uae) {
            throw new DowngradeException(uae.getMessage());
        }
        String dbName = cmdParser.getParam("dbname");
        if (dbName != null) {
            int dot = dbName.indexOf(".");
            if (dot > 0) {
                this.m_dbName = dbName.substring(0, dot);
                this.m_dbDomain = dbName.substring(dot + 1);
            } else {
                this.m_dbName = dbName;
                this.m_dbDomain = null;
            }
        }
        this.m_newOracleHome = cmdParser.getParam("orahome");
        String version = cmdParser.getParam("version");
        if (version == null || version.startsWith("10.")) {
            Trace.out("obtained version as 10.");
            this.m_version = Version.get101Version();
        } else if (version.startsWith("9.2")) {
            Trace.out("obtained version as 9.2");
            this.m_version = Version.get92Version();
        } else {
            Trace.out("unsupported version");
            throw new DowngradeException("invalid value entered for param version. Acceptable values are 9.2 or 10.1");
        }
    }

    public boolean downgradeDBConfig() throws DowngradeException {
        Trace.out("Downgrading the database configuration...");
        try {
            Trace.out("Getting the list of HA databases from the repository");
            String[] databases = Cluster.listParallelServers();
            if (databases == null || databases.length == 0) {
                Trace.out("No HA database repository inside OCR for downgrade");
                return true;
            }
            this.m_haDatabases = new Vector(databases.length);
            String dbName = null;
            String dbDomain = null;
            for (int i = 0; i < databases.length; ++i) {
                Trace.out("Downgrading OCR repository config for database:" + databases[i]);
                dbName = databases[i];
                int index = databases[i].indexOf(".");
                if (index > 0) {
                    dbName = databases[i].substring(0, index);
                    dbDomain = databases[i].substring(index + 1);
                }
                Trace.out("dbName = " + dbName);
                Trace.out("dbDomain = " + dbDomain);
                if (Cluster.isParallelServerConfigured(dbName, dbDomain)) {
                    Trace.out("Downgrading database: " + databases[i]);
                    this.downgradeDatabaseConfig(databases[i]);
                    continue;
                }
                Trace.out(databases[i] + " is not in " + new Version() + " format");
            }
        }
        catch (ConfigurationException ce) {
            Trace.out(ce);
            throw new DowngradeException(ce.getMessage());
        }
        catch (DowngradeException de) {
            Trace.out(de);
            Trace.out("Cancelling downgrading of database configuration");
            this.doCancel();
            throw new DowngradeException(de.getMessage());
        }
        return true;
    }

    private void downgradeDatabaseConfig(String gdbName) throws DowngradeException {
        Trace.out("downgradeDatabaseConfig: database = " + gdbName);
        ParallelServer pServer = null;
        ParallelServerConfig pConfig = null;
        String dbName = gdbName;
        String dbDomain = null;
        int dot = gdbName.indexOf(".");
        if (dot > 0) {
            dbName = gdbName.substring(0, dot);
            dbDomain = gdbName.substring(dot + 1);
        }
        try {
            pServer = Cluster.getParallelServer(dbName, dbDomain);
        }
        catch (ConfigurationException ce) {
            throw new DowngradeException(ce.getMessage());
        }
        if (pServer == null) {
            Trace.out("Couldn't get an handle to database object");
            return;
        }
        try {
            pConfig = pServer.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new DowngradeException(ce.getMessage());
        }
        Trace.out("Getting database details....");
        HADatabase haDatabase = new HADatabase(dbName, pConfig.getDomain());
        haDatabase.setOldOracleHome(pConfig.getOracleHome());
        haDatabase.setNewOracleHome(this.m_newOracleHome);
        haDatabase.setVIPAddress(pConfig.getVIPAddress());
        haDatabase.setSPFile(pConfig.getSPFile());
        haDatabase.setInstances(pConfig.enumerateInstances());
        haDatabase.setNodes(pConfig.enumerateNodes());
        try {
            haDatabase.setHAServices(DowngradeDBConfig.retrieveDatabaseServices(pServer, pConfig));
        }
        catch (ConfigurationException ce) {
            throw new DowngradeException(ce.getMessage());
        }
        catch (ServiceException se) {
            throw new DowngradeException(se.getMessage());
        }
        Trace.out("Downgrading database OCR configuration");
        gdbName = haDatabase.getGDBName();
        dbDomain = haDatabase.getDBDomain();
        String oracleHome = haDatabase.getNewOracleHome();
        String spFile = haDatabase.getSPFile();
        String[] instances = haDatabase.getInstances();
        String[] nodes = haDatabase.getNodes();
        Trace.out("Deleting HA services of database");
        DowngradeDBConfig.deleteHAServices(pServer, pConfig);
        Trace.out("Done deleteing HA Services");
        try {
            Trace.out("Removing HA configuration of database:" + gdbName);
            pServer.remove();
        }
        catch (DatabaseException e) {
            Trace.out("Failed to delete the RACHA database: " + gdbName);
            throw new DowngradeException(e.getMessage());
        }
        if (!Cluster.isParallelServerConfigured(dbName, dbDomain)) {
            Trace.out("Done deleting of " + gdbName + " from OCR.");
        } else {
            Trace.out("Database configuration deletion failed");
        }
        Trace.out("SP File name = " + spFile);
        Version toVer = this.m_version;
        try {
            pServer = Cluster.createParallelServer(dbName, dbDomain, oracleHome, spFile, null, toVer);
        }
        catch (ConfigurationException e) {
            Trace.out("Failed to create the " + this.m_version + " database: " + gdbName);
            throw new DowngradeException(e.getMessage());
        }
        try {
            for (int i = 0; i < instances.length; ++i) {
                Trace.out("Adding instance: " + instances[i] + " running on node: " + nodes[i] + " to OCR");
                pServer.createInstance(instances[i], nodes[i]);
            }
        }
        catch (InstanceException e) {
            Trace.out("Failed to add instances to the database:" + gdbName);
            throw new DowngradeException(e.getMessage());
        }
        if (Version.get101Version().equals(toVer)) {
            DowngradeDBConfig.createHAServices(pServer, haDatabase);
        }
        if (!Cluster.isParallelServerConfigured(dbName, dbDomain, toVer)) {
            Trace.out("Done creation of " + gdbName + " in OCR.");
        } else {
            Trace.out("Database configuration creation failed");
        }
        this.m_haDatabases.addElement(haDatabase);
    }

    public static HAService[] retrieveDatabaseServices(ParallelServer pServer, ParallelServerConfig pConfig) throws ConfigurationException, ServiceException {
        Trace.out("Retrieving the services configured for the database");
        String[] services = pConfig.enumerateServices();
        if (services == null || services.length == 0) {
            return null;
        }
        HAService[] haServices = new HAService[services.length];
        for (int i = 0; i < services.length; ++i) {
            Service service = new Service(services[i], pServer);
            String[] serviceInstances = service.getInstances();
            haServices[i] = new HAService(services[i], serviceInstances);
            haServices[i].setTAF(service.getTAFPolicy());
            String[] prefInstances = service.getPreferred();
            for (int j = 0; j < prefInstances.length; ++j) {
                haServices[i].setInstanceStatus(prefInstances[j], 1);
            }
            String[] availInstances = service.getAvailable();
            if (availInstances == null) continue;
            for (int j = 0; j < availInstances.length; ++j) {
                haServices[i].setInstanceStatus(availInstances[j], 2);
            }
        }
        return haServices;
    }

    public static boolean createHAServices(ParallelServer pServer, HADatabase haDatabase) {
        Trace.out("Creating HA services for the database");
        String dbName = haDatabase.getDBName();
        String dbDomain = haDatabase.getDBDomain();
        String gdbName = haDatabase.getGDBName();
        HAService[] haServices = haDatabase.getHAServices();
        if (haServices == null || haServices.length == 0) {
            Trace.out("Database:" + gdbName + " has no HA services to configure");
            return true;
        }
        Vector<String> failedServices = new Vector<String>(haServices.length);
        for (int i = 0; i < haServices.length; ++i) {
            Trace.out("Configuring HA service: " + haServices[i]);
            try {
                Service service = new Service(haServices[i].getName(), pServer);
                service.create(haServices[i].getInstances(1), haServices[i].getInstances(2), haServices[i].getTAFString());
                continue;
            }
            catch (ServiceException se) {
                failedServices.addElement(se.getMessage());
                Trace.out("Failed to configure service: " + haServices[i].getName());
                Trace.out(se);
            }
        }
        if (failedServices.size() != 0) {
            Trace.out(failedServices.toString());
        }
        return true;
    }

    public static boolean deleteHAServices(ParallelServer pServer, ParallelServerConfig pConfig) throws DowngradeException {
        Trace.out("Deleting HA services from the OCR");
        String[] serviceNames = pConfig.enumerateServices();
        if (serviceNames == null || serviceNames.length == 0) {
            Trace.out("Database: " + pConfig.getDBName() + " has no HA services configured to remove");
            return true;
        }
        Service service = null;
        try {
            for (int i = 0; i < serviceNames.length; ++i) {
                service = new Service(serviceNames[i], pServer);
                Trace.out("Trying to stop the service: " + serviceNames[i]);
                try {
                    service.stop();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                Trace.out("Now trying to remove the service");
                service.remove();
            }
        }
        catch (ServiceException se) {
            Trace.out(se);
            throw new DowngradeException(se.getMessage());
        }
        return true;
    }

    private void doCancel() {
        Trace.out("Performing cancel operation");
        if (this.m_haDatabases.size() > 0) {
            Object[] haDatabases = new HADatabase[this.m_haDatabases.size()];
            this.m_haDatabases.copyInto(haDatabases);
            for (int i = 0; i < haDatabases.length; ++i) {
                this.cancelDowngrade((HADatabase)haDatabases[i]);
            }
        }
    }

    private void cancelDowngrade(HADatabase haDatabase) {
        String oracleHome = haDatabase.getOldOracleHome();
        String dbName = haDatabase.getDBName();
        String gdbName = haDatabase.getGDBName();
        String dbDomain = haDatabase.getDBDomain();
        String[] nodeNames = haDatabase.getNodes();
        String[] instanceNames = haDatabase.getInstances();
        Version configVersion = this.m_version;
        Trace.out("Deleting " + configVersion + " version of database repository from OCR");
        ParallelServer pServer = null;
        ParallelServerConfig pConfig = null;
        try {
            pServer = Cluster.getParallelServer(dbName, dbDomain, configVersion);
            pConfig = pServer.getConfiguration();
        }
        catch (ConfigurationException ce) {
            Trace.out("Failed to get parallelserver object for OCR");
            Trace.out(ce);
            return;
        }
        if (pServer != null) {
            try {
                if (Version.get101Version().equals(this.m_version)) {
                    DowngradeDBConfig.deleteHAServices(pServer, pConfig);
                }
            }
            catch (DowngradeException ex) {
                Trace.out("Failed to delete HA services");
                Trace.out(ex);
                return;
            }
            Trace.out("Deleting the database configuration");
            try {
                pServer.delete();
            }
            catch (ConfigurationException ce) {
                Trace.out("Failed to delete the database configuration");
                Trace.out(ce);
                return;
            }
        }
        String spfileName = haDatabase.getSPFile();
        Trace.out("SP File name = " + spfileName);
        VIPAddress dbCluAddr = haDatabase.getVIPAddress();
        Trace.out("dbCluAddr = " + dbCluAddr);
        configVersion = new Version();
        Trace.out("Creating database configuration of version:" + configVersion);
        try {
            pServer = Cluster.createParallelServer(dbName, dbDomain, oracleHome, spfileName, dbCluAddr, configVersion);
        }
        catch (ConfigurationException e) {
            Trace.out("Failed to create HA database: " + gdbName);
            Trace.out(e);
            return;
        }
        Trace.out("Adding instances to the database : " + gdbName);
        try {
            for (int i = 0; i < instanceNames.length; ++i) {
                Trace.out("Adding instance: " + instanceNames[i] + " running on node: " + nodeNames[i] + " to OCR");
                pServer.createInstance(instanceNames[i], nodeNames[i]);
            }
        }
        catch (InstanceException e) {
            Trace.out("Failed to add instances to the database:" + gdbName);
            Trace.out(e);
            return;
        }
        if (DowngradeDBConfig.createHAServices(pServer, haDatabase)) {
            Trace.out("Done creating HA services for the database");
        } else {
            Trace.out("Failed to create HA services for the database");
        }
    }

    public void downgradeMain() {
        Trace.out("Inside downgradeMain");
        Trace.out("Command line parsing - OK");
        Trace.out("Oracle home entered = " + this.m_newOracleHome);
        Trace.out("Database name entered = " + this.m_dbName);
        if (this.m_dbName != null) {
            String dbName = this.m_dbName;
            if (this.m_dbDomain != null) {
                dbName = dbName + "." + this.m_dbDomain;
            }
            this.m_haDatabases = new Vector(1);
            try {
                this.downgradeDatabaseConfig(dbName);
                Trace.out("database '" + dbName + "' is downgraded successfully");
            }
            catch (DowngradeException de) {
                Trace.out("failed to downgrade the database: " + dbName);
                Trace.out(de);
                this.doCancel();
            }
        } else {
            try {
                this.downgradeDBConfig();
                Trace.out("databases are downgraded successfully");
            }
            catch (DowngradeException e) {
                System.err.println(e.getMessage());
            }
        }
    }
}

