/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database.config;

import java.io.Serializable;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;

public class ServiceInstance
implements Serializable,
OCRKeyLiterals {
    static final long serialVersionUID = -6935848131293271932L;
    private String m_serviceName;
    private String m_instanceName;
    private String m_type;
    private boolean m_enabled;

    public ServiceInstance(String servName, String instance, String type, boolean enabled) {
        this.m_serviceName = servName;
        this.m_instanceName = instance;
        this.m_type = type;
        this.m_enabled = enabled;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public boolean isTypePreferred() {
        return this.m_type.compareTo("PREFERRED") == 0;
    }

    public boolean isTypeAvailable() {
        return this.m_type.compareTo("AVAILABLE") == 0;
    }

    public void enable() {
        this.m_enabled = true;
    }

    public void disable() {
        this.m_enabled = false;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean equals(Object obj) {
        ServiceInstance si = (ServiceInstance)obj;
        return this.getServiceName().equalsIgnoreCase(si.getServiceName()) && this.getInstanceName().equalsIgnoreCase(si.getInstanceName());
    }
}

