/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.config.ServiceInstance;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.rawdevice.OCRKeyLiterals;
import oracle.ops.mgmt.trace.Trace;

public class ServiceComposite
implements Serializable,
HALiterals,
OCRKeyLiterals {
    static final long serialVersionUID = -8082206716880180961L;
    private String m_name;
    private Vector m_instances;
    private String m_tafPolicy;
    private String[] m_env;
    private boolean m_enabled;
    private String m_dbName;
    private Hashtable m_serviceMemberTable = null;
    private Hashtable m_serviceAttractorTable = null;
    private String m_serviceCompositeResName = null;

    public ServiceComposite(String name, String[] prefInst, String[] availInst, String tafPolicy, String[] env, boolean enabled, String dbName) {
        this.m_name = name;
        this.m_tafPolicy = tafPolicy;
        this.m_env = env;
        this.m_enabled = enabled;
        this.m_dbName = dbName;
        this.fillServiceInstances(prefInst, availInst);
        this.m_serviceCompositeResName = "ora." + this.m_dbName + "." + this.m_name + ".cs";
    }

    public ServiceComposite(String name, ServiceInstance[] servInstances, String tafPolicy, String[] env, boolean enabled, String dbName) {
        this.m_name = name;
        this.m_instances = new Vector();
        for (int i = 0; i < servInstances.length; ++i) {
            this.m_instances.addElement(servInstances[i]);
        }
        this.m_tafPolicy = tafPolicy;
        this.m_env = env;
        this.m_enabled = enabled;
        this.m_dbName = dbName;
        this.m_serviceCompositeResName = "ora." + this.m_dbName + "." + this.m_name + ".cs";
    }

    private void fillServiceInstances(String[] prefInst, String[] availInst) {
        int i;
        this.m_instances = new Vector();
        Trace.out("length = " + prefInst.length);
        for (i = 0; i < prefInst.length; ++i) {
            this.m_instances.addElement(new ServiceInstance(this.m_name, prefInst[i], "PREFERRED", true));
        }
        if (availInst != null) {
            for (i = 0; i < availInst.length; ++i) {
                this.m_instances.addElement(new ServiceInstance(this.m_name, availInst[i], "AVAILABLE", true));
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getModifiedName() {
        int strLength = this.m_name.length();
        StringBuffer strBuf = new StringBuffer(strLength);
        for (int i = 0; i < strLength; ++i) {
            char c = this.m_name.charAt(i);
            if (c == '.') {
                strBuf.append('*');
                continue;
            }
            strBuf.append(c);
        }
        return strBuf.toString();
    }

    public String[] getAvailableInstances() {
        Vector<String> avVec = new Vector<String>(this.m_instances.size());
        for (int i = 0; i < this.m_instances.size(); ++i) {
            ServiceInstance si = (ServiceInstance)this.m_instances.elementAt(i);
            if (!si.isTypeAvailable()) continue;
            avVec.addElement(si.getInstanceName());
        }
        int numAvail = avVec.size();
        Trace.out("Number of available instances : " + numAvail);
        if (numAvail == 0) {
            return null;
        }
        Object[] retval = new String[numAvail];
        avVec.copyInto(retval);
        return retval;
    }

    void setAvailableInstances(String[] availInst) {
        int i;
        Vector newInstances = new Vector();
        int index = this.getPreferredInstances().length;
        for (i = 0; i < index; ++i) {
            newInstances.addElement(this.m_instances.elementAt(i));
        }
        if (availInst != null) {
            for (i = 0; i < availInst.length; ++i) {
                ServiceInstance si = this.getServiceInstance(availInst[i]);
                boolean existingFlag = si == null ? true : si.getEnabled();
                newInstances.addElement(new ServiceInstance(this.m_name, availInst[i], "AVAILABLE", existingFlag));
            }
        }
        this.m_instances = newInstances;
    }

    public Vector getServiceInstances() {
        return this.m_instances;
    }

    ServiceInstance getServiceInstance(String instName) {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            ServiceInstance si = (ServiceInstance)this.m_instances.elementAt(i);
            if (!si.getInstanceName().equalsIgnoreCase(instName)) continue;
            return si;
        }
        Trace.out("ServiceInstance is null");
        return null;
    }

    public void deleteAvailableInstance(String inst) {
        ServiceInstance si = this.getServiceInstance(inst);
        if (si != null && si.isTypeAvailable()) {
            this.m_instances.removeElement(si);
        }
    }

    public boolean isAvailable(String instName) {
        ServiceInstance si = this.getServiceInstance(instName);
        return si != null ? si.isTypeAvailable() : false;
    }

    public String[] getPreferredInstances() {
        Vector<String> prVec = new Vector<String>(this.m_instances.size());
        for (int i = 0; i < this.m_instances.size(); ++i) {
            ServiceInstance si = (ServiceInstance)this.m_instances.elementAt(i);
            if (!si.isTypePreferred()) continue;
            prVec.addElement(si.getInstanceName());
        }
        Object[] retval = new String[prVec.size()];
        prVec.copyInto(retval);
        return retval;
    }

    void setPreferredInstances(String[] prefInst) {
        int i;
        Vector<ServiceInstance> newInstances = new Vector<ServiceInstance>();
        int index = this.getPreferredInstances().length;
        for (i = 0; i < prefInst.length; ++i) {
            ServiceInstance si = this.getServiceInstance(prefInst[i]);
            boolean existingFlag = si == null ? true : si.getEnabled();
            newInstances.addElement(new ServiceInstance(this.m_name, prefInst[i], "PREFERRED", existingFlag));
        }
        for (i = index; i < this.m_instances.size(); ++i) {
            newInstances.addElement((ServiceInstance)this.m_instances.elementAt(i));
        }
        this.m_instances = newInstances;
    }

    public void deletePreferredInstance(String inst) {
        ServiceInstance si = this.getServiceInstance(inst);
        if (si != null && si.isTypePreferred()) {
            this.m_instances.removeElement(si);
        }
    }

    Hashtable getSMResourceNames() {
        String modServName = this.m_name;
        String[] prefInstNames = this.getPreferredInstances();
        Hashtable<String, String> serviceMemberTable = new Hashtable<String, String>(prefInstNames.length);
        for (int i = 0; i < prefInstNames.length; ++i) {
            String resourceName = "ora." + this.m_dbName + "." + modServName + "." + prefInstNames[i] + ".srv";
            Trace.out("inserting SM: " + prefInstNames[i].toLowerCase() + " -> " + resourceName);
            serviceMemberTable.put(prefInstNames[i].toLowerCase(), resourceName);
        }
        return serviceMemberTable;
    }

    Hashtable getSAResourceNames() {
        Hashtable<String, String> serviceAttractorTable;
        String[] availInstNames = this.getAvailableInstances();
        if (availInstNames != null) {
            String modServName = this.m_name;
            serviceAttractorTable = new Hashtable(availInstNames.length);
            try {
                HAStatusOperation statOp = new HAStatusOperation(new Version());
                LocalCommand lCommand = new LocalCommand(statOp);
                lCommand.execute();
                HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
                if (result.getStatus() == 0) {
                    String[] statOutput = result.getOutput();
                    Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
                    Pattern pattern = Pattern.compile("ora." + this.m_dbName + "." + modServName + "." + "*" + "." + ".sa");
                    for (int i = 0; i < stats.size(); ++i) {
                        String resourceName = ((HAResourceStatus)stats.elementAt(i)).getResourceName();
                        if (!pattern.matcher(resourceName).matches()) continue;
                        String[] resCompNames = resourceName.replace('.', ':').split(":");
                        String instName = resCompNames[resCompNames.length - 2];
                        Trace.out("inserting SA: " + instName + " -> " + resourceName);
                        serviceAttractorTable.put(instName, resourceName);
                    }
                    return serviceAttractorTable;
                }
            }
            catch (HAOperationException e) {
                Trace.out(e);
            }
            if (serviceAttractorTable.size() == 0) {
                for (int i = 0; i < availInstNames.length; ++i) {
                    String resourceName = "ora." + this.m_dbName + "." + modServName + "." + availInstNames[i] + ".sa";
                    Trace.out("inserting SA: " + availInstNames[i].toLowerCase() + " -> " + resourceName);
                    serviceAttractorTable.put(availInstNames[i].toLowerCase(), resourceName);
                }
            }
        } else {
            serviceAttractorTable = new Hashtable<String, String>(0);
        }
        return serviceAttractorTable;
    }

    String getSCResourceName() {
        return this.m_serviceCompositeResName;
    }

    public String[] getAllResourceNames() {
        Hashtable serviceMemberTable = this.getSMResourceNames();
        Vector<String> allVec = new Vector<String>(serviceMemberTable.size() + 1);
        allVec.addElement(this.m_serviceCompositeResName);
        Enumeration e = serviceMemberTable.elements();
        while (e.hasMoreElements()) {
            allVec.addElement((String)e.nextElement());
        }
        Object[] allArray = new String[allVec.size()];
        allVec.copyInto(allArray);
        return allArray;
    }

    public boolean isPreferred(String instName) {
        ServiceInstance si = this.getServiceInstance(instName);
        if (si == null) {
            Trace.out("ServiceInstance " + instName + " does not exist");
            return false;
        }
        return si.isTypePreferred();
    }

    public void enable(String instName) {
        ServiceInstance si = this.getServiceInstance(instName);
        if (si != null) {
            si.enable();
        }
    }

    public void disable(String instName) {
        ServiceInstance si = this.getServiceInstance(instName);
        if (si != null) {
            si.disable();
        }
    }

    public String getTAFPolicy() {
        return this.m_tafPolicy;
    }

    void setTAFPolicy(String taf) {
        this.m_tafPolicy = taf;
    }

    public String[] getEnv() {
        return this.m_env;
    }

    public void setEnv(String[] env) {
        this.m_env = env;
    }

    public void enable() {
        this.m_enabled = true;
    }

    public void disable() {
        this.m_enabled = false;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isEnabled(String instName) {
        ServiceInstance si = this.getServiceInstance(instName);
        return si != null ? si.getEnabled() : false;
    }

    public int numEnabled() {
        int count = 0;
        for (int i = 0; i < this.m_instances.size(); ++i) {
            if (!((ServiceInstance)this.m_instances.elementAt(i)).isEnabled()) continue;
            ++count;
        }
        return count;
    }

    protected void processResourceNames() {
    }
}

