/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.Credentials;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.HAResourceStateUnknownException;
import oracle.ops.mgmt.database.HAResourceStatus;
import oracle.ops.mgmt.database.Instance;
import oracle.ops.mgmt.database.InstanceException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.database.ServiceAlreadyRunningException;
import oracle.ops.mgmt.database.ServiceAlreadyStoppedException;
import oracle.ops.mgmt.database.ServiceComposite;
import oracle.ops.mgmt.database.ServiceException;
import oracle.ops.mgmt.database.ServiceStateUnknownException;
import oracle.ops.mgmt.database.config.ServiceInstance;
import oracle.ops.mgmt.has.ClusterLock;
import oracle.ops.mgmt.has.ClusterLockException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.operation.SetEnvOperation;
import oracle.ops.mgmt.operation.SetEnvResult;
import oracle.ops.mgmt.operation.UnsetEnvOperation;
import oracle.ops.mgmt.operation.UnsetEnvResult;
import oracle.ops.mgmt.operation.ha.HALiterals;
import oracle.ops.mgmt.operation.ha.HAOperation;
import oracle.ops.mgmt.operation.ha.HAOperationException;
import oracle.ops.mgmt.operation.ha.HAOperationImpl;
import oracle.ops.mgmt.operation.ha.HAOperationResult;
import oracle.ops.mgmt.operation.ha.HAProfileOperation;
import oracle.ops.mgmt.operation.ha.HARacgWrapOperation;
import oracle.ops.mgmt.operation.ha.HARegisterOperation;
import oracle.ops.mgmt.operation.ha.HARelocateOperation;
import oracle.ops.mgmt.operation.ha.HAStartOperation;
import oracle.ops.mgmt.operation.ha.HAStatusOperation;
import oracle.ops.mgmt.operation.ha.HAStopOperation;
import oracle.ops.mgmt.operation.ha.HAUnregisterOperation;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class Service
implements Constants,
HALiterals {
    private MessageBundle s_opsMsgBundle;
    private ParallelServer m_server = null;
    private ParallelServerConfig m_serverConfig = null;
    private String m_serviceName;
    private String m_resourcePrefix;
    private Version m_version;
    private OCRTree m_ocrTree = null;
    private static String s_newline = System.getProperty("line.separator");

    public Service(String serviceName, ParallelServer server) throws ServiceException {
        Trace.out("In Service constructor");
        try {
            this.m_serverConfig = server.getConfiguration();
        }
        catch (ConfigurationException ce) {
            throw new ServiceException(ce.getMessage());
        }
        this.initialize(serviceName, server, this.m_serverConfig);
    }

    public Service(String serviceName, ParallelServer server, ParallelServerConfig serverConfig) throws ServiceException {
        this.initialize(serviceName, server, serverConfig);
    }

    private void initialize(String serviceName, ParallelServer server, ParallelServerConfig serverConfig) throws ServiceException {
        Trace.out("In Service constructor");
        if (HAOperationImpl.getHasHome() == null) {
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1060", true));
        }
        this.s_opsMsgBundle = MessageBundle.getMessageBundle("Prkp");
        this.validateServiceName(serviceName, serverConfig);
        this.m_serviceName = serviceName;
        this.m_server = server;
        this.m_version = server.getVersion();
        this.m_serverConfig = serverConfig;
        this.m_resourcePrefix = "ora." + this.m_serverConfig.getName() + ".";
        try {
            this.m_ocrTree = OCRTree.init(this.m_version);
        }
        catch (OCRException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private void validateServiceName(String name, ParallelServerConfig serverConfig) throws ServiceException {
        char c;
        String serviceDomain;
        String serviceName;
        Object args = new Object[]{name};
        String errMessage = this.s_opsMsgBundle.getMessage("1070", true, (Object[])args);
        if (name == null) {
            throw new ServiceException(errMessage);
        }
        int dotIdx = name.indexOf(46);
        if (dotIdx != -1) {
            serviceName = name.substring(0, dotIdx);
            serviceDomain = name.substring(dotIdx);
        } else {
            serviceName = name;
            serviceDomain = "";
        }
        if (serviceName.length() == 0) {
            throw new ServiceException(errMessage + "\n" + serviceName);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < serviceName.length(); ++i) {
            c = serviceName.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                sb.append(c);
                continue;
            }
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            sb.append(c);
        }
        int pc = 32;
        for (int i = 0; i < serviceDomain.length(); ++i) {
            c = serviceDomain.charAt(i);
            if (c == '.' && (pc == 46 || i == serviceDomain.length() - 1)) {
                sb.append(c);
            } else if (!Character.isLetterOrDigit(c) && c != '_' && c != '$' && c != '#' && c != '.') {
                sb.append(c);
            }
            pc = c;
        }
        if (sb.length() > 0) {
            throw new ServiceException(errMessage + "\n" + sb.toString());
        }
        String dbName = serverConfig.getName();
        String dbDomain = serverConfig.getDomain();
        String dbSvc = dbName;
        if (dbDomain != null && dbDomain.trim().length() > 0) {
            dbSvc = dbSvc + '.' + dbDomain;
        }
        if ((args = name.equalsIgnoreCase(dbSvc) ? new String[]{dbSvc} : (serviceName.equalsIgnoreCase(dbName) ? new String[]{dbName} : null)) != null) {
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1085", true, (Object[])args));
        }
    }

    public void enable() throws ServiceException {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        if (sc.isEnabled()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1018", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        sc.enable();
        Vector sis = sc.getServiceInstances();
        for (int i = 0; i < sis.size(); ++i) {
            ServiceInstance si = (ServiceInstance)sis.elementAt(i);
            sc.enable(si.getInstanceName());
        }
        Trace.out("updating ocr");
        try {
            this.m_ocrTree.enableDisableDatabaseService(this.m_serverConfig, sc, true);
        }
        catch (OCRException ce) {
            throw new ServiceException(ce.getMessage());
        }
        String[] prefs = sc.getPreferredInstances();
        String[] avails = sc.getAvailableInstances();
        try {
            int i;
            for (i = 0; i < prefs.length; ++i) {
                if (!this.m_server.isRunning(prefs[i])) continue;
                Trace.out("starting orphan on " + prefs[i]);
                this.runRacgWrapOp(this.getStartOrphanOp(prefs[i]));
            }
            if (avails != null) {
                for (i = 0; i < avails.length; ++i) {
                    if (!this.m_server.isRunning(avails[i])) continue;
                    Trace.out("starting orphan on " + avails[i]);
                    this.runRacgWrapOp(this.getStartOrphanOp(avails[i]));
                }
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public void enable(String instanceName) throws ServiceException {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        if (!this.isPreferred(instanceName) && !this.isAvailable(instanceName)) {
            Object[] args = new Object[]{instanceName, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1038", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        if (sc.numEnabled() == 0) {
            Trace.out("enable the serv globally because this is the first member to enable");
            sc.enable();
        }
        sc.enable(instanceName);
        Trace.out("updating ocr");
        try {
            this.m_ocrTree.enableDisableDatabaseServiceInstance(this.m_serverConfig, sc, sc.getServiceInstance(instanceName), true);
        }
        catch (OCRException e) {
            throw new ServiceException(e.getMessage());
        }
        try {
            if (this.m_server.isRunning(instanceName)) {
                Trace.out("starting orphan on " + instanceName);
                this.runRacgWrapOp(this.getStartOrphanOp(instanceName));
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public void disable() throws ServiceException {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        if (!sc.isEnabled()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1021", true, args));
        }
        if (this.isRunning()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1024", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        sc.disable();
        Vector sis = sc.getServiceInstances();
        for (int i = 0; i < sis.size(); ++i) {
            ServiceInstance si = (ServiceInstance)sis.elementAt(i);
            sc.disable(si.getInstanceName());
        }
        Trace.out("updating ocr");
        try {
            this.m_ocrTree.enableDisableDatabaseService(this.m_serverConfig, sc, true);
        }
        catch (OCRException ce) {
            throw new ServiceException(ce.getMessage());
        }
        String[] prefs = sc.getPreferredInstances();
        for (int i = 0; i < prefs.length; ++i) {
            if (!this.isRunning(prefs[i])) continue;
            this.runRacgWrapOp(this.getFailEventSrvSaOp(prefs[i]));
        }
    }

    public void disable(String instanceName) throws ServiceException {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        if (!this.isPreferred(instanceName) && !this.isAvailable(instanceName)) {
            Object[] args = new Object[]{instanceName, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1038", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        sc.disable(instanceName);
        if (sc.numEnabled() == 0) {
            Trace.out("disable the serv globally because this is the last member to disable");
            sc.disable();
        }
        Trace.out("updating ocr");
        try {
            this.m_ocrTree.enableDisableDatabaseServiceInstance(this.m_serverConfig, sc, sc.getServiceInstance(instanceName), true);
        }
        catch (OCRException e) {
            throw new ServiceException(e.getMessage());
        }
        if (this.isRunning(instanceName)) {
            this.runRacgWrapOp(this.getFailEventSrvSaOp(instanceName));
        }
    }

    private HARacgWrapOperation getStartOrphanOp(String instanceName) {
        HARacgWrapOperation wrapOp = null;
        try {
            wrapOp = new HARacgWrapOperation("startorp", this.m_serverConfig.getName(), instanceName, this.m_serviceName, this.m_serverConfig.getOracleHome(), this.m_version);
        }
        catch (HAOperationException hoe) {
            Trace.out("ignoring failure in starting orphan: constructor");
            Trace.out(hoe);
        }
        return wrapOp;
    }

    private HARacgWrapOperation getFailEventSrvSaOp(String instanceName) {
        HARacgWrapOperation wrapOp = null;
        try {
            wrapOp = new HARacgWrapOperation("failsrvsa", this.m_serverConfig.getName(), instanceName, this.m_serviceName, this.m_serverConfig.getOracleHome(), this.m_version);
        }
        catch (HAOperationException hoe) {
            Trace.out("ignoring failure in failevent srv/sa: constructor");
            Trace.out(hoe);
        }
        return wrapOp;
    }

    private void runRacgWrapOp(HARacgWrapOperation wrapOp) {
        if (wrapOp == null) {
            Trace.out("null wrap op. but we do not care");
            return;
        }
        HAOperationResult result = (HAOperationResult)wrapOp.run();
        if (result.getStatus() != 0) {
            Trace.out("ignoring failure in racgwrap: operation failure");
        }
    }

    public boolean isRunning() throws ServiceException {
        boolean retVal;
        try {
            retVal = this.isRunningInternal(false);
        }
        catch (HAResourceStateUnknownException e) {
            retVal = false;
        }
        return retVal;
    }

    private boolean isRunningInternal(boolean checkTarget) throws ServiceException, HAResourceStateUnknownException {
        HAStatusOperation statOp;
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        String scResourceName = sc.getSCResourceName();
        try {
            statOp = new HAStatusOperation(scResourceName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{scResourceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1056", true, args) + s_newline + result.getOutputAll());
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        if (stats.size() != 1) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        HAResourceStatus stat = (HAResourceStatus)stats.elementAt(0);
        if (stat.isUnknown()) {
            Trace.out("service comp resource state unknown: " + this.m_serviceName);
            throw new HAResourceStateUnknownException();
        }
        if (checkTarget) {
            return stat.isOnline() || stat.isTargetOnline();
        }
        return stat.isOnline();
    }

    public boolean isRunning(String instName) throws ServiceException {
        boolean retVal;
        try {
            retVal = this.isRunningInternal(instName);
        }
        catch (HAResourceStateUnknownException e) {
            retVal = false;
        }
        return retVal;
    }

    private boolean isRunningInternal(String instName) throws ServiceException, HAResourceStateUnknownException {
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        String node = this.m_serverConfig.getNode(instName);
        Vector stats = this.getMemberResourcesOnNode(this.m_serviceName, node, false, true);
        return stats.size() != 0;
    }

    private void genSMProfile(String instName, ServiceComposite sc, boolean update) throws ServiceException {
        HAProfileOperation profileOp;
        int i;
        Trace.out("Creating profile for Service Member");
        String[] prefInst = sc.getPreferredInstances();
        String[] availInst = sc.getAvailableInstances();
        String resourceName = (String)sc.getSMResourceNames().get(instName.toLowerCase());
        Trace.out("resource name is " + resourceName);
        Vector instances = this.m_serverConfig.getInstances();
        if (instances.size() == 0) {
            Object[] args = new Object[]{this.m_serverConfig.getName()};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1026", true, args));
        }
        int numNodes = availInst == null ? 1 : prefInst.length + availInst.length;
        String[] hostingNodes = new String[numNodes];
        int count = 0;
        hostingNodes[count++] = this.m_serverConfig.getNode(instName);
        if (availInst != null) {
            for (i = 0; i < prefInst.length; ++i) {
                if (prefInst[i].equalsIgnoreCase(instName)) continue;
                hostingNodes[count] = this.m_serverConfig.getNode(prefInst[i]);
                ++count;
            }
            for (i = 0; i < availInst.length; ++i) {
                hostingNodes[count] = this.m_serverConfig.getNode(availInst[i]);
                ++count;
            }
        }
        for (i = 0; i < numNodes; ++i) {
            Trace.out("hostingNodes[" + i + "] = " + hostingNodes[i]);
        }
        try {
            profileOp = new HAProfileOperation(resourceName, this.m_serverConfig.getOracleHome(), "srv", hostingNodes, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        if (update) {
            profileOp.setProfileOption("-update -h");
        } else if (this.m_serverConfig.getManagementPolicy() != null) {
            profileOp.setManagementPolicy(this.m_serverConfig.getManagementPolicy());
        }
        LocalCommand localCommand = new LocalCommand(profileOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("HA Profile operation failed");
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1029", true, args) + s_newline + result.getOutputAll());
        }
    }

    private void genSCProfile(ServiceComposite sc, boolean update) throws ServiceException {
        HARegisterOperation registerOp;
        HAProfileOperation profileOp;
        int i;
        String[] prefInst = sc.getPreferredInstances();
        String[] availInst = sc.getAvailableInstances();
        String taf = sc.getTAFPolicy();
        String resourceName = sc.getSCResourceName();
        Vector instances = this.m_serverConfig.getInstances();
        if (instances.size() == 0) {
            Object[] args = new Object[]{this.m_serverConfig.getName()};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1026", true, args));
        }
        int numNodes = availInst == null ? prefInst.length : prefInst.length + availInst.length;
        String[] hostingNodes = new String[numNodes];
        int count = 0;
        for (i = 0; i < prefInst.length; ++i) {
            hostingNodes[count] = this.m_serverConfig.getNode(prefInst[i]);
            Trace.out("hostingNodes[" + count + "] = " + hostingNodes[count]);
            ++count;
        }
        if (availInst != null) {
            for (i = 0; i < availInst.length; ++i) {
                hostingNodes[count] = this.m_serverConfig.getNode(availInst[i]);
                Trace.out("hostingNodes[" + count + "] = " + hostingNodes[count]);
                ++count;
            }
        }
        try {
            profileOp = new HAProfileOperation(resourceName, this.m_serverConfig.getOracleHome(), "cs", hostingNodes, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        if (update) {
            profileOp.setProfileOption("-update -h");
        } else if (this.m_serverConfig.getManagementPolicy() != null) {
            profileOp.setManagementPolicy(this.m_serverConfig.getManagementPolicy());
        }
        profileOp.setTAFPolicy(taf);
        LocalCommand localCommand = new LocalCommand(profileOp);
        Trace.out("Creating profile for Service Composite");
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("HA Profile operation failed");
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1029", true, args) + s_newline + result.getOutputAll());
        }
        try {
            registerOp = new HARegisterOperation(resourceName, update, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        LocalCommand lCommand = new LocalCommand(registerOp);
        Trace.out("Registering Service Composite");
        lCommand.execute();
        result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("HA Register operation failed");
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1029", true, args) + s_newline + result.getOutputAll());
        }
    }

    private boolean checkUniqueNames(String[] stringArray) {
        ArrayList<String> list = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0 || list.contains(stringArray[i].toUpperCase())) {
                Trace.out("Duplicate entry found in instance list");
                return false;
            }
            list.add(stringArray[i].toUpperCase());
            Trace.out("Added entry " + stringArray[i] + " to instance list");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String[] preferredInstances, String[] availableInstances, String TAFpolicy) throws ServiceException {
        int maxservices;
        ClusterLock dbLock = null;
        if (this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1083", true, args));
        }
        if (preferredInstances == null || preferredInstances.length == 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1028", true, args));
        }
        boolean unique = false;
        unique = this.checkUniqueNames(preferredInstances);
        if (!unique) {
            String instanceNames = null;
            instanceNames = Utils.getString(preferredInstances, " ");
            Object[] args = new Object[]{instanceNames, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1038", true, args));
        }
        if (availableInstances != null && availableInstances.length != 0 && !(unique = this.checkUniqueNames(availableInstances))) {
            String instanceNames = Utils.getString(availableInstances, " ");
            Object[] args = new Object[]{instanceNames, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1038", true, args));
        }
        StringBuffer options = this.checkServiceOptions(preferredInstances, availableInstances);
        if (options.length() > 0) {
            Object[] args = new Object[]{options, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1087", true, args));
        }
        String dbDomain = this.m_serverConfig.getDomain();
        if (dbDomain != null && dbDomain.length() != 0) {
            String upDbDomain = dbDomain.toUpperCase();
            String upServName = this.m_serviceName.toUpperCase();
            if (upServName.endsWith(upDbDomain)) {
                Object[] args = new Object[]{this.m_serviceName, this.m_serverConfig.getName(), dbDomain};
                String msg = this.s_opsMsgBundle.getMessage("1072", true, args);
                throw new ServiceException(msg);
            }
        }
        try {
            Util util = new Util();
            util.checkOracleUser(this.m_serverConfig.getOracleHome());
            maxservices = util.getMaxServices();
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        int currentServices = this.m_serverConfig.getServices().size();
        String dbLockName = "SRVM." + this.m_serverConfig.getName();
        try {
            int i;
            if (currentServices < maxservices) {
                try {
                    HAStatusOperation statOp;
                    dbLock = new ClusterLock();
                    Trace.out("Acquiring exclusive CSS lock " + dbLockName);
                    dbLock.acquire(dbLockName);
                    try {
                        statOp = new HAStatusOperation(this.m_version);
                    }
                    catch (HAOperationException e) {
                        throw new ServiceException(e.getMessage());
                    }
                    LocalCommand lCommand = new LocalCommand(statOp);
                    lCommand.execute();
                    HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
                    if (result.getStatus() != 0) {
                        Trace.out("Stat operation failed");
                        throw new ServiceException(result.getOutputSingle() + s_newline + result.getError());
                    }
                    Vector stats = HAResourceStatus.parseHAStatusOutput(result.getOutput());
                    Pattern pattern = Pattern.compile(this.m_resourcePrefix + "*" + "." + "cs");
                    int curServCount = 0;
                    for (i = 0; i < stats.size(); ++i) {
                        String resourceName = ((HAResourceStatus)stats.elementAt(i)).getResourceName();
                        if (!pattern.matcher(resourceName).matches()) continue;
                        ++curServCount;
                    }
                    if (curServCount > currentServices) {
                        currentServices = curServCount;
                    }
                }
                catch (ClusterLockException e) {
                    throw new ServiceException(e.getMessage());
                }
            }
            if (currentServices >= maxservices) {
                Object[] args = new Object[]{this.m_serverConfig.getName(), String.valueOf(maxservices)};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1084", true, args));
            }
            String[] cpPrefInstances = this.getCasePreservingInstNames(preferredInstances);
            String[] cpAvailInstances = this.getCasePreservingInstNames(availableInstances);
            ServiceComposite sc = new ServiceComposite(this.m_serviceName, cpPrefInstances, cpAvailInstances, TAFpolicy, null, true, this.m_serverConfig.getName());
            Trace.out("Creating Service Composite");
            this.genSCProfile(sc, false);
            LocalCommand[] localCommands = new LocalCommand[sc.getSMResourceNames().size()];
            int count = 0;
            try {
                for (i = 0; i < preferredInstances.length; ++i) {
                    String resourceName = (String)sc.getSMResourceNames().get(preferredInstances[i].toLowerCase());
                    this.genSMProfile(preferredInstances[i], sc, false);
                    HARegisterOperation registerOp = new HARegisterOperation(resourceName, this.m_version);
                    localCommands[count++] = new LocalCommand(registerOp);
                }
            }
            catch (HAOperationException haoe) {
                throw new ServiceException(haoe.getMessage());
            }
            Trace.out("Registering SMs");
            Trace.out("Number of resources to register : " + localCommands.length);
            for (int i2 = 0; i2 < localCommands.length; ++i2) {
                HAOperation operation = (HAOperation)localCommands[i2].getOperation();
                String resName = operation.getResourceName();
                Trace.out("Registering resource " + resName);
                localCommands[i2].execute();
                HAOperationResult result = (HAOperationResult)localCommands[i2].getOperationResult();
                if (result.getStatus() == 0) continue;
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1029", true, args) + s_newline + result.getOutputAll());
            }
            Trace.out("Updating OCR for the service");
            try {
                this.m_ocrTree.setDatabaseService(this.m_serverConfig, sc, true);
                this.m_serverConfig.addService(sc);
            }
            catch (OCRException e) {
                throw new ServiceException(e.getMessage());
            }
        }
        finally {
            try {
                if (dbLock != null) {
                    Trace.out("Releasing exclusive CSS lock " + dbLockName);
                    dbLock.release(dbLockName);
                }
            }
            catch (ClusterLockException e) {
                throw new ServiceException(e.getMessage());
            }
        }
    }

    public void start(String startupOptions) throws ServiceAlreadyRunningException, ServiceException {
        this.start(startupOptions, this.m_server.m_credentials);
    }

    public void start(String startupOptions, Credentials credentials) throws ServiceAlreadyRunningException, ServiceException {
        boolean dbEnabled;
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        boolean runningAlready = false;
        try {
            runningAlready = this.isRunningInternal(false);
        }
        catch (HAResourceStateUnknownException e) {
            Trace.out("service comp resource state unknown. not started");
            try {
                this.stop();
            }
            catch (ServiceAlreadyStoppedException ex) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceStateUnknownException(ex.getMessage());
            }
            catch (ServiceException ex1) {
                throw ex1;
            }
        }
        if (runningAlready) {
            Trace.out("service is already running: " + this.m_serviceName);
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceAlreadyRunningException(this.s_opsMsgBundle.getMessage("1062", true, args));
        }
        try {
            dbEnabled = this.m_server.isEnabled();
        }
        catch (DatabaseException e) {
            throw new ServiceException(e.getMessage());
        }
        if (!dbEnabled) {
            Trace.out("database is disabled: " + this.m_serverConfig.getName());
            Object[] args = new Object[]{this.m_serviceName, this.m_serverConfig.getName()};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1079", true, args));
        }
        LocalCommand localCommand = null;
        String openMode = null;
        String pFileName = null;
        if (startupOptions != null) {
            StringTokenizer tokens = new StringTokenizer(startupOptions);
            StringBuffer buffer = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                String thisToken = tokens.nextToken();
                if (thisToken.toUpperCase().startsWith("PFILE=")) {
                    pFileName = thisToken.substring(6);
                    continue;
                }
                buffer.append(thisToken);
                buffer.append(" ");
            }
            if (buffer.length() > 0) {
                openMode = buffer.toString().trim();
            }
        }
        try {
            ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
            if (!sc.isEnabled()) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1032", true, args));
            }
            String resourceName = sc.getSCResourceName();
            HAStartOperation startOp = new HAStartOperation(resourceName, openMode, pFileName, credentials, this.m_version);
            localCommand = new LocalCommand(startOp);
            localCommand.execute();
            HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1030", true, args) + s_newline + result.getOutputAll());
            }
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
    }

    public void stop() throws ServiceAlreadyStoppedException, ServiceException {
        this.stop(this.m_server.m_credentials, false);
    }

    public void stop(Credentials credentials) throws ServiceAlreadyStoppedException, ServiceException {
        this.stop(credentials, false);
    }

    public void stop(Credentials credentials, boolean disconnect) throws ServiceAlreadyStoppedException, ServiceException {
        this.stop(credentials, disconnect, false);
    }

    public void stop(Credentials credentials, boolean disconnect, boolean checkTarget) throws ServiceAlreadyStoppedException, ServiceException {
        boolean stoppedAlready;
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            stoppedAlready = !this.isRunningInternal(checkTarget);
        }
        catch (HAResourceStateUnknownException e) {
            Trace.out("service comp resource state unknown. go ahead and stop it");
            stoppedAlready = false;
        }
        if (stoppedAlready) {
            Trace.out("service is already stopped: " + this.m_serviceName);
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceAlreadyStoppedException(this.s_opsMsgBundle.getMessage("1063", true, args));
        }
        LocalCommand localCommand = null;
        try {
            ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
            String resourceName = sc.getSCResourceName();
            HAStopOperation stopOp = new HAStopOperation(resourceName, null, credentials, this.m_version);
            stopOp.setServiceDisconnect(disconnect);
            localCommand = new LocalCommand(stopOp);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1031", true, args) + s_newline + result.getOutputAll());
        }
    }

    public void startMember(String instName, String startupOptions, Credentials credentials) throws ServiceAlreadyRunningException, ServiceException {
        HAStartOperation startOp;
        boolean instEnabled;
        boolean runningAlready;
        if (!this.existsAny(instName)) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            runningAlready = this.isRunningInternal(instName);
        }
        catch (HAResourceStateUnknownException e) {
            Trace.out("service member resource state unknown. not started: " + instName);
            runningAlready = true;
        }
        if (runningAlready) {
            Trace.out("service member is already running: " + this.m_serviceName);
            Object[] args = new Object[]{this.m_serviceName, instName};
            throw new ServiceAlreadyRunningException(this.s_opsMsgBundle.getMessage("1064", true, args));
        }
        try {
            instEnabled = this.m_server.isEnabled(instName);
        }
        catch (InstanceException e) {
            throw new ServiceException(e.getMessage());
        }
        if (!instEnabled) {
            Trace.out("database inst is disabled: " + instName);
            Object[] args = new Object[]{this.m_serviceName, instName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1080", true, args));
        }
        String nodeName = this.m_serverConfig.getNode(instName);
        String openMode = null;
        String pFileName = null;
        if (startupOptions != null) {
            StringTokenizer tokens = new StringTokenizer(startupOptions);
            StringBuffer buffer = new StringBuffer();
            while (tokens.hasMoreTokens()) {
                String thisToken = tokens.nextToken();
                if (thisToken.toUpperCase().startsWith("PFILE=")) {
                    pFileName = thisToken.substring(6);
                    continue;
                }
                buffer.append(thisToken);
                buffer.append(" ");
            }
            if (buffer.length() > 0) {
                openMode = buffer.toString().trim();
            }
        }
        try {
            Object[] args;
            ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
            if (!sc.isEnabled(instName)) {
                args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1032", true, args));
            }
            String resourceName = null;
            if (sc.getAvailableInstances() == null) {
                resourceName = (String)sc.getSMResourceNames().get(instName.toLowerCase());
            } else {
                Vector instStats = new Vector();
                try {
                    instStats = this.getMemberResourcesOnNode(this.m_serviceName, null, true, false);
                }
                catch (HAResourceStateUnknownException hAResourceStateUnknownException) {
                    // empty catch block
                }
                for (int j = 0; j < instStats.size(); ++j) {
                    HAResourceStatus stat = (HAResourceStatus)instStats.elementAt(j);
                    if (stat.isOnline()) continue;
                    resourceName = stat.getResourceName();
                    break;
                }
            }
            Trace.out("resourceName is " + resourceName);
            if (resourceName == null) {
                args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1086", true, args));
            }
            startOp = new HAStartOperation(resourceName, openMode, pFileName, credentials, this.m_version);
            startOp.setResourceName(resourceName);
            startOp.setNode(nodeName);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        LocalCommand localCommand = new LocalCommand(startOp);
        localCommand.execute();
        HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1030", true, args) + s_newline + result.getOutputAll());
        }
    }

    public void stopMember(String instName) throws ServiceAlreadyStoppedException, ServiceException {
        this.stopMember(instName, this.m_server.m_credentials, false);
    }

    public void stopMember(String instName, Credentials credentials) throws ServiceException, ServiceAlreadyStoppedException {
        this.stopMember(instName, credentials, false);
    }

    public void stopMember(String instName, Credentials credentials, boolean disconnect) throws ServiceException, ServiceAlreadyStoppedException {
        HAStopOperation stopOp;
        boolean stoppedAlready;
        if (!this.existsAny(instName)) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            stoppedAlready = !this.isRunningInternal(instName);
        }
        catch (HAResourceStateUnknownException e) {
            Trace.out("service member resource state unknown. go ahead and stop it: " + instName);
            stoppedAlready = false;
        }
        if (stoppedAlready) {
            Trace.out("service members is already stopped: " + this.m_serviceName);
            Object[] args = new Object[]{this.m_serviceName, instName};
            throw new ServiceAlreadyStoppedException(this.s_opsMsgBundle.getMessage("1065", true, args));
        }
        String nodeName = this.m_serverConfig.getNode(instName);
        try {
            ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
            Vector stats = new Vector();
            try {
                stats = this.getMemberResourcesOnNode(this.m_serviceName, nodeName, false, false);
            }
            catch (HAResourceStateUnknownException hAResourceStateUnknownException) {
                // empty catch block
            }
            String resourceName = null;
            for (int j = 0; j < stats.size(); ++j) {
                HAResourceStatus stat = (HAResourceStatus)stats.elementAt(j);
                if (!stat.isOnline() && (!stat.isUnknown() || !disconnect)) continue;
                resourceName = stat.getResourceName();
                break;
            }
            Trace.out("Stopping Service member resource " + resourceName);
            if (resourceName == null) {
                Object[] args = new Object[]{this.m_serviceName, instName};
                throw new ServiceAlreadyStoppedException(this.s_opsMsgBundle.getMessage("1065", true, args));
            }
            stopOp = new HAStopOperation(resourceName, null, credentials, this.m_version);
            stopOp.setServiceDisconnect(disconnect);
            stopOp.setResourceName(resourceName);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        LocalCommand lc = new LocalCommand(stopOp);
        lc.execute();
        HAOperationResult result = (HAOperationResult)lc.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1031", true, args) + s_newline + result.getOutputAll());
        }
    }

    public void relocate(String sourceInstance, String targetInstance) throws ServiceException {
        this.relocate(sourceInstance, targetInstance, false);
    }

    public void relocate(String sourceInstance, String targetInstance, boolean disconnect) throws ServiceException {
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        String sourceNode = this.m_serverConfig.getNode(sourceInstance);
        String targetNode = this.m_serverConfig.getNode(targetInstance);
        Vector stats = new Vector();
        try {
            stats = this.getMemberResourcesOnNode(this.m_serviceName, sourceNode, false, false);
        }
        catch (HAResourceStateUnknownException hAResourceStateUnknownException) {
            // empty catch block
        }
        if (stats.size() == 0) {
            Object[] args = new Object[]{this.m_serviceName, sourceInstance, targetInstance};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1033", true, args));
        }
        String[] availInsts = this.getAvailable();
        if (availInsts == null || availInsts.length == 0) {
            Trace.out("stopping serv member on source instance " + sourceInstance);
            this.stopMember(sourceInstance);
            Trace.out("starting serv member on target instance " + targetInstance);
            try {
                this.startMember(targetInstance, null, null);
            }
            catch (ServiceAlreadyRunningException sare) {
                Trace.out("serv member is already running on " + targetInstance);
            }
            catch (ServiceException se) {
                Trace.out("start serv member failed on target instance " + targetInstance + ", try to roll back");
                this.startMember(sourceInstance, null, null);
            }
        } else {
            HARelocateOperation relocateOp;
            String sourceResource = ((HAResourceStatus)stats.elementAt(0)).getResourceName();
            try {
                relocateOp = new HARelocateOperation(sourceResource, targetNode, this.m_version);
                relocateOp.setServiceDisconnect(disconnect);
            }
            catch (HAOperationException haoe) {
                throw new ServiceException(haoe.getMessage());
            }
            relocateOp.setResourceName(sourceResource);
            HAOperationResult result = null;
            LocalCommand localCommand = new LocalCommand(relocateOp);
            localCommand.execute();
            result = (HAOperationResult)localCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Object[] args = new Object[]{this.m_serviceName, sourceInstance, targetInstance};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1033", true, args) + s_newline + result.getOutputAll());
            }
        }
    }

    public void remove() throws ServiceException {
        this.remove(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(boolean force) throws ServiceException {
        Vector serviceProviders = new Vector();
        Vector serviceAttractors = new Vector();
        StringBuffer stagedExceptionMesgs = new StringBuffer();
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        if (this.exists()) {
            boolean running = false;
            try {
                running = this.isRunningInternal(true);
            }
            catch (ServiceException se) {
                if (!force) {
                    throw new ServiceException(se.getMessage());
                }
                stagedExceptionMesgs.append(se.getMessage());
            }
            catch (HAResourceStateUnknownException e) {
                if (force) {
                    running = false;
                }
                Trace.out("service comp resource state unknown. not removed");
                running = true;
            }
            if (running) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1024", true, args));
            }
            ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
            Hashtable serviceMemberTable = sc.getSMResourceNames();
            Hashtable serviceAttractorTable = null;
            LocalCommand[] localCommands = null;
            boolean is101Version = Version.get101Version().equals(this.m_version);
            if (!is101Version) {
                localCommands = new LocalCommand[serviceMemberTable.size() + 1];
            } else {
                serviceAttractorTable = sc.getSAResourceNames();
                localCommands = new LocalCommand[serviceMemberTable.size() + serviceAttractorTable.size() + 1];
                try {
                    this.stopAllSA(false);
                }
                catch (ServiceException toGo) {
                    // empty catch block
                }
            }
            int count = 0;
            try {
                HAUnregisterOperation unregisterOp;
                String resourceName;
                Enumeration e = serviceMemberTable.elements();
                while (e.hasMoreElements()) {
                    resourceName = (String)e.nextElement();
                    Trace.out("togo: " + resourceName);
                    unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
                    localCommands[count++] = new LocalCommand(unregisterOp);
                }
                if (is101Version) {
                    e = serviceAttractorTable.elements();
                    while (e.hasMoreElements()) {
                        resourceName = (String)e.nextElement();
                        Trace.out("togo: " + resourceName);
                        unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
                        localCommands[count++] = new LocalCommand(unregisterOp);
                    }
                }
                resourceName = sc.getSCResourceName();
                Trace.out("togo: " + resourceName);
                unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
                localCommands[count++] = new LocalCommand(unregisterOp);
            }
            catch (HAOperationException haoe) {
                throw new ServiceException(haoe.getMessage());
            }
            for (int i = 0; i < localCommands.length; ++i) {
                localCommands[i].execute();
                HAOperationResult result = (HAOperationResult)localCommands[i].getOperationResult();
                String msg = null;
                if (result.getStatus() == 0 || result.getStatus() == 212) continue;
                Object[] args = new Object[]{this.m_serviceName};
                msg = this.s_opsMsgBundle.getMessage("1050", true, args) + s_newline + result.getOutputAll();
                if (!force) {
                    throw new ServiceException(msg);
                }
                stagedExceptionMesgs.append(s_newline + msg);
            }
            this.m_serverConfig.removeService(sc);
            try {
                this.m_ocrTree.removeDatabaseService(this.m_serverConfig, sc);
            }
            catch (OCRException ce) {
                if (!force) {
                    throw new ServiceException(ce.getMessage());
                }
                stagedExceptionMesgs.append(s_newline + ce.getMessage());
            }
        } else {
            int i;
            HAStatusOperation statOp;
            if (!force) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
            }
            try {
                statOp = new HAStatusOperation(this.m_version);
            }
            catch (HAOperationException e) {
                throw new ServiceException(e.getMessage());
            }
            LocalCommand lCommand = new LocalCommand(statOp);
            lCommand.execute();
            HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
            if (result.getStatus() != 0) {
                Trace.out("Stat operation failed");
                String msg = result.getOutputSingle() + s_newline + result.getError();
                stagedExceptionMesgs.append(msg);
            }
            String[] statOutput = result.getOutput();
            Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
            String signature = this.m_resourcePrefix + this.m_serviceName + ".";
            Vector<HAUnregisterOperation> toGo = new Vector<HAUnregisterOperation>();
            for (i = 0; i < stats.size(); ++i) {
                HAUnregisterOperation unregOp;
                HAResourceStatus st = (HAResourceStatus)stats.elementAt(i);
                String resourceName = st.getResourceName();
                if (!resourceName.startsWith(signature) || !resourceName.endsWith(".cs") && !resourceName.endsWith(".srv")) continue;
                try {
                    unregOp = new HAUnregisterOperation(resourceName, this.m_version);
                }
                catch (HAOperationException e) {
                    throw new ServiceException(e.getMessage());
                }
                toGo.addElement(unregOp);
            }
            for (i = 0; i < toGo.size(); ++i) {
                lCommand = new LocalCommand((HAUnregisterOperation)toGo.elementAt(i));
                lCommand.execute();
                result = (HAOperationResult)lCommand.getOperationResult();
                if (result.getStatus() == 0) continue;
                Trace.out("Stat operation failed");
                String msg = result.getOutputSingle() + s_newline + result.getError();
                stagedExceptionMesgs.append(msg);
            }
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new ServiceException(stagedExceptionMesgs.toString());
        }
    }

    private void stopAllSA(boolean disconnect) throws ServiceException {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        Hashtable serviceMemberTable = sc.getSMResourceNames();
        Hashtable serviceAttractorTable = sc.getSAResourceNames();
        LocalCommand[] localCommandsForStop = new LocalCommand[serviceAttractorTable.size()];
        int count = 0;
        try {
            Enumeration e = serviceAttractorTable.elements();
            while (e.hasMoreElements()) {
                String resourceName = (String)e.nextElement();
                Trace.out("to stop: " + resourceName);
                HAStopOperation stopOp = new HAStopOperation(resourceName, this.m_version);
                stopOp.setServiceDisconnect(disconnect);
                localCommandsForStop[count++] = new LocalCommand(stopOp);
            }
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        for (int i = 0; i < localCommandsForStop.length; ++i) {
            localCommandsForStop[i].execute();
            HAOperationResult result = (HAOperationResult)localCommandsForStop[i].getOperationResult();
            if (result.getStatus() == 0) continue;
            Trace.out("crs_stop failed. which is fine");
        }
    }

    public void removeMember(String instance) throws ServiceException {
        this.removeMember(instance, false);
    }

    public void removeMember(String instance, boolean force) throws ServiceException {
        String[] newPrefList;
        ServiceComposite sc;
        StringBuffer stagedExceptionMesgs;
        block19: {
            if (!this.exists(instance)) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
            }
            try {
                new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
            }
            catch (UtilException e) {
                throw new ServiceException(e.getMessage());
            }
            stagedExceptionMesgs = new StringBuffer();
            boolean running = false;
            try {
                running = this.isRunningInternal(instance);
            }
            catch (ServiceException se) {
                if (force) {
                    stagedExceptionMesgs.append(se.getMessage());
                }
                throw new ServiceException(se.getMessage());
            }
            catch (HAResourceStateUnknownException e) {
                if (force) {
                    running = false;
                }
                Trace.out("service member resource state unknown. not removed: " + instance);
                running = true;
            }
            if (running) {
                Object[] args = new Object[]{this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1024", true, args));
            }
            sc = this.m_serverConfig.getService(this.m_serviceName);
            String resourceName = (String)sc.getSMResourceNames().get(instance.toLowerCase());
            String[] prefList = sc.getPreferredInstances();
            if (prefList.length == 1) {
                Object[] args = new Object[]{instance, this.m_serviceName};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1075", true, args));
            }
            newPrefList = new String[prefList.length - 1];
            int ind = 0;
            for (int i = 0; i < prefList.length; ++i) {
                if (prefList[i].equalsIgnoreCase(instance)) continue;
                newPrefList[ind++] = prefList[i];
            }
            try {
                HAUnregisterOperation unregOp = new HAUnregisterOperation(resourceName, this.m_version);
                LocalCommand localCommand = new LocalCommand(unregOp);
                localCommand.execute();
                HAOperationResult result = (HAOperationResult)localCommand.getOperationResult();
                if (result.getStatus() == 0 || result.getStatus() == 212) break block19;
                Object[] args = new Object[]{this.m_serviceName, instance};
                String mesg = this.s_opsMsgBundle.getMessage("1051", true, args) + s_newline + result.getOutputAll();
                if (force) {
                    stagedExceptionMesgs.append(s_newline + mesg);
                    break block19;
                }
                throw new ServiceException(mesg);
            }
            catch (HAOperationException haoe) {
                if (force) {
                    stagedExceptionMesgs.append(s_newline + haoe.getMessage());
                }
                throw new ServiceException(haoe.getMessage());
            }
        }
        sc.setPreferredInstances(newPrefList);
        try {
            this.m_ocrTree.setDatabaseService(this.m_serverConfig, sc, true);
        }
        catch (OCRException ce) {
            if (force) {
                stagedExceptionMesgs.append(s_newline + ce.getMessage());
            }
            throw new ServiceException(ce.getMessage());
        }
        if (stagedExceptionMesgs.length() > 0) {
            throw new ServiceException(stagedExceptionMesgs.toString());
        }
    }

    public void removeAvailable(String instance) throws ServiceException {
        boolean running;
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (!sc.isAvailable(instance)) {
            Object[] args = new Object[]{instance, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1066", true, args));
        }
        String[] availList = sc.getAvailableInstances();
        if (availList.length == 1) {
            Trace.out("removing the last available instance! use modify service instead");
            Object[] args = new Object[]{instance, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1067", true, args));
        }
        try {
            running = this.isRunningInternal(instance);
        }
        catch (HAResourceStateUnknownException e) {
            running = false;
        }
        if (running) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1024", true, args));
        }
        String[] newAvailList = new String[availList.length - 1];
        int ind = 0;
        for (int i = 0; i < availList.length; ++i) {
            if (availList[i].equalsIgnoreCase(instance)) continue;
            newAvailList[ind++] = availList[i];
        }
        sc.setAvailableInstances(newAvailList);
        try {
            this.m_ocrTree.setDatabaseService(this.m_serverConfig, sc, true);
        }
        catch (OCRException ce) {
            throw new ServiceException(ce.getMessage());
        }
    }

    public void modify(String[] preferredInstances, String[] availableInstances, String tafPolicy) throws ServiceException {
        this.modify(preferredInstances, availableInstances, tafPolicy, false);
    }

    public void modify(String[] preferredInstances, String[] availableInstances, String tafPolicy, boolean disconnect) throws ServiceException {
        String resName;
        LocalCommand lc;
        int i;
        boolean servOnline;
        String[] availInstances;
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        if (preferredInstances == null) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1028", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        if (availableInstances == null || availableInstances.length == 0) {
            availInstances = null;
        } else {
            availInstances = new String[availableInstances.length];
            System.arraycopy(availableInstances, 0, availInstances, 0, availableInstances.length);
        }
        StringBuffer options = this.checkServiceOptions(preferredInstances, availableInstances);
        if (options.length() > 0) {
            Object[] args = new Object[]{options, this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1087", true, args));
        }
        this.displayServiceConfig("new", preferredInstances, availInstances);
        ServiceComposite oldSC = this.m_serverConfig.getService(this.m_serviceName);
        this.displayServiceConfig("old", oldSC.getPreferredInstances(), oldSC.getAvailableInstances());
        Object smName = null;
        String resourceName = null;
        Vector<LocalCommand> lCommands = new Vector<LocalCommand>();
        Vector<LocalCommand> stopCommands = new Vector<LocalCommand>();
        Vector<LocalCommand> startCommands = new Vector<LocalCommand>();
        Vector<HARacgWrapOperation> clnupOperations = new Vector<HARacgWrapOperation>();
        Vector prefInstToRemoveVec = new Vector();
        Vector prefInstToUpdateVec = new Vector();
        Vector prefInstToAddVec = new Vector();
        this.twoSetsBreakDown(oldSC.getPreferredInstances(), preferredInstances, prefInstToRemoveVec, prefInstToUpdateVec, prefInstToAddVec);
        Object[] prefInstToRemove = new String[prefInstToRemoveVec.size()];
        Object[] prefInstToUpdate = new String[prefInstToUpdateVec.size()];
        Object[] prefInstToAdd = new String[prefInstToAddVec.size()];
        prefInstToRemoveVec.copyInto(prefInstToRemove);
        prefInstToUpdateVec.copyInto(prefInstToUpdate);
        prefInstToAddVec.copyInto(prefInstToAdd);
        Vector availInstToRemoveVec = new Vector();
        Vector availInstToUpdateVec = new Vector();
        Vector availInstToAddVec = new Vector();
        this.twoSetsBreakDown(oldSC.getAvailableInstances(), availInstances, availInstToRemoveVec, availInstToUpdateVec, availInstToAddVec);
        Object[] availInstToRemove = new String[availInstToRemoveVec.size()];
        Object[] availInstToUpdate = new String[availInstToUpdateVec.size()];
        Object[] availInstToAdd = new String[availInstToAddVec.size()];
        availInstToRemoveVec.copyInto(availInstToRemove);
        availInstToUpdateVec.copyInto(availInstToUpdate);
        availInstToAddVec.copyInto(availInstToAdd);
        boolean servMbrOnline = false;
        try {
            servOnline = this.isRunningInternal(false);
            if (prefInstToAdd.length == 1 && prefInstToRemove.length == 1) {
                servMbrOnline = this.isRunning((String)prefInstToRemove[0]);
            }
        }
        catch (HAResourceStateUnknownException e) {
            servOnline = false;
        }
        String[] cpPrefInstances = this.getCasePreservingInstNames(preferredInstances);
        String[] cpAvailInstances = this.getCasePreservingInstNames(availInstances);
        ServiceComposite newSC = new ServiceComposite(this.m_serviceName, cpPrefInstances, cpAvailInstances, tafPolicy, oldSC.getEnv(), oldSC.isEnabled(), this.m_serverConfig.getName());
        this.m_serverConfig.setService(newSC);
        Trace.out("Updating Service Composite");
        this.genSCProfile(newSC, true);
        boolean is101Version = Version.get101Version().equals(this.m_version);
        try {
            HARegisterOperation registerOp;
            int i2;
            for (i2 = 0; i2 < prefInstToAdd.length; ++i2) {
                resourceName = (String)newSC.getSMResourceNames().get(((String)prefInstToAdd[i2]).toLowerCase());
                this.genSMProfile((String)prefInstToAdd[i2], newSC, false);
                registerOp = new HARegisterOperation(resourceName, this.m_version);
                lCommands.addElement(new LocalCommand(registerOp));
                if (servOnline && servMbrOnline) {
                    HAStartOperation startOp = new HAStartOperation(resourceName, this.m_version);
                    startCommands.addElement(new LocalCommand(startOp));
                }
                if (!is101Version || !servOnline) continue;
                clnupOperations.addElement(this.getStartOrphanOp((String)prefInstToAdd[i2]));
            }
            for (i2 = 0; i2 < prefInstToUpdate.length; ++i2) {
                resourceName = (String)newSC.getSMResourceNames().get(((String)prefInstToUpdate[i2]).toLowerCase());
                this.genSMProfile((String)prefInstToUpdate[i2], newSC, true);
                registerOp = new HARegisterOperation(resourceName, true, this.m_version);
                lCommands.addElement(new LocalCommand(registerOp));
            }
            for (i2 = 0; i2 < prefInstToRemove.length; ++i2) {
                Trace.out("prefInstToRemove = " + (String)prefInstToRemove[i2]);
                resourceName = (String)oldSC.getSMResourceNames().get(((String)prefInstToRemove[i2]).toLowerCase());
                if (servOnline) {
                    HAStopOperation stopOp = new HAStopOperation(resourceName, this.m_version);
                    stopOp.setServiceDisconnect(disconnect);
                    stopCommands.addElement(new LocalCommand(stopOp));
                }
                Trace.out("resource to unregister = " + resourceName);
                HAUnregisterOperation unregisterOp = new HAUnregisterOperation(resourceName, this.m_version);
                lCommands.addElement(new LocalCommand(unregisterOp));
                if (!is101Version || !servOnline) continue;
                clnupOperations.addElement(this.getFailEventSrvSaOp((String)prefInstToRemove[i2]));
            }
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        if (servOnline) {
            for (i = 0; i < stopCommands.size(); ++i) {
                lc = (LocalCommand)stopCommands.elementAt(i);
                resName = ((HAOperation)lc.getOperation()).getResourceName();
                Trace.out("Stopping on resource " + resName);
                lc.execute();
                HAOperationResult result = (HAOperationResult)lc.getOperationResult();
                if (result.getStatus() == 0) continue;
                Trace.out("stop op on res=" + resName + "return code " + result.getStatus());
            }
        }
        for (i = 0; i < lCommands.size(); ++i) {
            lc = (LocalCommand)lCommands.elementAt(i);
            resName = ((HAOperation)lc.getOperation()).getResourceName();
            Trace.out("Working on resource " + resName);
            lc.execute();
            HAOperationResult result = (HAOperationResult)lc.getOperationResult();
            if (result.getStatus() == 0) continue;
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1048", true, args) + s_newline + result.getOutputAll());
        }
        try {
            this.m_ocrTree.setDatabaseService(this.m_serverConfig, newSC, true);
        }
        catch (OCRException e) {
            throw new ServiceException(e.getMessage());
        }
        for (i = 0; i < startCommands.size(); ++i) {
            lc = (LocalCommand)startCommands.elementAt(i);
            resName = ((HAOperation)lc.getOperation()).getResourceName();
            Trace.out("Starting on resource " + resName);
            lc.execute();
            HAOperationResult result = (HAOperationResult)lc.getOperationResult();
            if (result.getStatus() == 0) continue;
            Trace.out("start op on res=" + resName + "return code " + result.getStatus());
        }
        if (servOnline) {
            int i3;
            String[] allToRemove = new String[prefInstToRemove.length + availInstToRemove.length];
            int ind = 0;
            for (i3 = 0; i3 < prefInstToRemove.length; ++i3) {
                allToRemove[ind++] = prefInstToRemove[i3];
            }
            for (i3 = 0; i3 < availInstToRemove.length; ++i3) {
                allToRemove[ind++] = availInstToRemove[i3];
            }
            for (int i4 = 0; i4 < allToRemove.length; ++i4) {
                int j;
                HAStatusOperation statOp;
                String nodeName = this.m_serverConfig.getNode(allToRemove[i4]);
                try {
                    statOp = new HAStatusOperation(newSC.getAllResourceNames(), nodeName, this.m_version);
                }
                catch (HAOperationException haoe) {
                    throw new ServiceException(haoe.getMessage());
                }
                lc = new LocalCommand(statOp);
                lc.execute();
                HAOperationResult result = (HAOperationResult)lc.getOperationResult();
                if (result.getStatus() != 0) {
                    String allResStr = "";
                    String[] allRes = newSC.getAllResourceNames();
                    for (j = 0; j < allRes.length; ++j) {
                        allResStr = allResStr + " " + allRes[j];
                    }
                    Object[] args = new Object[]{allResStr};
                    throw new ServiceException(this.s_opsMsgBundle.getMessage("1056", true, args) + s_newline + result.getOutputAll());
                }
                String[] statOutput = result.getOutput();
                Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
                Trace.out("node = " + nodeName + "; stats.size() = " + stats.size());
                for (j = 0; j < stats.size(); ++j) {
                    HARelocateOperation relOp;
                    HAResourceStatus s = (HAResourceStatus)stats.elementAt(j);
                    if (!s.isOnline()) continue;
                    String destInst = null;
                    if (s.getResourceName().endsWith(".srv")) {
                        int k;
                        for (k = 0; k < preferredInstances.length; ++k) {
                            if (this.isRunning(preferredInstances[k])) continue;
                            destInst = preferredInstances[k];
                            break;
                        }
                        if (availInstances != null && destInst == null) {
                            for (k = 0; k < availInstances.length; ++k) {
                                if (this.isRunning(availInstances[k])) continue;
                                destInst = availInstances[k];
                                break;
                            }
                        }
                    } else {
                        destInst = preferredInstances[0];
                    }
                    Trace.out("relocating " + s.getResourceName() + " to " + destInst);
                    try {
                        String destNode = this.m_serverConfig.getNode(destInst);
                        relOp = new HARelocateOperation(s.getResourceName(), destNode, this.m_version);
                        relOp.setServiceDisconnect(disconnect);
                        relOp.setResourceName(s.getResourceName());
                    }
                    catch (HAOperationException he) {
                        throw new ServiceException(he.getMessage());
                    }
                    lc = new LocalCommand(relOp);
                    lc.execute();
                    result = (HAOperationResult)lc.getOperationResult();
                    if (result.getStatus() == 0) continue;
                    Trace.out("failed to relocate " + s.getResourceName() + " to " + destInst);
                }
            }
        }
        if (is101Version) {
            for (int i5 = 0; i5 < clnupOperations.size(); ++i5) {
                this.runRacgWrapOp((HARacgWrapOperation)clnupOperations.elementAt(i5));
            }
        }
    }

    private void displayServiceConfig(String name, String[] preferredInstances, String[] availableInstances) {
        int i;
        for (i = 0; i < preferredInstances.length; ++i) {
            Trace.out(name + " preferredInstances[" + i + "] = " + preferredInstances[i]);
        }
        if (availableInstances == null) {
            Trace.out(name + " availableInstances is null");
        } else {
            Trace.out(name + " availableInstances.length = " + availableInstances.length);
            for (i = 0; i < availableInstances.length; ++i) {
                Trace.out(name + " availableInstances[" + i + "] = " + availableInstances[i]);
            }
        }
    }

    public boolean exists() {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        return sc != null;
    }

    public boolean exists(String instanceName) {
        if (!this.exists()) {
            return false;
        }
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        String[] preferredInstances = sc.getPreferredInstances();
        for (int i = 0; i < preferredInstances.length; ++i) {
            if (!preferredInstances[i].equalsIgnoreCase(instanceName)) continue;
            return true;
        }
        return false;
    }

    public boolean existsAny(String instanceName) {
        int i;
        if (!this.exists()) {
            return false;
        }
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        String[] preferredInstances = sc.getPreferredInstances();
        String[] availInstances = sc.getAvailableInstances();
        for (i = 0; i < preferredInstances.length; ++i) {
            if (!preferredInstances[i].equalsIgnoreCase(instanceName)) continue;
            return true;
        }
        if (availInstances != null) {
            for (i = 0; i < availInstances.length; ++i) {
                if (!availInstances[i].equalsIgnoreCase(instanceName)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getInstances() {
        int i;
        String[] pref = this.getPreferred();
        String[] avail = this.getAvailable();
        String[] list = avail != null ? new String[pref.length + avail.length] : new String[pref.length];
        int count = 0;
        for (i = 0; i < pref.length; ++i) {
            list[count++] = pref[i];
        }
        if (avail != null) {
            for (i = 0; i < avail.length; ++i) {
                list[count++] = avail[i];
            }
        }
        return list;
    }

    public String[] getPreferred() {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc != null) {
            return sc.getPreferredInstances();
        }
        return null;
    }

    public String[] getAvailable() {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc != null) {
            return sc.getAvailableInstances();
        }
        return null;
    }

    public String getTAFPolicy() {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc != null) {
            return sc.getTAFPolicy();
        }
        return null;
    }

    public boolean isPreferred(String instanceName) {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            return false;
        }
        return sc.isPreferred(instanceName);
    }

    public boolean isAvailable(String instanceName) {
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        if (sc == null) {
            return false;
        }
        return sc.isAvailable(instanceName);
    }

    public void setEnv(String name, String value) throws ServiceException {
        String[] envName = new String[]{name};
        String[] envValue = new String[]{value};
        this.setEnv(envName, envValue);
    }

    public void setEnv(String[] envName, String[] envValue) throws ServiceException {
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        SetEnvOperation setEnvOp = new SetEnvOperation(this.m_serverConfig.getName(), this.m_serviceName, 102, envName, envValue, this.m_version);
        SetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(setEnvOp);
        localCommand.execute();
        result = (SetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1057", true, args));
        }
    }

    public void unsetEnv(String name) throws ServiceException {
        String[] envName = new String[]{name};
        this.unsetEnv(envName);
    }

    public void unsetEnv(String[] envName) throws ServiceException {
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        try {
            new Util().checkOracleUser(this.m_serverConfig.getOracleHome());
        }
        catch (UtilException e) {
            throw new ServiceException(e.getMessage());
        }
        UnsetEnvOperation unsetEnvOp = new UnsetEnvOperation(this.m_serverConfig.getName(), this.m_serviceName, 102, envName, this.m_version);
        UnsetEnvResult result = null;
        LocalCommand localCommand = new LocalCommand(unsetEnvOp);
        localCommand.execute();
        result = (UnsetEnvResult)localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1058", true, args));
        }
    }

    public String[] getEnv(String[] envName) throws ServiceException {
        String[] servEnv = this.getEnv();
        String dbName = this.m_serverConfig.getName();
        if (servEnv.length == 0) {
            Object[] args = new Object[]{Utils.getString(envName, ","), this.m_serviceName, dbName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1049", true, args));
        }
        String[] values = new String[envName.length];
        int valIndex = 0;
        for (int j = 0; j < envName.length; ++j) {
            boolean found = false;
            for (int i = 0; i < servEnv.length; ++i) {
                String environName;
                int eqIndex = servEnv[i].indexOf("=");
                if (eqIndex == -1 || !(environName = servEnv[i].substring(0, eqIndex)).equals(envName[j])) continue;
                found = true;
                if (servEnv[i].length() > eqIndex) {
                    values[valIndex++] = servEnv[i].substring(eqIndex + 1);
                    break;
                }
                values[valIndex++] = "";
                break;
            }
            if (found) continue;
            Object[] args = new Object[]{envName[j], this.m_serviceName, dbName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1049", true, args));
        }
        return values;
    }

    public String[] getEnv() throws ServiceException {
        if (!this.exists()) {
            Object[] args = new Object[]{this.m_serviceName};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1025", true, args));
        }
        ServiceComposite sc = this.m_serverConfig.getService(this.m_serviceName);
        try {
            String[] env = this.m_ocrTree.getKeyValues(((OCRTreeDefinitionHA)this.m_ocrTree.getTreeDefinition()).getDBServiceEnvKey(this.m_serverConfig.getName(), sc.getModifiedName()));
            if (env == null) {
                env = new String[]{};
            }
            return env;
        }
        catch (OCRException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private Vector getMemberResourcesOnNode(String serviceName, String nodeName, boolean all, boolean throwForUnknownState) throws ServiceException, HAResourceStateUnknownException {
        HAStatusOperation statOp;
        ServiceComposite sc = this.m_serverConfig.getService(serviceName);
        Hashtable sms = sc.getSMResourceNames();
        String[] smRes = new String[sms.size()];
        int j = 0;
        Enumeration e = sms.elements();
        while (e.hasMoreElements()) {
            smRes[j] = (String)e.nextElement();
            ++j;
        }
        try {
            statOp = new HAStatusOperation(smRes, nodeName, this.m_version);
        }
        catch (HAOperationException haoe) {
            throw new ServiceException(haoe.getMessage());
        }
        LocalCommand lCommand = new LocalCommand(statOp);
        lCommand.execute();
        HAOperationResult result = (HAOperationResult)lCommand.getOperationResult();
        if (result.getStatus() != 0) {
            String smResStr = "";
            for (j = 0; j < smRes.length; ++j) {
                smResStr = smResStr + " " + smRes[j];
            }
            Object[] args = new Object[]{smResStr};
            throw new ServiceException(this.s_opsMsgBundle.getMessage("1056", true, args) + s_newline + result.getOutputAll());
        }
        String[] statOutput = result.getOutput();
        Vector stats = HAResourceStatus.parseHAStatusOutput(statOutput);
        Trace.out("stats.size() = " + stats.size());
        if (all) {
            return stats;
        }
        Vector retVal = new Vector();
        for (int i = 0; i < stats.size(); ++i) {
            if (((HAResourceStatus)stats.elementAt(i)).isOnline()) {
                retVal.addElement(stats.elementAt(i));
            }
            if (!((HAResourceStatus)stats.elementAt(i)).isUnknown() || !throwForUnknownState) continue;
            throw new HAResourceStateUnknownException();
        }
        return retVal;
    }

    private void twoSetsBreakDown(String[] existingSet, String[] newSet, Vector oldVec, Vector overlappingVec, Vector newVec) {
        boolean overlap;
        if (existingSet == null && newSet == null) {
            return;
        }
        if (existingSet == null) {
            for (int i = 0; i < newSet.length; ++i) {
                newVec.addElement(newSet[i]);
            }
            return;
        }
        if (newSet == null) {
            for (int i = 0; i < existingSet.length; ++i) {
                oldVec.addElement(existingSet[i]);
            }
            return;
        }
        for (int i = 0; i < existingSet.length; ++i) {
            overlap = false;
            for (int j = 0; j < newSet.length; ++j) {
                if (!existingSet[i].equalsIgnoreCase(newSet[j])) continue;
                overlap = true;
                break;
            }
            if (overlap) {
                overlappingVec.addElement(existingSet[i]);
                continue;
            }
            oldVec.addElement(existingSet[i]);
        }
        for (int j = 0; j < newSet.length; ++j) {
            overlap = false;
            for (int i = 0; i < existingSet.length; ++i) {
                if (!existingSet[i].equalsIgnoreCase(newSet[j])) continue;
                overlap = true;
                break;
            }
            if (overlap) continue;
            newVec.addElement(newSet[j]);
        }
    }

    private String[] getCasePreservingInstNames(String[] inputInsts) throws ServiceException {
        if (inputInsts == null) {
            return null;
        }
        String[] outputInsts = new String[inputInsts.length];
        for (int i = 0; i < inputInsts.length; ++i) {
            Instance inst = this.m_serverConfig.getInstance(inputInsts[i]);
            if (inst == null) {
                Object[] args = new Object[]{inputInsts[i], this.m_serverConfig.getName()};
                throw new ServiceException(this.s_opsMsgBundle.getMessage("1027", true, args));
            }
            outputInsts[i] = inst.getName();
        }
        return outputInsts;
    }

    private StringBuffer checkServiceOptions(String[] preferredInstances, String[] availableInstances) {
        StringBuffer dbInstances = new StringBuffer();
        if (preferredInstances != null && availableInstances != null) {
            Arrays.sort(availableInstances);
            Arrays.sort(preferredInstances);
            for (int i = 0; i < preferredInstances.length; ++i) {
                if (Arrays.binarySearch(availableInstances, preferredInstances[i]) < 0) continue;
                dbInstances.append(preferredInstances[i]);
                if (dbInstances.length() <= 0) continue;
                dbInstances.append(",");
            }
            if (dbInstances.length() > 0) {
                dbInstances.deleteCharAt(dbInstances.length() - 1);
            }
        }
        return dbInstances;
    }
}

