/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;

public class HAResourceStatus {
    private String s_resourceName;
    private String s_target;
    private String s_status;
    private String s_host;
    private int s_timeout;

    HAResourceStatus(String resName, String target, String status, String host) {
        this(resName, target, status, host, 0);
    }

    HAResourceStatus(String resName, String target, String status, String host, int timeout) {
        this.s_resourceName = resName;
        this.s_target = target;
        this.s_status = status;
        this.s_host = host;
        this.s_timeout = timeout;
    }

    public int getStopTimeOut() {
        return this.s_timeout;
    }

    public String getResourceName() {
        return this.s_resourceName;
    }

    public String getTargetStatus() {
        return this.s_target;
    }

    public String getStatus() {
        return this.s_status;
    }

    public String getHost() {
        return this.s_host;
    }

    public boolean isTargetOnline() {
        if (this.s_target == null) {
            return false;
        }
        return this.s_target.startsWith("ONLINE");
    }

    public boolean isOnline() {
        if (this.s_status == null) {
            return false;
        }
        return this.s_status.startsWith("ONLINE");
    }

    public boolean isUnknown() {
        if (this.s_status == null) {
            return false;
        }
        return this.s_status.startsWith("UNKNOWN");
    }

    public static HAResourceStatus parseHAStatusWithPFlagOutput(String[] text) {
        String resName = null;
        String target = null;
        String status = null;
        String host = null;
        int script_timeout = 0;
        int stop_timeout = 0;
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length; ++i) {
            if (text[i].startsWith("NAME=")) {
                resName = text[i].substring(text[i].indexOf(61) + 1);
                continue;
            }
            if (text[i].startsWith("HOSTING_MEMBERS")) {
                host = text[i].substring(text[i].indexOf(61) + 1);
                continue;
            }
            if (text[i].startsWith("SCRIPT_TIMEOUT=")) {
                try {
                    script_timeout = Integer.parseInt(text[i].substring(text[i].indexOf(61) + 1));
                }
                catch (NumberFormatException nfex) {
                    Trace.out("caught exception while tryign to parse script_timeout" + nfex.toString());
                }
                continue;
            }
            if (!text[i].startsWith("STOP_TIMEOUT=")) continue;
            try {
                stop_timeout = Integer.parseInt(text[i].substring(text[i].indexOf(61) + 1));
                continue;
            }
            catch (NumberFormatException nfex) {
                Trace.out("caught exception while tryign to parse script_timeout" + nfex.toString());
            }
        }
        int timeout = 0;
        timeout = stop_timeout == 0 ? (script_timeout == 0 ? 60 : script_timeout) : stop_timeout;
        Trace.out("stop_timeout: " + stop_timeout + " script_timeout: " + script_timeout + " timeout:" + timeout);
        HAResourceStatus rs = new HAResourceStatus(resName, null, null, host, timeout);
        Trace.out("got status: resource=" + resName + "target=" + target + " status=" + status + " host=" + host + " timeout=" + timeout);
        return rs;
    }

    public static Vector parseHAStatusOutput(String[] text) {
        Vector<HAResourceStatus> results = new Vector<HAResourceStatus>();
        String target = null;
        String status = null;
        String host = null;
        if (text == null) {
            return results;
        }
        for (int i = 0; i < text.length; ++i) {
            if (!text[i].startsWith("NAME=")) continue;
            String resName = text[i].substring(text[i].indexOf(61) + 1);
            target = text[i + 2].substring(text[i + 2].indexOf(61) + 1);
            status = text[i + 3].substring(text[i + 3].indexOf(61) + 1);
            host = status.indexOf(" on ") != -1 ? status.substring(status.lastIndexOf(" ") + 1) : null;
            i += 3;
            HAResourceStatus rs = new HAResourceStatus(resName, target, status, host);
            Trace.out("got status: resource=" + resName + "target=" + target + " status=" + status + " host=" + host);
            results.addElement(rs);
        }
        return results;
    }
}

