/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.database;

import java.io.Serializable;

public class Credentials
implements Serializable {
    static final long serialVersionUID = -2319266505351491246L;
    public static final int ROLE_NONE = 0;
    public static final int ROLE_SYSDBA = 1;
    public static final int ROLE_SYSOPER = 2;
    public static final int ROLE_SYSASM = 3;
    private String m_username;
    private String m_password;
    private int m_role;

    public Credentials(String username, String password, int role) {
        this.m_username = username;
        this.m_password = password;
        this.m_role = role;
    }

    public Credentials() {
        this("", "", 1);
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setUserName(String userName) {
        this.m_username = userName;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public int getRole() {
        return this.m_role;
    }

    public void setRole(int role) {
        this.m_role = role;
    }

    public String getConnectString() {
        StringBuffer cstr = new StringBuffer(this.m_username + "/" + this.m_password);
        if (this.m_role != 0) {
            cstr.append(" as ");
            if (this.m_role == 1) {
                cstr.append("sysdba");
            } else if (this.m_role == 2) {
                cstr.append("sysoper");
            } else if (this.m_role == 3) {
                cstr.append("sysasm");
            }
        }
        return cstr.toString();
    }

    public boolean areDefault() {
        return "".equals(this.m_username) && "".equals(this.m_password) && (1 == this.m_role || 3 == this.m_role);
    }
}

