/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.transfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.ops.mgmt.command.transfer.DataBuffer;
import oracle.ops.mgmt.command.transfer.TransferQueues;
import oracle.ops.mgmt.trace.Trace;

public class TransferWriter
extends Thread {
    private TransferQueues m_transferQueues;
    private FileOutputStream m_fileStream;
    private Vector m_errorLog;
    private String m_nodeName;

    public TransferWriter(TransferQueues transferQueues, String nodeName) {
        this.m_transferQueues = transferQueues;
        this.m_nodeName = nodeName;
        this.m_errorLog = new Vector();
    }

    @Override
    public void run() {
        boolean bDone = false;
        DataBuffer dataBuffer = null;
        while (!bDone) {
            try {
                dataBuffer = this.m_transferQueues.getDataBuffer();
                this.writeFile(dataBuffer);
                this.m_transferQueues.putFreeBuffer(dataBuffer);
                if (!this.m_transferQueues.isReaderDone() || this.m_transferQueues.getNumDataBuffers() != 0) continue;
                bDone = true;
            }
            catch (InterruptedException ie) {
                Trace.out(ie.getMessage());
                bDone = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(DataBuffer dataBuffer) {
        block27: {
            int fileStatus = dataBuffer.getFileStatus();
            Trace.out("fileStatus = " + fileStatus);
            if (fileStatus == DataBuffer.NO_OP) {
                Trace.out("Processed one NO_OP data buffer");
                return;
            }
            String fileToWrite = dataBuffer.getFileName();
            String fileName = "\\\\" + this.m_nodeName + "\\" + fileToWrite.replace(':', '$');
            Object absPath = null;
            Trace.out("Writing file: " + fileName);
            if (fileStatus == DataBuffer.CREATE_DIR) {
                Trace.out("Creating directory: " + fileName);
                File file = new File(fileName);
                if (!file.exists() & !file.mkdirs()) {
                    Trace.out("Failed to create directory");
                    this.m_errorLog.add(fileName);
                }
                file.setLastModified(dataBuffer.getLastModified());
                return;
            }
            if ((fileStatus & DataBuffer.CREATE_FILE) == DataBuffer.CREATE_FILE) {
                Trace.out("Creating path for file: " + fileName);
                File file = new File(fileName).getParentFile();
                Trace.out("path = " + file.getAbsolutePath());
                if (!file.exists() && !file.mkdirs()) {
                    Trace.out("Failed to create directory");
                    this.m_errorLog.add(fileName);
                }
            }
            boolean bError = false;
            try {
                Trace.out("fileStatus = " + fileStatus);
                if ((fileStatus & DataBuffer.CREATE_FILE) == DataBuffer.CREATE_FILE) {
                    Trace.out("Creating file: " + fileName);
                    this.m_fileStream = null;
                    this.m_fileStream = new FileOutputStream(fileName);
                }
            }
            catch (FileNotFoundException ex) {
                Trace.out("could not open file for writing: " + ex.getMessage());
                this.m_errorLog.add(ex.getMessage());
                return;
            }
            try {
                if ((fileStatus & DataBuffer.WRITE_FILE) != DataBuffer.WRITE_FILE) break block27;
                byte[] buffer = dataBuffer.getBuffer();
                int nBytes = dataBuffer.getNumBytes();
                if (this.m_fileStream != null) {
                    Trace.out("Writing the file: " + fileName);
                    this.m_fileStream.write(buffer, 0, nBytes);
                }
                if ((fileStatus & DataBuffer.CLOSE_FILE) != DataBuffer.CLOSE_FILE) break block27;
                Trace.out("Closing the file: " + fileName);
                if (this.m_fileStream != null) {
                    try {
                        this.m_fileStream.close();
                    }
                    catch (IOException ie) {
                        Trace.out(ie.getMessage());
                    }
                }
                Trace.out("Setting file attributes");
                File file = new File(fileName);
                if (dataBuffer.getFileType() == DataBuffer.READ_ONLY) {
                    Trace.out("Setting the file attribute to READ_ONLY");
                    file.setReadOnly();
                } else if (dataBuffer.getFileType() == DataBuffer.HIDDEN) {
                    Trace.out("Setting the file attribute to HIDDEN");
                }
                file.setLastModified(dataBuffer.getLastModified());
            }
            catch (IOException ie) {
                bError = true;
                Trace.out("Error in writeFile: " + ie.getMessage());
                this.m_errorLog.add(ie.getMessage());
            }
            finally {
                if (bError && this.m_fileStream != null) {
                    try {
                        this.m_fileStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String[] getErrors() {
        Object[] errors = new String[this.m_errorLog.size()];
        this.m_errorLog.copyInto(errors);
        return errors;
    }
}

