/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class QueryServiceDepCommand
extends ServiceCommand {
    public QueryServiceDepCommand(String service, String node) {
        this.serviceName = service;
        this.m_node = this.nodeName = node;
        Trace.out("Creating a QueryServiceDep command");
    }

    @Override
    public boolean execute() {
        Trace.out("Inside execute of QueryServiceDepCommand");
        try {
            Trace.out("calling nativeSystem.queryServiceDep with serviceName=" + this.serviceName + " and nodeName=" + this.nodeName);
            String returnString = this.nativeSystem.queryServiceDep(this.serviceName, this.nodeName);
            Trace.out("String returned from Native: " + returnString);
            this.commandResult = new CommandResult(returnString);
            this.getStatusLogger().log((Command)this, returnString);
        }
        catch (Exception e) {
            Trace.out("Exception occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

