/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class DeleteServiceCommand
extends ServiceCommand {
    private boolean m_ignoreNotExist;

    public DeleteServiceCommand(String service, String node) {
        this(service, node, false);
    }

    public DeleteServiceCommand(String service, String node, boolean ignoreNotExist) {
        this.serviceName = service;
        this.nodeName = node;
        this.m_ignoreNotExist = ignoreNotExist;
    }

    @Override
    public boolean execute() {
        Trace.out("Inside execute of CreateService");
        try {
            String ret = this.nativeSystem.deleteService(this.m_ignoreNotExist, this.serviceName, this.nodeName);
            Trace.out("DeleteService.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("DeleteService.execute:Exception occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

