/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.trace.Trace;

public class CreateServiceCommand
extends ServiceCommand {
    private int m_access = 0;
    private int m_type = 0;
    private int m_mode = 0;
    private int m_errCtrl = 0;
    private String m_deps = null;
    private String m_domainName = null;
    private String m_userName = null;
    private String m_password = null;
    private String m_loadGrp = null;

    public CreateServiceCommand(String service, String exe, int m, String node) {
        this.serviceName = service;
        this.exeLocation = exe;
        this.m_mode = m;
        this.nodeName = node;
    }

    public CreateServiceCommand(String service, String exe, int m, String domainName, String userName, String password, String node) {
        this.serviceName = service;
        this.exeLocation = exe;
        this.m_mode = m;
        this.m_userName = userName;
        this.m_domainName = domainName;
        this.m_password = password;
        this.nodeName = node;
    }

    @Override
    public boolean execute() {
        Trace.out("Inside execute of CreateService");
        try {
            String ret = this.nativeSystem.createService(this.serviceName, this.exeLocation, this.m_access, this.m_type, this.m_mode, this.m_errCtrl, this.m_deps, this.m_domainName, this.m_userName, this.m_password, this.m_loadGrp, this.nodeName);
            Trace.out("CreateService.execute:String returned from Native: " + ret);
            this.commandResult = new CommandResult(ret);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("CreateService.executeException occurred while calling nativesystem");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }
}

