/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.service;

import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.service.ServiceCommand;
import oracle.ops.mgmt.command.service.ServiceData;
import oracle.ops.mgmt.trace.Trace;

public class CheckServiceCommand
extends ServiceCommand {
    private boolean m_isValidState;
    private ServiceData m_data;

    public CheckServiceCommand(String service, String node, int state) {
        this.serviceName = service;
        this.nodeName = node;
        this.m_data = new ServiceData(state);
        this.commandResult = new CommandResult();
    }

    @Override
    public boolean execute() {
        Trace.out("CheckServiceCommand: with serviceName=" + this.serviceName + " and nodeName=" + this.nodeName);
        this.m_isValidState = this.nativeSystem.checkService(this.serviceName, this.nodeName, this.m_data, this.commandResult);
        Trace.out("CheckService.execute: The state been checked is : " + this.m_data.getState() + " and its result is " + this.m_isValidState);
        return this.commandResult.getStatus();
    }

    public boolean isValidState() {
        return this.m_isValidState;
    }

    public int getCurrentState() {
        return this.m_data.getCurrState();
    }
}

