/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.registry;

import oracle.ops.mgmt.command.registry.RegistryCommand;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.trace.Trace;

public class GetRegDataCommand
extends RegistryCommand {
    private String m_value = null;
    private RegistryKeyData m_data;

    public GetRegDataCommand(String node, String key, String value) {
        super(node, key);
        this.m_value = value;
        this.m_data = new RegistryKeyData(key, value);
    }

    public GetRegDataCommand(String node, String key, String value, int dataType) {
        this(node, key, value);
        this.m_data.setDataType(dataType);
    }

    public RegistryKeyData getDataObject() {
        return this.m_data;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of GetRegDataCommand");
        try {
            this.nativeSystem.regGetData(this.m_destNode, this.m_key, this.m_value, this.m_data, this.m_result);
        }
        catch (Exception e) {
            Trace.out("GetRegDataCommand.execute:Exception calling native system");
            this.m_result.setStatus(false);
            this.m_result.setResultString(e.getMessage());
        }
        return this.m_result.getStatus();
    }
}

