/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.node;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import oracle.cluster.resources.PrCnMsgID;
import oracle.cluster.util.PortException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class PortAvailableCommand
extends Command {
    private String[] m_nodeList = null;
    private int m_port;
    private int m_timeout = -1;

    public PortAvailableCommand(String[] nodeList, int port, int timeout) {
        Trace.out("New PortAvailableCommand: nodeList=" + nodeList.toString() + "; port=" + port + "; timeout=" + timeout);
        this.m_nodeList = nodeList;
        this.m_port = port;
        this.m_timeout = this.m_nodeList == null || this.m_nodeList.length == 0 ? timeout : timeout / this.m_nodeList.length;
    }

    public PortAvailableCommand(String[] nodeList, int port) {
        Trace.out("New PortAvailableCommand: nodeList=" + nodeList.toString() + "; port=" + port);
        this.m_nodeList = nodeList;
        this.m_port = port;
    }

    public PortAvailableCommand(int port, int timeout) {
        this.m_port = port;
        this.m_timeout = timeout;
    }

    public PortAvailableCommand(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        try {
            new InetSocketAddress(this.m_port);
        }
        catch (IllegalArgumentException iae) {
            this.commandResult = new CommandResult();
            this.commandResult.setStatus(false);
            this.commandResult.setException(new PortException((MessageKey)PrCnMsgID.PORT_OUT_OF_RANGE, (Throwable)iae, String.valueOf(this.m_port)));
            return false;
        }
        boolean isAvailable = true;
        this.commandResult = new CommandResult();
        Socket soc = null;
        StringBuilder nodelist = new StringBuilder();
        StringBuilder nodelistNA = new StringBuilder();
        boolean isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
        if (this.m_nodeList != null && this.m_nodeList.length > 0) {
            int i;
            for (i = 0; i < this.m_nodeList.length; ++i) {
                if (nodelist.length() > 0) {
                    nodelist.append(" " + this.m_nodeList[i]);
                    continue;
                }
                nodelist.append(this.m_nodeList[i]);
            }
            Trace.out("Check port on node(s): " + nodelist.toString());
            for (i = 0; i < this.m_nodeList.length; ++i) {
                try {
                    InetSocketAddress isocAddr;
                    if (!isUnixSystem) {
                        isocAddr = this.createSocketAddressViaDNS(this.m_nodeList[i], this.m_port);
                        if (isocAddr == null) {
                            Trace.out("Unable to find an IP address via DNS for host name" + this.m_nodeList[i]);
                            try {
                                String ipAddress = InetAddress.getByName(this.m_nodeList[i]).getHostAddress();
                                Trace.out("Using InetAddress.getByName() the IP address that is used to create the socket address is: " + ipAddress);
                                isocAddr = new InetSocketAddress(ipAddress, this.m_port);
                            }
                            catch (UnknownHostException uhe) {
                                Trace.out("Unable to find an IP address via InetAddress.getByName() for host name" + this.m_nodeList[i]);
                                try {
                                    InetAddress hostInetAddress = InetAddress.getByName(this.m_nodeList[i]);
                                    String fqdn = hostInetAddress.getCanonicalHostName();
                                    isocAddr = new InetSocketAddress(fqdn, this.m_port);
                                }
                                catch (UnknownHostException uhe2) {
                                    Trace.out("Unable to construct the FQDN for host name" + this.m_nodeList[i] + ". Using the name host name itself to create the socket address");
                                    isocAddr = new InetSocketAddress(this.m_nodeList[i], this.m_port);
                                }
                            }
                        }
                    } else {
                        isocAddr = new InetSocketAddress(this.m_nodeList[i], this.m_port);
                    }
                    soc = new Socket();
                    if (this.m_timeout < 0) {
                        soc.connect(isocAddr);
                    } else {
                        soc.connect(isocAddr, this.m_timeout);
                    }
                    isAvailable = false;
                    Trace.out("Port " + this.m_port + " is not available on node " + this.m_nodeList[i]);
                    if (nodelistNA.length() > 0) {
                        nodelistNA.append(",").append(this.m_nodeList[i]);
                        continue;
                    }
                    nodelistNA.append(this.m_nodeList[i]);
                    continue;
                }
                catch (IOException e) {
                    Trace.out("Port " + this.m_port + " is available on node " + this.m_nodeList[i]);
                    continue;
                }
                finally {
                    if (soc != null) {
                        try {
                            soc.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            String localNodeName = null;
            try {
                InetSocketAddress isocAddr;
                InetAddress inetaddr = InetAddress.getLocalHost();
                localNodeName = inetaddr.getHostName();
                Trace.out("localNodeName = " + localNodeName);
                if (!isUnixSystem) {
                    isocAddr = this.createSocketAddressViaDNS(localNodeName, this.m_port);
                    if (isocAddr == null) {
                        isocAddr = new InetSocketAddress(this.m_port);
                    }
                } else {
                    isocAddr = new InetSocketAddress(this.m_port);
                }
                soc = new Socket();
                if (this.m_timeout < 0) {
                    soc.connect(isocAddr);
                } else {
                    soc.connect(isocAddr, this.m_timeout);
                }
                isAvailable = false;
                nodelistNA.append(localNodeName);
                Trace.out("Port " + this.m_port + " is not available on node " + localNodeName);
            }
            catch (IOException e) {
                Trace.out("Port " + this.m_port + " is available on node " + localNodeName);
            }
            finally {
                if (soc != null) {
                    try {
                        soc.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.commandResult.setStatus(isAvailable);
        if (!this.commandResult.getStatus()) {
            if (nodelistNA.length() == 0) {
                this.commandResult.setException(new PortException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE, String.valueOf(this.m_port)));
            } else {
                this.commandResult.setException(new PortException((MessageKey)PrCnMsgID.PORT_NOT_AVAILABLE_ACROSS_NODES, String.valueOf(this.m_port), nodelistNA.toString()));
            }
        }
        return this.commandResult.getStatus();
    }

    private InetSocketAddress createSocketAddressViaDNS(String hostname, int port) {
        try {
            List<String> ipAddresses = IPAddressUtil.getIPAddressesUsingDNSLookup(hostname);
            if (ipAddresses != null && !ipAddresses.isEmpty()) {
                Trace.out("Created InetSocketAddress for host IP adress =" + ipAddresses.get(0));
                return new InetSocketAddress(ipAddresses.get(0), port);
            }
            Trace.out("Host name \"" + hostname + "\" does not resolve to an IP address");
            return null;
        }
        catch (IPAddressException ipae) {
            Trace.out("Error resolving the host name \"" + hostname + "\" in DNS:" + ipae.getMessage());
            return null;
        }
    }
}

