/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.node;

import java.util.Iterator;
import oracle.ops.mgmt.cluster.NodeLivenessEvent;
import oracle.ops.mgmt.cluster.NodeLivenessListener;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class NodeLivenessCommand
extends Command {
    private String m_node;
    private int m_timeout;
    private NodeLivenessListener m_listener;

    public NodeLivenessCommand(String node, int timeout, NodeLivenessListener listener) {
        this.m_node = node;
        this.m_timeout = timeout;
        this.m_listener = listener;
        this.addListener(this.m_listener);
    }

    @Override
    public boolean execute() {
        this.commandResult = new CommandResult();
        this.nativeSystem.isNodeAlive(this.m_node, this.m_timeout, this.commandResult);
        if (this.commandResult.getStatus()) {
            NodeLivenessEvent evt = new NodeLivenessEvent(this, this.commandResult);
            this.postEvent(evt);
        }
        this.removeListener(this.m_listener);
        return this.commandResult.getStatus();
    }

    protected void postEvent(NodeLivenessEvent event) {
        Trace.out("Inside NodeLivenessCommand.postEvent, listener size=" + this.m_cmdListeners.size());
        Iterator listeners = this.m_cmdListeners.iterator();
        while (listeners.hasNext()) {
            ((NodeLivenessListener)listeners.next()).updateStatus(event);
        }
    }
}

