/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.listener;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;

public class StartListenerCommand
extends Command {
    private String nodeName;
    private String listenerName;
    private String oracleHome;
    private String OracleHomeName;

    public StartListenerCommand(String node, String listener, String oracleHome, String oracleHomeName) {
        this.nodeName = node;
        this.listenerName = listener;
        this.oracleHome = oracleHome;
        this.OracleHomeName = oracleHomeName;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of StartListenerCommand");
        String ret = null;
        try {
            ret = this.nativeSystem.startListener(this.nodeName, this.listenerName, this.oracleHome, this.OracleHomeName);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            Trace.out("StartListenerCommand.execute:Exception calling native system");
        }
        if (ret == null) {
            Trace.out("StartListenerCommand: Result is null");
            return false;
        }
        Trace.out("StartListenerCommand: Before calling CommandResult");
        this.commandResult = new CommandResult(ret);
        if (this.commandResult == null) {
            Trace.out("StartListenerCommand:CommandResult is null");
            return false;
        }
        return this.commandResult.getStatus();
    }
}

