/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.FileCommand;
import oracle.ops.mgmt.trace.Trace;

public class RemoveCommand
extends FileCommand {
    private String temp1;

    public RemoveCommand(String node, String file) {
        this.destNode = node;
        this.destFile = file;
    }

    @Override
    public boolean execute() {
        Trace.out("In Execute function of RemoveCommand");
        try {
            String ret = this.nativeSystem.removeFile(this.destNode, this.destFile);
            Trace.out(" Execute Message returned: " + ret);
            this.setResultInfo(ret, null);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            this.setResultInfo(null, e);
            Trace.out("RemoveCommand.execute:Exception occured while calling native system");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }

    @Override
    public boolean abort() {
        try {
            String ret = this.nativeSystem.removeFile(this.destNode, this.temp1);
            Trace.out("Abort Message returned: " + ret);
            this.setResultInfo(ret, null);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            this.setResultInfo(null, e);
            Trace.out("RemoveCommand.abort:Exception occured while calling native system");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }

    @Override
    public boolean commit() {
        try {
            String ret = this.nativeSystem.removeFile(this.destNode, this.temp1);
            Trace.out("Commit Message returned: " + ret);
            ret = null;
            String ret1 = this.nativeSystem.removeFile(this.destNode, this.destFile);
            this.setResultInfo(ret1, null);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            this.setResultInfo(null, e);
            Trace.out("RemoveCommand.commit:Exception occured while calling native system");
        }
        if (this.commandResult == null) {
            return false;
        }
        return this.commandResult.getStatus();
    }

    @Override
    public boolean prepare() {
        this.temp1 = this.destFile + ".tmp1" + this.getOwnerThread().getName();
        String ret = null;
        try {
            ret = this.nativeSystem.copyFile(this.destNode, this.destFile, this.destNode, this.temp1);
            Trace.out("Prepare Message returned: " + ret);
            this.setResultInfo(ret, null);
            this.getStatusLogger().log((Command)this, ret);
        }
        catch (Exception e) {
            this.setResultInfo(null, e);
            Trace.out("RemoveCommand.commit:Exception occured while calling native system");
        }
        if (this.commandResult == null) {
            return false;
        }
        Trace.out("RemoveCommand:Finished Prepare Phase: return String" + ret);
        return this.commandResult.getStatus();
    }

    private void setResultInfo(String ret, Exception e) {
        if (e != null) {
            this.commandResult = new CommandResult("0|" + e.getMessage());
            this.commandResult.setException(e);
            this.commandResult.setNodeName(this.destNode);
        } else if (ret != null) {
            this.commandResult = new CommandResult(ret);
            this.commandResult.setNodeName(this.destNode);
        }
    }
}

