/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.file;

import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class IsCFSCheckFileCommand
extends Command {
    protected String m_node;
    protected String m_localNode;
    protected String m_path;
    protected String m_fileName;
    protected Constants.CFS_OP_TYPE m_opType;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");

    public IsCFSCheckFileCommand(String node, String path, String fileName, Constants.CFS_OP_TYPE opType, String localNode) throws ClusterException {
        block6: {
            block5: {
                this.m_node = node;
                this.m_path = path;
                this.m_fileName = fileName;
                this.m_localNode = localNode;
                this.commandResult = new CommandResult();
                this.commandResult.setNodeName(this.m_node);
                if (!node.equalsIgnoreCase(this.m_localNode)) break block5;
                switch (opType) {
                    case FILE_WRITE: {
                        Trace.out("Performing Write phase");
                        this.m_opType = Constants.CFS_OP_TYPE.FILE_WRITE_LOCAL;
                        break block6;
                    }
                    case FILE_LIST: {
                        Trace.out("Performing Write phase");
                        this.m_opType = Constants.CFS_OP_TYPE.FILE_LIST_LOCAL;
                        break block6;
                    }
                    case FILE_DEL: {
                        Trace.out("Performing Write phase");
                        this.m_opType = Constants.CFS_OP_TYPE.FILE_DEL_LOCAL;
                        break block6;
                    }
                    default: {
                        Trace.out("Invalid Operation type supplied");
                        throw new ClusterException(s_msgBundle.getMessage("1179", true, new String[]{"opType"}));
                    }
                }
            }
            this.m_opType = opType;
        }
    }

    @Override
    public boolean execute() {
        try {
            Trace.out(5, "Checking path: '" + this.m_path + "' on node: '" + this.m_node + "'");
            this.nativeSystem.checkCFSPath(this.m_node, this.m_path, this.m_fileName, this.m_opType, this.commandResult);
        }
        catch (RemoteShellException rse) {
            Trace.out("REMOTESHELLEXCEPTION: " + rse.getMessage());
            this.commandResult.setException(rse);
            this.commandResult.setStatus(false);
            return false;
        }
        return this.commandResult.getStatus();
    }
}

