/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.command.crs;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.trace.Trace;

public class CRSConfigCommand
extends Command {
    private Version m_version;

    public CRSConfigCommand(String node, Version version) {
        this.m_node = node;
        this.m_version = version;
    }

    public CRSConfigCommand(String node) {
        this.m_node = node;
        this.m_version = new Version();
    }

    @Override
    public boolean execute() {
        try {
            boolean retVal = this.nativeSystem.isCRSConfigured(this.m_node, this.m_version);
            this.commandResult = new CommandResult();
            this.commandResult.setStatus(retVal);
            Trace.out("CRS Configured = " + retVal + " on node: " + this.m_node);
        }
        catch (NativeException ne) {
            this.commandResult = new CommandResult();
            this.commandResult.setStatus(false);
            this.commandResult.setException(ne);
        }
        return this.commandResult.getStatus();
    }
}

