/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.synchronize.SyncBuffer;
import oracle.ops.mgmt.trace.Trace;

class CommandBuffer
extends SyncBuffer {
    CommandBuffer(int capacity) {
        super(capacity);
    }

    protected Command[] getAllCommands() {
        Object[] object = super.getAll();
        Command[] commandObject = new Command[object.length];
        for (int i = 0; i < commandObject.length; ++i) {
            try {
                commandObject[i] = (Command)object[i];
                continue;
            }
            catch (ClassCastException e) {
                Trace.out("Caught classcast exception");
                return null;
            }
        }
        return commandObject;
    }

    protected synchronized boolean checkCommandStatus() {
        Object[] commandArray = null;
        try {
            commandArray = this.read();
        }
        catch (Exception e) {
            Trace.out(e);
            return false;
        }
        if (commandArray != null) {
            for (int i = 0; i < commandArray.length; ++i) {
                if (commandArray[i] == null) continue;
                if (!((Command)commandArray[i]).getOwnerThread().equals(Thread.currentThread())) {
                    Trace.out("ERROR......THIS IS NOT MY COMMAND");
                    continue;
                }
                if (((Command)commandArray[i]).getCommand().getStatus()) continue;
                Trace.out("CommandBuffer:checkCommandStatus returning false, command number= " + i + " thread name= " + Thread.currentThread());
                return false;
            }
            return true;
        }
        Trace.out("Error...CommandBuffer:checkCommandStatus returning False..CommandArray is null");
        return false;
    }
}

