/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterBatch;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.ClusterRegistry;
import oracle.ops.mgmt.cluster.ClusterService;
import oracle.ops.mgmt.cluster.ClusterServiceOption;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.SetAclsCommand;
import oracle.ops.mgmt.command.registry.CreateRegKeyCommand;
import oracle.ops.mgmt.command.registry.DeleteRegKeyCommand;
import oracle.ops.mgmt.command.registry.DeleteRegValueCommand;
import oracle.ops.mgmt.command.registry.ExistsRegKeyCommand;
import oracle.ops.mgmt.command.registry.GetRegDataCommand;
import oracle.ops.mgmt.command.registry.GetRegSubKeyCommand;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.registry.RegistryNativeResult;
import oracle.ops.mgmt.command.registry.SetRegValueCommand;
import oracle.ops.mgmt.command.service.CheckServiceCommand;
import oracle.ops.mgmt.command.service.CreateServiceCommand;
import oracle.ops.mgmt.command.service.CreateServiceDepCommand;
import oracle.ops.mgmt.command.service.DeleteServiceCommand;
import oracle.ops.mgmt.command.service.QueryServiceDepCommand;
import oracle.ops.mgmt.command.service.RemoveServiceDepCommand;
import oracle.ops.mgmt.command.service.StartServiceCommand;
import oracle.ops.mgmt.command.service.StopServiceCommand;
import oracle.ops.mgmt.command.util.GetEnvVarCommand;
import oracle.ops.mgmt.command.util.GetWinDomainCommand;
import oracle.ops.mgmt.command.util.RebootNodeCommand;
import oracle.ops.mgmt.command.util.RegisterOCXCommand;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.command.util.ResolvePathCommand;
import oracle.ops.mgmt.command.util.UpdateEnvCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.WindowsSystem;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ClusterWindows
implements Constants {
    public static final int AUTO = 2;
    public static final int MANUAL = 1;
    public static final int BATCH = 3;
    public static final int BLOCKING = 4;
    public static final int SERVICE_STOPPED = 3;
    public static final int SERVICE_START_PENDING = 4;
    public static final int SERVICE_STOP_PENDING = 5;
    public static final int SERVICE_RUNNING = 6;
    public static final int SERVICE_CONTINUE_PENDING = 7;
    public static final int SERVICE_PAUSE_PENDING = 8;
    public static final int SERVICE_PAUSED = 9;
    public static final int SERVICE_STATE_DIFFERENT = 10;
    public static final int SERVICE_INVALID = 0;
    private final String m_windowsGlobalRootpattern = "\\\\.\\";
    private int m_mode = 4;
    private boolean m_isBlocking = true;
    private int m_commandCount = 0;
    private int m_noOfNodes;
    private String m_localNode = null;
    private GetActiveNodes m_activeNodes = null;
    private ClusterService clusterService;
    private ClusterConfig clusterConfig;
    private ClusterServiceOption m_clusterService = null;
    private ClusterRegistry m_clusterRegistry = null;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");

    public ClusterWindows(int m) throws ClusterException {
        this.m_mode = m;
        if (this.m_mode == 3) {
            this.clusterService = new ClusterBatch();
            this.m_clusterRegistry = new ClusterRegistry();
        } else if (this.m_mode == 4) {
            this.m_isBlocking = true;
            this.clusterService = ClusterConfig.init();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public ClusterWindows() throws ClusterException {
        this(4);
    }

    public void createRegKeyCluster(String key, String subKey) throws ClusterException {
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += this.m_noOfNodes;
        }
        this.m_clusterRegistry.createRegKeyCluster(key, subKey, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void createRegKeyOnNodes(String key, String subKey, String[] nodeNames) throws ClusterException {
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        this.m_clusterRegistry.createRegKeyOnNodes(key, subKey, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void createRegKeyOnNode(String key, String subKey) throws ClusterException {
        this.createRegKeyOnNode(key, subKey, "localnode");
    }

    public void createRegKeyOnNode(String key, String subKey, String nodeName) throws ClusterException {
        String node;
        ClusterCmd.assertNode(nodeName);
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{node};
            this.createRegKeyOnNodes(key, subKey, nodeNames);
        } else {
            CreateRegKeyCommand command = new CreateRegKeyCommand(node, key, subKey);
            Trace.out("CreateRegKeyCommand status=" + command.execute());
            RegistryNativeResult result = command.getResultObject();
            if (!result.getStatus()) {
                Object[] args = new String[]{subKey, key, nodeName, result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1116", true, args));
            }
        }
    }

    public String[] getRegSubKey(String key) throws ClusterException {
        return this.getRegSubKey(key, "localnode");
    }

    public Map<String, List<String>> getServices4ImagePath(String[] nodeNames, String imagePath) throws ClusterException, ClusterOperationException {
        this.m_clusterRegistry = new ClusterRegistry();
        HashMap<String, List<String>> rsltMap = this.m_clusterRegistry.getServices4ImagePath(nodeNames, imagePath, true);
        this.m_clusterRegistry.destroy();
        return rsltMap;
    }

    public String[] getRegSubKey(String key, String nodeName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertKey(key, false);
        String node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        GetRegSubKeyCommand command = new GetRegSubKeyCommand(node, key);
        Trace.out("getRegSubKey status = " + command.execute());
        RegistryNativeResult nativeResult = command.getResultObject();
        if (!nativeResult.getStatus()) {
            Object[] args = node != null ? new String[]{key, nodeName, nativeResult.getOSString()} : new String[]{key, nativeResult.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage(node != null ? "1070" : "1069", true, args));
        }
        RegistryKeyData regKeyData = command.getDataObject();
        String[] result = regKeyData.getStringArrayData();
        if (result == null) {
            result = new String[]{};
        }
        return result;
    }

    public void deleteRegKeyRecursiveOnNode(String key, String nodeName) throws ClusterException {
        String[] subkeys = this.getRegSubKey(key, nodeName);
        for (int i = 0; i < subkeys.length; ++i) {
            this.deleteRegKeyRecursiveOnNode(key + "\\" + subkeys[i], nodeName);
        }
        int indexOfBackslash = key.indexOf("\\");
        if (indexOfBackslash != -1) {
            String keyPart = key.substring(0, indexOfBackslash);
            String subkeyPart = key.substring(indexOfBackslash + 1).trim();
            this.deleteRegKeyOnNode(keyPart, subkeyPart, nodeName);
        }
    }

    public void deleteRegRecursiveOnNodes(String key, String[] nodeNames) throws ClusterException {
        if (nodeNames != null) {
            for (int i = 0; i < nodeNames.length; ++i) {
                this.deleteRegKeyRecursiveOnNode(key, nodeNames[i]);
            }
        }
    }

    public void deleteRegKeyCluster(String key, String subKey) throws ClusterException {
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertKey(subKey, true);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += this.m_noOfNodes;
        }
        this.m_clusterRegistry.deleteRegKeyCluster(key, subKey, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void deleteRegKeyOnNodes(String key, String subKey, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertKey(subKey, true);
        ClusterCmd.assertNodes(nodeNames);
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        this.m_clusterRegistry.deleteRegKeyOnNodes(key, subKey, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void deleteRegKeyOnNode(String key, String subKey) throws ClusterException {
        this.deleteRegKeyOnNode(key, subKey, "localnode");
    }

    public void deleteRegKeyOnNode(String key, String subKey, String nodeName) throws ClusterException {
        String node;
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertKey(subKey, true);
        ClusterCmd.assertNode(nodeName);
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            this.deleteRegKeyOnNodes(key, subKey, new String[]{node});
        } else {
            DeleteRegKeyCommand command = new DeleteRegKeyCommand(node, key, subKey);
            Trace.out("DeleteRegKeyCommand status = " + command.execute());
            RegistryNativeResult result = command.getResultObject();
            if (!result.getStatus()) {
                Object[] args = new String[]{subKey, key, nodeName, result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1117", true, args));
            }
        }
    }

    public void setRegValueCluster(String key, String value, String data) throws ClusterException {
        this.setRegValueCluster(key, value, data, false);
    }

    public void setRegValueCluster(String key, String value, String data, boolean expand) throws ClusterException {
        Object[] keyData = new Object[]{data};
        if (expand) {
            this.setRegValueCluster(key, value, keyData, 14);
        } else {
            this.setRegValueCluster(key, value, keyData, 10);
        }
    }

    public void setRegValueCluster(String key, String value, Integer data) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueCluster(key, value, keyData, 12);
    }

    public void setRegValueCluster(String key, String value, Byte data) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueCluster(key, value, keyData, 13);
    }

    public void setRegValueCluster(String key, String value, String[] data) throws ClusterException {
        this.setRegValueCluster(key, value, data, 11);
    }

    protected void setRegValueCluster(String key, String value, Object[] data, int dataType) throws ClusterException {
        Trace.out("Setting value/data for registry key (" + key + ")");
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += this.m_noOfNodes;
        }
        this.m_clusterRegistry.setRegValueCluster(key, value, data, dataType, this.m_isBlocking);
        Trace.out("Registry key value/data is set");
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void setRegValueOnNodes(String key, String value, String data, String[] nodeNames) throws ClusterException {
        this.setRegValueOnNodes(key, value, data, false, nodeNames);
    }

    public void setRegValueOnNodes(String key, String value, String data, boolean expand, String[] nodeNames) throws ClusterException {
        Object[] keyData = new Object[]{data};
        if (expand) {
            this.setRegValueOnNodes(key, value, keyData, 14, nodeNames);
        } else {
            this.setRegValueOnNodes(key, value, keyData, 10, nodeNames);
        }
    }

    public void setRegValueOnNodes(String key, String value, Integer data, String[] nodeNames) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNodes(key, value, keyData, 12, nodeNames);
    }

    public void setRegValueOnNodes(String key, String value, Byte data, String[] nodeNames) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNodes(key, value, keyData, 13, nodeNames);
    }

    public void setRegValueOnNodes(String key, String value, String[] data, String[] nodeNames) throws ClusterException {
        this.setRegValueOnNodes(key, value, data, 11, nodeNames);
    }

    protected void setRegValueOnNodes(String key, String value, Object[] data, int dataType, String[] nodeNames) throws ClusterException {
        Trace.out("Setting value/data for registry key (" + key + ")");
        ClusterCmd.assertNodes(nodeNames);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        this.m_clusterRegistry.setRegValueOnNodes(key, value, data, dataType, nodeNames, this.m_isBlocking);
        Trace.out("Registry key value/data is now set");
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void setRegValueOnNode(String key, String value, String data, String nodeName) throws ClusterException {
        this.setRegValueOnNode(key, value, data, false, nodeName);
    }

    public void setRegValueOnNode(String key, String value, String data, boolean expand, String nodeName) throws ClusterException {
        Object[] keyData = new Object[]{data};
        if (expand) {
            this.setRegValueOnNode(key, value, keyData, 14, nodeName);
        } else {
            this.setRegValueOnNode(key, value, keyData, 10, nodeName);
        }
    }

    public void setRegValueOnNode(String key, String value, Integer data, String nodeName) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNode(key, value, keyData, 12, nodeName);
    }

    public void setRegValueOnNode(String key, String value, Byte data, String nodeName) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNode(key, value, keyData, 13, nodeName);
    }

    public void setRegValueOnNode(String key, String value, String[] data, String nodeName) throws ClusterException {
        this.setRegValueOnNode(key, value, data, 11, nodeName);
    }

    protected void setRegValueOnNode(String key, String value, Object[] data, int dataType, String nodeName) throws ClusterException {
        String node;
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            this.setRegValueOnNodes(key, value, data, dataType, new String[]{node});
        } else {
            if (data == null || data.length == 0) {
                Object[] args = new String[]{key};
                throw new ClusterException(s_msgBundle.getMessage("1051", true, args));
            }
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != null) continue;
                Object[] args = new String[]{key};
                throw new ClusterException(s_msgBundle.getMessage("1051", true, args));
            }
            SetRegValueCommand command = new SetRegValueCommand(node, key, value);
            RegistryKeyData keyData = command.getDataObject();
            keyData.setDataType(dataType);
            switch (dataType) {
                case 12: {
                    keyData.setData((Integer)data[0]);
                    break;
                }
                case 10: 
                case 14: {
                    keyData.setData((String)data[0]);
                    break;
                }
                case 13: {
                    keyData.setData((Byte)data[0]);
                    break;
                }
                case 11: {
                    keyData.setData((String[])data);
                }
            }
            Trace.out("SetRegValueCommand status = " + command.execute());
            RegistryNativeResult resultObj = command.getResultObject();
            if (!resultObj.getStatus()) {
                Object[] args = new String[]{value, key, nodeName, resultObj.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1119", true, args));
            }
        }
    }

    public void setRegValueOnNode(String key, String value, String data) throws ClusterException {
        this.setRegValueOnNode(key, value, data, false);
    }

    public void setRegValueOnNode(String key, String value, String data, boolean expand) throws ClusterException {
        Object[] keyData = new Object[]{data};
        if (expand) {
            this.setRegValueOnNode(key, value, keyData, 14, "localnode");
        } else {
            this.setRegValueOnNode(key, value, keyData, 10, "localnode");
        }
    }

    public void setRegValueOnNode(String key, String value, Integer data) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNode(key, value, keyData, 12, "localnode");
    }

    public void setRegValueOnNode(String key, String value, Byte data) throws ClusterException {
        Object[] keyData = new Object[]{data};
        this.setRegValueOnNode(key, value, keyData, 13, "localnode");
    }

    public void setRegValueOnNode(String key, String value, String[] data) throws ClusterException {
        this.setRegValueOnNode(key, value, data, 11, "localnode");
    }

    public void deleteRegValueCluster(String key, String value) throws ClusterException {
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += this.m_noOfNodes;
        }
        this.m_clusterRegistry.deleteRegValueCluster(key, value, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void deleteRegValueOnNodes(String key, String value, String[] nodeNames) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        this.m_clusterRegistry.deleteRegValueOnNodes(key, value, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
    }

    public void deleteRegValueOnNode(String key, String value, String nodeName) throws ClusterException {
        String node;
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            this.deleteRegValueOnNodes(key, value, new String[]{node});
        } else {
            DeleteRegValueCommand command = new DeleteRegValueCommand(node, key, value);
            Trace.out("DeleteRegValueCommand status = " + command.execute());
            RegistryNativeResult resultObj = command.getResultObject();
            if (!resultObj.getStatus()) {
                Object[] args = new String[]{value, key, node, resultObj.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1121", true, args));
            }
        }
    }

    public void deleteRegValueOnNode(String key, String value) throws ClusterException {
        this.deleteRegValueOnNode(key, value, "localnode");
    }

    public String[] getRegDataOnNode(String key, String value, String nodeName) throws ClusterException {
        String data = this.getRegStringDataOnNode(key, value, nodeName);
        String[] result = new String[]{data};
        return result;
    }

    public String getRegStringDataOnNode(String key, String value, String nodeName) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 10, nodeName);
        if (result != null && result.length > 0) {
            return (String)result[0];
        }
        return null;
    }

    public Integer getRegIntegerDataOnNode(String key, String value, String nodeName) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 12, nodeName);
        if (result != null && result.length > 0) {
            return (Integer)result[0];
        }
        return null;
    }

    public Byte getRegBinaryDataOnNode(String key, String value, String nodeName) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 13, nodeName);
        if (result != null && result.length > 0) {
            return (Byte)result[0];
        }
        return null;
    }

    public String[] getRegStringArrayDataOnNode(String key, String value, String nodeName) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 11, nodeName);
        if (result != null) {
            return (String[])result;
        }
        return null;
    }

    protected Object[] getRegDataOnNode(String key, String value, int dataType, String nodeName) throws ClusterException {
        String node;
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        Object[] resultObj = null;
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            ++this.m_commandCount;
            resultObj = this.m_clusterRegistry.getRegDataOnNode(key, value, dataType, node, this.m_isBlocking);
        } else {
            GetRegDataCommand command = new GetRegDataCommand(node, key, value, dataType);
            Trace.out("GetRegDataCommand status = " + command.execute());
            RegistryNativeResult result = command.getResultObject();
            if (!result.getStatus()) {
                Object[] args = new String[]{value, key, nodeName, result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1120", true, args));
            }
            Trace.out("Registry key data obtained successfully");
            RegistryKeyData regKeyData = command.getDataObject();
            switch (dataType) {
                case 10: 
                case 14: {
                    resultObj = new Object[]{regKeyData.getStringData()};
                    break;
                }
                case 12: {
                    resultObj = new Object[]{regKeyData.getIntegerData()};
                    break;
                }
                case 13: {
                    resultObj = new Object[]{regKeyData.getBinaryData()};
                    break;
                }
                case 11: {
                    resultObj = new Object[1];
                    resultObj = regKeyData.getStringArrayData();
                    break;
                }
                default: {
                    Trace.out("Invalid data type");
                }
            }
        }
        return resultObj;
    }

    public String[] getRegDataOnNode(String key, String value) throws ClusterException {
        String data = this.getRegStringDataOnNode(key, value);
        String[] result = new String[]{data};
        return result;
    }

    public String getRegStringDataOnNode(String key, String value) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 10, "localnode");
        if (result != null && result.length > 0) {
            return (String)result[0];
        }
        return null;
    }

    public Integer getRegIntegerDataOnNode(String key, String value) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 12, "localnode");
        if (result != null && result.length > 0) {
            return (Integer)result[0];
        }
        return null;
    }

    public Byte getRegBinaryDataOnNode(String key, String value) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 13, "localnode");
        if (result != null && result.length > 0) {
            return (Byte)result[0];
        }
        return null;
    }

    public String[] getRegStringArrayDataOnNode(String key, String value) throws ClusterException {
        Object[] result = this.getRegDataOnNode(key, value, 11, "localnode");
        return (String[])result;
    }

    public boolean regKeyExistsOnNode(String key) throws ClusterException {
        return this.regKeyExistsOnNode(key, "localnode");
    }

    public boolean regKeyExistsOnNode(String key, String nodeName) throws ClusterException {
        String node;
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        String string = node = "localnode".equalsIgnoreCase(nodeName) ? null : nodeName;
        if (this.m_mode == 3) {
            return this.regKeyExistsOnNodes(key, new String[]{node});
        }
        ExistsRegKeyCommand command = new ExistsRegKeyCommand(node, key);
        Trace.out("ExistsRegKeyCommand status = " + command.execute());
        RegistryNativeResult result = command.getResultObject();
        if (!result.getStatus()) {
            Object[] args = new String[]{key, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1118", true, args));
        }
        return command.getKeyExists();
    }

    public boolean regKeyExistsOnNodes(String key, String[] nodeNames) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterWindows.assertKey(key, false);
        ClusterWindows.assertValidKey(key);
        if (this.m_mode == 4) {
            this.m_clusterRegistry = new ClusterRegistry();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        boolean keyExists = this.m_clusterRegistry.existsRegKeyOnNodes(key, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterRegistry.destroy();
        }
        return keyExists;
    }

    public void createServiceDepCluster(String serviceName, String[] dependencyList) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        this.m_clusterService.createServiceDepCluster(serviceName, dependencyList, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
    }

    public void createServiceDepOnNodes(String serviceName, String[] dependencyList, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        this.m_clusterService.createServiceDepOnNodes(serviceName, dependencyList, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
    }

    public void createServiceDepOnNode(String serviceName, String[] dependencyList, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            this.createServiceDepOnNodes(serviceName, dependencyList, nodeNames);
        } else {
            CreateServiceDepCommand command = new CreateServiceDepCommand(serviceName, dependencyList, nodeName);
            Trace.out("CreateServiceDepCommand status = " + command.execute());
            CommandResult result = command.getCommandResult();
            if (!result.getStatus()) {
                Object[] args = new String[]{serviceName, Utils.getString(dependencyList, ","), nodeName, result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1124", true, args));
            }
        }
    }

    public void createServiceDepOnNode(String serviceName, String[] dependencyList) throws ClusterException {
        this.createServiceDepOnNode(serviceName, dependencyList, "localnode");
    }

    public void removeServiceDepCluster(String serviceName, String[] dependencyList) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertServiceDep(serviceName, dependencyList);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        this.m_clusterService.removeServiceDepCluster(serviceName, dependencyList, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
    }

    public void removeServiceDepOnNodes(String serviceName, String[] dependencyList, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        ClusterWindows.assertServiceDep(serviceName, dependencyList);
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        this.m_clusterService.removeServiceDepOnNodes(serviceName, dependencyList, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
    }

    public void removeServiceDepOnNode(String serviceName, String[] dependencyList, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        ClusterWindows.assertServiceDep(serviceName, dependencyList);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            this.removeServiceDepOnNodes(serviceName, dependencyList, nodeNames);
        } else {
            RemoveServiceDepCommand command = new RemoveServiceDepCommand(serviceName, dependencyList, nodeName);
            Trace.out("RemoveServiceDepCommand status = " + command.execute());
            CommandResult result = command.getCommandResult();
            if (!result.getStatus()) {
                Object[] args = new String[]{serviceName, Utils.getString(dependencyList, ","), nodeName, result.getOSString()};
                throw new ClusterException(s_msgBundle.getMessage("1134", true, args));
            }
        }
    }

    public void removeServiceDepOnNode(String serviceName, String[] dependencyList) throws ClusterException {
        this.removeServiceDepOnNode(serviceName, dependencyList, "localnode");
    }

    public Map<String, String[]> queryServiceDepCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        this.createGetActiveNodes();
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        Map<String, String[]> depList = this.m_clusterService.queryServiceDepCluster(serviceName, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
        return depList;
    }

    public Map<String, String[]> queryServiceDepOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        if (this.m_mode == 4) {
            this.m_clusterService = new ClusterServiceOption();
        }
        if (this.m_mode == 3) {
            this.m_commandCount += nodeNames.length;
        }
        Map<String, String[]> depList = this.m_clusterService.queryServiceDepOnNodes(serviceName, nodeNames, this.m_isBlocking);
        if (this.m_mode == 4) {
            this.m_clusterService.destroy();
        }
        return depList;
    }

    public String[] queryServiceDepOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            Map<String, String[]> depMap = this.queryServiceDepOnNodes(serviceName, nodeNames);
            return depMap.get(nodeName);
        }
        QueryServiceDepCommand command = new QueryServiceDepCommand(serviceName, nodeName);
        Trace.out("QueryServiceDepCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkn");
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(msgBundle.getMessage("1022", true, args));
        }
        String existingDep = result.getResultString()[0];
        Trace.out("existingDep = " + existingDep);
        String[] depList = Utils.getStringArray(existingDep, ",");
        return depList;
    }

    public String[] queryServiceDepOnNode(String serviceName) throws ClusterException {
        return this.queryServiceDepOnNode(serviceName, "localnode");
    }

    public boolean startServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.startServiceCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean startServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        ClusterCmd.assertNodes(nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.startServiceOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean startServiceOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.startServiceOnNodes(serviceName, nodeNames);
        }
        Trace.out("Starting service on node:" + nodeName);
        StartServiceCommand command = new StartServiceCommand(serviceName, nodeName);
        Trace.out("StartServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1125", true, args));
        }
        return true;
    }

    private boolean checkServiceStatusOnNode(String serviceName, String nodeName, int state) throws ClusterException {
        CheckServiceCommand command = new CheckServiceCommand(serviceName, nodeName, state);
        Trace.out("CheckServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1138", true, args));
        }
        return command.isValidState();
    }

    public boolean checkServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.checkServiceOnNodes(serviceName, nodeNames);
        }
        return this.checkServiceStatusOnNode(serviceName, nodeName, 6);
    }

    public int getServiceStateCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        int result = this.clusterService.getServiceStateCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public int getServiceStateOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
        }
        int result = this.clusterService.getServiceStateOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public int getServiceStateOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.getServiceStateOnNodes(serviceName, nodeNames);
        }
        CheckServiceCommand command = new CheckServiceCommand(serviceName, nodeName, 11);
        Trace.out("CheckServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1138", true, args));
        }
        return command.getCurrentState();
    }

    public boolean checkServiceRunningCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceRunningCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceRunningOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceRunningOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceRunningOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.checkServiceRunningOnNodes(serviceName, nodeNames);
        }
        return this.checkServiceStatusOnNode(serviceName, nodeName, 6);
    }

    public boolean checkServiceStoppedCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceStoppedCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceStoppedOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceStoppedOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceStoppedOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.checkServiceStoppedOnNodes(serviceName, nodeNames);
        }
        return this.checkServiceStatusOnNode(serviceName, nodeName, 3);
    }

    public boolean checkServiceExistCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceExistCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceExistOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceExistOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.checkServiceExistOnNodes(serviceName, nodeNames);
        }
        return this.checkServiceStatusOnNode(serviceName, nodeName, 1);
    }

    public boolean checkServiceNotExistCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceNotExistCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceNotExistOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.checkServiceNotExistOnNodes(serviceName, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean checkServiceNotExistOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.checkServiceNotExistOnNodes(serviceName, nodeNames);
        }
        return this.checkServiceStatusOnNode(serviceName, nodeName, 2);
    }

    public boolean stopServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.stopServiceCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.stopServiceOnNodes(serviceName, nodeNames, true, false);
    }

    public boolean stopServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean bypassStopAttemptIfNotRunning) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.stopServiceOnNodes(serviceName, nodeNames, isBlocking, bypassStopAttemptIfNotRunning);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean stopServiceOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.stopServiceOnNodes(serviceName, nodeNames);
        }
        StopServiceCommand command = new StopServiceCommand(serviceName, nodeName);
        Trace.out("StopServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1126", true, args));
        }
        return true;
    }

    public boolean createServiceCluster(String serviceName, String exeLocation, int mode) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.createServiceCluster(serviceName, exeLocation, mode);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.createServiceOnNodes(serviceName, exeLocation, mode, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean createServiceOnNode(String serviceName, String exeLocation, int mode, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.createServiceOnNodes(serviceName, exeLocation, mode, nodeNames);
        }
        CreateServiceCommand command = new CreateServiceCommand(serviceName, exeLocation, mode, nodeName);
        Trace.out("CreateServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1123", true, args));
        }
        return true;
    }

    public boolean createServiceCluster(String serviceName, String exeLocation, int mode, String domainName, String userName, String password) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertUserName(userName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.createServiceCluster(serviceName, exeLocation, mode, domainName, userName, password);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean createServiceOnNodes(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String[] nodeNames) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertUserName(userName);
        ClusterCmd.assertNodes(nodeNames);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.createServiceOnNodes(serviceName, exeLocation, mode, domainName, userName, password, nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean createServiceOnNode(String serviceName, String exeLocation, int mode, String domainName, String userName, String password, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterWindows.assertUserName(userName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.createServiceOnNodes(serviceName, exeLocation, mode, domainName, userName, password, nodeNames);
        }
        CreateServiceCommand command = new CreateServiceCommand(serviceName, exeLocation, mode, domainName, userName, password, nodeName);
        Trace.out("CreateServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1123", true, args));
        }
        return true;
    }

    public boolean deleteServiceCluster(String serviceName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.deleteServiceCluster(serviceName);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames) throws ClusterException {
        return this.deleteServiceOnNodes(serviceName, nodeNames, true, false);
    }

    public boolean deleteServiceOnNodes(String serviceName, String[] nodeNames, boolean isBlocking, boolean ignoreNotExist) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        boolean result = false;
        ClusterCmd.assertNodes(nodeNames);
        if (isBlocking) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        result = this.clusterService.deleteServiceOnNodes(serviceName, nodeNames, isBlocking, ignoreNotExist);
        if (isBlocking) {
            this.clusterConfig.destroy();
        }
        return result;
    }

    public boolean deleteServiceOnNode(String serviceName, String nodeName) throws ClusterException {
        ClusterWindows.assertService(serviceName);
        ClusterCmd.assertNode(nodeName);
        if (this.m_mode == 3) {
            String[] nodeNames = new String[]{nodeName};
            return this.clusterService.deleteServiceOnNodes(serviceName, nodeNames);
        }
        DeleteServiceCommand command = new DeleteServiceCommand(serviceName, nodeName);
        Trace.out("DeleteServiceCommand status = " + command.execute());
        CommandResult result = command.getCommandResult();
        if (!result.getStatus()) {
            Object[] args = new String[]{serviceName, nodeName, result.getOSString()};
            throw new ClusterException(s_msgBundle.getMessage("1127", true, args));
        }
        return true;
    }

    public void Execute() {
        this.execute();
    }

    public void execute() {
        this.clusterService.execute();
        try {
            Trace.out("In ClusterWindows execute.");
            this.m_clusterRegistry.waitToCleanUp(this.m_commandCount);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_clusterRegistry.destroy();
        }
    }

    public static String getClusterServiceName(Version version) {
        if (Version.isPre10i(version)) {
            return "OracleCMService9i";
        }
        return "OracleCSService";
    }

    public static String getCRServiceName(Version version) throws ClusterException {
        if (!Version.isPre10i(version)) {
            return "OracleCRService";
        }
        Object[] args = new String[]{version.toString(), new Version().toString()};
        throw new ClusterException(MessageBundle.getMessageBundle("Prkc").getMessage("1049", true, args));
    }

    public static String getEVMServiceName(Version version) throws ClusterException {
        if (!Version.isPre10i(version)) {
            return "OracleEVMService";
        }
        Object[] args = new String[]{version.toString(), new Version().toString()};
        throw new ClusterException(MessageBundle.getMessageBundle("Prkc").getMessage("1050", true, args));
    }

    private void createGetActiveNodes() throws ClusterException {
        if (this.m_activeNodes == null) {
            this.m_activeNodes = GetActiveNodes.create();
        }
        this.m_noOfNodes = this.m_activeNodes.getNodeNumber();
        this.m_localNode = this.m_activeNodes.getNodeName();
    }

    public boolean stopRemoteExecServer(String[] nodeNames) throws ClusterException {
        if (this.m_mode == 4) {
            this.clusterConfig = ClusterConfig.init();
            this.clusterService = this.clusterConfig;
        }
        boolean ret = this.clusterService.stopServiceOnNodes("OracleRemExecServiceV2", nodeNames);
        if (this.m_mode == 4) {
            this.clusterConfig.destroy();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEnv(String[] nodeNames, String srcLoc) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(srcLoc, true);
        Command[] updateEnvCmds = new UpdateEnvCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            updateEnvCmds[i] = (UpdateEnvCommand)factory.CreateCommand(new UpdateEnvCommand(nodeNames[i], srcLoc), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            clusterConfig.submit(updateEnvCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        StringBuffer updateEnvFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        NativeResult[] results = new NativeResult[updateEnvCmds.length];
        for (int i = 0; i < updateEnvCmds.length; ++i) {
            results[i] = updateEnvCmds[i].getCommandResult();
            if (results[i].getStatus()) continue;
            if (updateEnvFailList != null) {
                updateEnvFailList.append("," + results[i].getNodeName());
            } else {
                updateEnvFailList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append(results[i].getOSString() + "\n");
        }
        if (updateEnvFailList != null) {
            Object[] args = new Object[]{updateEnvFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1090", args, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOCX(String[] nodeNames, String ocxFname, String wkdir, boolean bregisterFlag, String srcLoc) throws RemoteFileOperationException, ClusterException {
        int indexOfBin;
        Trace.out("Calling ClusterWindows.registerOCX() with:");
        if (nodeNames != null) {
            for (int i = 0; i < nodeNames.length; ++i) {
                Trace.out(" nodeNames[" + i + "]=" + nodeNames[i]);
            }
        } else {
            Trace.out("nodeNames -> null");
        }
        Trace.out(", ocxFname=" + ocxFname + ", wkdir=" + wkdir + ",  bregisterFlag=" + bregisterFlag + ", srcLoc=" + srcLoc);
        if ((srcLoc.endsWith("bin") || srcLoc.endsWith("bin\\") || srcLoc.endsWith("bin\\\\")) && (srcLoc = srcLoc.substring(0, indexOfBin = srcLoc.lastIndexOf("bin"))).endsWith("\\\\")) {
            int lastIndexOfFileSeparator = srcLoc.lastIndexOf("\\");
            srcLoc = srcLoc.substring(0, lastIndexOfFileSeparator);
        }
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(srcLoc, true);
        if (!ocxFname.toLowerCase().endsWith(".ocx") && !ocxFname.toLowerCase().endsWith(".dll")) {
            Object[] args = new String[]{ocxFname};
            throw new ClusterException(s_msgBundle.getMessage("1097", true, args));
        }
        if (wkdir == null) {
            wkdir = "";
        }
        Command[] registerOCXCmds = new RegisterOCXCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            registerOCXCmds[i] = (RegisterOCXCommand)factory.CreateCommand(new RegisterOCXCommand(nodeNames[i], ocxFname, wkdir, bregisterFlag, srcLoc), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            Trace.out("Before submitting commands");
            clusterConfig.submit(registerOCXCmds, true);
        }
        finally {
            Trace.out("Destroying cluster");
            clusterConfig.destroy();
        }
        Trace.out("Processing OCX commands result");
        StringBuffer registerOCXFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        NativeResult[] results = new NativeResult[registerOCXCmds.length];
        for (int i = 0; i < registerOCXCmds.length; ++i) {
            results[i] = registerOCXCmds[i].getCommandResult();
            if (results[i].getStatus()) continue;
            Trace.out("There is a failure in OCX registration for node " + results[i].getNodeName());
            if (registerOCXFailList != null) {
                registerOCXFailList.append("," + results[i].getNodeName());
            } else {
                registerOCXFailList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append(results[i].getOSString() + "\n");
        }
        if (registerOCXFailList != null) {
            Trace.out("errorBuf = " + errorBuf.toString());
            Object[] args = new Object[]{registerOCXFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1095", args, results);
        }
        Trace.out("Stopping (if running) the OracleRemExecService on all nodes");
        this.stopServiceOnNodes("OracleRemExecServiceV2", nodeNames, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebootNode(String[] nodeNames, String srcLoc) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(srcLoc, true);
        Command[] rebootNodeCmds = new RebootNodeCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            rebootNodeCmds[i] = (RebootNodeCommand)factory.CreateCommand(new RebootNodeCommand(nodeNames[i], srcLoc), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            clusterConfig.submit(rebootNodeCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        StringBuffer rebootNodeFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        NativeResult[] results = new NativeResult[rebootNodeCmds.length];
        for (int i = 0; i < rebootNodeCmds.length; ++i) {
            results[i] = rebootNodeCmds[i].getCommandResult();
            if (results[i].getStatus()) continue;
            if (rebootNodeFailList != null) {
                rebootNodeFailList.append("," + results[i].getNodeName());
            } else {
                rebootNodeFailList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append(results[i].getOSString() + "\n");
        }
        if (rebootNodeFailList != null) {
            Object[] args = new Object[]{rebootNodeFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1096", args, results);
        }
    }

    public void setPermissions(String path, boolean isAdmin) throws ClusterException {
        try {
            this.setPermissions(new String[]{"localnode"}, path, isAdmin);
        }
        catch (RemoteFileOperationException e) {
            throw new ClusterException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(String[] nodeNames, String path, boolean isAdmin) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertFile(path);
        ClusterCmd.assertNodes(nodeNames);
        String[] localNodeList = new String[nodeNames.length];
        for (int i = 0; i < nodeNames.length; ++i) {
            localNodeList[i] = !nodeNames[i].equalsIgnoreCase(this.m_localNode) ? nodeNames[i] : "localnode";
        }
        Command[] setAclsCmds = new SetAclsCommand[localNodeList.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < localNodeList.length; ++i) {
            setAclsCmds[i] = (SetAclsCommand)factory.CreateCommand(new SetAclsCommand(localNodeList[i], path, isAdmin), 0);
        }
        if (nodeNames.length == 1) {
            Trace.out("SetAclsCommand status=" + setAclsCmds[0].execute());
        } else {
            ClusterConfig clusterConfig = ClusterConfig.init(setAclsCmds.length);
            try {
                clusterConfig.submit(setAclsCmds, true);
            }
            finally {
                clusterConfig.destroy();
            }
        }
        NativeResult[] results = new NativeResult[setAclsCmds.length];
        StringBuffer setPermFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        for (int i = 0; i < setAclsCmds.length; ++i) {
            results[i] = setAclsCmds[i].getCommandResult();
            if (results[i].getNodeName().equalsIgnoreCase("localnode")) {
                results[i].setNodeName(this.m_localNode != null ? this.m_localNode : nodeNames[i]);
            }
            if (results[i].getStatus()) continue;
            if (setPermFailList != null) {
                setPermFailList.append("," + results[i].getNodeName());
            } else {
                setPermFailList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append(results[i].getOSString() + "\n");
        }
        if (setPermFailList != null) {
            Object[] args = new Object[]{path, setPermFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException(isAdmin ? "1132" : "1131", args, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableDriveLetters(String[] nodeNames, String srcLoc) throws RemoteFileOperationException, ClusterException {
        ClusterWindows.assertPath(srcLoc);
        ClusterWindows.assertDir(srcLoc);
        ClusterCmd.assertNodes(nodeNames);
        String[] localNodeList = new String[nodeNames.length];
        HashSet<String> driveLetterSet = new HashSet<String>();
        String getDLCmd = "srvmGetDriveLetters";
        String[] allDriveLetters = new String[]{"A:", "B:", "C:", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "K:", "L:", "M:", "N:", "O:", "P:", "Q:", "R:", "S:", "T:", "U:", "V:", "W:", "X:", "Y:", "Z:"};
        String dstLoc = null;
        WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
        Command[] getDriveLettersCmds = new RemoteExecCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            CommandResult rslt = new CommandResult();
            dstLoc = this.getDestLocForNode(nodeNames[i]);
            getDriveLettersCmds[i] = new RemoteExecCommand(getDLCmd, null, null, nodeNames[i], null, srcLoc, dstLoc, (NativeResult)rslt, true);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            clusterConfig.submit(getDriveLettersCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        StringBuffer getDriveLettersFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        NativeResult[] results = new NativeResult[getDriveLettersCmds.length];
        for (int i = 0; i < getDriveLettersCmds.length; ++i) {
            String[] drlsArr;
            results[i] = getDriveLettersCmds[i].getCommandResult();
            if (!results[i].getStatus()) {
                if (getDriveLettersFailList != null) {
                    getDriveLettersFailList.append("," + results[i].getNodeName());
                } else {
                    getDriveLettersFailList = new StringBuffer(results[i].getNodeName());
                }
                errorBuf.append(results[i].getOSString() + "\n");
                continue;
            }
            String drls = results[i].getResultString()[0];
            for (String drl : drlsArr = drls.split(",")) {
                driveLetterSet.add(drl.toUpperCase());
            }
        }
        if (getDriveLettersFailList != null) {
            Object[] args = new Object[]{getDriveLettersFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1150", args, results);
        }
        Vector<String> avdrls = new Vector<String>();
        for (String drlet : allDriveLetters) {
            if (driveLetterSet.contains(drlet)) continue;
            Trace.out("Drive letter " + drlet + "is available");
            avdrls.add(drlet);
        }
        return avdrls.toArray(new String[avdrls.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> resolvePath(String[] nodeList, String inputPath, String srcLoc) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeList);
        ClusterCmd.assertDir(srcLoc, true);
        String destLoc = null;
        if (inputPath == null) {
            return null;
        }
        HashMap<String, String> nodePathPair = new HashMap<String, String>(nodeList.length);
        Command[] resolvePathCmds = new ResolvePathCommand[nodeList.length];
        WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeList.length; ++i) {
            destLoc = this.getDestLocForNode(nodeList[i]);
            resolvePathCmds[i] = (ResolvePathCommand)factory.CreateCommand(new ResolvePathCommand(nodeList[i], inputPath, srcLoc, destLoc), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(resolvePathCmds.length);
        try {
            clusterConfig.submit(resolvePathCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        NativeResult[] results = new NativeResult[resolvePathCmds.length];
        StringBuffer resolvePathFailNodes = null;
        StringBuffer errorBuf = new StringBuffer();
        for (int i = 0; i < resolvePathCmds.length; ++i) {
            results[i] = resolvePathCmds[i].getCommandResult();
            String resolvedPath = null;
            if (!results[i].getStatus()) {
                if (resolvePathFailNodes != null) {
                    resolvePathFailNodes.append("," + results[i].getNodeName());
                } else {
                    resolvePathFailNodes = new StringBuffer(results[i].getNodeName());
                }
                errorBuf.append(" : " + results[i].getOSString() + "\n");
                resolvedPath = null;
            } else {
                resolvedPath = results[i].getResultString()[0];
            }
            if (resolvedPath != null && resolvedPath.startsWith("\\\\.\\")) {
                resolvedPath = resolvedPath.substring("\\\\.\\".length());
            }
            nodePathPair.put(results[i].getNodeName(), resolvedPath);
        }
        if (resolvePathFailNodes != null) {
            Object[] args = new Object[]{inputPath, resolvePathFailNodes.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1167", args, results);
        }
        return nodePathPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getEnvironmentVariable(String[] nodeList, String varName, String srcLoc, boolean restartRemExecService) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeList);
        ClusterCmd.assertDir(srcLoc, true);
        String destLoc = null;
        String envValue = null;
        if (varName == null) {
            return null;
        }
        HashMap<String, String> nodeValPair = new HashMap<String, String>(nodeList.length);
        Command[] getEVNodeCmds = new GetEnvVarCommand[nodeList.length];
        WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeList.length; ++i) {
            destLoc = this.getDestLocForNode(nodeList[i]);
            getEVNodeCmds[i] = (GetEnvVarCommand)factory.CreateCommand(new GetEnvVarCommand(nodeList[i], varName, srcLoc, destLoc, restartRemExecService), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(getEVNodeCmds.length);
        try {
            clusterConfig.submit(getEVNodeCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        NativeResult[] results = new NativeResult[getEVNodeCmds.length];
        StringBuffer getEnvFailList = null;
        StringBuffer errorBuf = new StringBuffer();
        for (int i = 0; i < getEVNodeCmds.length; ++i) {
            results[i] = getEVNodeCmds[i].getCommandResult();
            envValue = null;
            if (!results[i].getStatus()) {
                if (getEnvFailList != null) {
                    getEnvFailList.append("," + results[i].getNodeName());
                } else {
                    getEnvFailList = new StringBuffer(results[i].getNodeName());
                }
                errorBuf.append(results[i].getOSString() + "\n");
                envValue = null;
            } else {
                envValue = results[i].getResultString()[0];
            }
            nodeValPair.put(results[i].getNodeName(), envValue);
        }
        if (getEnvFailList != null) {
            Object[] args = new Object[]{varName, getEnvFailList.toString(), errorBuf.toString()};
            throw new RemoteFileOperationException("1160", args, results);
        }
        return nodeValPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> getWindowsDomain(String[] nodeList, String srcLoc) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeList);
        ClusterCmd.assertDir(srcLoc, true);
        HashMap<String, String> nodeValPair = new HashMap<String, String>(nodeList.length);
        Command[] getWinDomainCmds = new GetWinDomainCommand[nodeList.length];
        WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
        CommandFactory factory = new CommandFactory();
        String destLoc = null;
        for (int i = 0; i < nodeList.length; ++i) {
            destLoc = this.getDestLocForNode(nodeList[i]);
            getWinDomainCmds[i] = (GetWinDomainCommand)factory.CreateCommand(new GetWinDomainCommand(nodeList[i], srcLoc, destLoc), 0);
        }
        ClusterConfig clusterConfig = ClusterConfig.init(getWinDomainCmds.length);
        try {
            clusterConfig.submit(getWinDomainCmds, true);
        }
        finally {
            clusterConfig.destroy();
        }
        NativeResult[] results = new NativeResult[getWinDomainCmds.length];
        StringBuffer cmdFailList = new StringBuffer();
        for (int i = 0; i < getWinDomainCmds.length; ++i) {
            String domainName;
            results[i] = getWinDomainCmds[i].getCommandResult();
            if (!results[i].getStatus()) {
                cmdFailList.append(results[i].getNodeName());
                cmdFailList.append(",");
                domainName = null;
            } else {
                domainName = results[i].getResultString()[0];
            }
            nodeValPair.put(results[i].getNodeName(), domainName);
        }
        if (cmdFailList.length() > 0) {
            cmdFailList.setLength(cmdFailList.length() - 1);
            Object[] args = new Object[]{cmdFailList.toString()};
            throw new RemoteFileOperationException("1161", args, results);
        }
        return nodeValPair;
    }

    static final void assertPath(String path) throws ClusterException {
        File fl = new File(path);
        if (!fl.exists()) {
            throw new ClusterException(s_msgBundle.getMessage("1151", true, new String[]{path}));
        }
    }

    static final void assertDir(String path) throws ClusterException {
        File fl = new File(path);
        if (!fl.isDirectory()) {
            throw new ClusterException(s_msgBundle.getMessage("1152", true, new String[]{path}));
        }
    }

    static final void assertKey(String regKey, boolean isSubKey) throws ClusterException {
        if (regKey == null || regKey.trim().length() == 0) {
            throw new ClusterException(isSubKey ? s_msgBundle.getMessage("1115", true) : s_msgBundle.getMessage("1114", true));
        }
    }

    static final void assertValidKey(String regKey) throws ClusterException {
        if (regKey == null || regKey.indexOf("\\") == -1) {
            Object[] args = new String[]{regKey};
            throw new ClusterException(s_msgBundle.getMessage("1135", true, args));
        }
    }

    static final void assertService(String svcName) throws ClusterException {
        if (svcName == null || svcName.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1122", true));
        }
    }

    static final void assertUserName(String userName) throws ClusterException {
        if (userName == null || userName.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1142", true));
        }
    }

    static final void assertDomainName(String domainName) throws ClusterException {
        if (domainName == null || domainName.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1143", true));
        }
    }

    static final void assertServiceDep(String serviceName, String[] dependencyList) throws ClusterException {
        if (dependencyList == null || dependencyList.length == 0) {
            Object[] args = new String[]{serviceName};
            throw new ClusterException(MessageBundle.getMessageBundle("Prkc").getMessage("1133", true, args));
        }
    }

    public boolean stopLegacyRemoteExecServiceOnNodes(String[] nodeNames, boolean isBlocking) throws ClusterException {
        String serviceName = "OracleRemExecService";
        return this.stopServiceOnNodes(serviceName, nodeNames, isBlocking, true);
    }

    private String getDestLocForNode(String nodeName) throws ClusterException {
        try {
            WindowsSystem ws = (WindowsSystem)new SystemFactory().CreateSystem();
            return ws.getDestLoc(nodeName);
        }
        catch (RemoteDirException rde) {
            throw new ClusterException(s_msgBundle.getMessage("1153", true, new String[]{nodeName}));
        }
    }
}

