/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.TransactionException;
import oracle.ops.mgmt.nls.MessageBundle;

public class ClusterTxn {
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private ClusterConfig clusterConfig = ClusterConfig.init();

    private ClusterTxn() throws ClusterException {
    }

    public static ClusterTxn begin() throws ClusterException {
        return new ClusterTxn();
    }

    public boolean copyFileCluster(String string) throws ClusterException {
        ClusterCmd.assertFile(string);
        GetActiveNodes getActiveNodes = GetActiveNodes.create();
        return this.copyFileToNodes(string, getActiveNodes.getNodeList());
    }

    public synchronized boolean copyFileToNodes(String string, String[] stringArray) throws ClusterException {
        ClusterCmd.assertFile(string);
        ClusterCmd.assertNodes(stringArray);
        this.copyFileToNodes(string, stringArray, string);
        return true;
    }

    public synchronized boolean copyFileToNodes(String string, String[] stringArray, String string2) throws ClusterException, TransactionException {
        ClusterCmd.assertFile(string);
        ClusterCmd.assertNodes(stringArray);
        ClusterCmd.assertFile(string2);
        boolean bl = this.clusterConfig.copyFileToNodesPrepare(string, stringArray, string2);
        boolean bl2 = this.clusterConfig.doSecondPhase();
        if (!bl2) {
            throw new TransactionException(s_msgBundle.getMessage("1014", true));
        }
        if (!bl) {
            throw new ClusterException(s_msgBundle.getMessage("1013", true));
        }
        return bl2;
    }

    public String printLastStatus() {
        ClusterTxn clusterTxn = this;
        return clusterTxn.clusterConfig.getTransactionSummary();
    }

    public boolean removeFileCluster(String string) throws ClusterException {
        ClusterCmd.assertFile(string);
        GetActiveNodes getActiveNodes = GetActiveNodes.create();
        return this.removeFileFromNodes(getActiveNodes.getNodeList(), string);
    }

    public boolean removeFileFromNodes(String[] stringArray, String string) throws ClusterException {
        ClusterCmd.assertNodes(stringArray);
        ClusterCmd.assertFile(string);
        boolean bl = this.clusterConfig.removeFileFromNodesPrepare(stringArray, string);
        boolean bl2 = this.clusterConfig.doSecondPhase();
        if (!bl2) {
            throw new TransactionException(s_msgBundle.getMessage("1014", true));
        }
        if (!bl) {
            throw new ClusterException(s_msgBundle.getMessage("1013", true));
        }
        return bl2;
    }

    public void end() {
        this.clusterConfig.destroy();
    }
}

