/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.QueryCluster;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class ClusterNodeMap {
    public static final String LSNODES = "lsnodes";
    public static final String LSNODES_OPTION = "-n";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public final String SPACE = String.valueOf(" ");
    static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private NativeSystem m_nativeSystem;
    private Hashtable m_nodeMap;

    public ClusterNodeMap() throws ClusterException {
        if (!new QueryCluster().isCluster()) {
            throw new ClusterException(s_msgBundle.getMessage("1000", true));
        }
        this.m_nativeSystem = new SystemFactory().CreateSystem();
        this.m_nodeMap = new Hashtable();
    }

    public Hashtable getMap() throws ClusterException {
        CommandResult commandResult = (CommandResult)this.m_nativeSystem.getEnvironment("ORACLE_HOME");
        String string = commandResult.getStringResult();
        Trace.out("ORACLE_HOME=" + string);
        if (string == null) {
            Object[] objectArray = new Object[]{"ORACLE_HOME"};
            MessageBundle messageBundle = MessageBundle.getMessageBundle("Prkp");
            String string2 = messageBundle.getMessage("1015", true, objectArray);
            throw new ClusterException(string2);
        }
        String string3 = string + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + LSNODES;
        File file = new File(string3);
        if (!file.exists()) {
            Object[] objectArray = new Object[]{string3};
            MessageBundle messageBundle = MessageBundle.getMessageBundle("Prkr");
            String string4 = messageBundle.getMessage("1023", true, objectArray);
            throw new ClusterException(string4);
        }
        try {
            String string5 = string3 + this.SPACE + LSNODES_OPTION;
            Trace.out("cmdToRun=" + string5);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string5);
            int n = process.waitFor();
            Trace.out("proc returned ret =" + n);
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string6 = null;
            StringTokenizer stringTokenizer = null;
            while ((string6 = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string6, "\t");
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                this.m_nodeMap.put(string8, string7);
            }
        }
        catch (IOException iOException) {
            Trace.out(iOException);
        }
        catch (InterruptedException interruptedException) {
            Trace.out(interruptedException);
        }
        return this.m_nodeMap;
    }
}

