/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.deployment.ractrans.MultiTierTransfer;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.remote.ExecRunTime;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterConfig;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.CopyListedFilesException;
import oracle.ops.mgmt.cluster.CreateListedDirsException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.NodeLivenessListener;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.RemoteResponseListener;
import oracle.ops.mgmt.cluster.RemoteShellException;
import oracle.ops.mgmt.cluster.RemoveListedFilesException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandFactory;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.file.CopyCommand;
import oracle.ops.mgmt.command.file.CreateListedDirsCommand;
import oracle.ops.mgmt.command.file.DirCreateCommand;
import oracle.ops.mgmt.command.file.DirRemoveCommand;
import oracle.ops.mgmt.command.file.LinkCommand;
import oracle.ops.mgmt.command.file.ListDirCommand;
import oracle.ops.mgmt.command.file.MoveCommand;
import oracle.ops.mgmt.command.file.PathExistCommand;
import oracle.ops.mgmt.command.file.RemoveCommand;
import oracle.ops.mgmt.command.file.RemoveListedDirsCommand;
import oracle.ops.mgmt.command.node.NodeLivenessCommand;
import oracle.ops.mgmt.command.transfer.TransferDirCommand;
import oracle.ops.mgmt.command.transfer.TransferFileCommand;
import oracle.ops.mgmt.command.transfer.TransferListedDirsCommand;
import oracle.ops.mgmt.command.transfer.TransferListedFilesCommand;
import oracle.ops.mgmt.command.util.GetEnvironmentCommand;
import oracle.ops.mgmt.command.util.RunCtlCommand;
import oracle.ops.mgmt.command.util.UserEquivCommand;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.UnixSystem;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.Listener;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class ClusterCmd
implements Constants {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle("Prkc");
    private static final int PRINT_LIMIT = 15;

    public static boolean getDeconfigNonClusterMode() {
        return ClusterConfig.getDeconfigNonClusterMode();
    }

    public static void setDeconfigNonClusterMode(boolean dcFlag) {
        ClusterConfig.setDeconfigNonClusterMode(dcFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean submit(Command[] commandVector) throws ClusterException {
        boolean result;
        if (commandVector.length == 0) {
            return true;
        }
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            result = clusterConfig.submit(commandVector, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return result;
    }

    public boolean submit(Vector commandVector) throws ClusterException {
        Object[] commandArray = new Command[commandVector.size()];
        commandVector.copyInto(commandArray);
        return this.submit((Command[])commandArray);
    }

    public void addRemoteResponseListener(RemoteResponseListener l) throws ClusterException {
        ClusterConfig clusterConfig = ClusterConfig.init();
        clusterConfig.addRemoteResponseListener(l);
    }

    public void removeRemoteResponseListener(RemoteResponseListener l) throws ClusterException {
        ClusterConfig clusterConfig = ClusterConfig.init();
        clusterConfig.removeRemoteResponseListener(l);
    }

    public synchronized String getEnvironment(String environmentVariable) throws ClusterException {
        GetEnvironmentCommand getEnvironment = new GetEnvironmentCommand(environmentVariable);
        boolean cmdStatus = getEnvironment.execute();
        Trace.out("GetEnvironmentCommand.execute status=" + cmdStatus);
        CommandResult commandResult = getEnvironment.getCommandResult();
        if (commandResult.getStatus()) {
            String envValue = commandResult.getStringResult();
            Trace.out("envValue=" + envValue);
            if (envValue != null) {
                return envValue;
            }
            Object[] args = new String[]{environmentVariable};
            throw new ClusterException(MessageBundle.getMessageBundle("Prkp").getMessage("1015", true, args));
        }
        Object[] args = new String[]{environmentVariable, commandResult.getOSString()};
        throw new ClusterException(s_msgBundle.getMessage("1016", true, args), commandResult.getException());
    }

    public boolean moveFilesOnNode(String node, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        MoveCommand command = new MoveCommand(node, sourceFile, destFile);
        if (((Command)command).execute()) {
            return true;
        }
        Object[] args = new String[]{sourceFile, destFile, node, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1109", true, args), new Command[]{command});
    }

    public boolean moveFilesOnNode(String sourceFile, String destFile) throws ClusterException {
        return this.moveFilesOnNode("localnode", sourceFile, destFile);
    }

    public boolean createSymLinkOnNode(String node, String sourceFile, String destFile) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        LinkCommand command = new LinkCommand(node, sourceFile, destFile);
        if (((Command)command).execute()) {
            return true;
        }
        Object[] args = new String[]{sourceFile, destFile, node, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1107", true, args), new Command[]{command});
    }

    public boolean createSymLinkOnNode(String sourceFile, String destFile) throws ClusterException {
        return this.createSymLinkOnNode("localnode", sourceFile, destFile);
    }

    public boolean copyFileCluster(String fileName) throws ClusterException {
        return this.copyFileCluster(fileName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileCluster(String fileName, boolean noPreserve) throws ClusterException {
        ClusterCmd.assertFile(fileName);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.copyFileCluster(fileName, true, noPreserve);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean runIDCmd(String user, String[] nodeList) throws ClusterException {
        ClusterCmd.assertUser(user);
        ClusterCmd.assertNodes(nodeList);
        return this.runCmd("/usr/bin/id", new String[]{user}, null, nodeList);
    }

    private String getLocalNodeName() throws ClusterException {
        String localNodeName = null;
        GetActiveNodes activeNodes = null;
        if (ClusterConfig.isClusterInstalled()) {
            activeNodes = GetActiveNodes.create();
        }
        if (activeNodes != null) {
            localNodeName = activeNodes.getNodeName();
        }
        return localNodeName;
    }

    public boolean copyFileBetweenNodes(String sourceNode, String sourceFile, String destNode, String destFile) throws ClusterException {
        return this.copyFileBetweenNodes(sourceNode, sourceFile, destNode, destFile, false);
    }

    public boolean copyFileBetweenNodes(String sourceNode, String sourceFile, String destNode, String destFile, boolean noPreserve) throws ClusterException {
        CopyCommand command;
        ClusterCmd.assertNode(sourceNode);
        ClusterCmd.assertNode(destNode);
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        if (ClusterConfig.isClusterInstalled()) {
            String localNode = null;
            try {
                localNode = this.getLocalNodeName();
                if (sourceNode.compareToIgnoreCase(localNode) == 0) {
                    sourceNode = "localnode";
                }
                if (destNode.compareToIgnoreCase(localNode) == 0) {
                    destNode = "localnode";
                }
            }
            catch (ClusterException clusterException) {
                // empty catch block
            }
        }
        if (((Command)(command = new CopyCommand(sourceNode, sourceFile, destNode, destFile, noPreserve))).execute()) {
            return true;
        }
        Object[] args = new String[]{sourceFile, sourceNode, destFile, destNode, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1108", true, args), new Command[]{command});
    }

    public boolean copyFileCluster(String sourceFile, String destFile) throws ClusterException {
        return this.copyFileCluster(sourceFile, destFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileCluster(String sourceFile, String destFile, boolean noPreserve) throws ClusterException {
        ClusterCmd.assertFile(sourceFile);
        ClusterCmd.assertFile(destFile);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.copyFileCluster(sourceFile, destFile, true, noPreserve);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean copyFileFromNode(String sourceNode, String sourceFile, String destFile) throws ClusterException {
        return this.copyFileBetweenNodes(sourceNode, sourceFile, "localnode", destFile, false);
    }

    public boolean copyFileFromNode(String sourceNode, String sourceFile, String destFile, boolean noPreserve) throws ClusterException {
        return this.copyFileBetweenNodes(sourceNode, sourceFile, "localnode", destFile, noPreserve);
    }

    public boolean copyFileToNodes(String sourceFile, String[] nodeNames) throws ClusterException {
        return this.copyFileToNodes(sourceFile, nodeNames, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileToNodes(String sourceFile, String[] nodeNames, boolean noPreserve) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertFile(sourceFile);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.copyFileToNodes(sourceFile, nodeNames, true, noPreserve);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean copyFileToNodes(String sourceFile, String[] nodeNames, String destFile) throws ClusterException {
        return this.copyFileToNodes(sourceFile, nodeNames, destFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFileToNodes(String sourceFile, String[] nodeNames, String destFile, boolean noPreserve) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertFile(sourceFile, true, true);
        ClusterCmd.assertFile(destFile);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            if (System.getProperty("SRVM_PARALLEL_TRANSFER") == null || !System.getProperty("SRVM_PARALLEL_TRANSFER").contains(Thread.currentThread().getName())) {
                clusterConfig.copyFileToNodes(sourceFile, nodeNames, destFile, true, noPreserve);
            } else {
                clusterConfig.copyFileToNodesNonSynchronized(sourceFile, nodeNames, destFile, true, noPreserve);
            }
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean copyFileToNode(String sourceFile, String nodeName, String destFile) throws ClusterException {
        return this.copyFileBetweenNodes("localnode", sourceFile, nodeName, destFile, false);
    }

    public boolean copyFileToNode(String sourceFile, String nodeName, String destFile, boolean noPreserve) throws ClusterException {
        return this.copyFileBetweenNodes("localnode", sourceFile, nodeName, destFile, noPreserve);
    }

    public boolean createDirCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, false);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.createDirCluster(dirName, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean createDirInNode(String nodeName, String dirName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirName, false);
        DirCreateCommand command = new DirCreateCommand(nodeName, dirName, false);
        if (((Command)command).execute()) {
            return true;
        }
        Object[] args = new String[]{dirName, nodeName, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1110", true, args), new Command[]{command});
    }

    public boolean createDirInNodes(String[] nodeNames, String dirName) throws ClusterException {
        return this.createDirOnNodes(nodeNames, dirName, false, null);
    }

    public boolean createDirWithModeOnNodes(String[] nodeNames, String dirName) throws ClusterException {
        return this.createDirOnNodes(nodeNames, dirName, true, null);
    }

    public boolean createDirWithPermissionsOnNodes(String[] nodeNames, String dirName, String perm) throws ClusterException {
        boolean permIsOK = true;
        if (perm == null || perm.length() == 0 || perm.length() > 4) {
            permIsOK = false;
        }
        if (permIsOK) {
            char[] digits = perm.toCharArray();
            for (int i = 0; i < digits.length; ++i) {
                if (digits[i] >= '0' && digits[i] <= '7') continue;
                permIsOK = false;
                break;
            }
        }
        if (!permIsOK) {
            MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
            throw new ClusterException(msgBundle.getMessage("1146", true) + ": " + perm);
        }
        return this.createDirOnNodes(nodeNames, dirName, true, perm);
    }

    public boolean createDirWithParentPermsOnNodes(String[] nodeNames, String dirName, String permissions) throws ClusterException {
        ArrayList notExistPath = new ArrayList();
        List<String> paths = null;
        String pathList = "";
        boolean skipValidation = false;
        Trace.out("dir[" + dirName + "] permissions[" + permissions + "]");
        if (IS_UNIX_SYSTEM) {
            paths = this.getListParents(dirName);
            for (String pathDerived : paths) {
                if (skipValidation) {
                    pathList = pathList + " " + pathDerived;
                    continue;
                }
                try {
                    this.dirExists(nodeNames, pathDerived);
                }
                catch (ClusterException | ClusterOperationException ce) {
                    pathList = pathList + " " + pathDerived;
                    skipValidation = true;
                }
            }
        }
        this.createDirWithPermissionsOnNodes(nodeNames, dirName, permissions);
        if (IS_UNIX_SYSTEM && pathList.length() > 0) {
            Trace.out("paths [" + pathList + "]");
            this.changeModeDirOnNodes(nodeNames, pathList, permissions);
        }
        return true;
    }

    private List<String> getListParents(String path) {
        ArrayList<String> paths = new ArrayList<String>();
        String parents = "";
        String auxPath = "";
        String[] tokens = null;
        parents = path;
        paths.add(parents);
        while (true) {
            auxPath = "";
            if (parents.equals(FILE_SEPARATOR)) {
                paths.add(parents);
                break;
            }
            tokens = parents.split(FILE_SEPARATOR);
            if (tokens.length == 2 && parents.equals(FILE_SEPARATOR + tokens[1])) {
                paths.add(parents);
                break;
            }
            for (int index = 0; index < tokens.length - 1; ++index) {
                if (tokens[index].equals("")) continue;
                auxPath = auxPath + FILE_SEPARATOR + tokens[index];
            }
            parents = auxPath;
            paths.add(parents);
        }
        Collections.reverse(paths);
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeModeDirOnNodes(String[] nodeNames, String paths, String perms) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.changeModeOnNodes(nodeNames, paths, true, perms);
        }
        finally {
            clusterConfig.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDirOnNodes(String[] nodeNames, String dirName, boolean useMode, String permissions) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, false);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            if (System.getProperty("SRVM_PARALLEL_TRANSFER") == null || !System.getProperty("SRVM_PARALLEL_TRANSFER").contains(Thread.currentThread().getName())) {
                if (permissions != null) {
                    boolean bl = clusterConfig.createDirWithPermissionsOnNodes(nodeNames, dirName, true, permissions);
                    return bl;
                }
                if (useMode) {
                    boolean bl = clusterConfig.createDirWithModeOnNodes(nodeNames, dirName, true);
                    return bl;
                }
                boolean bl = clusterConfig.createDirInNodes(nodeNames, dirName, true);
                return bl;
            }
            boolean bl = clusterConfig.createDirOnNodes(nodeNames, dirName, true, useMode, permissions);
            return bl;
        }
        finally {
            clusterConfig.destroy();
        }
    }

    public String[] listDirectory(String nodeName, String dirPath) throws RemoteDirException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirPath, false);
        if ("localnode".equalsIgnoreCase(nodeName)) {
            try {
                ClusterCmd.assertDir(dirPath, true);
            }
            catch (ClusterException e) {
                throw new RemoteDirException(e.getMessage());
            }
        } else if (!this.dirExists(nodeName, dirPath)) {
            Object[] args = new String[]{dirPath, nodeName};
            throw new RemoteDirException(s_msgBundle.getMessage("1113", true, args));
        }
        ListDirCommand command = new ListDirCommand(nodeName, dirPath);
        if (((Command)command).execute()) {
            return command.getCommandResult().getResultString();
        }
        Object[] args = new String[]{dirPath, nodeName, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1112", true, args), new Command[]{command});
    }

    public Map<String, String[]> listDirContents(String[] nodeList, String dirPath) throws ClusterException, ClusterOperationException {
        boolean allFailed;
        ClusterCmd.assertNodes(nodeList);
        ClusterCmd.assertDir(dirPath, false);
        ClusterException ce = null;
        Command[] cmdArray = new ListDirCommand[nodeList.length];
        CommandFactory factory = new CommandFactory();
        NativeResult[] results = new CommandResult[nodeList.length];
        Vector<String> failNodes = new Vector<String>();
        HashMap<String, String[]> dirList = new HashMap<String, String[]>();
        for (int i = 0; i < nodeList.length; ++i) {
            cmdArray[i] = (ListDirCommand)factory.CreateCommand(new ListDirCommand(nodeList[i], dirPath), 0);
        }
        try {
            this.submit(cmdArray);
        }
        catch (ClusterException e) {
            ce = e;
        }
        for (int i = 0; i < cmdArray.length; ++i) {
            results[i] = cmdArray[i].getCommandResult();
            if (!results[i].getStatus()) {
                failNodes.add(results[i].getNodeName());
                continue;
            }
            dirList.put(results[i].getNodeName(), results[i].getResultString());
        }
        boolean bl = allFailed = failNodes.size() == nodeList.length;
        if (failNodes.size() > 0) {
            String failNodesStr = Utils.getString(failNodes, ",");
            Object[] args = new String[]{dirPath, failNodesStr};
            String msg = s_msgBundle.getMessage("1176", true, args);
            if (allFailed) {
                if (null != ce) {
                    throw ce;
                }
                throw new ClusterException(msg);
            }
            throw new ClusterOperationException("1176", args, results);
        }
        return dirList;
    }

    public boolean copyDirContentsToNodes(String[] nodeNames, String dirName) throws ClusterException {
        return this.copyDirContentsToNodes(nodeNames, dirName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyDirContentsToNodes(String[] nodeNames, String dirName, boolean noPreserve) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, true);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.copyDirContentsToNodes(nodeNames, dirName, true, noPreserve);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public void copyDirToNodes(String[] nodeNames, String pathName, boolean isBlocking) throws RemoteDirException, ClusterException {
        this.copyDirToNodes(nodeNames, pathName, isBlocking, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDirToNodes(String[] nodeNames, String pathName, boolean isBlocking, boolean noPreserve) throws RemoteDirException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(pathName, true);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            for (int i = 0; i < nodeNames.length; ++i) {
                if (this.dirExists(nodeNames[i], pathName)) continue;
                clusterConfig.createDirInNode(nodeNames[i], pathName, true);
            }
            clusterConfig.copyDirContentsToNodes(nodeNames, pathName, isBlocking, noPreserve);
        }
        finally {
            clusterConfig.destroy();
        }
    }

    public boolean removeListedFilesFromNode(String nodeName, String removeListFile) throws RemoteShellException, RemoveListedFilesException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        if (removeListFile == null) {
            throw new RemoveListedFilesException("1046");
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.removeListedFilesFromNode(nodeName, removeListFile);
    }

    public boolean createListedDirsOnNode(String nodeName, String createListFile) throws RemoteShellException, CreateListedDirsException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        if (createListFile == null) {
            throw new CreateListedDirsException("1047");
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.createListedDirsOnNode(nodeName, createListFile);
    }

    public boolean copyListedFilesToNode(String nodeName, String copyListFile) throws RemoteShellException, CopyListedFilesException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        if (copyListFile == null) {
            throw new CopyListedFilesException("1046");
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.copyListedFilesToNode(nodeName, copyListFile);
    }

    public boolean copyFilesByTar(String[] nodeNames, String dirName, String scratchPath) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, true);
        ClusterCmd.assertDir(scratchPath, true);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!IS_UNIX_SYSTEM) {
            return false;
        }
        UnixSystem unixsystem = (UnixSystem)nativeSystem;
        String scratchFile = scratchPath + File.separatorChar + "Files.lst";
        boolean b_fileList = this.listFilesRecurse(dirName, scratchFile);
        Trace.out("b_fileList=" + b_fileList);
        for (int i = 0; i < nodeNames.length; ++i) {
            int retval = unixsystem.copyFilesByTar(nodeNames[i], scratchFile);
            if (retval != 1) continue;
            Object[] args = new String[]{scratchFile, nodeNames[i]};
            throw new ClusterException(s_msgBundle.getMessage("1038", true, args));
        }
        File file = new File(scratchFile);
        if (file.exists()) {
            file.delete();
        }
        return true;
    }

    private boolean listFilesRecurse(String dirName, String scratchFilePath) {
        String[] dirContents;
        PrintWriter m_pw = null;
        File DirName = new File(dirName);
        if (!DirName.isDirectory()) {
            Trace.out("directory " + dirName + " is not a directory");
            return false;
        }
        try {
            m_pw = new PrintWriter(new FileOutputStream(scratchFilePath, true), true);
        }
        catch (IOException ex) {
            m_pw = null;
        }
        if (m_pw != null) {
            m_pw.println(dirName);
            m_pw.close();
            m_pw = null;
        }
        if ((dirContents = DirName.list()) == null) {
            Trace.out("Directory '" + dirName + "' is empty");
            return true;
        }
        for (int i = 0; i < dirContents.length; ++i) {
            dirContents[i] = dirName + File.separatorChar + dirContents[i];
            File content = new File(dirContents[i]);
            if (content.isDirectory()) {
                this.listFilesRecurse(dirContents[i], scratchFilePath);
                continue;
            }
            try {
                m_pw = new PrintWriter(new FileOutputStream(scratchFilePath, true), true);
            }
            catch (IOException ex) {
                m_pw = null;
            }
            if (m_pw == null) continue;
            m_pw.println(dirContents[i]);
            m_pw.close();
            m_pw = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirectoryFromCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, true);
        ClusterConfig clusterConfig = ClusterConfig.init();
        boolean retVal = false;
        try {
            retVal = clusterConfig.removeDirCluster(dirName, false, false, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDirCluster(String dirName) throws ClusterException {
        ClusterCmd.assertDir(dirName, true);
        boolean retVal = false;
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            retVal = clusterConfig.removeDirCluster(dirName, false, true, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return retVal;
    }

    public boolean removeDirFromNode(String nodeName, String dirName) throws ClusterException {
        return this.removeDirectory(nodeName, dirName, true);
    }

    public boolean removeDirectory(String nodeName, String dirName) throws ClusterException {
        return this.removeDirectory(nodeName, dirName, false);
    }

    private boolean removeDirectory(String nodeName, String dirName, boolean isDirPathRemove) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(dirName, false);
        DirRemoveCommand command = new DirRemoveCommand(nodeName, dirName, false, isDirPathRemove);
        if (((Command)command).execute()) {
            return true;
        }
        Object[] args = new String[]{dirName, nodeName, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1111", true, args), new Command[]{command});
    }

    public boolean removeDirFromNodes(String[] nodeNames, String dirName) throws ClusterException {
        return this.removeDirFromNodes(nodeNames, dirName, false, true);
    }

    public boolean removeDirectory(String[] nodeNames, String dirName) throws ClusterException {
        return this.removeDirFromNodes(nodeNames, dirName, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDirFromNodes(String[] nodeNames, String dirName, boolean isRecurse, boolean isDirPathRemove) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(dirName, false);
        boolean retVal = false;
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            retVal = System.getProperty("SRVM_PARALLEL_TRANSFER") == null || !System.getProperty("SRVM_PARALLEL_TRANSFER").contains(Thread.currentThread().getName()) ? clusterConfig.removeDirFromNodes(nodeNames, dirName, isRecurse, isDirPathRemove, true) : clusterConfig.removeDirFromNodesNonSynchronized(nodeNames, dirName, isRecurse, isDirPathRemove, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return retVal;
    }

    public boolean removeDirectory(String[] nodeNames, String dirName, boolean isRecurse) throws ClusterException {
        return this.removeDirFromNodes(nodeNames, dirName, isRecurse, false);
    }

    public boolean removeDirFromNodes(String[] nodeNames, String dirName, boolean isRecurse) throws ClusterException {
        return this.removeDirFromNodes(nodeNames, dirName, isRecurse, true);
    }

    public boolean removeFileCluster(String fileName) throws ClusterException {
        ClusterCmd.assertFile(fileName);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.removeFileCluster(fileName, true);
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean removeFileFromNode(String nodeName, String fileName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertFile(fileName);
        RemoveCommand command = new RemoveCommand(nodeName, fileName);
        if (((Command)command).execute()) {
            return true;
        }
        Object[] args = new String[]{fileName, nodeName, command.getCommandResult().getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1106", true, args), new Command[]{command});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFileFromNodes(String[] nodeNames, String fileName) throws ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertFile(fileName);
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            if (System.getProperty("SRVM_PARALLEL_TRANSFER") == null || !System.getProperty("SRVM_PARALLEL_TRANSFER").contains(Thread.currentThread().getName())) {
                clusterConfig.removeFileFromNodes(nodeNames, fileName, true);
            } else {
                clusterConfig.removeFileFromNodesNonSynchronized(nodeNames, fileName, true);
            }
        }
        finally {
            clusterConfig.destroy();
        }
        return true;
    }

    public boolean fileExists(String file) throws ClusterException {
        return this.fileExists("localnode", file);
    }

    public boolean fileExists(String node, String file) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertFile(file);
        String path = new File(file).getAbsolutePath();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.pathExists(node, path, 2);
    }

    public boolean isACFS(String dir) throws ClusterException {
        ClusterCmd.assertDir(dir, false);
        String path = new File(dir).getAbsolutePath();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        try {
            return nativeSystem.isPathACFS(path);
        }
        catch (NativeException ne) {
            Trace.out("NativeException :" + ne.getMessage());
            throw new ClusterException(ne.getMessage(), ne);
        }
    }

    public boolean isDirWritable(String dir) throws ClusterException {
        return this.isDirWritable("localnode", dir);
    }

    public boolean isDirWritable(String node, String dir) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertDir(dir, false);
        String path = new File(dir).getAbsolutePath();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.pathExists(node, path, 4);
    }

    public boolean dirExists(String[] nodeList, String dir) throws ClusterException, ClusterOperationException {
        ClusterCmd.assertDir(dir, false);
        return this.pathExists(nodeList, dir, 1);
    }

    public boolean isDirWritable(String[] nodeList, String dir) throws ClusterException, ClusterOperationException {
        ClusterCmd.assertDir(dir, false);
        return this.pathExists(nodeList, dir, 4);
    }

    public boolean pathExists(String[] nodeList, String path, int pathType) throws ClusterException, ClusterOperationException {
        boolean allFailed;
        ClusterCmd.assertNodes(nodeList);
        ClusterException ce = null;
        String absPath = new File(path).getAbsolutePath();
        Command[] cmdArray = new PathExistCommand[nodeList.length];
        CommandFactory factory = new CommandFactory();
        NativeResult[] results = new CommandResult[nodeList.length];
        Vector<String> failNodes = new Vector<String>();
        for (int i = 0; i < nodeList.length; ++i) {
            cmdArray[i] = (PathExistCommand)factory.CreateCommand(new PathExistCommand(nodeList[i], absPath, pathType), 0);
        }
        try {
            this.submit(cmdArray);
        }
        catch (ClusterException e) {
            ce = e;
        }
        for (int i = 0; i < cmdArray.length; ++i) {
            results[i] = cmdArray[i].getCommandResult();
            if (results[i].getStatus()) continue;
            failNodes.add(results[i].getNodeName());
        }
        boolean bl = allFailed = failNodes.size() == nodeList.length;
        if (failNodes.size() > 0) {
            String key;
            String failNodesStr = Utils.getString(failNodes, ",");
            Object[] args = new String[]{path, failNodesStr};
            switch (pathType) {
                case 4: {
                    key = "1028";
                    break;
                }
                default: {
                    key = "1027";
                }
            }
            String msg = s_msgBundle.getMessage(key, true, args);
            if (allFailed) {
                if (null != ce) {
                    throw ce;
                }
                throw new ClusterException(msg);
            }
            throw new ClusterOperationException(key, args, results);
        }
        return true;
    }

    public long getModificationTime(String file) throws ClusterException {
        return this.getModificationTime("localnode", file);
    }

    public long getModificationTime(String node, String file) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertFile(file);
        if ("localnode".equalsIgnoreCase(node)) {
            return new File(file).lastModified();
        }
        String tempFileName = null;
        File tempFile = null;
        try {
            tempFile = File.createTempFile("GGG", ".gmt");
            tempFileName = tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            Object[] args = new String[]{file, node, e.getMessage()};
            throw new ClusterException(s_msgBundle.getMessage("1029", true, args));
        }
        try {
            Trace.out("copyFile status=" + this.copyFileFromNode(node, file, tempFileName));
            long e = tempFile.lastModified();
            return e;
        }
        catch (ClusterException e) {
            Object[] args = new String[]{file, node, e.getMessage()};
            throw new ClusterException(s_msgBundle.getMessage("1029", true, args));
        }
        finally {
            tempFile.delete();
        }
    }

    public long getFreeSpace(String path) throws ClusterException {
        return this.getFreeSpace("localnode", path);
    }

    public long getFreeSpace(String node, String path) throws ClusterException {
        ClusterCmd.assertNode(node);
        ClusterCmd.assertDir(path, false);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult nativeResult = new NativeResult(nativeSystem.getFreeSpace(node, path));
        if (nativeResult.getStatus() && nativeResult.getResultString() != null) {
            String[] resArr = nativeResult.getResultString();
            Trace.out((Object)"getFreeSpace:%s\n", Utils.getString(resArr, "\n"));
            return Long.parseLong(resArr[0]);
        }
        Object[] msgArgs = new Object[]{path, node};
        throw new ClusterException(s_msgBundle.getMessage("1031", true, msgArgs) + "\n" + Utils.getString(nativeResult.getResultString(), "\n"));
    }

    public boolean isNodeAccessible(String node) throws ClusterException {
        ClusterCmd.assertNode(node);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        CommandResult commandResult = new CommandResult(nativeSystem.isNodeAccessible(node));
        if (commandResult.getStatus()) {
            return true;
        }
        Object[] args = new String[]{node, commandResult.getErrorString()};
        throw new ClusterException(s_msgBundle.getMessage("1030", true, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startListener(String[] nodeNames, String[] listeners, String oraHome, String oracleHomeName) throws ClusterException {
        if (!Version.isPre10i(Cluster.getVersion())) {
            for (int i = 0; i < nodeNames.length; ++i) {
                try {
                    Listener lsnr = new Listener(listeners[i], nodeNames[i], oraHome);
                    lsnr.start();
                    continue;
                }
                catch (ListenerException e) {
                    throw new ClusterException(e.getMessage());
                }
            }
        } else {
            ClusterConfig clusterConfig = ClusterConfig.init();
            try {
                clusterConfig.startListener(nodeNames, listeners, oraHome, oracleHomeName, true);
            }
            finally {
                clusterConfig.destroy();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startListener(String[] nodeNames, String listenerName, String oraHome, String oracleHomeName) throws ClusterException {
        if (!Version.isPre10i(Cluster.getVersion())) {
            for (int i = 0; i < nodeNames.length; ++i) {
                try {
                    Listener lsnr = new Listener(listenerName, nodeNames[i], oraHome);
                    lsnr.start();
                    continue;
                }
                catch (ListenerException e) {
                    throw new ClusterException(e.getMessage());
                }
            }
        } else {
            ClusterConfig clusterConfig = ClusterConfig.init();
            try {
                clusterConfig.startListener(nodeNames, listenerName, oraHome, oracleHomeName, true);
            }
            finally {
                clusterConfig.destroy();
            }
        }
        return true;
    }

    public boolean startListener(String nodeName, String listenerName, String oracleHome, String oracleHomeName) throws ClusterException {
        String[] nodeNames = new String[]{nodeName};
        return this.startListener(nodeNames, listenerName, oracleHome, oracleHomeName);
    }

    public void startOPSMDaemonCluster(String oracleHomeName) throws ClusterException {
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.startOPSMDaemonCluster(oracleHomeName, true);
        }
        finally {
            clusterConfig.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOPSMDaemonOnNodes(String[] nodeNames, String oracleHomeName) throws ClusterException {
        ClusterConfig clusterConfig = ClusterConfig.init();
        try {
            clusterConfig.startOPSMDaemonOnNodes(nodeNames, oracleHomeName, true);
        }
        finally {
            clusterConfig.destroy();
        }
    }

    public ExecRunTime runCmdNoWait(String cmd, String[] args, String[] env) throws ClusterException {
        return this.runCmdNoWait(cmd, args, env, true);
    }

    public ExecRunTime runCmdNoWait(String cmd, String[] args, String[] env, boolean inherit) throws ClusterException {
        Trace.out("Beginning of runCmdNoWait");
        ExecRunTime execRunTime = null;
        String[] commands = this.combineCmdArgs(cmd, args);
        Trace.out("Calling RuntimeExec to execute the command -->" + commands[0]);
        RuntimeExec runtimeExec = new RuntimeExec(commands, null, env, inherit);
        try {
            execRunTime = runtimeExec.runCommandNoWait();
        }
        catch (IOException ioe) {
            Trace.out("exception in runCmdNoWait: " + ioe.getMessage());
            throw new ClusterException(s_msgBundle.getMessage("1178", true, new Object[]{cmd, ioe.getMessage()}));
        }
        return execRunTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCmd(String cmd, String[] args, String[] env, String[] nodeList) throws ClusterException {
        if (nodeList == null) {
            throw new ClusterException(s_msgBundle.getMessage("1062", true));
        }
        if (nodeList.length == 0) {
            String[] commands = this.combineCmdArgs(cmd, args);
            Trace.out("Calling RuntimeExec to execute the command -->" + commands[0]);
            RuntimeExec runtimeExec = new RuntimeExec(commands, null, env);
            int retValue = runtimeExec.runCommand();
            return retValue != 1 && retValue != 2;
        }
        if (nodeList.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeList.length);
            try {
                boolean bl = clusterConfig.runCmd(cmd, args, env, nodeList, true);
                return bl;
            }
            finally {
                clusterConfig.destroy();
            }
        }
        Command command = new CommandFactory().CreateCommand(new RunCtlCommand(cmd, args, env, nodeList[0]), 0);
        if (command.execute()) {
            return true;
        }
        throw new ClusterException(command.getCommandResult().getErrorString());
    }

    public boolean runCmd(String cmd, String[] args, String[] env, String node, String srcLoc, String destLoc) throws ClusterException {
        Command command = new CommandFactory().CreateCommand(new RunCtlCommand(cmd, args, env, node, srcLoc, destLoc), 0);
        if (command.execute()) {
            return true;
        }
        throw new ClusterException(command.getCommandResult().getErrorString());
    }

    public boolean dirExists(String node, String dir) throws RemoteDirException {
        try {
            ClusterCmd.assertNode(node);
            ClusterCmd.assertDir(dir, false);
            if (this.isNodeAccessible(node)) {
                String path = new File(dir).getAbsolutePath();
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                return nativeSystem.pathExists(node, path, 1);
            }
            Object[] msgArgs = new Object[]{node, ""};
            throw new RemoteDirException(s_msgBundle.getMessage("1054", true, msgArgs));
        }
        catch (ClusterException ce) {
            throw new RemoteDirException(ce.getMessage());
        }
    }

    public boolean isNodeAlive(String node, int timeout) {
        boolean nodeAlive = false;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        nativeSystem.isNodeAlive(node, timeout, result);
        if (result.getStatus() && result.getBooleanResult()) {
            nodeAlive = true;
        }
        return nodeAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areNodesAlive(String[] nodeNames, int timeout, NodeLivenessListener lsnr) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        Command[] nodeLivenessCmds = new NodeLivenessCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeLivenessCmds[i] = (NodeLivenessCommand)factory.CreateCommand(new NodeLivenessCommand(nodeNames[i], timeout, lsnr), 0);
        }
        ClusterException ce = null;
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            clusterConfig.submit(nodeLivenessCmds, true);
        }
        catch (ClusterException e) {
            ce = e;
            Trace.out(e);
        }
        finally {
            clusterConfig.destroy();
        }
        StringBuffer downNodeList = null;
        StringBuffer errorBuf = new StringBuffer(LINE_SEPARATOR);
        NativeResult[] results = new NativeResult[nodeLivenessCmds.length];
        boolean allNodesDown = true;
        for (int i = 0; i < nodeLivenessCmds.length; ++i) {
            results[i] = nodeLivenessCmds[i].getCommandResult();
            allNodesDown &= !results[i].getStatus() || !results[i].getBooleanResult();
            if (results[i].getStatus() && results[i].getBooleanResult()) continue;
            if (downNodeList != null) {
                downNodeList.append("," + results[i].getNodeName());
            } else {
                downNodeList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append((results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()) + LINE_SEPARATOR);
            Trace.out("Node: " + results[i].getNodeName() + " : " + (results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()));
        }
        if (allNodesDown) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new Object[3];
            if (nodeNames.length < 15) {
                args[0] = downNodeList != null ? downNodeList.toString() : Utils.getString(nodeNames, ",");
                args[1] = String.valueOf(timeout);
                args[2] = errorBuf.toString();
                throw new ClusterException(s_msgBundle.getMessage("1071", true, args));
            }
            throw new ClusterException(s_msgBundle.getMessage("1182", true));
        }
        if (downNodeList != null) {
            throw new RemoteFileOperationException("1002", results);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateUserEquivalence(String[] nodeNames) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        if (DeterminePlatform.getOSName().equals("OpenVMS")) {
            return true;
        }
        Command[] usrEquivCmds = new UserEquivCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            usrEquivCmds[i] = (UserEquivCommand)factory.CreateCommand(new UserEquivCommand(nodeNames[i]), 0);
        }
        ClusterException ce = null;
        ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
        try {
            clusterConfig.submit(usrEquivCmds, true);
        }
        catch (ClusterException e) {
            ce = e;
            Trace.out(ce);
        }
        finally {
            clusterConfig.destroy();
        }
        NativeResult[] results = new NativeResult[usrEquivCmds.length];
        StringBuffer nonUserEquivNodeList = null;
        StringBuffer errorBuf = new StringBuffer();
        int failNodes = 0;
        boolean noUserEquivWithAllNodes = true;
        for (int i = 0; i < usrEquivCmds.length; ++i) {
            results[i] = usrEquivCmds[i].getCommandResult();
            noUserEquivWithAllNodes &= !results[i].getStatus();
            if (results[i].getStatus()) continue;
            ++failNodes;
            if (nonUserEquivNodeList != null) {
                nonUserEquivNodeList.append("," + results[i].getNodeName());
            } else {
                nonUserEquivNodeList = new StringBuffer(results[i].getNodeName());
            }
            errorBuf.append((results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()) + "\n");
            Trace.out("Node: " + results[i].getNodeName() + " : " + (results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()));
        }
        if (noUserEquivWithAllNodes) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new Object[2];
            if (failNodes < 15) {
                args[0] = nonUserEquivNodeList.toString();
                args[1] = errorBuf.toString();
                throw new ClusterException(s_msgBundle.getMessage("1075", true, args));
            }
            throw new ClusterException(s_msgBundle.getMessage("1181", true));
        }
        if (nonUserEquivNodeList != null) {
            throw new RemoteFileOperationException("1002", results);
        }
        return true;
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile) throws RemoteFileOperationException, ClusterException {
        this.transferDirToNodes(oracleHome, remoteNodeNames, topLevelDir, excludeListFile, System.getProperty("java.io.tmpdir"));
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, String remoteNodeTempDir) throws RemoteFileOperationException, ClusterException {
        this.transferDirToNodes(oracleHome, remoteNodeNames, topLevelDir, excludeListFile, false, remoteNodeTempDir);
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertDir(oracleHome, true);
        this.transferDirToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, null);
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertDir(oracleHome, true);
        this.validateProgressListener(progressListener);
        this.transferDirToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, progressListener);
    }

    private void transferDirToNodesInternal(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(remoteNodeNames);
        ClusterCmd.assertDir(remoteNodeTempDir, true);
        StringBuilder nodeNames = new StringBuilder();
        for (String remoteNodeName : remoteNodeNames) {
            nodeNames.append("'" + remoteNodeName + "' ");
        }
        Trace.out("In ClusterCmd.transferDirToNodesInternal() with:\n            Oracle home      :" + oracleHome + "            remote nodes     :" + nodeNames + "\n            top-level dir    :" + topLevelDir + "\n            temp dir         :" + remoteNodeTempDir + "\n            exclude list     :" + excludeListFile + "\n            regex allowed    :" + excludePathnamesCanBeRegex + "\n            progress listener:" + (progressListener != null ? "exists" : "does not exist"));
        if (IS_UNIX_SYSTEM) {
            File file;
            ClusterCmd.assertDir(topLevelDir, false);
            if (excludeListFile != null && excludeListFile.trim().length() != 0 && !(file = new File(excludeListFile)).canRead()) {
                Object[] args = new String[]{excludeListFile};
                throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
            }
            if (System.getenv("SRVM_USE_RACTRANS") == null && System.getProperty("SRVM_USE_RACTRANS") == null) {
                Trace.out("RAPIDTRANSFER_IS_INVOKED");
                try {
                    RapidTransfer rapidTransfer = new RapidTransfer();
                    String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
                    for (int i = 0; i < remoteNodeNames.length; ++i) {
                        remoteNodeDestDirs[i] = topLevelDir;
                    }
                    List<Object> progressListeners = progressListener != null ? Arrays.asList(progressListener) : new ArrayList();
                    rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, null, false, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, progressListeners);
                    return;
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            try {
                Trace.out("RAC Transfer API invoked.");
                new RACTransfer().transferDirToNodes(oracleHome, remoteNodeNames, topLevelDir, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir);
                return;
            }
            catch (RemoteFileOpException rfoe) {
                throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
            }
        }
        ClusterCmd.assertDir(topLevelDir, true);
        this.transferDirToNodesInternal(remoteNodeNames, topLevelDir, excludeListFile, remoteNodeTempDir, progressListener);
    }

    public void transferListedDirsToNode(String oracleHome, String nodeName, String topLevelDir, String copyListFile, String excludeListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        Trace.out("Calling transferListedDirsToNodes with single node");
        ClusterCmd.assertNode(nodeName);
        this.transferListedDirsToNodes(oracleHome, new String[]{nodeName}, topLevelDir, copyListFile, excludeListFile, tmpDir);
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodes(oracleHome, remoteNodeNames, topLevelDir, copyListFile, false, excludeListFile, false, System.getProperty("java.io.tmpdir"));
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, boolean copyPathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodes(oracleHome, remoteNodeNames, topLevelDir, copyListFile, copyPathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, System.getProperty("java.io.tmpdir"));
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile, String remoteNodeTempDir) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodes(oracleHome, remoteNodeNames, topLevelDir, copyListFile, false, excludeListFile, false, remoteNodeTempDir);
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, boolean copyPathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, copyListFile, copyPathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, null);
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, boolean copyPathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        this.validateProgressListener(progressListener);
        this.transferListedDirsToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, copyListFile, copyPathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, progressListener);
    }

    private void transferListedDirsToNodesInternal(String oracleHome, String[] remoteNodeNames, String topLevelDir, String copyListFile, boolean copyPathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        File exFile;
        ClusterCmd.assertNodes(remoteNodeNames);
        ClusterCmd.assertDir(topLevelDir, true);
        ClusterCmd.assertDir(remoteNodeTempDir, true);
        if (copyListFile == null || copyListFile.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1091", true));
        }
        File cFile = new File(copyListFile);
        if (!cFile.canRead()) {
            Object[] args = new String[]{copyListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        if (excludeListFile != null && excludeListFile.trim().length() != 0 && !(exFile = new File(excludeListFile)).canRead()) {
            Object[] args = new String[]{excludeListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        if (IS_UNIX_SYSTEM) {
            ClusterCmd.assertDir(oracleHome, true);
            if (System.getenv("SRVM_USE_RACTRANS") == null && System.getProperty("SRVM_USE_RACTRANS") == null) {
                Trace.out("RAPIDTRANSFER_IS_INVOKED");
                try {
                    RapidTransfer rapidTransfer = new RapidTransfer();
                    String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
                    for (int i = 0; i < remoteNodeNames.length; ++i) {
                        remoteNodeDestDirs[i] = topLevelDir;
                    }
                    List<Object> progressListeners = progressListener != null ? Arrays.asList(progressListener) : new ArrayList();
                    rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, copyListFile, copyPathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, progressListeners);
                    return;
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            try {
                Trace.out("RAC Transfer API invoked.");
                new RACTransfer().transferListedDirsToNodes(oracleHome, remoteNodeNames, topLevelDir, copyListFile, copyPathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir);
            }
            catch (RemoteFileOpException rfoe) {
                throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
            }
        } else {
            this.transferListedDirsToNodes(remoteNodeNames, topLevelDir, copyListFile, excludeListFile, remoteNodeTempDir);
        }
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, String excludeListFile, String remoteNodeTempDir, String[] remoteNodeDestDir) throws RemoteFileOperationException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, false, excludeListFile, false, remoteNodeTempDir, remoteNodeDestDir);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestCommonDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(remoteNodeNames);
        String[] remoteNodeDestDir = new String[remoteNodeNames.length];
        for (int i = 0; i < remoteNodeDestDir.length; ++i) {
            remoteNodeDestDir[i] = remoteNodeDestCommonDir;
        }
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDir) throws RemoteFileOperationException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir, true);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDir, boolean singleThreadOnly) throws RemoteFileOperationException, ClusterException {
        this.transferDirStructureToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDir, singleThreadOnly, null);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestCommonDir, boolean singleThreadOnly, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(remoteNodeNames);
        String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            remoteNodeDestDirs[i] = remoteNodeDestCommonDir;
        }
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, singleThreadOnly, progressListener);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, boolean singleThreadOnly, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        this.validateProgressListener(progressListener);
        this.transferDirStructureToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, singleThreadOnly, progressListener);
    }

    private void transferDirStructureToNodesInternal(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, boolean singleThreadOnly, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(remoteNodeNames);
        ClusterCmd.assertDir(remoteNodeTempDir, true);
        if (IS_UNIX_SYSTEM) {
            InetAddress localhost;
            boolean useMttrans;
            boolean bl = useMttrans = remoteNodeNames.length >= MultiTierTransferConstants.MIN_NUM_OF_NODES_FOR_MTTRANS;
            if (System.getenv("SRVM_DISABLE_MTTRANS") != null || System.getProperty("SRVM_DISABLE_MTTRANS") != null) {
                useMttrans = false;
            } else if (remoteNodeNames.length == 1) {
                if (IPAddressUtil.isIPAddressString(remoteNodeNames[0])) {
                    if (IPAddressUtil.isLocalhost(remoteNodeNames[0])) {
                        useMttrans = false;
                    }
                } else {
                    localhost = null;
                    try {
                        localhost = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException uhe) {
                        Trace.out("Error retrieving the local host name. Details:\n" + uhe.getMessage());
                        throw new ClusterException(MessageBundle.getMessageBundle(PrCfMsgID.facility).getMessage(PrCfMsgID.UNSUCCESSFUL_LOCAL_NODE_NAME_RETRIEVAL, true));
                    }
                    if (localhost.getHostName().equalsIgnoreCase(remoteNodeNames[0])) {
                        useMttrans = false;
                    }
                }
            }
            Trace.out("Using mttrans for the transfer: " + useMttrans);
            if (useMttrans) {
                localhost = null;
                try {
                    localhost = InetAddress.getLocalHost();
                }
                catch (UnknownHostException uhe) {
                    Trace.out("Error retrieving the local host name. Details:\n" + uhe.getMessage());
                    throw new ClusterException(MessageBundle.getMessageBundle(PrCfMsgID.facility).getMessage(PrCfMsgID.UNSUCCESSFUL_LOCAL_NODE_NAME_RETRIEVAL, true));
                }
                String javaNodeName = localhost.getHostName();
                MultiTierTransfer mttransfer = new MultiTierTransfer();
                try {
                    mttransfer.transferDirStructureToNodes(oracleHome, javaNodeName, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs);
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            if (System.getenv("SRVM_USE_RACTRANS") == null && System.getProperty("SRVM_USE_RACTRANS") == null) {
                Trace.out("RAPIDTRANSFER_IS_INVOKED");
                try {
                    RapidTransfer rapidTransfer = new RapidTransfer();
                    List<Object> progressListeners = progressListener != null ? Arrays.asList(progressListener) : new ArrayList();
                    rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, progressListeners);
                    return;
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            ClusterCmd.assertDir(topLevelDir, false);
            ClusterCmd.assertDir(oracleHome, true);
            RACTransfer racTransfer = new RACTransfer(singleThreadOnly, null);
            try {
                racTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs);
            }
            catch (RemoteFileOpException rfoe) {
                throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
            }
        }
        ClusterCmd.assertDir(topLevelDir, true);
        if (includeListFile != null && !includeListFile.trim().equals("")) {
            this.transferListedDirsToNodes(remoteNodeNames, topLevelDir, includeListFile, excludeListFile, remoteNodeTempDir);
        } else {
            this.transferDirToNodes(remoteNodeNames, topLevelDir, excludeListFile, remoteNodeTempDir);
        }
        Trace.out("Exiting from ClusterCmd.transferDirStructureToNodesInternal()");
    }

    public void transferDirToNodes(String[] remoteNodeNames, String topLevelDir, String excludeListFile) throws RemoteFileOperationException, ClusterException {
        this.transferDirToNodes(remoteNodeNames, topLevelDir, excludeListFile, System.getProperty("java.io.tmpdir"));
    }

    public void transferDirToNodes(String[] remoteNodeNames, String topLevelDir, String excludeListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        this.transferDirToNodesInternal(null, remoteNodeNames, topLevelDir, excludeListFile, false, tmpDir, null);
    }

    public void transferDirToNodes(String[] remoteNodeNames, String topLevelDir, String excludeListFile, String tmpDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        this.validateProgressListener(progressListener);
        this.transferDirToNodesInternal(remoteNodeNames, topLevelDir, excludeListFile, tmpDir, progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferDirToNodesInternal(String[] remoteNodeNames, String topLevelDir, String excludeListFile, String tmpDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(remoteNodeNames);
        ClusterCmd.assertDir(tmpDir, true);
        StringBuilder nodeNames = new StringBuilder();
        int numOfNodes = remoteNodeNames.length;
        for (int i = 0; i < numOfNodes - 1; ++i) {
            nodeNames.append(remoteNodeNames[i] + ", ");
        }
        nodeNames.append(remoteNodeNames[numOfNodes - 1]);
        Trace.out("Calling ClusterCmd.transferDirToNodesInternal() with:\n            remote nodes     : " + nodeNames.toString() + "\n            top-level dir    : " + topLevelDir + "\n            temp dir         : " + tmpDir + "\n            exclude list     : " + excludeListFile + "\n            progress listener: " + (progressListener != null ? "exists" : "does not exist"));
        if (IS_UNIX_SYSTEM) {
            File file;
            ClusterCmd.assertDir(topLevelDir, false);
            if (excludeListFile != null && excludeListFile.trim().length() != 0 && !(file = new File(excludeListFile)).canRead()) {
                Object[] args = new String[]{excludeListFile};
                throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
            }
            if (System.getenv("SRVM_USE_RACTRANS") == null && System.getProperty("SRVM_USE_RACTRANS") == null) {
                Trace.out("RAPIDTRANSFER_IS_INVOKED");
                try {
                    RapidTransfer rapidTransfer = new RapidTransfer();
                    String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
                    for (int i = 0; i < remoteNodeNames.length; ++i) {
                        remoteNodeDestDirs[i] = topLevelDir;
                    }
                    List<Object> progressListeners = progressListener != null ? Arrays.asList(progressListener) : new ArrayList();
                    rapidTransfer.transferDirStructureToNodes(null, remoteNodeNames, topLevelDir, null, false, excludeListFile, false, tmpDir, remoteNodeDestDirs, progressListeners);
                    return;
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            try {
                new RACTransfer().transferDirToNodes(null, remoteNodeNames, topLevelDir, excludeListFile, false, tmpDir);
                return;
            }
            catch (RemoteFileOpException rfoe) {
                throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
            }
        }
        ClusterCmd.assertDir(topLevelDir, true);
        NativeSystem system = new SystemFactory().CreateSystem();
        String newExclListFile = excludeListFile;
        if (excludeListFile != null && excludeListFile.trim().length() != 0) {
            File file = new File(excludeListFile);
            if (!file.canRead()) {
                Object[] args = new String[]{excludeListFile};
                throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
            }
            if (IS_UNIX_SYSTEM) {
                newExclListFile = this.getListFileWithRelPaths(topLevelDir, excludeListFile, tmpDir);
            }
        }
        Command[] transferDirCommands = new TransferDirCommand[remoteNodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            transferDirCommands[i] = (TransferDirCommand)factory.CreateCommand(new TransferDirCommand(remoteNodeNames[i], topLevelDir, newExclListFile), 0);
        }
        ClusterException ce = null;
        if (remoteNodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(remoteNodeNames.length);
            try {
                clusterConfig.submit(transferDirCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (remoteNodeNames.length == 1) {
            Trace.out("TransferDirToNode single node execution");
            ((TransferDirCommand)transferDirCommands[0]).execute();
        }
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        boolean bSuccess = true;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        NativeResult[] results = new NativeResult[remoteNodeNames.length];
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            nodeBuf.append(remoteNodeNames[i] + " ");
            results[i] = transferDirCommands[i].getCommandResult();
            boolean cmdStatus = results[i].getStatus();
            String errors = results[i].getOSString();
            boolean bErrors = errors != null && errors.length() > 0;
            bThrowRemoteFileOpException |= cmdStatus & bErrors;
            bSuccess &= cmdStatus & !bErrors;
            if (!(bThrowClusterException &= !cmdStatus)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{remoteNodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (excludeListFile != null && IS_UNIX_SYSTEM && !excludeListFile.equals(newExclListFile)) {
            new File(newExclListFile).delete();
        }
        if (bThrowClusterException) {
            Trace.out("Top-level dir: " + topLevelDir + lineSep + "Errors       : " + errBuf + lineSep + "Nodes        : " + nodeNames.toString());
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{topLevelDir, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1073", true, args));
        }
        if (bThrowRemoteFileOpException && !bSuccess) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append("Failures occurred on some of the nodes. Details:\n");
            for (int i = 0; i < numOfNodes; ++i) {
                if (results[i].getStatus()) continue;
                errorMsg.append("Node name             : " + remoteNodeNames[i] + lineSep + "OS String (with error): " + results[i].getOSString() + lineSep);
            }
            Trace.out(errorMsg.toString());
            throw new RemoteFileOperationException("1002", results);
        }
    }

    public void transferListedDirsToNodes(String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodes(remoteNodeNames, topLevelDir, copyListFile, excludeListFile, System.getProperty("java.io.tmpdir"));
    }

    public void transferListedDirsToNodes(String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile, String remoteNodeTempDirr) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNodesInternal(remoteNodeNames, topLevelDir, copyListFile, excludeListFile, remoteNodeTempDirr, null);
    }

    public void transferListedDirsToNodes(String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        this.validateProgressListener(progressListener);
        this.transferListedDirsToNodesInternal(remoteNodeNames, topLevelDir, copyListFile, excludeListFile, remoteNodeTempDir, progressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferListedDirsToNodesInternal(String[] remoteNodeNames, String topLevelDir, String copyListFile, String excludeListFile, String remoteNodeTempDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        File exFile;
        ClusterCmd.assertNodes(remoteNodeNames);
        ClusterCmd.assertDir(topLevelDir, true);
        ClusterCmd.assertDir(remoteNodeTempDir, true);
        if (copyListFile == null || copyListFile.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1091", true));
        }
        File cFile = new File(copyListFile);
        if (!cFile.canRead()) {
            Object[] args = new String[]{copyListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        if (excludeListFile != null && excludeListFile.trim().length() != 0 && !(exFile = new File(excludeListFile)).canRead()) {
            Object[] args = new String[]{excludeListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        if (IS_UNIX_SYSTEM) {
            if (System.getenv("SRVM_USE_RACTRANS") == null && System.getProperty("SRVM_USE_RACTRANS") == null) {
                Trace.out("RAPIDTRANSFER_IS_INVOKED");
                try {
                    RapidTransfer rapidTransfer = new RapidTransfer();
                    String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
                    for (int i = 0; i < remoteNodeNames.length; ++i) {
                        remoteNodeDestDirs[i] = topLevelDir;
                    }
                    List<Object> progressListeners = progressListener != null ? Arrays.asList(progressListener) : new ArrayList();
                    rapidTransfer.transferDirStructureToNodes(null, remoteNodeNames, topLevelDir, copyListFile, false, excludeListFile, false, remoteNodeTempDir, remoteNodeDestDirs, progressListeners);
                    return;
                }
                catch (RemoteFileOpException rfoe) {
                    throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
                }
            }
            try {
                Trace.out("RAC Transfer API invoked.");
                new RACTransfer().transferListedDirsToNodes(null, remoteNodeNames, topLevelDir, copyListFile, false, excludeListFile, false, remoteNodeTempDir);
                return;
            }
            catch (RemoteFileOpException rfoe) {
                throw new RemoteFileOperationException("1175", new Object[]{topLevelDir}, rfoe);
            }
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String newCopyListFile = copyListFile;
        String newExclListFile = excludeListFile;
        if (!IS_UNIX_SYSTEM) {
            Trace.out("Processing copyList file");
            newCopyListFile = this.generateCopyListFile(remoteNodeTempDir, topLevelDir, copyListFile);
            if (newCopyListFile == null) {
                Object[] args = new String[]{copyListFile};
                args[1] = remoteNodeNames.toString();
                throw new ClusterException(s_msgBundle.getMessage("1088", true, args));
            }
        } else {
            newCopyListFile = this.getListFileWithRelPaths(topLevelDir, copyListFile, remoteNodeTempDir);
            if (excludeListFile != null) {
                newExclListFile = this.getListFileWithRelPaths(topLevelDir, excludeListFile, remoteNodeTempDir);
            }
        }
        Command[] transferListedDirsCommands = new TransferListedDirsCommand[remoteNodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            transferListedDirsCommands[i] = (TransferListedDirsCommand)factory.CreateCommand(new TransferListedDirsCommand(remoteNodeNames[i], topLevelDir, newCopyListFile, newExclListFile), 0);
        }
        ClusterException ce = null;
        if (remoteNodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(remoteNodeNames.length);
            try {
                clusterConfig.submit(transferListedDirsCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (remoteNodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((TransferListedDirsCommand)transferListedDirsCommands[0]).execute();
        }
        NativeResult[] resultObj = new NativeResult[remoteNodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        boolean bSuccess = true;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            nodeBuf.append(remoteNodeNames[i] + " ");
            resultObj[i] = transferListedDirsCommands[i].getCommandResult();
            String errors = resultObj[i].getOSString();
            boolean bStatus = resultObj[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            bSuccess &= bStatus & !bErrors;
            if (!(bThrowClusterException &= !bStatus)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{remoteNodeNames[i], resultObj[i].getException() != null ? resultObj[i].getException().getMessage() : resultObj[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        Trace.out("Deleting the file: " + newCopyListFile);
        new File(newCopyListFile).delete();
        if (excludeListFile != null && IS_UNIX_SYSTEM) {
            new File(newExclListFile).delete();
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{copyListFile, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1078", true, args));
        }
        if (bThrowRemoteFileOpException && !bSuccess) {
            throw new RemoteFileOperationException("1002", resultObj);
        }
    }

    public void transferListedDirsToNode(String nodeName, String topLevelDir, String copyListFile, String excludeListFile) throws RemoteFileOperationException, ClusterException {
        this.transferListedDirsToNode(nodeName, topLevelDir, copyListFile, excludeListFile, System.getProperty("java.io.tmpdir"));
    }

    public void transferListedDirsToNode(String nodeName, String topLevelDir, String copyListFile, String excludeListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        Trace.out("Calling transferListedDirsToNodes() with single node");
        ClusterCmd.assertNode(nodeName);
        this.transferListedDirsToNodes(new String[]{nodeName}, topLevelDir, copyListFile, excludeListFile, tmpDir);
    }

    public void transferListedFilesToNode(String nodeName, String oracleHome, String copyListFile) throws RemoteFileOperationException, ClusterException {
        this.transferListedFilesToNode(nodeName, oracleHome, copyListFile, System.getProperty("java.io.tmpdir"));
    }

    public void transferListedFilesToNode(String nodeName, String oracleHome, String copyListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        this.transferListedFilesToNodes(new String[]{nodeName}, oracleHome, copyListFile, tmpDir);
    }

    public void transferListedFilesToNodes(String[] nodeNames, String oracleHome, String copyListFile) throws RemoteFileOperationException, ClusterException {
        this.transferListedFilesToNodes(nodeNames, oracleHome, copyListFile, System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferListedFilesToNodes(String[] nodeNames, String oracleHome, String copyListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(oracleHome, true);
        ClusterCmd.assertDir(tmpDir, true);
        if (copyListFile == null || copyListFile.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1091", true));
        }
        File file = new File(copyListFile);
        if (!file.canRead()) {
            Object[] args = new String[]{copyListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        NativeSystem system = new SystemFactory().CreateSystem();
        String newCopyListFile = copyListFile;
        if (IS_UNIX_SYSTEM) {
            newCopyListFile = this.getListFileWithRelPaths(oracleHome, copyListFile, tmpDir);
        }
        Command[] transferListedFilesCommands = new TransferListedFilesCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            transferListedFilesCommands[i] = (TransferListedFilesCommand)factory.CreateCommand(new TransferListedFilesCommand(nodeNames[i], oracleHome, newCopyListFile), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
            try {
                clusterConfig.submit(transferListedFilesCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((TransferListedFilesCommand)transferListedFilesCommands[0]).execute();
        }
        NativeResult[] results = new NativeResult[nodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = transferListedFilesCommands[i].getCommandResult();
            String errors = results[i].getOSString();
            boolean bStatus = results[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            boolean bl = !bStatus;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            if (!(bThrowClusterException &= bl)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (IS_UNIX_SYSTEM) {
            new File(newCopyListFile).delete();
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{copyListFile, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1073", true, args));
        }
        if (bThrowRemoteFileOpException) {
            throw new RemoteFileOperationException("1002", results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferFileToNodes(String[] nodeNames, String oracleHome, String sourceFile) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(oracleHome, true);
        ClusterCmd.assertFile(sourceFile);
        File file = new File(sourceFile);
        if (!file.exists()) {
            Object[] args = new String[]{sourceFile, "localnode"};
            throw new ClusterException(s_msgBundle.getMessage("1027", true, args));
        }
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (IS_UNIX_SYSTEM) {
            if (!sourceFile.startsWith(oracleHome)) {
                Object[] args = new String[]{sourceFile};
                throw new ClusterException(s_msgBundle.getMessage("1079", true, args));
            }
        } else if (!sourceFile.toLowerCase().startsWith(oracleHome.toLowerCase())) {
            Object[] args = new String[]{sourceFile};
            throw new ClusterException(s_msgBundle.getMessage("1079", true, args));
        }
        Command[] transferFileCommands = new TransferFileCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            transferFileCommands[i] = (TransferFileCommand)factory.CreateCommand(new TransferFileCommand(nodeNames[i], oracleHome, sourceFile), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
            try {
                clusterConfig.submit(transferFileCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((TransferFileCommand)transferFileCommands[0]).execute();
        }
        NativeResult[] results = new NativeResult[nodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = transferFileCommands[i].getCommandResult();
            String errors = results[i].getOSString();
            boolean bStatus = results[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            boolean bl = !bStatus;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            if (!(bThrowClusterException &= bl)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{sourceFile, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1080", true, args));
        }
        if (bThrowRemoteFileOpException) {
            throw new RemoteFileOperationException("1002", results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPathInNodes(String[] nodeNames, String pathName, String oracleHome) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(pathName, false);
        ClusterCmd.assertDir(oracleHome, true);
        if (!pathName.startsWith(oracleHome)) {
            Object[] args = new String[]{pathName};
            throw new ClusterException(s_msgBundle.getMessage("1079", true, args));
        }
        Command[] dirCreateCommands = new DirCreateCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            dirCreateCommands[i] = (DirCreateCommand)factory.CreateCommand(new DirCreateCommand(nodeNames[i], pathName, false), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
            try {
                clusterConfig.submit(dirCreateCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((DirCreateCommand)dirCreateCommands[0]).execute();
        }
        NativeResult[] results = new CommandResult[nodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = dirCreateCommands[i].getCommandResult();
            results[i].setNodeName(nodeNames[i]);
            String errString = ((CommandResult)results[i]).getErrorString();
            if (errString != null && (!IS_UNIX_SYSTEM && errString.trim().length() > 0 || IS_UNIX_SYSTEM && errString.indexOf("successful") < 0)) {
                Trace.out("resString = " + errString);
                results[i].setOSString(errString);
            }
            String errors = results[i].getOSString();
            boolean bStatus = results[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            boolean bl = !bStatus;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            if (!(bThrowClusterException &= bl)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{pathName, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1084", true, args));
        }
        if (bThrowRemoteFileOpException) {
            Trace.out("RemoteFileOperation Exception will be thrown");
            throw new RemoteFileOperationException("1002", results);
        }
    }

    private String generateNewListFile(String tmpDir, String listFile, boolean remAction) throws ClusterException {
        Trace.out("Generating listFile in directory:" + tmpDir + " using the given list file: " + listFile);
        String scratchFileName = null;
        BufferedReader bufRead = null;
        PrintWriter scratchOut = null;
        Trace.out("Generating listFile in directory:" + tmpDir + " using the given list file: " + listFile);
        try {
            String curr_line;
            File newListFile = new File(listFile);
            newListFile = File.createTempFile(newListFile.getName(), "tmp", new File(tmpDir));
            scratchFileName = newListFile.getAbsolutePath();
            Trace.out("scratchFileName = " + scratchFileName);
            bufRead = new BufferedReader(new FileReader(listFile));
            scratchOut = new PrintWriter(new FileOutputStream(scratchFileName, true), true);
            while ((curr_line = bufRead.readLine()) != null) {
                if (!IS_UNIX_SYSTEM) {
                    curr_line = curr_line.trim();
                    StringBuilder pathname = new StringBuilder("\"");
                    pathname.append(curr_line);
                    pathname.append(File.separator);
                    pathname.append("\";");
                    scratchOut.println(pathname.toString().replace(':', '$'));
                    continue;
                }
                if (!remAction) continue;
                curr_line = curr_line.trim().concat("/");
                scratchOut.println(curr_line);
            }
        }
        catch (IOException ioe) {
            Trace.out("Can't determine path of include files");
            Trace.out(ioe.getMessage());
            throw new ClusterException(ioe.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                    scratchOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        return scratchFileName;
    }

    public void createListedDirsOnNode(String nodeName, String createListFile, String oracleHome) throws RemoteFileOperationException, ClusterException {
        this.createListedDirsOnNode(nodeName, createListFile, oracleHome, System.getProperty("java.io.tmpdir"));
    }

    public void createListedDirsOnNode(String nodeName, String createListFile, String oracleHome, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        this.createListedDirsOnNodes(new String[]{nodeName}, createListFile, oracleHome, tmpDir);
    }

    public void createListedDirsOnNodes(String[] nodeNames, String createListFile, String oracleHome) throws RemoteFileOperationException, ClusterException {
        this.createListedDirsOnNodes(nodeNames, createListFile, oracleHome, System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createListedDirsOnNodes(String[] nodeNames, String createListFile, String oracleHome, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(oracleHome, true);
        ClusterCmd.assertDir(tmpDir, true);
        if (createListFile == null || createListFile.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1067", true));
        }
        File file = new File(createListFile);
        if (!file.canRead()) {
            Object[] args = new String[]{createListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        this.validateListFile(oracleHome, createListFile);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        String newCreateListFile = createListFile;
        if (!IS_UNIX_SYSTEM) {
            Trace.out("Processing createList file");
            newCreateListFile = this.generateNewListFile(tmpDir, createListFile, false);
            if (newCreateListFile == null) {
                Object[] args = new String[]{createListFile};
                args[1] = nodeNames.toString();
                throw new ClusterException(s_msgBundle.getMessage("1098", true, args));
            }
        }
        Command[] createListedDirsCommands = new CreateListedDirsCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            createListedDirsCommands[i] = (CreateListedDirsCommand)factory.CreateCommand(new CreateListedDirsCommand(nodeNames[i], newCreateListFile), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
            try {
                clusterConfig.submit(createListedDirsCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((CreateListedDirsCommand)createListedDirsCommands[0]).execute();
        }
        NativeResult[] results = new NativeResult[nodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = createListedDirsCommands[i].getCommandResult();
            String errors = results[i].getOSString();
            boolean bStatus = results[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            boolean bl = !bStatus;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            if (!(bThrowClusterException &= bl)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (newCreateListFile != null && !IS_UNIX_SYSTEM) {
            new File(newCreateListFile).delete();
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{createListFile, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1082", true, args));
        }
        if (bThrowRemoteFileOpException) {
            throw new RemoteFileOperationException("1002", results);
        }
    }

    public void removeListedDirsFromNodes(String[] nodeNames, String removeListFile) throws RemoteFileOperationException, ClusterException {
        this.removeListedDirsFromNodes(nodeNames, removeListFile, System.getProperty("java.io.tmpdir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListedDirsFromNodes(String[] nodeNames, String removeListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNodes(nodeNames);
        ClusterCmd.assertDir(tmpDir, true);
        if (removeListFile == null || removeListFile.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1067", true));
        }
        File file = new File(removeListFile);
        if (!file.canRead()) {
            Object[] args = new String[]{removeListFile};
            throw new ClusterException(s_msgBundle.getMessage("1026", true, args));
        }
        String newRemoveListFile = removeListFile;
        Trace.out("Processing removeList file");
        newRemoveListFile = this.generateNewListFile(tmpDir, removeListFile, true);
        if (newRemoveListFile == null) {
            Object[] args = new String[]{removeListFile, nodeNames.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1098", true, args));
        }
        Command[] removeListedDirsCommands = new RemoveListedDirsCommand[nodeNames.length];
        CommandFactory factory = new CommandFactory();
        for (int i = 0; i < nodeNames.length; ++i) {
            removeListedDirsCommands[i] = (RemoveListedDirsCommand)factory.CreateCommand(new RemoveListedDirsCommand(nodeNames[i], newRemoveListFile), 0);
        }
        ClusterException ce = null;
        if (nodeNames.length > 1) {
            ClusterConfig clusterConfig = ClusterConfig.init(nodeNames.length);
            try {
                clusterConfig.submit(removeListedDirsCommands, true);
            }
            catch (ClusterException e) {
                ce = e;
                Trace.out(ce);
            }
            finally {
                clusterConfig.destroy();
            }
        } else if (nodeNames.length == 1) {
            Trace.out("Single node execution will not using clientResources");
            ((RemoveListedDirsCommand)removeListedDirsCommands[0]).execute();
        }
        NativeResult[] results = new NativeResult[nodeNames.length];
        boolean bThrowClusterException = true;
        boolean bThrowRemoteFileOpException = false;
        StringBuffer nodeBuf = new StringBuffer();
        StringBuffer errBuf = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeBuf.append(nodeNames[i] + " ");
            results[i] = removeListedDirsCommands[i].getCommandResult();
            String errors = results[i].getOSString();
            boolean bStatus = results[i].getStatus();
            boolean bErrors = errors != null && errors.length() > 0;
            boolean bl = !bStatus;
            bThrowRemoteFileOpException |= bStatus & bErrors;
            if (!(bThrowClusterException &= bl)) continue;
            errBuf.append(lineSep);
            Object[] args = new String[]{nodeNames[i], results[i].getException() != null ? results[i].getException().getMessage() : results[i].getOSString()};
            errBuf.append(s_msgBundle.getMessage("1074", false, args));
        }
        if (newRemoveListFile != null) {
            new File(newRemoveListFile).delete();
        }
        if (bThrowClusterException) {
            if (ce != null) {
                throw ce;
            }
            Object[] args = new String[]{removeListFile, nodeBuf.toString(), errBuf.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1083", true, args));
        }
        if (bThrowRemoteFileOpException) {
            throw new RemoteFileOperationException("1002", results);
        }
    }

    public void removeListedDirsFromNode(String nodeName, String removeListFile) throws RemoteFileOperationException, ClusterException {
        this.removeListedDirsFromNode(nodeName, removeListFile, System.getProperty("java.io.tmpdir"));
    }

    public void removeListedDirsFromNode(String nodeName, String removeListFile, String tmpDir) throws RemoteFileOperationException, ClusterException {
        ClusterCmd.assertNode(nodeName);
        this.removeListedDirsFromNodes(new String[]{nodeName}, removeListFile, tmpDir);
    }

    static final void assertUser(String user) throws ClusterException {
        if (user == null || user.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1045", true));
        }
    }

    static final void assertNode(String node) throws ClusterException {
        if (node == null || node.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1045", true));
        }
    }

    static final void assertNodes(String[] nodeList) throws ClusterException {
        if (nodeList == null || nodeList.length == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1062", true));
        }
    }

    static final void assertFile(String filePathname) throws ClusterException {
        ClusterCmd.assertFile(filePathname, false, false);
    }

    static final void assertFile(String filePathname, boolean checkForExistence, boolean checkIfFile) throws ClusterException {
        if (filePathname == null || filePathname.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1067", true));
        }
        if (checkForExistence && !new File(filePathname).exists()) {
            Object[] args = new Object[]{filePathname};
            throw new ClusterException(s_msgBundle.getMessage("1144", true, args));
        }
        if (checkIfFile && !new File(filePathname).isFile()) {
            Object[] args = new Object[]{filePathname};
            throw new ClusterException(s_msgBundle.getMessage("1162", true, args));
        }
    }

    static final void assertDir(String dirName, boolean checkPathType) throws ClusterException {
        if (dirName == null || dirName.trim().length() == 0) {
            throw new ClusterException(s_msgBundle.getMessage("1055", true));
        }
        if (checkPathType && !new File(dirName).isDirectory()) {
            Object[] args = new String[]{dirName};
            throw new ClusterException(s_msgBundle.getMessage("1032", true, args));
        }
    }

    private void validateProgressListener(ProgressListener progressListener) throws ClusterException {
        if (progressListener == null) {
            Object[] args = new Object[]{"error-progress-listener"};
            throw new ClusterException(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, args));
        }
    }

    private void validateListFile(String oracleHome, String listFile) throws ClusterException {
        Trace.out("Validating listFile for transfer APIs");
        Trace.out("oracleHome = " + oracleHome);
        BufferedReader bufRead = null;
        boolean bInvalidList = false;
        StringBuffer invalidFiles = new StringBuffer();
        int nInclFiles = 0;
        NativeSystem system = new SystemFactory().CreateSystem();
        try {
            String filePath;
            bufRead = new BufferedReader(new FileReader(listFile));
            while ((filePath = bufRead.readLine()) != null) {
                Trace.out("filePath = " + filePath);
                ++nInclFiles;
                if (IS_UNIX_SYSTEM) {
                    if (filePath.indexOf(oracleHome) != -1) continue;
                    bInvalidList = true;
                    invalidFiles.append(filePath);
                    continue;
                }
                if (filePath.toLowerCase().indexOf(oracleHome.toLowerCase()) != -1) continue;
                bInvalidList = true;
                invalidFiles.append(filePath);
            }
        }
        catch (IOException ie) {
            Trace.out("Can't determine path of include files");
            Trace.out(ie.getMessage());
            throw new ClusterException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (nInclFiles == 0) {
            Object[] args = new String[]{listFile};
            throw new ClusterException(s_msgBundle.getMessage("1089", true, args));
        }
        if (bInvalidList) {
            Object[] args = new String[]{listFile, invalidFiles.toString()};
            throw new ClusterException(s_msgBundle.getMessage("1077", true, args));
        }
    }

    private String getListFileWithRelPaths(String pathName, String listFile, String tmpDir) throws ClusterException {
        Trace.out("constructing a listFile with files relative to:" + pathName);
        String scratchFileName = null;
        BufferedReader bufRead = null;
        PrintWriter out = null;
        String filePath = null;
        int nFiles = 0;
        boolean bEndsWithSlash = pathName.endsWith(System.getProperty("file.separator"));
        String replaceString = bEndsWithSlash ? "./" : ".";
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            filePath = bufRead.readLine();
            if (filePath != null) {
                if (filePath.indexOf(pathName) < 0) {
                    Trace.out("List file has the relative paths. Nothing to do");
                    scratchFileName = listFile;
                    nFiles = -1;
                } else {
                    Trace.out("Creating a temporary listFile");
                    File copyListFile = new File(listFile);
                    copyListFile = File.createTempFile(copyListFile.getName(), "tmp", new File(tmpDir));
                    scratchFileName = copyListFile.getAbsolutePath();
                    Trace.out("scratchFileName = " + scratchFileName);
                    out = new PrintWriter(new FileOutputStream(scratchFileName, true), true);
                    out.println(filePath.replaceFirst(pathName, replaceString));
                    ++nFiles;
                    while ((filePath = bufRead.readLine()) != null) {
                        out.println(filePath.replaceFirst(pathName, replaceString));
                        ++nFiles;
                    }
                }
            }
        }
        catch (IOException ie) {
            Trace.out("Can't determine path of include files");
            Trace.out(ie.getMessage());
            throw new ClusterException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                out.close();
            }
        }
        if (nFiles == 0) {
            Object[] args = new String[]{listFile};
            throw new ClusterException(s_msgBundle.getMessage("1089", true, args));
        }
        return scratchFileName;
    }

    private String generateCopyListFile(String tmpDir, String oracleHome, String listFile) throws ClusterException {
        Trace.out("Generating listFile in directory:" + tmpDir + " using the given copy list file: " + listFile);
        int nFiles = 0;
        String scratchFileName = null;
        BufferedReader bufRead = null;
        try {
            bufRead = new BufferedReader(new FileReader(listFile));
            String filePath = bufRead.readLine();
            if (filePath != null) {
                File copyListFile = new File(listFile);
                copyListFile = File.createTempFile(copyListFile.getName(), "tmp", new File(tmpDir));
                scratchFileName = copyListFile.getAbsolutePath();
                Trace.out("scratchFileName = " + scratchFileName);
                boolean bRelPaths = filePath.toLowerCase().indexOf(oracleHome.toLowerCase()) < 0;
                Trace.out("bRelPaths = " + bRelPaths);
                while (filePath != null) {
                    ++nFiles;
                    String absPath = filePath;
                    if (bRelPaths) {
                        absPath = oracleHome + File.separator + filePath;
                    }
                    this.listFilesRecurse(absPath, scratchFileName);
                    filePath = bufRead.readLine();
                }
            }
        }
        catch (IOException ie) {
            Trace.out("Can't determine path of include files");
            Trace.out(ie.getMessage());
            throw new ClusterException(ie.getMessage());
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (nFiles == 0) {
            Object[] args = new String[]{listFile};
            throw new ClusterException(s_msgBundle.getMessage("1089", true, args));
        }
        return scratchFileName;
    }

    private String[] combineCmdArgs(String cmd, String[] args) {
        String[] commands = null;
        commands = args != null ? new String[args.length + 1] : new String[]{cmd};
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                commands[i + 1] = args[i];
            }
        }
        return commands;
    }
}

