/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.DeviceException;
import oracle.ops.mgmt.cluster.GetActiveNodes;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.LocalCommand;
import oracle.ops.mgmt.command.RemoteCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.DatabaseException;
import oracle.ops.mgmt.database.ListenerException;
import oracle.ops.mgmt.database.ParallelServer;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.QueryCluster;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.operation.ListParallelServersOperation;
import oracle.ops.mgmt.operation.ListParallelServersResult;
import oracle.ops.mgmt.operation.OperationResult;
import oracle.ops.mgmt.operation.ReloadListenerOperation;
import oracle.ops.mgmt.operation.ReloadListenerResult;
import oracle.ops.mgmt.rawdevice.NetworkInterface;
import oracle.ops.mgmt.rawdevice.OCR;
import oracle.ops.mgmt.rawdevice.OCRException;
import oracle.ops.mgmt.rawdevice.OCRTree;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinition;
import oracle.ops.mgmt.rawdevice.OCRTreeDefinitionHA;
import oracle.ops.mgmt.rawdevice.OCRTreeHA;
import oracle.ops.mgmt.rawdevice.RawDeviceException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class Cluster
implements Constants {
    private static Version s_version = new Version();
    private static boolean s_isCluster = false;
    private static boolean s_isClusterSet = false;

    private Cluster() {
    }

    public static boolean isCluster() {
        if (s_isClusterSet) {
            return s_isCluster;
        }
        try {
            s_isCluster = Cluster.isCluster("localnode", s_version);
            s_isClusterSet = true;
            return s_isCluster;
        }
        catch (ClusterInfoException e) {
            Trace.out(e);
            return false;
        }
        catch (ClusterException e) {
            Trace.out(e);
            return false;
        }
    }

    public static boolean isCluster(String node, Version version) throws ClusterException, ClusterInfoException {
        block6: {
            if (Version.isPre10i(version)) {
                return true;
            }
            try {
                if (!OCR.isCluster()) break block6;
                if (!node.equals("localnode")) {
                    String[] nodes = Cluster.getNodes();
                    if (nodes != null) {
                        for (int i = 0; i < nodes.length; ++i) {
                            if (!node.equals(nodes[i])) continue;
                            return true;
                        }
                    }
                    break block6;
                }
                return true;
            }
            catch (OCRException e) {
                throw new ClusterException(e.getMessage(), e);
            }
        }
        return false;
    }

    public static boolean isVendorCluster() {
        return new QueryCluster().isCluster();
    }

    public static Version getVersion() {
        return s_version;
    }

    public static String getVersionString() {
        return s_version.toString();
    }

    public static String[] getNodes() throws ClusterException {
        GetActiveNodes getActiveNodes = GetActiveNodes.create();
        return getActiveNodes.getNodeList();
    }

    public static String getLocalNode() throws ClusterException {
        if (Cluster.isCluster()) {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
            return getActiveNodes.getNodeName();
        }
        return Cluster.getHostName();
    }

    public static String getHostName() throws ClusterException {
        return GetActiveNodes.getHostName();
    }

    public static Version getParallelServerVersion(String dbName) throws ConfigurationException {
        Trace.out("Attempting to get version of " + dbName);
        Version retVersion = null;
        if (Cluster.isParallelServerConfigured(dbName)) {
            try {
                OCRTree ocrTree = OCRTree.init(new Version());
                String dbVersionKey = ocrTree.getTreeDefinition().getDBVersionKey(dbName);
                if (!ocrTree.keyExists(dbVersionKey)) {
                    return Version.get92Version();
                }
                String versionString = ocrTree.getKeyValue(dbVersionKey);
                retVersion = Version.getVersion(versionString);
            }
            catch (OCRException ex) {
                throw new ConfigurationException(ex.getMessage());
            }
            if (retVersion != null) {
                return retVersion;
            }
        }
        Object[] args = new Object[]{dbName};
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        String msg = msgBundle.getMessage("1136", true, args);
        throw new ConfigurationException(msg);
    }

    public static String[] listParallelServers(Version v) throws ConfigurationException {
        Trace.out("Attempting to get parallel servers of version " + v);
        String[] allServers = Cluster.listParallelServers();
        if (allServers == null || allServers.length == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < allServers.length; ++i) {
            try {
                ParallelServer ps = Cluster.getParallelServer(allServers[i], null, v);
                if (ps == null) continue;
                ParallelServerConfig config = ps.getConfiguration();
                Trace.out("adding " + allServers[i]);
                list.add(allServers[i]);
                continue;
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        if (list.size() > 0) {
            String[] retArray = new String[list.size()];
            retArray = list.toArray(retArray);
            return retArray;
        }
        Trace.out("returning empty array");
        return new String[0];
    }

    public static String[] listParallelServers() throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
        ListParallelServersOperation listParallelServersOperation = new ListParallelServersOperation(s_version);
        LocalCommand localCommand = new LocalCommand(listParallelServersOperation);
        localCommand.execute();
        OperationResult result = null;
        result = localCommand.getOperationResult();
        if (result.getStatus() != 0) {
            Trace.out("Parallel Server list failed: " + result.getStatus());
            MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkr");
            String msg = msgBundle.getMessage("1027", true);
            throw new ConfigurationException(msg);
        }
        ListParallelServersResult listResult = (ListParallelServersResult)result;
        return listResult.getResult();
    }

    public static synchronized String[] listOracleHomes(Version v) throws OCRException {
        try {
            ClusterInfo.assertVersion(v);
        }
        catch (ClusterInfoException e) {
            throw new OCRException(e.getMessage());
        }
        String[] ohList = null;
        OCRTree ocrTree = OCRTree.init(v, 7);
        ohList = ocrTree.listOracleHomes();
        return ohList;
    }

    public static boolean isParallelServerConfigured(String dbName) {
        return Cluster.isParallelServerConfigured(dbName, null);
    }

    public static boolean isParallelServerConfigured(String dbName, String dbDomain) {
        return Cluster.isParallelServerConfigured(dbName, dbDomain, s_version);
    }

    public static boolean isParallelServerConfigured(String dbName, String dbDomain, Version version) {
        if (dbName == null || dbName.trim().length() == 0) {
            Trace.out("Invalid database name passed=" + dbName);
            return false;
        }
        if (dbDomain != null && dbDomain.trim().length() == 0) {
            Trace.out("Invalid database domain passed=" + dbDomain);
            return false;
        }
        try {
            ClusterInfo.assertVersion(version);
            OCRTree ocrTree = OCRTree.init(version, 7);
            return ocrTree.isDatabaseConfigured(dbName, dbDomain);
        }
        catch (OCRException oe) {
            return false;
        }
        catch (ClusterInfoException oe) {
            return false;
        }
    }

    public static ParallelServer getParallelServer(String dbName) throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.getMessage());
        }
        Version dbVer = Cluster.getParallelServerVersion(dbName);
        return Cluster.getParallelServer(dbName, null, dbVer);
    }

    public static ParallelServer getParallelServer(String dbName, String dbDomain) throws ConfigurationException {
        Version dbVer = Cluster.getParallelServerVersion(dbName);
        return Cluster.getParallelServer(dbName, dbDomain, dbVer);
    }

    public static ParallelServer getParallelServer(String dbName, String dbDomain, Version version) throws ConfigurationException {
        if (dbName == null) {
            throw new ConfigurationException(MessageBundle.getMessageBundle("Prkp").getMessage("1081", true));
        }
        if (Cluster.isParallelServerConfigured(dbName, dbDomain, version)) {
            return ParallelServer.init(dbName, dbDomain, version);
        }
        throw new ConfigurationException(MessageBundle.getMessageBundle("Prkr").getMessage("1001", true, new String[]{dbName}));
    }

    public static ParallelServer createParallelServer(String dbName, String oracleHome) throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (ClusterException e) {
            throw new ConfigurationException(e.getMessage());
        }
        ParallelServer ops = ParallelServer.init(dbName, s_version);
        try {
            ops.create(oracleHome);
        }
        catch (DatabaseException de) {
            throw new ConfigurationException(de.getMessage());
        }
        return ops;
    }

    public static ParallelServer createParallelServer(String dbName, String oracleHome, Version v) throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (ClusterException e) {
            throw new ConfigurationException(e.getMessage());
        }
        ParallelServer ops = ParallelServer.init(dbName, v);
        try {
            ops.create(oracleHome);
        }
        catch (DatabaseException de) {
            throw new ConfigurationException(de.getMessage());
        }
        return ops;
    }

    public static ParallelServer createParallelServer(String dbName, String oracleHome, String spfileName) throws ConfigurationException {
        return Cluster.createParallelServer(dbName, oracleHome, spfileName, s_version);
    }

    public static ParallelServer createParallelServer(String dbName, String oracleHome, String spfileName, Version v) throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (ClusterException e) {
            throw new ConfigurationException(e.getMessage());
        }
        ParallelServer ops = ParallelServer.init(dbName, v);
        try {
            ops.create(oracleHome, spfileName);
        }
        catch (DatabaseException de) {
            throw new ConfigurationException(de.getMessage());
        }
        return ops;
    }

    public static ParallelServer createParallelServer(String dbName, String domainName, String oracleHome, String spfileName) throws ConfigurationException {
        return Cluster.createParallelServer(dbName, domainName, oracleHome, spfileName, null, null, null, null, s_version);
    }

    public static ParallelServer createParallelServer(String dbName, String domainName, String oracleHome, String spfileName, VIPAddress dbCluAlias) throws ConfigurationException {
        return Cluster.createParallelServer(dbName, domainName, oracleHome, spfileName, dbCluAlias, null, null, null, s_version);
    }

    public static ParallelServer createParallelServer(String dbName, String domainName, String oracleHome, String spfileName, VIPAddress dbCluAlias, Version version) throws ConfigurationException {
        return Cluster.createParallelServer(dbName, domainName, oracleHome, spfileName, dbCluAlias, null, null, null, version);
    }

    public static ParallelServer createParallelServer(String dbUniqName, String domainName, String oracleHome, String spfileName, VIPAddress dbCluAlias, String dbName, String role, String startOpt, Version version) throws ConfigurationException {
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (ClusterException e) {
            throw new ConfigurationException(e.getMessage());
        }
        ParallelServer ops = ParallelServer.init(dbUniqName, domainName, version);
        try {
            ops.create(oracleHome, spfileName, dbCluAlias, dbName, role, startOpt);
        }
        catch (DatabaseException de) {
            throw new ConfigurationException(de.getMessage());
        }
        return ops;
    }

    public static boolean validateRawDevice(String deviceName) throws RawDeviceException {
        NativeResult nativeResult;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        if (deviceName == null) {
            Trace.out("Cluster.validateRawDevice: deviceName passed is null");
            throw new RawDeviceException(msgBundle.getMessage("1067", true));
        }
        try {
            nativeResult = nativeSystem.validateRawDevice(deviceName);
        }
        catch (NativeException ne) {
            Object[] args = new String[]{deviceName};
            String exceptionMsg = msgBundle.getMessage("1157", true, args);
            throw new RawDeviceException(exceptionMsg, ne);
        }
        if (!nativeResult.getStatus()) {
            Object[] args = new String[]{deviceName, nativeResult.getOSString()};
            throw new RawDeviceException(msgBundle.getMessage("1156", true, args));
        }
        return nativeResult.getBooleanResult();
    }

    public static boolean validateDevice(String deviceName) throws DeviceException {
        NativeResult nativeResult;
        NativeSystem nativeSystem = null;
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        if (deviceName == null) {
            Trace.out("Cluster.validateDevice: deviceName passed is null");
            throw new DeviceException(msgBundle.getMessage("1067", true));
        }
        nativeSystem = new SystemFactory().CreateSystem();
        try {
            nativeResult = nativeSystem.validateDevice(deviceName);
        }
        catch (NativeException ne) {
            Object[] args = new String[]{deviceName};
            String exceptionMsg = msgBundle.getMessage("1159", true, args);
            throw new DeviceException(exceptionMsg, ne);
        }
        if (!nativeResult.getStatus()) {
            Object[] args = new String[]{deviceName, nativeResult.getOSString()};
            throw new DeviceException(msgBundle.getMessage("1158", true, args));
        }
        return nativeResult.getBooleanResult();
    }

    public static synchronized boolean isSharedPath(String pathName, String[] nodeList) throws SharedDeviceException, InvalidNodeListException {
        Cluster.verifyNodeList(nodeList);
        String localNode = null;
        try {
            localNode = GetActiveNodes.create().getNodeName();
        }
        catch (ClusterException e) {
            Trace.out("Cluster.isSharedPath: unable to get local node name");
        }
        return Cluster.isSharedPath(pathName, nodeList, localNode);
    }

    public static synchronized boolean isSharedPath(String pathName, String[] nodeList, String localNode) throws SharedDeviceException, InvalidNodeListException {
        String dirPath;
        if (nodeList == null) {
            Trace.out("Cluster.isSharedPath: nodeList passed is null");
            throw new InvalidNodeListException("Prkc", "1062");
        }
        if (pathName == null) {
            Trace.out("Cluster.isSharedPath: pathName passed is null");
            throw new SharedDeviceException(MessageBundle.getMessageBundle("Prkc").getMessage("1055", true));
        }
        Trace.out("NodeList=" + Arrays.asList(nodeList));
        HashSet<String> nodeSet = new HashSet<String>();
        for (String curnode : nodeList) {
            nodeSet.add(curnode);
        }
        String[] effectiveNodeList = nodeSet.toArray(new String[nodeSet.size()]);
        File file = new File(pathName);
        try {
            dirPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            dirPath = file.getAbsolutePath();
        }
        boolean isPathShared = true;
        String node4ErrorTrc = "";
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        ClusterwareInfo cwInfo = new ClusterwareInfo();
        try {
            String crsHome = cwInfo.getCRSHome(new Version());
            if (cwInfo.isACFSDriversSupported(crsHome)) {
                File path = Cluster.getExistingParentDirectory(dirPath, effectiveNodeList);
                String mtPoint = path != null ? path.getAbsolutePath() : dirPath;
                String binaryPath = Utils.isDevelopmentEnv() ? crsHome + "/usm" : crsHome;
                String[] stringArray = effectiveNodeList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String node;
                    node4ErrorTrc = node = stringArray[i];
                    isPathShared &= cwInfo.isPathOnACFS(binaryPath, mtPoint, node);
                }
            } else {
                isPathShared = false;
            }
        }
        catch (InstallException ie) {
            Trace.out("failure to run isPathOnACFS on node " + node4ErrorTrc);
            Trace.out("Error: " + ie.getMessage());
            isPathShared = false;
        }
        if (!isPathShared && isUnix) {
            Trace.out("pathName=" + pathName + " dirPath = " + dirPath);
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            NativeResult result = nativeSystem.isSharedPath(dirPath, effectiveNodeList, localNode);
            return result.getBooleanResult();
        }
        return isPathShared;
    }

    public static synchronized boolean isSharedPathWithNodes(String pathName, String[] nodeList) throws SharedDeviceException, InvalidNodeListException {
        Cluster.verifyNodeList(nodeList);
        String localNode = null;
        try {
            localNode = GetActiveNodes.create().getNodeName();
        }
        catch (ClusterException ce) {
            Trace.out("Cluster.isSharedPath: unable to get local node name. Details: " + ce.getMessage());
        }
        return Cluster.isSharedPathWithNodes(pathName, nodeList, localNode);
    }

    public static synchronized boolean isSharedPathWithNodes(String pathName, String[] nodeList, String localNode) throws SharedDeviceException, InvalidNodeListException {
        String dirPath;
        if (nodeList == null) {
            Trace.out("Cluster.isSharedPath: nodeList passed is null");
            throw new InvalidNodeListException("Prkc", "1062");
        }
        if (pathName == null) {
            Trace.out("Cluster.isSharedPath: pathName passed is null");
            throw new SharedDeviceException(MessageBundle.getMessageBundle("Prkc").getMessage("1055", true));
        }
        Trace.out("NodeList=" + Arrays.asList(nodeList));
        HashSet<String> nodeSet = new HashSet<String>();
        for (String curnode : nodeList) {
            nodeSet.add(curnode);
        }
        String[] effectiveNodeList = nodeSet.toArray(new String[nodeSet.size()]);
        File file = new File(pathName);
        try {
            dirPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            dirPath = file.getAbsolutePath();
        }
        Trace.out("pathName=" + pathName + " dirPath = " + dirPath);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = nativeSystem.isSharedPath(dirPath, effectiveNodeList, localNode);
        if (result.getException() == null) {
            return result.getBooleanResult();
        }
        Object[] args = new Object[]{result.getException().getMessage()};
        String exceptionMessage = MessageBundle.getMessageBundle("Prkc").getMessage("1166", true, args);
        throw new SharedDeviceException(exceptionMessage, result.getException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void verifyNodeList(String[] nodeList) throws InvalidNodeListException {
        int i;
        String[] clusterNodes;
        block17: {
            if (nodeList == null) {
                Trace.out("Cluster.isSharedPath: nodeList passed is null");
                throw new InvalidNodeListException("Prkc", "1062");
            }
            clusterNodes = null;
            ClusterException ce = null;
            try {
                clusterNodes = Cluster.getNodes();
                if (clusterNodes != null) break block17;
                throw new InvalidNodeListException("Prkc", "1035", ce);
            }
            catch (ClusterException e) {
                try {
                    Trace.out("Got exception while trying to get node names from clusterware \n" + e);
                    ce = e;
                    if (clusterNodes == null) {
                        throw new InvalidNodeListException("Prkc", "1035", ce);
                    }
                }
                catch (Throwable throwable) {
                    if (clusterNodes != null) throw throwable;
                    throw new InvalidNodeListException("Prkc", "1035", ce);
                }
            }
        }
        for (i = 0; i < clusterNodes.length; ++i) {
            Trace.out("clusterNodes[" + i + "]=" + clusterNodes[i]);
        }
        for (i = 0; i < nodeList.length; ++i) {
            Trace.out("nodeList[" + i + "]=" + nodeList[i]);
        }
        if (nodeList.length > clusterNodes.length) {
            StringBuffer sb = null;
            int i2 = 0;
            while (true) {
                if (i2 >= nodeList.length) {
                    Object[] args = new String[]{sb.toString(), String.valueOf(nodeList.length), String.valueOf(clusterNodes.length)};
                    throw new InvalidNodeListException("Prkc", "1064", args);
                }
                if (sb != null) {
                    sb.append("," + nodeList[i2]);
                } else {
                    sb = new StringBuffer(nodeList[i2]);
                }
                ++i2;
            }
        }
        Vector<String> ncNodes = new Vector<String>(nodeList.length);
        for (int i3 = 0; i3 < nodeList.length; ++i3) {
            boolean isMember = false;
            for (int j = 0; j < clusterNodes.length; ++j) {
                if (!clusterNodes[j].equalsIgnoreCase(nodeList[i3])) continue;
                isMember = true;
            }
            if (isMember) continue;
            ncNodes.addElement(nodeList[i3]);
        }
        if (ncNodes.size() <= 0) return;
        Object[] args = new String[]{ncNodes.toString()};
        throw new InvalidNodeListException("Prkc", "1065", args);
    }

    private static File getExistingParentDirectory(String path, String[] nodeList) {
        File mtPt = new File(path);
        ClusterCmd cc = new ClusterCmd();
        String absPath = "";
        do {
            absPath = mtPt.getAbsolutePath();
            Trace.out("Checking path:" + absPath);
            try {
                if (cc.dirExists(nodeList, absPath)) {
                    return mtPt;
                }
            }
            catch (ClusterException | ClusterOperationException e) {
                Trace.out("path " + absPath + " not found");
                Trace.out("Exception: " + e.getMessage());
            }
        } while ((mtPt = mtPt.getParentFile()) != null);
        Trace.out("No parent found");
        return null;
    }

    public static String getHostName(String nodeName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        String hostName = GetActiveNodes.getHostName(nodeName);
        Trace.out("hostname = " + hostName);
        return hostName;
    }

    public static boolean isExists(String nodeName, String pathName) throws ClusterException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertFile(pathName);
        String path = new File(pathName).getAbsolutePath();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        return nativeSystem.pathExists(nodeName, path, 0);
    }

    public static boolean repositoryExists() {
        boolean exists = true;
        try {
            OCR oCR = OCR.init(2, s_version);
        }
        catch (Exception e) {
            exists = false;
        }
        return exists;
    }

    public static String[] listParallelServers(String oracleHome) throws OCRException {
        return Cluster.listParallelServers(oracleHome, s_version);
    }

    public static String[] listParallelServers(String oracleHome, Version v) throws OCRException {
        String cpath1;
        OCRTreeDefinition ocrTreeDef = null;
        OCR ocr = null;
        if (oracleHome == null) {
            return new String[0];
        }
        try {
            ClusterInfo.assertVersion(v);
        }
        catch (ClusterInfoException e) {
            throw new OCRException(e.getMessage());
        }
        if (!Version.isPre10i(v)) {
            ocrTreeDef = new OCRTreeDefinitionHA();
            Trace.out("listParallelServers : Latest version. CRS installed trying DEFAULT MT level");
            try {
                ocr = OCR.init(7, v);
            }
            catch (OCRException ocrExp) {
                Trace.out("listParallelServers : Fatal error in OCR init [" + Integer.toString(ocrExp.getErrorCode()) + "]");
                throw ocrExp;
            }
        }
        ocrTreeDef = new OCRTreeDefinition();
        Trace.out("listParallelServers : 9.2 version.");
        try {
            ocr = OCR.init(7, v);
        }
        catch (OCRException ocrExp) {
            Trace.out("listParallelServers : Error in OCR init");
            Trace.out("listParallelServers : Fatal error in OCR init [" + Integer.toString(ocrExp.getErrorCode()) + "]");
            throw ocrExp;
        }
        if (!ocr.keyExists(ocrTreeDef.getDBRootKey())) {
            return new String[0];
        }
        String[] dbList = ocr.listSubKeys(ocrTreeDef.getDBRootKey());
        Vector<String> dbListVec = new Vector<String>(dbList.length);
        String cpath2 = "";
        try {
            cpath1 = new File(oracleHome).getCanonicalPath();
        }
        catch (IOException e) {
            cpath1 = oracleHome;
        }
        for (int i = 0; i < dbList.length; ++i) {
            Trace.out("Trying to find the Oracle Home name for key " + ocrTreeDef.getDBOHomeKey(dbList[i]));
            String dbOraHome = ocr.getKeyValue(ocrTreeDef.getDBOHomeKey(dbList[i]));
            Trace.out("Oracle Home Name found " + dbOraHome);
            if (dbOraHome != null) {
                try {
                    cpath2 = new File(dbOraHome).getCanonicalPath();
                }
                catch (IOException e) {
                    cpath2 = dbOraHome;
                }
            }
            if (dbOraHome == null || !dbOraHome.equalsIgnoreCase(oracleHome) && !cpath1.equalsIgnoreCase(cpath2)) continue;
            String dbKeyVal = ocr.getKeyValue(ocrTreeDef.getDBKey(dbList[i]));
            Trace.out("dbList[" + i + "]: " + dbList[i] + " dbKeyVal: " + dbKeyVal);
            if (dbKeyVal != null && dbKeyVal.length() > 0) {
                dbListVec.addElement(dbKeyVal);
                continue;
            }
            dbListVec.addElement(dbList[i]);
        }
        dbListVec.trimToSize();
        Object[] ohomeDbList = new String[dbListVec.size()];
        dbListVec.copyInto(ohomeDbList);
        return ohomeDbList;
    }

    public static boolean reloadListener(String[] listenerNames, String oracleHome, String nodeName) throws ClusterException, ListenerException {
        ClusterCmd.assertNode(nodeName);
        ClusterCmd.assertDir(oracleHome, false);
        try {
            GetActiveNodes getActiveNodes = GetActiveNodes.create();
        }
        catch (ClusterException e) {
            Trace.out(e);
            throw e;
        }
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkp");
        Command[] remoteCommands = new RemoteCommand[listenerNames.length];
        try {
            for (int i = 0; i < listenerNames.length; ++i) {
                ReloadListenerOperation reloadListenerOperation = new ReloadListenerOperation(listenerNames[i], oracleHome);
                String[] env = new String[]{"ORACLE_HOME=" + oracleHome};
                reloadListenerOperation.setEnvironment(env);
                remoteCommands[i] = new RemoteCommand(nodeName, reloadListenerOperation);
            }
        }
        catch (ClusterException e) {
            Trace.out("reloadListener: cannot create cmds for node " + nodeName);
            Trace.out(e);
            Object[] args = new String[]{nodeName};
            String msg = msgBundle.getMessage("1043", true, args);
            throw new ListenerException(msg, e.getMessage());
        }
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.submit(remoteCommands);
        }
        catch (ClusterException ce) {
            Trace.out("Could not submit reload listener commands:" + ce.getMessage());
        }
        boolean status = true;
        StringBuffer sb = new StringBuffer();
        ReloadListenerResult listenerResult = null;
        for (int i = 0; i < remoteCommands.length; ++i) {
            try {
                listenerResult = (ReloadListenerResult)((RemoteCommand)remoteCommands[i]).getOperationResult();
            }
            catch (ClusterException e) {
                Trace.out("reloadListener: cannot get result");
                Trace.out(e);
                Object[] args = new String[]{nodeName};
                String msg = msgBundle.getMessage("1043", true, args);
                throw new ListenerException(msg, e.getMessage());
            }
            if (listenerResult.getStatus() == 0) continue;
            status = false;
            sb.append(listenerNames[i] + ":" + listenerResult.getOutput() + "\n");
        }
        if (!status) {
            Object[] args = new String[]{nodeName};
            String msg = msgBundle.getMessage("1043", true, args);
            throw new ListenerException(msg, sb.toString());
        }
        return true;
    }

    public static synchronized boolean isShared(String pathName, String[] nodeList, String localNode) throws SharedDeviceException {
        if (pathName == null) {
            Trace.out("Cluster.isShared: pathName passed is null");
            return false;
        }
        if (nodeList == null || nodeList.length < 2) {
            Trace.out("Cluster.isShared: nodeList length < 2 ");
            return false;
        }
        try {
            return Cluster.isSharedPath(pathName, nodeList, localNode);
        }
        catch (InvalidNodeListException e) {
            Trace.out(e);
            return false;
        }
    }

    public static boolean isPortAvailable(String[] ipAddresses, int portNum) throws ClusterException, ClusterOperationException {
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        if (ipAddresses == null || ipAddresses.length == 0) {
            throw new ClusterException(msgBundle.getMessage("1099", true));
        }
        NativeResult[] results = new NativeResult[ipAddresses.length];
        boolean bAvailable = true;
        Object[] args = new String[]{"" + portNum};
        String failureMsg = msgBundle.getMessage("1100", true, args);
        for (int i = 0; i < ipAddresses.length; ++i) {
            results[i] = new NativeResult();
            results[i].setNodeName(ipAddresses[i]);
            try {
                InetAddress inetAddr = InetAddress.getByName(ipAddresses[i]);
                InetSocketAddress inetSocAddr = new InetSocketAddress(inetAddr, portNum);
                Trace.out("inetSocAddr = " + inetSocAddr);
                Socket s = new Socket();
                s.connect(inetSocAddr);
                bAvailable &= false;
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                results[i].setStatus(false);
                results[i].setOSString(failureMsg);
                continue;
            }
            catch (UnknownHostException uhe) {
                Trace.out(uhe);
                throw new ClusterException(uhe.getMessage());
            }
            catch (IOException ie) {
                Trace.out(ie.getMessage());
                bAvailable &= true;
                results[i].setStatus(true);
            }
        }
        if (!bAvailable) {
            throw new ClusterOperationException("1101", args, results);
        }
        return true;
    }

    public static synchronized NetworkInterface[] listInterfaces() throws ClusterException {
        Trace.out("Listing all the interfaces found in OCR");
        return Cluster.listInterfaces(1, 0);
    }

    public static synchronized NetworkInterface[] listPublicInterfaces() throws ClusterException {
        Trace.out("Listing public interfaces from OCR");
        return Cluster.listInterfaces(4, 0);
    }

    public static synchronized NetworkInterface[] listPrivateInterfaces() throws ClusterException {
        Trace.out("Listing private interfaces from OCR");
        return Cluster.listInterfaces(8, 0);
    }

    public static synchronized NetworkInterface[] listInterfaces(int ifType, int ipType) throws ClusterException {
        MessageBundle msgBundle = MessageBundle.getMessageBundle("Prkc");
        if (!NetworkInterface.assertInterfaceType(ifType)) {
            Trace.out("Invalid interface type passed as an argument");
            throw new ClusterException(msgBundle.getMessage("1128", true, new String[]{"" + ifType}));
        }
        if (!NetworkInterface.assertIPType(ipType)) {
            Trace.out("Invalid ip type passed as an argument");
            throw new ClusterException(msgBundle.getMessage("1129", true, new String[]{"" + ipType}));
        }
        Trace.out("Listing all the interfaces of type:" + ifType + " & IP type: " + ipType);
        NetworkInterface[] netIFs = null;
        try {
            OCRTreeHA ocrTreeHA = (OCRTreeHA)OCRTree.init(new Version(), 7);
            netIFs = ocrTreeHA.listInterfaces();
        }
        catch (OCRException oe) {
            Trace.out("Error listing private interfaces from OCR");
            throw new ClusterException(oe.getMessage());
        }
        return Cluster.extractInterfaces(netIFs, ifType, ipType);
    }

    private static NetworkInterface[] extractInterfaces(NetworkInterface[] ifsAll, int ifType, int ipType) {
        Trace.out("ifType = " + ifType);
        Trace.out("ipType = " + ipType);
        if (ifsAll != null && ifsAll.length != 0) {
            Trace.out("No. of interfaces found in OCR = " + ifsAll.length);
            ArrayList<NetworkInterface> ifsListV = new ArrayList<NetworkInterface>(ifsAll.length);
            for (int i = 0; i < ifsAll.length; ++i) {
                if (ifType != 1 && ifsAll[i].getType() != ifType || ipType != 0 && ifsAll[i].getIPType() != ipType) continue;
                ifsListV.add(ifsAll[i]);
            }
            NetworkInterface[] netIFs = null;
            if (ifsListV.size() > 0) {
                netIFs = new NetworkInterface[ifsListV.size()];
                netIFs = ifsListV.toArray(netIFs);
                Trace.out("netIFs.length = " + netIFs.length);
            }
            return netIFs;
        }
        return null;
    }
}

