/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.mgmt.cluster;

import oracle.ops.mgmt.cluster.CommandBuffer;
import oracle.ops.mgmt.cluster.RemoteResponseListener;
import oracle.ops.mgmt.synchronize.Semaphore;
import oracle.ops.mgmt.trace.Trace;

class ClientResource {
    public static final boolean ALIVE = true;
    public static final boolean DEAD = false;
    private static final int LENGTH_MULTIPLIER = 50;
    private final Semaphore m_blockingSemaphore;
    private CommandBuffer m_commandBuffer;
    private boolean m_status;
    private StringBuffer m_transactionSummary;
    private RemoteResponseListener m_remoteResponseListener = null;
    private int m_commandBufferLength = 0;

    public ClientResource(int bufSize) {
        this(bufSize, true);
    }

    ClientResource(int bufSize, boolean useMultiplier) {
        this.m_commandBufferLength = useMultiplier ? bufSize * 50 : bufSize;
        this.m_blockingSemaphore = new Semaphore(0, "ClientResource Constructor:Blocking Semaphore owned by " + Thread.currentThread().getName());
        this.m_status = true;
        this.m_commandBuffer = new CommandBuffer(this.m_commandBufferLength);
        this.m_transactionSummary = new StringBuffer();
    }

    protected int getCommandBufferLength() {
        return this.m_commandBufferLength;
    }

    protected void cleanUp() {
        this.clearCommandBuffer();
        this.m_transactionSummary = new StringBuffer();
        this.m_remoteResponseListener = null;
    }

    protected boolean isBufferFull() {
        return this.m_commandBuffer.getFillCount() == this.m_commandBufferLength;
    }

    protected void clearCommandBuffer() {
        this.m_commandBuffer.clearAll();
    }

    protected void setTransactionSummary(String summary) {
        this.m_transactionSummary.append(summary + "\n");
    }

    protected String getTransactionSummary() {
        return this.m_transactionSummary.toString();
    }

    protected CommandBuffer getBuffer() {
        return this.m_commandBuffer;
    }

    protected RemoteResponseListener getListener() {
        Trace.out("Calling getListener");
        return this.m_remoteResponseListener;
    }

    protected void setListener(RemoteResponseListener l) {
        Trace.out("Inside setListener");
        if (l == null) {
            Trace.out("cry out");
        }
        this.m_remoteResponseListener = l;
    }

    protected Semaphore getSemaphore() {
        return this.m_blockingSemaphore;
    }

    protected void setStatus(boolean stat) {
        this.m_status = stat;
    }

    protected boolean getStatus() {
        return this.m_status;
    }
}

