/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.winsecurity;

import oracle.cluster.impl.winsecurity.WinSecurityFactoryImpl;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.Service;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WinSecurityUtil;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class WinSecurityFactory
implements Constants {
    private static WinSecurityFactory s_instance;
    private WinSecurityFactoryImpl s_securityFactoryImpl;

    private WinSecurityFactory(String srcLoc, String destLoc) throws WindowsSecurityException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PLATFORM, new Object[0]);
        }
        this.s_securityFactoryImpl = WinSecurityFactoryImpl.getInstance(srcLoc, destLoc);
    }

    public static synchronized WinSecurityFactory getInstance(String srcLoc, String destLoc) throws WindowsSecurityException {
        if (null == s_instance) {
            s_instance = new WinSecurityFactory(srcLoc, destLoc);
        }
        return s_instance;
    }

    public static synchronized WinSecurityFactory getInstance() throws WindowsSecurityException {
        String oracleHome = System.getenv("ORACLE_HOME");
        Trace.out("oracle home got is" + oracleHome);
        if (oracleHome == null || oracleHome.length() == 0) {
            oracleHome = System.getProperty("ORACLE_HOME");
        }
        Trace.out("oracle home got is" + oracleHome);
        if (oracleHome != null && oracleHome.length() != 0) {
            String srcloc = oracleHome + FILE_SEPARATOR + "bin";
            String destloc = System.getProperty("java.io.tmpdir");
            return WinSecurityFactory.getInstance(srcloc, destloc);
        }
        throw new WindowsSecurityException((MessageKey)PrCzMsgID.ORACLE_HOME_ENV_ERROR, new Object[0]);
    }

    public User getUser(Credentials credentials, Version version) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        if (version == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getUserInstance(credentials, version);
    }

    public Home getHome(String homePath, Version version) throws WindowsSecurityException {
        if (homePath == null || homePath.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "homePath");
        }
        if (version == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getHomeInstance(homePath, version);
    }

    public UserPrivilege getUserPrivilege(Credentials credentials, Version version) throws WindowsSecurityException {
        if (credentials == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "credentials");
        }
        if (version == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getUserPrivilegeInstance(credentials, version);
    }

    public Service getService(String serviceName, Version version) throws WindowsSecurityException {
        if (serviceName == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "serviceName");
        }
        if (version == null || Version.isPre12c(version)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getServiceInstance(serviceName, version);
    }

    public Group getGroup(String groupName, Version version) throws WindowsSecurityException {
        if (groupName == null || groupName.length() == 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "group");
        }
        if (version == null || Version.isPre12c(version)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getGroupInstance(groupName, version);
    }

    public void migrateDBServiceSidsForUpgrade(Version version) throws WindowsSecurityException {
        if (version == null || Version.isPre12c(version)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        this.s_securityFactoryImpl.migrateDBServiceSidsForUpgrade();
    }

    public void migrateDBServiceSidsForDowngrade(Version version) throws WindowsSecurityException {
        if (version == null || Version.isPre12c(version)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        this.s_securityFactoryImpl.migrateDBServiceSidsForDowngrade();
    }

    public WinSecurityUtil getWinSecurityUtil(Version version) throws WindowsSecurityException {
        if (version == null || Version.isPre12c(version)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "version");
        }
        return this.s_securityFactoryImpl.getWinSecurityUtilInstance(version);
    }
}

