/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.winsecurity;

import oracle.cluster.impl.winsecurity.SecureUtil;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class Credentials {
    private String m_username = null;
    private String m_password = null;
    private String m_groupname = null;
    private boolean m_isBuiltinUser = false;
    private BuiltinUser m_builtinUser = BuiltinUser.INVALIDUSER;
    private final String SVC_USER_LOCAL_SYSTEM = "LOCAL_SYSTEM";
    private final String SVC_USER_LOCAL_SERVICE = "LOCAL_SERVICE";
    private final String SVC_USER_VIRTUAL_ACCOUNT = "ORACLE_VIRTUAL";

    public Credentials(String username) throws WindowsSecurityException {
        if (username == null || username.trim().length() <= 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_USERNAME, new Object[0]);
        }
        this.m_username = username;
    }

    public Credentials(String username, String password) throws WindowsSecurityException {
        if (username == null || username.trim().length() <= 0) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_USERNAME, new Object[0]);
        }
        if (password == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PASSWORD, new Object[0]);
        }
        this.m_username = username;
        this.m_password = this.encryptPassword(password);
    }

    public Credentials(BuiltinUser builtinUser) throws WindowsSecurityException {
        this(builtinUser, null, false);
    }

    private Credentials(BuiltinUser builtinUser, String oracleHomeName, boolean checkOracleHomeName) throws WindowsSecurityException {
        if (checkOracleHomeName && (oracleHomeName == null || oracleHomeName.trim().length() == 0)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "oracle home name");
        }
        if (!(oracleHomeName != null && oracleHomeName.trim().length() != 0 || !checkOracleHomeName && builtinUser != BuiltinUser.VIRTUALACCOUNT)) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "oracle home name");
        }
        if (builtinUser == BuiltinUser.INVALIDUSER) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_USERNAME, new Object[0]);
        }
        this.m_isBuiltinUser = true;
        SecureUtil secureUtil = new SecureUtil();
        if (builtinUser != BuiltinUser.VIRTUALACCOUNT) {
            this.m_username = secureUtil.getUsernameFromSid(builtinUser.toString());
        } else {
            this.m_groupname = secureUtil.getVirtualAccountGroupName(oracleHomeName);
        }
        this.m_builtinUser = builtinUser;
    }

    public Credentials(BuiltinUser builtinUser, String oracleHomeName) throws WindowsSecurityException {
        this(builtinUser, oracleHomeName, true);
    }

    public String getUsername() {
        return this.getUsername(false);
    }

    public String getUsername(boolean isSetServiceUser) {
        if (isSetServiceUser) {
            if (!this.m_isBuiltinUser) {
                return this.m_username;
            }
            switch (this.m_builtinUser) {
                case LOCALSYSTEM: {
                    return "LOCAL_SYSTEM";
                }
                case LOCALSERVICE: {
                    return "LOCAL_SERVICE";
                }
                case VIRTUALACCOUNT: {
                    return "ORACLE_VIRTUAL";
                }
            }
        }
        if (this.m_builtinUser != BuiltinUser.VIRTUALACCOUNT) {
            return this.m_username;
        }
        return this.m_groupname;
    }

    public String getPassword() {
        String password = this.decryptPassword();
        return password;
    }

    public void setPassword(String password) throws WindowsSecurityException {
        if (password == null) {
            throw new WindowsSecurityException((MessageKey)PrCzMsgID.INVALID_PASSWORD, new Object[0]);
        }
        this.m_password = this.encryptPassword(password);
    }

    public boolean isUserBuiltinUser() {
        return this.m_isBuiltinUser;
    }

    public boolean isUserLocalSystem() {
        if (!this.isUserBuiltinUser()) {
            return false;
        }
        return this.m_builtinUser == BuiltinUser.LOCALSYSTEM;
    }

    public boolean isUserLocalService() {
        if (!this.isUserBuiltinUser()) {
            return false;
        }
        return this.m_builtinUser == BuiltinUser.LOCALSERVICE;
    }

    public boolean isUserVirtualAccount() {
        if (!this.isUserBuiltinUser()) {
            return false;
        }
        return this.m_builtinUser == BuiltinUser.VIRTUALACCOUNT;
    }

    private String encryptPassword(String password) {
        return password;
    }

    private String decryptPassword() {
        return this.m_password;
    }

    public void store() throws WindowsSecurityException {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        if (this.m_builtinUser != BuiltinUser.VIRTUALACCOUNT) {
            return this.m_username != null && this.m_username.equalsIgnoreCase(other.getUsername());
        }
        return this.m_groupname != null && this.m_groupname.equalsIgnoreCase(other.getUsername());
    }

    public int hashCode() {
        if (this.m_builtinUser != BuiltinUser.VIRTUALACCOUNT) {
            return this.m_username.hashCode();
        }
        return this.m_groupname.hashCode();
    }

    public void setBuiltinUser(BuiltinUser builtinUser) {
        Trace.out("**** set builtin user called with type as " + (Object)((Object)builtinUser));
        this.m_isBuiltinUser = true;
        this.m_builtinUser = builtinUser;
        if (builtinUser == BuiltinUser.VIRTUALACCOUNT) {
            this.m_groupname = this.m_username;
        }
    }

    public static enum BuiltinUser {
        INVALIDUSER(""),
        LOCALSYSTEM("NT AUTHORITY\\SYSTEM"),
        LOCALSERVICE("NT AUTHORITY\\LOCAL SERVICE"),
        NETWORKSERVICE("NT AUTHORITY\\NETWORK SERVICE"),
        VIRTUALACCOUNT("ORA_HOME_NAME_SVCACCTS");

        private String m_user;

        private BuiltinUser(String user) {
            this.m_user = user;
        }

        public String toString() {
            return this.m_user;
        }
    }
}

