/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.wallet;

import java.util.List;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.wallet.CLSW;
import oracle.cluster.wallet.CLSWAccessDeniedException;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWAlreadyExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class OSUserWallet {
    private static OSUserWallet s_instance = null;
    private CLSW m_clsw;
    private Version m_version;
    private final String OSUSER_WALLET_NAME = "OSUSER";
    private MessageBundle prfcBundle = MessageBundle.getMessageBundle(PrCfMsgID.facility);

    private OSUserWallet(Version version) throws CLSWException {
        Trace.out("initializing OSUserWallet");
        this.m_version = version;
        this.m_clsw = CLSW.getInstance(version);
    }

    public static synchronized OSUserWallet getInstance() throws CLSWException {
        Trace.out("create a new instance. get the current version first");
        return OSUserWallet.getInstance(new Version());
    }

    public static synchronized OSUserWallet getInstance(Version version) throws CLSWException {
        NativeSystem system = new SystemFactory().CreateSystem();
        if (system.isUnixSystem()) {
            return null;
        }
        if (s_instance == null) {
            Trace.out("OSUser wallet instance is not present, create a new one");
            s_instance = new OSUserWallet(version);
        }
        return s_instance;
    }

    public void initializeWalletContext() throws CLSWException {
        this.m_clsw.initializeCLSW();
    }

    public void terminateWalletContext() throws CLSWException {
        this.m_clsw.terminateCLSW();
    }

    public void createWallet(Credentials credentials) throws CLSWException, CLSWAlreadyExistException, CLSWNotExistException, CLSWAccessDeniedException {
        String username = credentials.getUsername();
        String osUserPassword = credentials.getPassword();
        try {
            this.m_clsw.openWallet("OSUSER", new String(""));
        }
        catch (CLSWAlreadyExistException e) {
            Trace.out("OSUSER wallet already exists, no creation, just need to add the user");
        }
        this.m_clsw.setSecret("OSUSER", new String(""), username, osUserPassword);
    }

    public void updateWallet(Credentials credentials) throws CLSWException, CLSWAccessDeniedException {
        if (credentials == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "update - creds"));
        }
        String username = credentials.getUsername();
        String osUserPassword = credentials.getPassword();
        this.m_clsw.setSecret("OSUSER", new String(""), username, osUserPassword);
    }

    public void deleteWallet() throws CLSWException, CLSWAccessDeniedException, CLSWNotExistException {
        this.m_clsw.deleteWallet("OSUSER", new String(""), new String(""));
    }

    public void deleteWallet(Credentials credentials) throws CLSWException, CLSWAccessDeniedException, CLSWNotExistException {
        if (credentials == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "delete - creds"));
        }
        String username = credentials.getUsername();
        this.m_clsw.deleteWallet("OSUSER", new String(""), username);
    }

    public boolean isUserWalletExist(Credentials credentials) throws CLSWException, CLSWAccessDeniedException {
        if (credentials == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "is exists - creds"));
        }
        String userName = credentials.getUsername();
        try {
            String userPassword = this.m_clsw.getSecret("OSUSER", new String(""), userName);
            Trace.out("user found in wallet");
            return true;
        }
        catch (CLSWAliasNotExistException e) {
            Trace.out("wallet exists but alias doesn't");
            return false;
        }
        catch (CLSWNotExistException e) {
            Trace.out("wallet doesn't exist");
            return false;
        }
    }

    public void getWalletContents(Credentials credentials) throws CLSWException, CLSWAccessDeniedException, CLSWNotExistException, CLSWAliasNotExistException {
        if (credentials == null) {
            throw new CLSWException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "get passwd - creds"));
        }
        String userName = credentials.getUsername();
        String password = this.m_clsw.getSecret("OSUSER", new String(""), userName);
        Trace.out("got password from wallet");
        try {
            credentials.setPassword(password);
        }
        catch (WindowsSecurityException e) {
            throw new CLSWException(e);
        }
    }

    public List<String> getWalletUsersList() throws CLSWException, CLSWAccessDeniedException, CLSWNotExistException {
        return this.m_clsw.getWalletUsersList("OSUSER", new String(""));
    }
}

