/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.wallet;

import oracle.cluster.wallet.CLSW;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWAlreadyExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;

public class CVUDatabaseWallet {
    private static final String CVUDB_WALLET_TYPE = "CVUDB";
    public static final String DB_DEFAULT_USER = "DBSNMP";
    private static CVUDatabaseWallet s_instance = null;
    private CLSW m_clsw;

    private CVUDatabaseWallet(Version v) throws CLSWException {
        Trace.out("create a new instance. get the current version first");
        this.m_clsw = CLSW.getInstance(v);
    }

    public static synchronized CVUDatabaseWallet getInstance(Version v) throws CLSWException {
        if (s_instance == null) {
            s_instance = new CVUDatabaseWallet(v);
        }
        return s_instance;
    }

    public static CVUDatabaseWallet getInstance() throws CLSWException {
        return CVUDatabaseWallet.getInstance(new Version());
    }

    public void open() throws CLSWException {
        this.m_clsw.initializeCLSW();
    }

    public void close() throws CLSWException {
        this.m_clsw.terminateCLSW();
    }

    public void createWallet(String dbUniqueName, String password) throws CLSWException {
        try {
            this.m_clsw.openWallet(CVUDB_WALLET_TYPE, dbUniqueName);
        }
        catch (CLSWAlreadyExistException e) {
            Trace.out("CLSWAlreadyExistException occured. msg:" + e.getMessage());
            Trace.out("CVUDB already exists. not creation. updating the wallet...");
        }
        this.m_clsw.setSecret(CVUDB_WALLET_TYPE, dbUniqueName, DB_DEFAULT_USER, password);
    }

    public void updateWallet(String dbUniqueName, String password) throws CLSWException {
        this.m_clsw.setSecret(CVUDB_WALLET_TYPE, dbUniqueName, DB_DEFAULT_USER, password);
    }

    public void deleteWallet(String dbUniqueName) throws CLSWException {
        this.m_clsw.deleteWallet(CVUDB_WALLET_TYPE, dbUniqueName, "");
    }

    public boolean isWalletExists(String dbUniqueName) throws CLSWException {
        boolean retVal = false;
        try {
            this.m_clsw.getSecret(CVUDB_WALLET_TYPE, dbUniqueName, DB_DEFAULT_USER);
            retVal = true;
        }
        catch (CLSWAliasNotExistException e) {
            Trace.out("wallet exists but alias doesn't");
        }
        catch (CLSWNotExistException e) {
            Trace.out("wallet doesn't exist");
        }
        return retVal;
    }

    public String getPassword(String dbUniqueName) throws CLSWException, CLSWAliasNotExistException {
        String password = this.m_clsw.getSecret(CVUDB_WALLET_TYPE, dbUniqueName, DB_DEFAULT_USER);
        return password;
    }
}

