/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.wallet;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.cluster.common.CommonBaseException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

public class CLSWException
extends CommonBaseException {
    protected Object[] m_Args = null;
    private Exception m_e;
    private int m_code;
    private String m_debugMsg;

    public CLSWException(String msg) {
        super(msg);
    }

    public CLSWException(String msg, Exception e) {
        super(msg, e);
    }

    public CLSWException(Exception e) {
        super(e);
    }

    public void setDebugMessage(String msg) {
        this.m_debugMsg = msg;
    }

    public String getDebugMessage() {
        return this.m_debugMsg;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public int getCode() {
        return this.m_code;
    }

    private String getHASMessage() {
        String msg = super.getMessage();
        if (Trace.isLevelEnabled(16) && this.getDebugMessage() != null) {
            return msg + "(" + this.getDebugMessage() + ":[" + this.m_code + "])";
        }
        if (this.m_code != 0) {
            return msg + " :[" + this.m_code + "]";
        }
        return msg;
    }

    @Override
    public String getMessage() {
        if (this.m_e == null) {
            return this.getHASMessage();
        }
        return this.getHASMessage() + "\n" + this.m_e.getMessage();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            this.m_e.printStackTrace(out);
        }
    }

    @Override
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.m_e != null) {
            this.m_e.printStackTrace(out);
        }
    }

    public CLSWException(int code) {
        this(MessageBundle.getMessageBundle("PrCw").getMessage(Integer.toString(code), true));
    }

    public CLSWException(int code, Object[] args) {
        this(MessageBundle.getMessageBundle("PrCw").getMessage(Integer.toString(code), true, args));
        this.m_Args = args;
    }
}

