/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.vm;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.vm.VMFactoryImpl;
import oracle.cluster.resources.PrCzMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.vm.OVMM;
import oracle.cluster.vm.OVMMArgs;
import oracle.cluster.vm.OVMMException;
import oracle.cluster.vm.VM;
import oracle.cluster.vm.VMArgs;
import oracle.cluster.vm.VMException;
import oracle.cluster.vm.VMWarningException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;

public class VMFactory {
    private static VMFactory s_vmFactory;
    private VMFactoryImpl s_vmFactoryImpl = VMFactoryImpl.getInstance();

    private VMFactory() throws SoftwareModuleException {
    }

    public static synchronized VMFactory getInstance() throws SoftwareModuleException {
        if (null == s_vmFactory) {
            s_vmFactory = new VMFactory();
        }
        return s_vmFactory;
    }

    public VM createVM(VMArgs args) throws VMException, AlreadyExistsException, VMWarningException {
        return this.s_vmFactoryImpl.createVM(args);
    }

    public VM getVM(String vmName) throws NotExistsException, VMException {
        return this.s_vmFactoryImpl.getVM(vmName);
    }

    public static List<VM> getVMRes() throws VMException {
        return VMFactoryImpl.getVMRes();
    }

    public static String[] getVMResNames() throws VMException {
        return VMFactoryImpl.getVMResNames();
    }

    public static String getResourceType() {
        return "ora." + ResourceLiterals.VM.toString() + '.' + ResourceLiterals.TYPE.toString();
    }

    public static String getResourceName(String vmName) {
        return "ora." + vmName + '.' + ResourceLiterals.VM.toString();
    }

    public static Map<String, List<String>> validateVMs(String[] vmInstArr) throws VMException {
        return VMFactoryImpl.validateVMs(vmInstArr);
    }

    public OVMM createOVMM(OVMMArgs ovmmArgs) throws AlreadyExistsException, OVMMException {
        return this.s_vmFactoryImpl.createOVMM(ovmmArgs);
    }

    public OVMM getOVMM() throws NotExistsException, OVMMException {
        return this.s_vmFactoryImpl.getOVMM();
    }

    public static void validateOVMMArgs4Create(OVMMArgs ovmmArgs) throws OVMMException {
        if (null == ovmmArgs) {
            throw new OVMMException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "ovmmArgs");
        }
        String username = ovmmArgs.getUsername();
        if (null == username) {
            throw new OVMMException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "username");
        }
        if (username.trim().isEmpty()) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_USERNAME_INVALID, username);
        }
        String ovmmhost = ovmmArgs.getOVMMHost();
        if (null == ovmmhost || ovmmhost.trim().isEmpty()) {
            throw new OVMMException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "ovmmhost");
        }
        if (!IPAddressUtil.isValidHostName(ovmmhost) && !IPAddressUtil.isValidHostNameOrIPAddress(ovmmhost)) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_HOST_INVALID, ovmmhost);
        }
    }

    public static void validateOVMMArgs4Modify(OVMMArgs ovmmArgs) throws OVMMException {
        if (null == ovmmArgs) {
            throw new OVMMException((MessageKey)PrCzMsgID.INVALID_PARAMETER_VALUE, "ovmmArgs");
        }
        String username = ovmmArgs.getUsername();
        if (null != username && username.trim().isEmpty()) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_USERNAME_INVALID, username);
        }
        String ovmmhost = ovmmArgs.getOVMMHost();
        if (null != ovmmhost && !IPAddressUtil.isValidHostName(ovmmhost) && !IPAddressUtil.isValidHostNameOrIPAddress(ovmmhost)) {
            throw new OVMMException((MessageKey)PrCzMsgID.OVMM_HOST_INVALID, ovmmhost);
        }
    }
}

