/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.vm;

import java.util.HashMap;
import java.util.List;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.RelocateException;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyNotPresentException;
import oracle.cluster.util.AlreadyPresentException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotConfiguredException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.cluster.vm.VMArgs;
import oracle.cluster.vm.VMDetail;
import oracle.cluster.vm.VMException;
import oracle.cluster.vm.VMWarningException;

public interface VM
extends SoftwareModule {
    public CRSResource crsResource() throws NotExistsException, VMException;

    public List<VMWarningException> getWarnings();

    public boolean isWarningExists();

    @Override
    public String getName();

    public String[] getVM() throws VMException;

    public int getStopTimeout() throws VMException;

    public int getCheckInterval() throws VMException;

    public void setStopTimeout(int var1) throws VMException;

    public void setCheckInterval(int var1) throws VMException;

    @Override
    public void enable() throws VMException, AlreadyEnabledException;

    @Override
    public void disable() throws VMException, AlreadyDisabledException;

    public void enable(Node var1) throws VMException, AlreadyEnabledException;

    public void enable(String var1) throws VMException, AlreadyEnabledException;

    public void disable(Node var1) throws VMException, AlreadyDisabledException;

    public void disable(String var1) throws VMException, AlreadyDisabledException;

    public void remove(boolean var1) throws VMException, AlreadyRunningException;

    public void modify(VMArgs var1) throws VMException, VMWarningException, AlreadyPresentException, AlreadyNotPresentException;

    public void addVM(List<String> var1) throws VMException, AlreadyPresentException;

    public void removeVM(List<String> var1) throws VMException, AlreadyNotPresentException;

    public ServerPool getServerPool() throws VMException, NotExistsException, NotConfiguredException;

    public ServerCategory getServerCategory() throws VMException, NotExistsException, NotConfiguredException;

    public String[] getNodes() throws VMException, NotExistsException, NotConfiguredException;

    public void setServerPool(ServerPool var1) throws VMException;

    public void setServerCategory(ServerCategory var1) throws VMException;

    public void setServerPool(String var1) throws VMException;

    public void setServerCategory(String var1) throws VMException;

    public void setNodes(List<String> var1) throws VMException;

    public void relocate(String var1, Node var2) throws VMException, NotRunningException, RelocateException;

    public void relocate(Node var1, Node var2) throws NotRunningException, RelocateException, VMException;

    public void relocate(String var1) throws VMException, RelocateException, NotRunningException;

    public void relocate(Node var1) throws RelocateException, NotRunningException, VMException;

    public void start(String var1, Node var2) throws VMException, AlreadyRunningException;

    public void start(String var1) throws VMException, AlreadyRunningException;

    public void start(Node var1) throws VMException, AlreadyRunningException;

    public void stop(String var1) throws VMException, AlreadyStoppedException;

    public void stop(Node var1) throws VMException, AlreadyStoppedException;

    @Override
    public void start() throws VMException, AlreadyRunningException;

    public void stop() throws VMException, AlreadyStoppedException;

    public boolean isEnabledVM(String var1) throws VMException;

    public HashMap<VMDetail, String> getStatus() throws VMException;

    public void disableVMs(List<String> var1) throws VMException, AlreadyDisabledException;

    public void enableVMs(List<String> var1) throws VMException, AlreadyEnabledException;

    public void enable(List<Node> var1) throws VMException, AlreadyEnabledException;

    public void disable(List<Node> var1) throws VMException, AlreadyDisabledException;

    public String[] getInvalidVMs() throws VMException;

    public String[] getDisabledVMs() throws VMException;

    public List<VMDetail> getVMDetail() throws VMException;

    public VMDetail getVMDetail(String var1) throws VMException;
}

