/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.util;

import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.CryptoAlg;
import oracle.cluster.util.CryptoUtilException;
import oracle.ops.mgmt.nls.MessageKey;

public class CryptoUtil {
    public byte[] getHash(String str) throws CryptoUtilException {
        try {
            byte[] plainText = str.getBytes();
            MessageDigest messageDigest = MessageDigest.getInstance(CryptoAlg.SHA256.toString());
            messageDigest.update(plainText);
            byte[] bytes = messageDigest.digest();
            return bytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.GET_HASH_CODE_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public byte[] encrypt(String key, String plainText) throws CryptoUtilException {
        return this.encrypt(CryptoAlg.AES, key, plainText);
    }

    public byte[] encrypt(CryptoAlg cAlg, String key, String plainText) throws CryptoUtilException {
        try {
            String cryptoAlg = cAlg.toString();
            byte[] encodedKeyArr = this.hex2Byte(key);
            SecretKeySpec encodedKey = new SecretKeySpec(encodedKeyArr, cryptoAlg);
            Cipher encCipher = Cipher.getInstance(cryptoAlg);
            encCipher.init(1, encodedKey);
            byte[] byteArr = plainText.getBytes();
            byte[] encArr = encCipher.doFinal(byteArr);
            return encArr;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.ENCRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InvalidKeyException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.ENCRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.ENCRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.ENCRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (BadPaddingException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.ENCRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String decrypt(String key, byte[] cipherTxtArr) throws CryptoUtilException {
        return this.decrypt(CryptoAlg.AES, key, cipherTxtArr);
    }

    public String decrypt(CryptoAlg cAlg, String key, byte[] cipherTxtArr) throws CryptoUtilException {
        try {
            String cryptoAlg = cAlg.toString();
            Cipher decCipher = Cipher.getInstance(cryptoAlg);
            byte[] encoded = this.hex2Byte(key);
            SecretKeySpec decKey = new SecretKeySpec(encoded, cryptoAlg);
            decCipher.init(2, decKey);
            byte[] decArr = decCipher.doFinal(cipherTxtArr);
            String decStr = new String(decArr);
            return decStr;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.DECRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (InvalidKeyException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.DECRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.DECRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.DECRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
        catch (BadPaddingException e) {
            throw new CryptoUtilException((MessageKey)PrCgMsgID.DECRYPTION_FAILED, (Throwable)e, new Object[0]);
        }
    }

    public String byte2Hex(byte[] b) {
        StringBuffer hexStr = new StringBuffer();
        String stmp = null;
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hexStr.append("0" + stmp);
            } else {
                hexStr.append(stmp);
            }
            if (n >= b.length - 1) continue;
            hexStr.append("");
        }
        return hexStr.toString();
    }

    public byte[] hex2Byte(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public String getDecryptedPassword(String encryptKey, String encryptedPassword) throws CryptoUtilException {
        byte[] passArr = this.hex2Byte(encryptedPassword);
        String decryptPass = this.decrypt(encryptKey, passArr);
        return decryptPass;
    }
}

