/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.sql;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import oracle.cluster.resources.PrCqMsgID;
import oracle.cluster.sql.DBConnectionException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class SQLFactory {
    public static OracleConnection getDBConnection(String connDescr, String userName, String password) throws DBConnectionException {
        return SQLFactory.getConnection(connDescr, userName, password, null, true);
    }

    public static OracleConnection getConnection(String connDescr, String userName, String password, String internalLogon, boolean isThinDriver) throws DBConnectionException {
        return SQLFactory.getConnection(connDescr, userName, password, internalLogon, null, isThinDriver);
    }

    public static OracleConnection getConnection(String connDescr, String userName, String password, String internalLogon, Properties properties, boolean isThinDriver) throws DBConnectionException {
        String driverType = "oci";
        if (isThinDriver) {
            driverType = "thin";
        }
        String jdbcURL = "jdbc:oracle:" + driverType + ":@" + connDescr;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out("Exception while loading OracleDriver. exception: " + cnfe.getMessage());
            throw new DBConnectionException((MessageKey)PrCqMsgID.ORADRIVER_LOAD_ERROR_2, (Throwable)cnfe, new Object[0]);
        }
        try {
            Properties conProperties = new Properties();
            if (properties != null && !properties.isEmpty()) {
                Trace.out("JDBC Connection properties are explicitly specified, using those");
                conProperties.putAll((Map<?, ?>)properties);
            }
            if (userName != null && password != null) {
                conProperties.put("user", userName);
                conProperties.put("password", password);
            }
            if (internalLogon != null && internalLogon.length() != 0) {
                conProperties.put("internal_logon", internalLogon);
            }
            Trace.out("Trying to establish connection using thin jdbc url '" + jdbcURL + "' and user '" + userName + "'");
            return (OracleConnection)DriverManager.getConnection(jdbcURL, conProperties);
        }
        catch (SQLException sqlex) {
            Trace.out("SQLException occured while geting establishing connection to database using jdbc url '" + jdbcURL + "' and user name '" + userName + "'");
            Trace.out("SQLException: " + sqlex.getMessage());
            throw new DBConnectionException((MessageKey)PrCqMsgID.GET_CONNECTION_FAILED, (Throwable)sqlex, connDescr, userName);
        }
    }

    public static void main(String[] args) throws Exception {
        String query = "select 'a' from dual";
        OracleConnection con = null;
        con = SQLFactory.getDBConnection(args[0], args[1], args[2]);
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery(query);
        rs.next();
        System.out.println("query: " + query);
        System.out.println("output: " + rs.getString(1));
        rs.close();
        s.close();
        con.close();
    }
}

