/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.server;

import oracle.cluster.resources.PrCsMsgID;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerGroupException;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ServerPoolArgs {
    private Integer m_minSize = null;
    private Integer m_maxSize = null;
    private Integer m_importance = null;
    private String m_category = null;
    private Server[] m_servers = null;

    public void setMinSize(int minSize) throws ServerGroupException {
        this.m_minSize = new Integer(minSize);
    }

    public Integer getMinSize() {
        return this.m_minSize;
    }

    public void setMaxSize(int maxSize) throws ServerGroupException {
        this.m_maxSize = new Integer(maxSize);
    }

    public Integer getMaxSize() {
        return this.m_maxSize;
    }

    public void setImportance(int importance) throws ServerGroupException {
        this.m_importance = new Integer(importance);
    }

    public Integer getImportance() {
        return this.m_importance;
    }

    public void setCategory(String category) throws ServerGroupException {
        this.m_category = category;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void setServers(Server[] servers) {
        try {
            this.setServers(servers, false);
        }
        catch (ServerGroupException e) {
            Trace.out("Got ServerGroupException: " + e.getMessage());
        }
    }

    public void setServers(Server[] servers, boolean checkRole) throws ServerGroupException {
        StringBuilder hubServers = new StringBuilder();
        StringBuilder leafServers = new StringBuilder();
        try {
            if (checkRole) {
                for (Server server : servers) {
                    if (server.role() == Server.ServerRole.HUB) {
                        if (hubServers.length() > 0) {
                            hubServers.append(",");
                        }
                        hubServers.append(server.getName());
                    } else if (server.role() == Server.ServerRole.RIM) {
                        if (leafServers.length() > 0) {
                            leafServers.append(",");
                        }
                        leafServers.append(server.getName());
                    }
                    if (hubServers.length() <= 0 || leafServers.length() <= 0) continue;
                    Trace.out("Servers with hub role: %s", hubServers);
                    Trace.out("Servers with leaf role: %s", leafServers);
                    throw new ServerGroupException((MessageKey)PrCsMsgID.SERVERS_HAVE_MULTI_CSSROLES, new Object[0]);
                }
            }
        }
        catch (ServerException e) {
            throw new ServerGroupException(e);
        }
        this.m_servers = servers;
    }

    public Server[] getServers() {
        return this.m_servers;
    }

    public void setServerCategory(ServerCategory category) throws ServerGroupException {
        throw new RuntimeException("not implemented yet");
    }

    public ServerCategory getServerCategory() {
        throw new RuntimeException("not implemented yet");
    }
}

