/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.server;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.Service;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPoolArgs;
import oracle.cluster.util.CompositeOperationException;

public interface ServerPool
extends ManageableEntity {
    public int getCurrentSize() throws ServerGroupException;

    public int getMinSize() throws ServerGroupException;

    public int getMaxSize() throws ServerGroupException;

    public int getImportance() throws ServerGroupException;

    public void setImportance(int var1) throws ServerGroupException;

    public void setMinSize(int var1) throws ServerGroupException;

    public void setMaxSize(int var1) throws ServerGroupException;

    public List<Server> servers() throws ServerGroupException;

    public List<Server> candidateServers() throws ServerGroupException;

    public boolean hasExecutePermissions() throws ServerGroupException;

    public boolean hasUpdatePermissions() throws ServerGroupException;

    public void addServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public void addServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public String[] relocateServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public String[] relocateServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public void removeServers(List<Server> var1) throws CompositeOperationException, ServerGroupException;

    public void removeServers(boolean var1, List<Server> var2) throws CompositeOperationException, ServerGroupException;

    public List<Database> databases() throws ServerGroupException;

    public List<String> databaseNames() throws ServerGroupException;

    public Map<String, List<String>> getRunningDatabaseInstances() throws ServerGroupException;

    public Map<Database, List<DatabaseInstance>> getOnlineDatabaseInstances() throws ServerGroupException;

    public Map<Database, List<DatabaseInstance>> getAllDatabaseInstances() throws ServerGroupException;

    public Map<Database, List<DatabaseInstance>> getAllDatabaseInstances(String var1) throws ServerGroupException;

    public List<Service> services() throws ServerGroupException;

    public List<Service> services(String var1) throws ServerGroupException;

    public void remove() throws CompositeOperationException, ServerGroupException;

    public void modify(boolean var1, ServerPoolArgs var2) throws ServerGroupException;

    public void modifyLocal(boolean var1, ServerPoolArgs var2) throws ServerGroupException;

    public int getPolicyMinSize() throws ServerGroupException;

    public int getPolicyMaxSize() throws ServerGroupException;

    public int getPolicyImportance() throws ServerGroupException;

    public void setPolicyImportance(int var1) throws ServerGroupException;

    public void setPolicyMinSize(int var1) throws ServerGroupException;

    public void setPolicyMaxSize(int var1) throws ServerGroupException;

    public ServerCategory serverCategory() throws ServerGroupException;

    public String serverCategoryStr() throws ServerGroupException;

    public List<Server> candidateServersByCategory() throws ServerGroupException;

    public List<Server> getEligibleServers() throws ServerGroupException;

    public List<Server> getEligibleServers(Server.ServerState var1) throws ServerGroupException;

    public boolean isBuiltinPool();
}

